package com.digiwin.athena.knowledgegraph.service;


import com.digiwin.app.service.DWFile;
import com.digiwin.app.service.DWService;

/**
 * 文件服务
 * @javadoc
 */
public interface IFileService extends DWService {

    /**
     * 上传文件
     * @param file 文件
     * @param key 文件key值
     * @param version 版本
     * @return
     * @throws Exception
     */
    Object postUpload(DWFile file, String key, String version)  throws Exception;

    /**
     * 上传文件
     * @param file 文件
     * @param key 文件key值
     * @param version 版本
     * @param desc 描述
     * @return
     * @throws Exception
     */
    Object postUpload(DWFile file, String key, String version, String desc)  throws Exception;

    /**
     * 获取下载模板
     * @param fileId 文件id
     * @throws Exception
     */
    void getDownloadTemplate(String fileId) throws Exception;

    /**
     * 获取文件id
     * @param key 文件key
     * @param version 版本
     * @return
     * @throws Exception
     */
    Object getFileId(String key, String version) throws Exception;
}
