package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.guide.GuideConfig;

/**
 * 新手引导服务
 * @program: athena_backend
 * @description: 新手引导服务接口
 * @author: lingxiang
 * @create: 2022-05-18 16:00
 * @javadoc
 **/
public interface IGuideService extends DWService {
    /**
     * 保存新手引导服务接口
     * @param guideConfig 指引配置
     * @return
     * @throws DWBusinessException
     */
    Object put(GuideConfig guideConfig) throws DWBusinessException;

    /**
     * 删除新手引导配置
     * @param appCode 应用code
     * @param code 指引配置code
     * @param type 指引配置类型
     * @param version 版本号
     * @return
     * @throws DWBusinessException
     */
    Object delete(String appCode, String code, String type, String version) throws DWBusinessException;

    /**
     * 更新保存新手引导配置
     * @param guideConfig 引导配置
     * @return
     * @throws DWBusinessException
     */
    Object post(GuideConfig guideConfig) throws DWBusinessException;

    /**
     * 查询新手引导配置
     * @param appCode 应用code
     * @param code code
     * @param type 类型
     * @return
     * @throws DWBusinessException
     */
    Object postQuery(String appCode, String code, String type) throws DWBusinessException;
}
