package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.mechanism.MechanismContext;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Paradigm;
import com.digiwin.athena.knowledgegraph.domain.mechanism.Principle;
import com.digiwin.athena.knowledgegraph.domain.mechanism.PrincipleDetail;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismAchiveRecord;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismOld;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismScene;
import com.digiwin.athena.knowledgegraph.vo.VariableBean;
import com.digiwin.athena.knowledgegraph.vo.VariableQueryVO;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.assign.AdvancedUserDefinitionWidget;

import java.util.List;
import java.util.Map;

public interface IMechanismService extends DWService {
    /**
     * 根据机制变量code获取机制变量详情数据，包含租户设置的数值
     *
     * @param variableName 机制变量code
     * @param tenantId     租户id
     * @return
     * @throws DWBusinessException
     */
    Object getVariable(String variableName, String tenantId) throws DWBusinessException;

    /**
     * 根据查询条件查询变量列表
     *
     * @param queryData 查询条件
     * @return
     * @throws DWBusinessException
     */
    Object postQueryVariable(VariableQueryVO queryData) throws DWBusinessException;

    /**
     * 根据查询条件获取原理详情
     * @param subComponent 子组件
     * @return
     */
    PrincipleDetail getPrincipleDetailByComponent(StructuredComponentBO subComponent) throws DWBusinessException;

    /**
     * 获取机制
     * @param tenantId 租户id
     * @param key 机制code
     * @return
     * @throws DWBusinessException
     */
    MechanismOld getDetail(String tenantId, String key) throws DWBusinessException;

    /**
     * 获取机制场景
     * @param mechanism 机制
     * @param keys 机制code
     * @return
     */
    MechanismScene getScene(MechanismOld mechanism, String[] keys);

    /**
     * 根据机制原理详情获取机制原理详情
     * @param code 机制原理详情code
     * @return 机制原理详情
     */
    PrincipleDetail getPrincipleDetailByCode(String code) throws DWBusinessException;

    /**
     * 根据机制原理code获取机制原理
     * @param code 机制原理code
     * @return 返回机制原理
     */
    Principle getPrincipleByCode(String code) throws DWBusinessException;

    /**
     * 补充参数变量数值，普通数值先取mechanismVariable值，没有取预设值VariableDefinition。特殊类型特殊处理，例如报表等
     *
     * @param map 变量定义
     * @return
     * @throws Exception
     */
    Object postVariableList(VariableBean map) throws Exception;

    /**
     * @param map
     * @return
     * @throws Exception
     */
    Object postVariableListSimple(VariableBean map) throws Exception;

    /**
     * 根据变量名更新数值
     *
     * @param variableName 机制变量code
     * @param tenantId     租户id
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object putVariable(String variableName, String tenantId, Object value) throws Exception;

    /**
     * 根据机制变量code更新租户设置的机制变量数值
     * @param variableName 机制变量code
     * @param tenantId 租户id
     * @param value 机制变量数值
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postVariable(String variableName, String tenantId, Object value) throws Exception;

    /**
     * 根据机制变量code更新租户设置的机制变量数值
     * @param variableName 机制变量code
     * @param tenantId 租户id
     * @param operationUnit 运营单元
     * @param value 机制变量数值
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object postVariable(String variableName, String tenantId, OperationUnit operationUnit, Object value) throws Exception;

    Object postSelectVariable(String variableCode, String tenantId);

    //查询机制详情 todo 可能需要修改参数格式
    @AllowAnonymous
    Object postMechanism(String key,String tenantId,String product) throws DWBusinessException;
    //平铺查询机制各项的值 todo 可能需要修改参数格式
    @AllowAnonymous
    Object postMechanismMaterialConfig(String key,String tenantId,String product) throws DWBusinessException;
    //保存机制产生记录
    @AllowAnonymous
    Object postMechanismRecordSave(MechanismAchiveRecord data) throws DWBusinessException;

    MechanismAchiveRecord findOne(String instanceId);

    //查询机制产生记录
    @AllowAnonymous
    Object postMechanismRecordGet(String instanceId);
    //通知机制发生变化
    @AllowAnonymous
    Object postNotifyChange(MechanismContext data) throws DWBusinessException;
    //查询机制详情附加上下文
    @AllowAnonymous
    Object postMechanismWithContext(MechanismContext data) throws DWBusinessException;

    //保存服务调用参数值
    @AllowAnonymous
    Object postSaveMechanismMaterialConfig(String mechanismCode, String tenantId, Map<String, Object> variables) throws DWBusinessException;
    @AllowAnonymous
    Object postSaveMechanismMaterialConfig(String mechanismCode, String tenantId, Map<String, Object> variables, OperationUnit operationUnit) throws DWBusinessException;
    //读取服务调用参数值
    @AllowAnonymous
    Object postReadMechanismMaterialConfig(String mechanismCode,String tenantId) throws DWBusinessException;

    @AllowAnonymous
    Object postReadMechanismMaterialConfig(String mechanismCode,String tenantId, OperationUnit operationUnit) throws DWBusinessException;

    /**
     * 根据机制变量code和租户删除租户变量
     * @param variableName 机制变量
     * @param tenantId 租户id
     * @return
     * @throws Exception
     */
    @AllowAnonymous
    Object deleteVariable(String variableName, String tenantId) throws Exception;

    //保存服务调用参数值
//    @AllowAnonymous
    Object postSaveMechanismExecuteParam(String mechanismCode,  Map<String, Object> parameters) throws DWBusinessException;

    Object postSaveMechanismExecuteParam(String mechanismCode,  Map<String, Object> parameters, OperationUnit operationUnit) throws DWBusinessException;
    //读取服务调用参数值
//    @AllowAnonymous
    Object postReadMechanismExecuteParam(String mechanismCode) throws DWBusinessException;

    // 获取用户设定过的执行参数内容
    Object postReadMechanismExecuteParam(String mechanismCode, OperationUnit operationUnit) throws DWBusinessException;

    Object postCopyMechanismExecuteParam(String mechanismCode, OperationUnit sourceOperationUnit, OperationUnit operationUnit, List<String> monitorRuleIds)  throws DWBusinessException;

    Object postCopyMechanismParam(String appCode, List<String> mechanismCode, OperationUnit operationUnit,
                                  String tenantId,
                                  String copyTenantId) throws DWBusinessException;

    Object postTimeIntervalCode() throws DWBusinessException;

    Object postTimeIntervalCode(String mechanismCode) throws DWBusinessException;

    Object getTimeIntervalDetailByCode(String code) throws DWBusinessException;

    Object getMechanismExecuteTableParam(String code, String key, String column) throws DWBusinessException;

    Object getVariableTableParam(String variableName, String tenantId, String keyColumn, String key, String valueColumn) throws DWBusinessException;

    /**
     * 根据机制code和运营单元信息获取机制信息
     * @param code 机制code
     * @param operationUnit 运营单元信息
     * @return 机制数据
     * @throws DWBusinessException
     */
    Object postQueryMechanismByCode(String code,OperationUnit operationUnit) throws DWBusinessException;

    /**
     * 根据机制code，运营单元及其级别获取机制数据
     * @param code 机制code
     * @param operationUnit 运营单元
     * @param queryWithEocLevel 是否需要运营单元级别
     * @return 机制数据
     * @throws DWBusinessException
     */
    Object postQueryMechanismByCode(String code, OperationUnit operationUnit, Boolean queryWithEocLevel) throws DWBusinessException;

    /**
     * 根据机制code，运营单元及其级别获取机制数据
     * @param codeList 机制code集合
     * @param operationUnit 运营单元信息
     * @return
     * @throws DWBusinessException
     */
    Object postQueryMechanismByCode(List<String> codeList, OperationUnit operationUnit) throws DWBusinessException;

    /**
     * 根据机制code，运营单元信息查询机制数据
     * @param codeList 机制code集合
     * @param operationUnit 运营单元信息
     * @param queryWithEocLevel 是否需要带运营单元级别查询
     * @return 机制数据
     * @throws DWBusinessException
     */
    Object postQueryMechanismByCode(List<String> codeList, OperationUnit operationUnit, Boolean queryWithEocLevel) throws DWBusinessException;

    /**
     * 根据机制code + 运营单元获取租户级机制数据
     * @param code 机制code
     * @param operationUnit 运营单元
     * @return
     * @throws DWBusinessException
     */
    Object postQueryTenantMechanismByCode(String code, OperationUnit operationUnit) throws DWBusinessException;

    List<String> getVariableCode(String mechanismCode) throws DWBusinessException;

    List<String> getMonitorRuleCode(String mechanismCode) throws DWBusinessException;

    /**
     * 根据机制code集合 去组件清单表查询对应的范式code，分组逻辑：key机制code，value：范式code
     * @param mechanismCode 范式集合code
     */
    Map<String, String> postParadigmCode(List<String> mechanismCode) throws DWBusinessException;

    /**
     * 根据范式集合code查询范式集合数据
     * @param paradigmTypeCodeList 范式code 集合
     */
    List<Paradigm> postParadigmNameAndCode(List<String> paradigmTypeCodeList) throws DWBusinessException;

    /**
     * 查询租户应用下范式和机制的权限数据，返回机制code集合
     * @param code 应用code
     * @param tenantId 租户id
     */
    Object getMechanismTenantParadigm(String code, String tenantId) throws DWBusinessException;

    /**
     * 根据租户id保存机制数据（MechanismTenantParadigm）
     * @param code 应用code
     * @param tenantId 租户id
     * @param value value值，保存的是机制code
     * @return
     * @throws DWBusinessException
     */
    Object postMechanismTenantParadigm(String code, String tenantId, List<String> value) throws DWBusinessException;

    Object getMechanismSort(String appCode) throws DWBusinessException;

    Object getMechanismAndParadigmSort(String appCode) throws DWBusinessException;

    Object postUpdateTenantMechanism(String code,  String name, List<Principle> principles, OperationUnit operationUnit) throws DWBusinessException;

    /**
     * 根据code更新租户设置的机制数据
     * @param code 机制code
     * @param name 机制名称
     * @param principles 机制下得机制原理集合
     * @param operationUnit 运营单元
     * @param mergeVersion 合并版本
     * @return
     * @throws DWBusinessException
     */
    Object postUpdateTenantMechanism(String code,  String name, List<Principle> principles, OperationUnit operationUnit, String mergeVersion) throws DWBusinessException;

    /**
     * 根据机制code和运营单元清理租户级机制原理
     * @param code 机制code
     * @param operationUnit 运营单元
     * @return
     * @throws DWBusinessException
     */
    Object postClearTenantMechanism(String code, OperationUnit operationUnit) throws DWBusinessException;

    Object postSaveMechanismLogic(MechanismLogic logic) throws DWBusinessException;

    Object getMechanismLogic(String code) throws DWBusinessException;

    Object getDeleteMechanismLogic(String code) throws DWBusinessException;

    Object getHasGroundEnd() throws DWBusinessException;


    @AllowAnonymous
    Object getBuildGraph(String mechanismCode) throws DWBusinessException;


    @AllowAnonymous
    Object postMechanismPluginsMerge(String mechanismCode);


   // @AllowAnonymous
    Object postMechanismApplyRecord(Map query) throws Exception;

    @AllowAnonymous
    Object postMechanismExecuteParamsUpdate(String tenantId);

    /**
     * 查询pwd定制机制参数
     * @param variableCode 参数code
     * @param tenantId 租户id
     * @return 参数值
     * @throws DWBusinessException 业务异常
     */
    @AllowAnonymous
    Object getPwdCustomizeVariable(String variableCode, String tenantId) throws DWBusinessException;

    Object postQuerySmartDataVariable(List<String> variableIds, String tenantId);

    List<ActivityWidget> postGeneratePreActivities(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, String capacityCode) throws DWBusinessException;

    /**
     * 租户级机制相关数据复制功能
     * @param codes               要复制的机制code集合
     * @param sourceTenantId      源租户id
     * @param targetTenantId      目标租户id
     * @return
     * @throws DWBusinessException
     */
    Object postCopyTenantMechanismInfo(List<String> codes, String sourceTenantId, String targetTenantId) throws DWBusinessException;

    /**
     * 根据appCode查询机制
     * @param appCode appCode
     * @param operationUnit 运营单元
     * @param queryWithEocLevel 运营单元层级
     * @return 机制
     */
    Object postParadigmAndMechanismByApp(String appCode, OperationUnit operationUnit, Boolean queryWithEocLevel) throws Exception;
}
