package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.service.model.CommentResult;
import com.digiwin.athena.knowledgegraph.service.model.GoodsEntityRelation;

/**
 * 知识本体订购关系
 * @javadoc
 */
public interface ISubscribeService extends DWService {

     /**
      * 保存知识本体订购关系
      * @param relation  知识本体和商品id的对应关系
      * @return
      * @throws DWException
      */
     @AllowAnonymous
     Object postRelation(GoodsEntityRelation relation) throws DWException;

     /**
      *
      * @param entityID 实体id
      * @param goodsID 商品id
      * @return
      * @throws DWException
      */
     @AllowAnonymous
     Object deleteRelation(String entityID,String goodsID) throws DWException;

     /**
      * 获取
      * @param tenantID 租户id
      * @param userID 用户id
      * @param entityID 实体id
      * @param type 类型
      * @return
      * @throws DWException
      */
     @AllowAnonymous
     Object getSubscription(String tenantID,String userID, String entityID,String type) throws DWException;


}
