package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.targets.SystemIndicatorForestDto;

/**
 * 系统级指标树
 * @javadoc
 */
public interface ISystemTargetService extends DWService {

    /**
     * 删除指标树
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    Object deleteIndicatorForest() throws DWBusinessException;

    /**
     * 获取指标树
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    Object getIndicatorForest() throws DWBusinessException;

    /**
     * 保存指标树
     * @param systemIndicatorForest 指标树
     * @return
     * @throws DWBusinessException
     */
    @AllowAnonymous
    Object postIndicatorForest(SystemIndicatorForestDto systemIndicatorForest) throws DWBusinessException;

}
