package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.targets.Target;
import com.digiwin.athena.knowledgegraph.dto.AppendLeafDto;
import com.digiwin.athena.knowledgegraph.dto.RemoveNodeDto;
import com.digiwin.athena.knowledgegraph.dto.TargetTreeForAppDto;

/**
 * 指标树服务
 * @javadoc
 */
public interface ITargetService extends DWService {

    /**
     * 获取租户下配置的所有指标树
     * @return
     * @throws DWBusinessException
     */
    Object getForest() throws DWBusinessException;

    /**
     * 根据机制code获取指标树
     * @param mechanismId 机制code
     * @return
     * @throws DWBusinessException
     */
    Object getMechanismTargets(String mechanismId) throws DWBusinessException;

    /**
     * 构建指标树
     * @param targetTreeForAppDto 指标树数据
     * @return
     * @throws Exception
     */
    Object postBuildTree(TargetTreeForAppDto targetTreeForAppDto) throws Exception;

    /**
     * 追加指标树子叶子节点
     * @param appendLeafDto
     * @return
     * @throws Exception
     */
    Object postAppendLeaf(AppendLeafDto appendLeafDto) throws Exception;

    /**
     * 获取指标树
     * @return
     * @throws DWBusinessException
     */
    Object getTargetPool() throws DWBusinessException;

    /**
     * 根据根节点获取指标树
     * @param rootId
     * @return
     * @throws DWBusinessException
     */
    Object getTargetTree(String rootId) throws DWBusinessException;

    /**
     * 删除指标树节点
     * @param removeNodeDto
     * @return
     * @throws Exception
     */
    Object postRemoveNode(RemoveNodeDto removeNodeDto) throws Exception;

    /**
     * 根据指标树节点获取数据
     * @param targetId 指标树节点
     * @return
     * @throws DWBusinessException
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     */
    Object getTarget(String targetId) throws DWBusinessException, NoSuchFieldException, IllegalAccessException;

    /**
     * 保存指标树
     * @param target 指标
     * @return
     * @throws DWBusinessException
     */
    Object postTarget(Target target) throws DWBusinessException;
}
