package com.digiwin.athena.knowledgegraph.service;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.knowledgegraph.domain.topic.Topic;
import com.digiwin.athena.knowledgegraph.dto.topic.TopicDto;

import java.util.List;

/**
 * 议题相关接口多个应用可以组成一个议题
 * @javadoc
 */
public interface ITopicService extends DWService {

    /**
     * 根据议题code查询议题信息
     * @param code 议题code
     */
    Topic getTopic(String code)  throws DWBusinessException;

    /**
     * 查询所有议题数据
     */
    List<Topic> getAllTopics() throws DWBusinessException;

    /**
     * 新增/修改议题数据
     * @param dto 实体
     */
    boolean postSaveTopic(TopicDto dto) throws DWBusinessException;

    /**
     * 根据议题code删除议题数据
     * @param code 议题code
     */
    boolean postDeleteTopic(String code) throws DWBusinessException;

}
