package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.action.model.LogConstant;
import com.digiwin.athena.kmservice.action.model.LogDataDto;
import com.digiwin.athena.kmservice.action.model.LogDto;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import com.digiwin.athena.kmservice.service.ActionExecutionPathService;
import com.digiwin.athena.knowledgegraph.action.constant.ActionCons;
import com.digiwin.athena.knowledgegraph.action.execution.ActionQueryService;
import com.digiwin.athena.kmservice.action.execution.ProductNameGetter;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.action.execution.model.ActionDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.ActionExecutionPathDTO;
import com.digiwin.athena.kmservice.action.execution.model.ApiDataFieldDefinitionDTO;
import com.digiwin.athena.kmservice.action.execution.model.ESPActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.MultiPathActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.PullingActionExecutionParamDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartDataEventActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartProcessActionExecutionDTO;
import com.digiwin.athena.kmservice.action.execution.model.StartServiceComposerActionExecutionDTO;
import com.digiwin.athena.kmservice.action.metadata.ActionMetadataManager;
import com.digiwin.athena.knowledgegraph.action.metadata.ApiSynchronizer;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kmservice.action.metadata.model.ApiDataMetadataDTO;
import com.digiwin.athena.kmservice.action.metadata.model.ApiMetadataDataDTO;
import com.digiwin.athena.knowledgegraph.action.model.ActionMetadataDTOConvertor;
import com.digiwin.athena.knowledgegraph.action.model.ActionParamDTO;
import com.digiwin.athena.knowledgegraph.action.model.DutyRoleDTO;
import com.digiwin.athena.kg.action.EspActionMetadataDTO;
import com.digiwin.athena.kg.action.GetActionLocaleResponseDTO;
import com.digiwin.athena.knowledgegraph.action.model.ProcessParamDTO;
import com.digiwin.athena.knowledgegraph.action.model.TaskActionDefinitionDTO;
import com.digiwin.athena.knowledgegraph.action.transrule.TransformActionRuleManager;
import com.digiwin.athena.knowledgegraph.app.AppTenantVersionService;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;
import com.digiwin.athena.kg.action.Action;
import com.digiwin.athena.knowledgegraph.domain.Task;
import com.digiwin.athena.kg.action.ActionLabel;
import com.digiwin.athena.kg.action.ESPServiceVO;
import com.digiwin.athena.kg.action.TaskDataGroupAction;
import com.digiwin.athena.knowledgegraph.domain.application.AppTenantVersion;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.domain.task.DueDateTimeDistance;
import com.digiwin.athena.kg.action.ActionConfig;
import com.digiwin.athena.knowledgegraph.po.DimensionParam;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.kg.report.hz.model.metaData.DataSourceStructDTO;
import com.digiwin.athena.kg.report.hz.model.metaData.FieldDTO;
import com.digiwin.athena.kg.report.hz.model.pushMetadata.ActionExecutionParam;
import com.digiwin.athena.knowledgegraph.service.IActionService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.support.AbstractionHandler;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.BPMConverter;
import com.digiwin.athena.knowledgegraph.svcomposition.bpm.NodeType;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.Edge;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.GraphHelperTemplate;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.MatrixGraph;
import com.digiwin.athena.knowledgegraph.svcomposition.graph.OldGraphHelper;
import com.digiwin.athena.kmservice.action.execution.model.ActionParamTypeEnum;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.kmservice.utils.MetadataTranslator;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import static com.digiwin.athena.knowledgegraph.svcomposition.bpm.BPMConverter.addGateway;
import static com.digiwin.athena.knowledgegraph.svcomposition.bpm.BPMConverter.addStartEndNodes;

@Lang
@Service
@Slf4j
@MyExceptionHandler
public class ActionService implements IActionService {


    public static final String DESCRIPTION_FILED = "Description";
    public static final String REMARK_FILED = "Remark";
    private final String SYS_TENANT = "SYSTEM";

    @Autowired
    ActionExecutionPathService actionExecutionPathService;

    @Autowired
    ActionMetadataManager actionMetadataManager;
    @Autowired
    ApiSynchronizer apiSynchronizer;
    @Autowired
    IAMUtils iamUtils;

    @Autowired
    ActionRepository actionRepository;

    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    ActionQueryService actionQueryService;
    @Autowired
    AbstractionHandler abstractionHandler;
    @Autowired
    TaskService taskService;
    @Autowired
    TenantService tenantService;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    AppService appService;

    @Autowired
    AppTenantVersionService appTenantVersionService;

    @Autowired
    MongoEntityBaseDAO mongoEntityBaseDAO;

    @Autowired(required=false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain1;

    @Autowired(required=false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain2;

    @Autowired
    private SceneService sceneService;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    SessionFactory neo4jSessionFactory;

    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object getDefinition(String actionId) throws Exception {

//        actionId = compositeExchangeActionService.getRealActionId(actionId);

        if (actionId.equals("requisition_actionid")) {
            TaskActionDefinitionDTO dto = new TaskActionDefinitionDTO();
            dto.setActionId(actionId);
            dto.setType("task");
            DutyRoleDTO dutyRole = new DutyRoleDTO();
            dutyRole.setRoleId("176591553090112");
            dutyRole.setRoleName("采购员");
            dto.setDutyRole(dutyRole);
            dto.setTaskId("task_StartProductionOnSchedule");
            dto.setTaskName("如期开工任务");
            dto.setProcessId("AthenaRequisitionToPurchase");

            List<ProcessParamDTO> processParams = new ArrayList<ProcessParamDTO>();
            ProcessParamDTO purchaseNoParam = new ProcessParamDTO();
            purchaseNoParam.setName("purchase_no");
            purchaseNoParam.setType("actionParam");
            purchaseNoParam.setValue("purchase_no");
            processParams.add(purchaseNoParam);
            ProcessParamDTO timeDistanceDTO = new ProcessParamDTO();
            timeDistanceDTO.setName("time_distance");
            timeDistanceDTO.setType("mechanismVariable");
            timeDistanceDTO.setValue("var_time_distance");
            processParams.add(timeDistanceDTO);
            dto.setProcessParams(processParams);

            List<ActionParamDTO> actionParams = new ArrayList<ActionParamDTO>();
            ActionParamDTO actionParamDTO = new ActionParamDTO();
            actionParamDTO.setName("purchase_no");
            actionParamDTO.setDescription("请购单号");
            actionParamDTO.setData_type("string");
            actionParamDTO.setRequired(true);
            actionParams.add(actionParamDTO);
            dto.setActionParams(actionParams);

            //   Object result =  DWServiceResultBuilder.build(dto);
            return dto;
        } else {
            Object result = DWServiceResultBuilder.build(false, I18nUtils.getValue("knowledgegraph.actionNotFound2"), actionId);
            return result;
        }
    }

    @Override
    public Object delete(String actionId) throws Exception {

//        actionId = compositeExchangeActionService.getRealActionId(actionId);

        String queryStatement = "MATCH (action:Action) where action.actionId='"
                + actionId + "' delete action";
        Neo4jManager.getNeo4jManager().ExecuteNoQuery(queryStatement);
        // return DWServiceResultBuilder.build(actionId);
        return actionId;
    }

    @Override
    public Object getActionRule(String ruleId) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Object ruleObj = new TransformActionRuleManager().getRuleById(ruleId, tenantId, tenantVersion);
        if (null == ruleObj) {
            ruleObj = new TransformActionRuleManager().getRuleById(ruleId, SYS_TENANT, tenantVersion);
        }
        if (null == ruleObj) {
            ruleObj = new TransformActionRuleManager().getRuleById(ruleId, null, tenantVersion);
        }
        if (null == ruleObj) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.ruleNotFound",ruleId));
        }
        List<ActionLabel> actionAndLabelsByRuleId = dataPickService.filterByIndividual(actionRepository.getActionAndLabelsByRuleId(ruleId), tenantId,
                actionLabel -> actionLabel.getAction().getNameSpace());
        if (CollectionUtils.isEmpty(actionAndLabelsByRuleId)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.ruleLabelNotFound",ruleId));
        }
        ActionLabel actionLabel = actionAndLabelsByRuleId.get(0);
        if (actionLabel.getAction() instanceof TaskDataGroupAction) {
            //需要通过taskId去获取组户级的时距配置，动态替换到rule规则中
            TaskDataGroupAction action = (TaskDataGroupAction) actionLabel.getAction();
            String taskId = action.getTaskId();
            Object taskObj = this.taskService.getDefinitionWithMultiLanguage(taskId);
            Task task = JSON.parseObject(JSON.toJSONString(taskObj), Task.class);
            DueDateTimeDistance dateTimeDistance = null;
            if (StringUtils.equals(task.getType(), "FEEDBACK")) {
                dateTimeDistance = task.getDateTimeDistance();
            } else {
                dateTimeDistance = task.getDueDateTimeDistance();
            }
            if (StringUtils.equals(dateTimeDistance.getType(), "MULTI_DAY") || StringUtils.equals(dateTimeDistance.getType(), "DAY")
                    || StringUtils.equals(dateTimeDistance.getType(), "WEEK_DAY")) {//当时多天的时候 替换
                String startDate = "";
                String format = "";
                String count = "";
                if (StringUtils.equals(dateTimeDistance.getType(), "MULTI_DAY")) {
                    startDate = dateTimeDistance.getStartDate();
                    format = dateTimeDistance.getFormat();
                    count = dateTimeDistance.getCount();
                } else if (StringUtils.equals(dateTimeDistance.getType(), "DAY")) {
                    startDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    format = "yyyy-MM-dd";
                    count = "1";
                } else {
                    String timeDistanceBegin = StringUtils.isEmpty(dateTimeDistance.getTimeDistanceBegin()) ? "1" : dateTimeDistance.getTimeDistanceBegin();
                    startDate = LocalDate.now().with(DayOfWeek.of(Integer.parseInt(timeDistanceBegin))).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                    format = "yyyy-MM-dd";
                    count = "7";
                }

                JSONObject object = JSON.parseObject(JSON.toJSONString(ruleObj));
                JSONArray step = object.getJSONArray("step");
                for (int i = 0; i < step.size(); i++) {
                    if (StringUtils.equals(step.getJSONObject(i).getString("technique"), "calculate")) {
                        JSONArray rule = step.getJSONObject(i).getJSONArray("rule");
                        for (int j = 0; j < rule.size(); j++) {
                            if (StringUtils.equals(rule.getJSONObject(j).getString("calcType"), "NumberOfIntervalByDay")) {
                                rule.getJSONObject(j).put("fieldB", startDate);
                                rule.getJSONObject(j).put("formatB", format);
                                rule.getJSONObject(j).put("intervalDays", Integer.valueOf(count));
                            }
                        }
                    }
                }
                return object;
            }

        }
//        Object result =  DWServiceResultBuilder.build(ruleObj);
//        return result;
        return ruleObj;
    }

    @Override
    public String getProductName(String serviceName) throws Exception {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantId = (String) profile.getOrDefault("tenantId", "");
        return productNameResolver.getProductName(serviceName, tenantId);
    }

 //   @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getMetadata$0",  ttlSecs = 7200,language = true,tenant = true)
    @Override
    public Object getMetadata(String actionId) throws Exception {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantId = (String) profile.getOrDefault("tenantId", "");
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        actionId = compositeExchangeActionService.getRealActionId(actionId);

        Locale locale = DWResourceBundleUtils.getCurrentLocale();
        String localeStr = locale.toString();

        EspActionMetadataDTO responseDTO = this.actionMetadataManager.getActionMetadata(actionId, tenantId, tenantVersion);
        GetActionLocaleResponseDTO localeResponseDTO = ActionMetadataDTOConvertor.convertToGetActionLocaleResponseDTO(responseDTO);
        ProductNameGetter productNameGetter = null;
        if (actionId.startsWith("esp_")) {
            productNameGetter = new ProductNameGetter.MdcProductNameGetter(this.productNameResolver, actionId.substring(4), tenantId);
        }
        //给requestApiFieldMetadata多语言重新赋值，租户产品字段精度赋值
        MetadataTranslator.translateField(localeResponseDTO, responseDTO, localeStr, productNameGetter);

//        Object result =  DWServiceResultBuilder.build(localeResponseDTO);
//        return result;
        return localeResponseDTO;
    }

    public Object getCompositAction(String actionId, String tenantId) throws Exception {
        String queryStatement = "MATCH (action:TestCompositAction)-[:Contains]->(eleAction)\n" +
                "where action.actionId='" + actionId + "'\n" +
                "return eleAction,labels(eleAction) as eleLabels";
        List<Map<String, Object>> actionQueryResult = Neo4jManager.getNeo4jManager().ExecuteQuery(queryStatement);
        if (actionQueryResult.size() == 0) {
            throw new DWBusinessException("P.KG.500.0001 action not found: " + actionId);
        }
        List<Map> actions = actionQueryResult.stream().map(item -> {
            Map map = new HashMap(3);
            map.putAll((Map) item.get("eleAction"));
            map.put("eleLabels", item.get("eleLabels"));
            return map;
        }).collect(Collectors.toList());
        List<HashMap> nodes = JSONObject.parseArray(JSONObject.toJSONString(actions), HashMap.class);
        for (int i = 0; i < nodes.size(); i++) {
            nodes.get(i).put("index", i);
        }
        final Map<String, Map> actionMap = nodes.stream().collect(Collectors.toMap(x ->
                x.get("actionId").toString(), x -> x));
        final Set<String> actionIds = nodes.stream().map(item -> (String) item.get("actionId"))
                .collect(Collectors.toSet());
        List<Edge> edgeList = new ArrayList<>();
        for (HashMap item : nodes) {
            String queryActionId = (String) item.get("actionId");
            GraphHelperTemplate graphHelperTemplate = new OldGraphHelper();
            graphHelperTemplate.processNodeAndEdges(actionMap, actionIds, edgeList, item, queryActionId);
            item.put("type", NodeType.SERVICE);
        }
        MatrixGraph<Map> graph = new MatrixGraph(nodes.toArray(new HashMap[nodes.size()]),
                edgeList.toArray(new Edge[edgeList.size()]));
        //添加首尾节点
        addStartEndNodes(graph);
        graph.trimEdge();
        //添加关卡
        addGateway(graph);
        return BPMConverter.convertToBPMJson(graph, tenantId);
    }


    /*@Deprecated
    private static String getTargetLang(Method method, MultiLanguageDTO lang) {
        try {
            return (String) method.invoke(lang);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return "";
    }*/

    @Override
    public Object getMetadata(String actionId, String language) throws Exception {
        mockSwitch = !mockSwitch;
        return null;
    }

    public Object put(String apiName, String productName, String productVersion) throws Exception {
//        new ApiSynchronizer().SynchronizeOne(apiName, productName, productVersion);
        this.apiSynchronizer.SynchronizeOne(apiName, productName, productVersion);
        // return DWServiceResultBuilder.build(true, null);
        return null;
    }

    public Object put(String tenantId) throws Exception {
//        new ApiSynchronizer().SynchronizeAll(tenantId);
        this.apiSynchronizer.SynchronizeAll(tenantId);
        // return DWServiceResultBuilder.build(true, null);
        return null;
    }

    private static boolean mockSwitch = false;


  //  @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "postQueryExecutionPath$0$1$2$3", ttlSecs = 7200, loadEmpty = true)
    public Object postQueryExecutionPath(String actionId, String tenant, List<String> existingActionParams, List<String> existingSysParams) throws Exception {
//        try {
//            Locale locale = DWResourceBundleUtils.getCurrentLocale();
//            String localeStr = locale.toString();
//            Map<String, Object> profile = DWServiceContext.getContext().getProfile();
//            String tenantId = (String) profile.getOrDefault("tenantId", "");
//
//            // 如果是指标需要获取到指标对应的actionId
//            String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//            if (StringUtils.isNotEmpty(actionId) && actionId.startsWith("METRIC_")) {
//                List<Action> actionList = actionRepository.findByActionIdAndVersion(actionId, tenantVersion);
//                if (CollectionUtils.isNotEmpty(actionList)) {
//                    actionId = actionList.get(0).getQuoteMetricCode();
//                }
//            }
//
//            List<String> existingActionParamsWithoutRoot = this.removeActionParamRoot(existingActionParams);
//            List<String> existingSysParamsWithoutRoot = this.removeActionParamRoot(existingSysParams);
//            List<String> subtractSysParams = (List<String>) CollectionUtils.subtract(existingSysParamsWithoutRoot, existingActionParamsWithoutRoot);
//            List<String> existingAllParams = (List<String>) CollectionUtils.union(existingActionParamsWithoutRoot, existingSysParamsWithoutRoot);
//            ActionExecutionPathDTO pathDTO = getDataPullingPathGenerator().Generate(actionId, tenantId, existingAllParams,tenantVersion);
//            //后续处理ActionExecution，设置productName，locale等
//            // actions的重复问题处理
//            handleDistinctActions(pathDTO.getActions());
//            // 查询action二次计算的定义
//            List<ActionRecast> actionRecast = sceneService.postQueryActionRecast(Arrays.asList(actionId));
//            if (CollectionUtils.isNotEmpty(actionRecast)) {
//                pathDTO.setRecast(actionRecast.get(0).getRecast());
//            }
//
//            JSONObject actionParamMapping = mongoTemplate.findOne(Query.query(Criteria.where("code").is(actionId).and("version").is(tenantVersion)), JSONObject.class,"agiledata_parameter_mapping");
//            if (!ObjectUtils.isEmpty(actionParamMapping)) {
//                pathDTO.setStandardParameterMapping(actionParamMapping.getJSONObject("parameterMapping"));
//            }
//
//            this.postActionExecutionProcessor(pathDTO.getActions(), tenantId, subtractSysParams);
//            this.logTrace(actionId, true, null);
//            return pathDTO;
//        } catch (Exception e) {
//            this.logTrace(actionId, false, e.getMessage());
//            throw new Exception(e);
//        }
        return actionExecutionPathService.postQueryExecutionPath(actionId, tenant, existingActionParams, existingSysParams);
    }

    public Object postQueryExecutionPath(String actionId, String tenantId, List<String> existingActionParams) throws Exception {
//        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
//        tenantId = (String) profile.getOrDefault("tenantId", "");
//        List<String> existingActionParamsWithoutRoot = this.removeActionParamRoot(existingActionParams);
//        ActionExecutionPathDTO pathDTO = getDataPullingPathGenerator().Generate(actionId, tenantId, existingActionParamsWithoutRoot);
//        //后续处理ActionExecution，设置productName，locale等
//        this.postActionExecutionProcessor(pathDTO.getActions(), tenantId);
////        Object result = DWServiceResultBuilder.build(pathDTO);
////        return result;
//        return pathDTO;
        return postQueryExecutionPath(actionId, tenantId, existingActionParams, null);
    }

    public Object postActionConfig(DimensionParam data) throws Exception {
        if (data.getActionId() == null) {
            throw new IllegalArgumentException(I18nUtils.getValue("knowledgegraph.actionNull"));
        }
        ActionConfig config = actionRepository.queryActionConfig(data.getActionId());
        abstractionHandler.dealWithAbstraction(config, data);
        // return DWServiceResultBuilder.build(config);
        return config;
    }

    public Object postQueryExecutionInfo(String actionId) throws Exception {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantId = (String) profile.getOrDefault("tenantId", "");
        ActionExecutionDTO actionExecutionDTO = this.actionQueryService.queryActionExeution(actionId, tenantId);
        if(null==actionExecutionDTO){
            return new ActionExecutionDTO();
        }
        this.postActionExecutionProcessor(Arrays.asList(actionExecutionDTO), tenantId, null);

        //查找返回对应appCode和appVersion
        processAppCodeVersion(actionExecutionDTO);

        //return DWServiceResultBuilder.build(actionExecutionDTO);
        return actionExecutionDTO;
    }

    private void processAppCodeVersion(ActionExecutionDTO actionExecutionDTO) throws DWBusinessException {
        ApplicationRelation relation = appService.getApplicationByTypeAndCode("action", actionExecutionDTO.getActionId());
        if (relation != null) {
            actionExecutionDTO.setAppCode(relation.getAppCode());
            AppTenantVersion version = appTenantVersionService.postQueryVersion(relation.getAppCode());
            if (version != null) {
                actionExecutionDTO.setAppVersion(version.getAppVersion());
            }
        }
    }

    private void postActionExecutionProcessor(List<ActionExecutionDTO> actionExecutions, String tenantId, List<String> existsSysParamsWithoutRoot) throws Exception {
        for (ActionExecutionDTO e : actionExecutions) {
            if (e instanceof ESPActionExecutionDTO) {
                String productName = this.productNameResolver.getProductName(((ESPActionExecutionDTO) e).getServiceName(), tenantId);
                ((ESPActionExecutionDTO) e).setProductName(productName);
            } else if (e instanceof StartProcessActionExecutionDTO) {
                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
                String token = headers == null ? null : (String) headers.get("token");
                ((StartProcessActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
            } else if (e instanceof StartDataEventActionExecutionDTO) {
                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
                String token = headers == null ? null : (String) headers.get("token");
                ((StartDataEventActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
            } else if (e instanceof StartServiceComposerActionExecutionDTO) {
                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
                String token = headers == null ? null : (String) headers.get("token");
                ((StartServiceComposerActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
            }
            // 如果存在sysParam，则把type改为SYSPARAM
            if (CollectionUtils.isNotEmpty(existsSysParamsWithoutRoot)) {
                List<ActionExecutionParamDTO> params = e.getParams();
                if (CollectionUtils.isNotEmpty(params)) {
                    for (ActionExecutionParamDTO executionParamDTO : params) {

                        String value = (!(executionParamDTO instanceof  MultiPathActionExecutionParamDTO) && executionParamDTO.getValue().startsWith("$.")) ? executionParamDTO.getValue().substring(2) : executionParamDTO.getValue();
                        if (existsSysParamsWithoutRoot.contains(value)) {
                            executionParamDTO.setType(ActionParamTypeEnum.SYSPARAM);
                        }
                    }
                }
            }
        }

        // todo  敏捷报表修改 后续考虑去掉
        /*if (CollectionUtils.isNotEmpty(existsSysParamsWithoutRoot)) {
            for (ActionExecutionDTO e : actionExecutions) {
                List<ActionExecutionParamDTO> params = e.getParams();
                if (CollectionUtils.isNotEmpty(params)) {
                    for (ActionExecutionParamDTO executionParamDTO : params) {
                        List<String> pathData = getArrayData(executionParamDTO.getName());
                        setSysParam(pathData,params);
                    }
                }
            }
        }*/

//        actionExecutions.forEach(e->{
//            if(e instanceof ESPActionExecutionDTO){
//                String productName = null;
//                 productName = this.productNameResolver.getProductName(((ESPActionExecutionDTO) e).getServiceName(), tenantId);
//                ((ESPActionExecutionDTO) e).setProductName(productName);
//            }else if(e instanceof StartProcessActionExecutionDTO){
//                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
//                String token = headers == null ? null : (String)headers.get("token");
//                ((StartProcessActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
//            }else if(e instanceof StartDataEventActionExecutionDTO){
//                Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
//                String token = headers == null ? null : (String)headers.get("token");
//                ((StartDataEventActionExecutionDTO) e).setLocale(this.iamUtils.getTenantLocale(token));
//            }
//            //如果存在sysParam，则把type改为SYSPARAM
//            if(CollectionUtils.isNotEmpty(existsSysParamsWithoutRoot)){
//                List<ActionExecutionParamDTO> params = e.getParams();
//                if(CollectionUtils.isNotEmpty(params)){
//                    for(ActionExecutionParamDTO executionParamDTO : params){
//                        String value = executionParamDTO.getValue().startsWith("$.") ? executionParamDTO.getValue().substring(2) : executionParamDTO.getValue();
//                        if(existsSysParamsWithoutRoot.contains(value)){
//                            executionParamDTO.setType(ActionParamTypeEnum.SYSPARAM);
//                        }
//                    }
//                }
//            }
//        });
    }

    private List<String> removeActionParamRoot(List<String> existsActionParams) {
        List<String> actionParamsWithoutRoot = new ArrayList();
        if (!CollectionUtils.isEmpty(existsActionParams)) {
            existsActionParams.forEach(e -> {
                if (e.startsWith(ActionCons.ROOT)) {
                    actionParamsWithoutRoot.add(e.substring(2));
                } else {
                    actionParamsWithoutRoot.add(e);
                }
            });
        }
        return actionParamsWithoutRoot;
    }

/*    private List<String> getArrayData(String input) {
        String[] parts = input.split("\\.");

        List<String> output = new ArrayList<>();
        String current = "";

        for (int i = 0; i < parts.length; i++) {
            current += (current.isEmpty() ? "" : ".") + parts[i];
            output.add(current);
        }
        return output;
    }

    private void setSysParam(List<String> pathDatas,List<ActionExecutionParamDTO> params) {
            for (ActionExecutionParamDTO param : params) {
                if (ActionParamTypeEnum.PARAM.equals(param.getType()) && !ActionParamTypeEnum.SYSPARAM.equals(param.getType())
                        && pathDatas.contains(param.getName())) {
                    param.setType(ActionParamTypeEnum.SYSPARAM);
                }
            }
    }*/


    public Object getEspApi() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();

        List<ESPServiceVO> espServiceVOS = this.actionRepository.queryEspService(tenantId, locale, tenantVersion);
        return espServiceVOS;
    }

    public Object getProduct(String serviceName) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        productNameResolver.getCloudProductNamesWithRetry(tenantId, 3);
        List<String> cloudProductNamesWithRetry = this.productNameResolver.getCloudProductNamesWithRetry(serviceName, tenantId, 3);
        return cloudProductNamesWithRetry;
    }

    public Object postSetProduct(String serviceName, String productName) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        this.productNameResolver.setProductNames(serviceName, tenantId, productName);
        return "success";
    }

    public Object postQueryActionInfo(String actionId) throws Exception {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantId = (String) profile.getOrDefault("tenantId", "");
        ActionDefinitionDTO actionDefinitionDTO = this.actionQueryService.queryActionMetadataInfo(actionId, tenantId);

        return actionDefinitionDTO;
    }

    public List<String> getTenantProductList() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        List<String> cloudProductNamesWithRetry = this.productNameResolver.getCloudProductNamesWithRetryAfterEocSet(tenantId, 3);
        return cloudProductNamesWithRetry;
    }

    public Object getSourceIdKey(String ruleCode) throws Exception {
//        Action monitorTriggerAction = this.actionRepository.getMonitorTriggerAction(ruleCode);
//        return monitorTriggerAction == null ? null : monitorTriggerAction.getSourceIdKey();
        String tenantVersion = kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
        return this.actionRepository.getSourceIdKey(ruleCode, tenantVersion);
    }

    public Object postQueryExecutionInfo(List<String> actionIds) throws Exception {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String tenantId = (String) profile.getOrDefault("tenantId", "");
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<ActionExecutionDTO> actionExecutionDTOS = this.actionQueryService.queryActionExeutionList(actionIds, tenantId, tenantVersion);
        this.postActionExecutionProcessor(actionExecutionDTOS, tenantId, null);
        //return DWServiceResultBuilder.build(actionExecutionDTO);
        return actionExecutionDTOS;
    }

    public Object postAddMdcApiMetadataToNeo4j(String messageStr) {
//        List<String> executeNeo4jScripts = (Arrays.asList("match (a:MonitorRule{code:'149'}) return a"));
        ApiMetadataDataDTO espApiMetadata = JSON.parseObject(messageStr, ApiMetadataDataDTO.class);
        String apiName = espApiMetadata.getApi_name();
        String apiVersion = espApiMetadata.getApi_version();
        String remark_cn = espApiMetadata.getRemark().getZh_CN();
        String remark_tw = espApiMetadata.getRemark().getZh_TW();
        remark_cn = remark_cn.replaceAll("'", "");
        remark_tw = remark_tw.replaceAll("'", "");
        String desc_cn = espApiMetadata.getDescription().getZh_CN();
        String desc_tw = espApiMetadata.getDescription().getZh_TW();
        String url = espApiMetadata.getUrl() == null ? "" : espApiMetadata.getUrl();
        String invokeType = espApiMetadata.getType();
        String lastUpdateTime = espApiMetadata.getLastUpdateTime();
        LocalDateTime currentDateTime = LocalDateTime.now(); // 获取当前时间
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"); // 定义格式化规则
        String currentTime = currentDateTime.format(formatter); // 格式化时间为字符串
        Boolean idempotency = espApiMetadata.getIdempotency();
        String actionId = "esp_" + apiName;
        String deployVersion = "1.0";

        ApiDataMetadataDTO dataMetadata = espApiMetadata.getData_metadata();
        List<ApiDataFieldMetadataDTO> fieldsOfParameter = new ArrayList<>();
        if (dataMetadata.getRequest().getBody().getField() != null && dataMetadata.getRequest().getBody().getField().get(0).getField() != null) {
            fieldsOfParameter = dataMetadata.getRequest().getBody().getField().get(0).getField();
        }
        List<ApiDataFieldMetadataDTO> fieldRequestObjects = new ArrayList<>();
        for (ApiDataFieldMetadataDTO fieldOfParameter : fieldsOfParameter) {
            if (!fieldOfParameter.getData_name().equals("enterprise_no")
                    && !fieldOfParameter.getData_name().equals("site_no")
                    && !fieldOfParameter.getData_name().equals("call_id")) {
                fieldRequestObjects.add(fieldOfParameter);
            }
        }

        Action oneByActionId = null;
        List<Action> actions = dataPickService.excludeWithSameCode(actionRepository.findByActionIdAndVersion(actionId, deployVersion));
        if(!org.springframework.util.CollectionUtils.isEmpty(actions)){
            oneByActionId = actions.get(0);
        }

        //TODO 暂时从库里已有的EnumKey同步
        if (!ObjectUtils.isEmpty(oneByActionId)) {
            try {
                List<ApiDataFieldMetadataDTO> request_parameters = JSONArray.parseArray(oneByActionId.getRequest_parameters(), ApiDataFieldMetadataDTO.class);
                putEnumKey(fieldRequestObjects, request_parameters);
            }catch(Exception e) {
                log.error("postAddMdcApiMetadataToNeo4j parseObject error:{}",e);
            }
        }

        String request_str = JSON.toJSONString(fieldRequestObjects, SerializerFeature.NotWriteDefaultValue);
        List<ApiDataFieldMetadataDTO> fieldsOfResponse = dataMetadata.getResponse_success().getBody().getField();
        ApiDataFieldMetadataDTO fieldReponseObject = null;
        for (ApiDataFieldMetadataDTO fieldOfResponse : fieldsOfResponse) {
            if (fieldOfResponse.getData_name().equals("parameter")) {
                fieldReponseObject = fieldOfResponse;
                break;
            }
        }
        String response_str = "";
        if (fieldReponseObject != null && fieldReponseObject.getField().size() > 0) {
            Optional<ApiDataFieldMetadataDTO> findObject = fieldReponseObject.getField().stream().filter(field -> "object".equals(field.getData_type())).findFirst();
            if (findObject.isPresent()) {
                ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = findObject.get();
                //TODO 暂时从库里已有的EnumKey同步
                if (!ObjectUtils.isEmpty(oneByActionId)) {
                    try {
                        ApiDataFieldMetadataDTO response_object = JSONObject.parseObject(oneByActionId.getResponse_object(), ApiDataFieldMetadataDTO.class);
                        if (response_object != null) {
                            putEnumKey(apiDataFieldMetadataDTO, response_object);
                        }
                    }catch (Exception e) {
                        log.error("postAddMdcApiMetadataToNeo4j parseObject error:{}",e);
                    }
                }
                response_str = JSON.toJSONString(apiDataFieldMetadataDTO, SerializerFeature.NotWriteDefaultValue);
            } else
                response_str = JSON.toJSONString(fieldReponseObject.getField().get(0), SerializerFeature.NotWriteDefaultValue);
        }


        List<String> executeNeo4jScripts = new ArrayList<>();
        if (ObjectUtils.isEmpty(oneByActionId)) {
            log.info("MdcApiMetadata Create：{}", actionId);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Create (action:Action:EspAction {");
            stringBuffer.append("actionId:'");
            stringBuffer.append(actionId);
            stringBuffer.append("', url:'");
            stringBuffer.append(url);
            stringBuffer.append("', serviceName:'");
            stringBuffer.append(apiName);
            stringBuffer.append("', serviceVersion:'");
            stringBuffer.append(apiVersion);
            stringBuffer.append("', actionName:'");
            stringBuffer.append(desc_cn);
            stringBuffer.append("', actionName_tw:'");
            stringBuffer.append(desc_tw);
            stringBuffer.append("', desc:'");
            stringBuffer.append(remark_cn);
            stringBuffer.append("', desc_tw:'");
            stringBuffer.append(remark_tw);
            stringBuffer.append("', request_parameters:'");
            stringBuffer.append(request_str.replaceAll("'", "")/*.replaceAll("(?<!/)/(?!/)", "、").replaceAll("'", "\\\\'")).replaceAll("\\\\\"","").replaceAll("'", "\\\\'")*/);
            stringBuffer.append("', response_object:'");
            stringBuffer.append(response_str.replaceAll("'", "")/*.replaceAll("(?<!/)/(?!/)", "、").replaceAll("'", "\\\\'")).replaceAll("\\\\\"","").replaceAll("'", "\\\\'")*/);
            stringBuffer.append("', invokeType:'");
            stringBuffer.append(invokeType);
            stringBuffer.append("', lastUpdateTime:'");
            stringBuffer.append(lastUpdateTime);
            stringBuffer.append("', updateTime:'");
            stringBuffer.append(currentTime);
            stringBuffer.append("', idempotency:");
            stringBuffer.append(idempotency);
            stringBuffer.append(", version:'");
            stringBuffer.append(deployVersion);
            stringBuffer.append("', nameSpace:'");
            stringBuffer.append("espCommon");
            stringBuffer.append("'})");

//            StringBuffer relationSb = new StringBuffer();
//            relationSb.append("match (te:TenantEntity{ifCommon:true,version:'1.0'})")
//                    .append(" match (espAction:Action{")
//                    .append("actionId:'")
//                    .append(actionId)
//                    .append("', version:'1.0'}) ")
//                    .append(" merge (te)-[:ACTION]->(espAction)");

            executeNeo4jScripts.add(StringEscapeUtils.escapeJava(stringBuffer.toString()));
        //    executeNeo4jScripts.add(relationSb.toString());
        } else {
            log.info("MdcApiMetadata Update：{}", actionId);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Match (action:Action:EspAction {");
            stringBuffer.append("actionId:'");
            stringBuffer.append(actionId);
            stringBuffer.append("', version:'");
            stringBuffer.append(deployVersion);
            stringBuffer.append("'})  set action.url='");
            stringBuffer.append(url);
            stringBuffer.append("', action.serviceName='");
            stringBuffer.append(apiName);
            stringBuffer.append("', action.serviceVersion='");
            stringBuffer.append(apiVersion);
            stringBuffer.append("', action.actionName='");
            stringBuffer.append(desc_cn);
            stringBuffer.append("', action.actionName_tw='");
            stringBuffer.append(desc_tw);
            stringBuffer.append("', action.desc='");
            stringBuffer.append(remark_cn);
            stringBuffer.append("', action.desc_tw='");
            stringBuffer.append(remark_tw);
            stringBuffer.append("', action.request_parameters='");
            stringBuffer.append(request_str.replaceAll("'", "")/*.replaceAll("(?<!/)/(?!/)", "、")/*.replaceAll("\\\\\"","").replaceAll("'", "\\\\'")*/);
            stringBuffer.append("', action.response_object='");
            stringBuffer.append(response_str.replaceAll("'", "")/*.replaceAll("(?<!/)/(?!/)", "、")/*.replaceAll("\\\\\"","").replaceAll("'", "\\\\'")*/);
            stringBuffer.append("', action.invokeType='");
            stringBuffer.append(invokeType);
            stringBuffer.append("', action.lastUpdateTime='");
            stringBuffer.append(lastUpdateTime);

            stringBuffer.append("', action.updateTime='");
            stringBuffer.append(currentTime);
            stringBuffer.append("', action.idempotency=");
            stringBuffer.append(idempotency);
            stringBuffer.append(", action.version='");
            stringBuffer.append(deployVersion);
            stringBuffer.append("', action.nameSpace='");
            stringBuffer.append("espCommon");
            stringBuffer.append("'");

            executeNeo4jScripts.add(StringEscapeUtils.escapeJava(stringBuffer.toString()));
        }

        executeNeo4jScript(executeNeo4jScripts,sessionFactoryDomain1);
        executeNeo4jScript(executeNeo4jScripts, sessionFactoryDomain2);
        return "success";
    }

    private void executeNeo4jScript(List<String> executeNeo4jScripts,SessionFactory sessionFactory){

/*        if (CollectionUtils.isNotEmpty(executeNeo4jScripts)) {
            for (String str : executeNeo4jScripts) {
                Neo4j2EspManager.getNeo4j2EspManager().ExecuteNoQuery(str);
            }
        }*/
        if(org.springframework.util.CollectionUtils.isEmpty(executeNeo4jScripts)){
            return;
        }

        if(sessionFactory == null){
            return;
        }
        Session session = sessionFactory.openSession();

        try (Transaction transaction = session.beginTransaction()){
            for(String str : executeNeo4jScripts){
                session.query(str, new HashMap<>());
            }
            transaction.commit();
        }catch (Exception e) {
            log.error("executeNeo4jScript error:{}",e);
        }

        session.clear();
    }

    private void putEnumKey(ApiDataFieldMetadataDTO toApiDataFieldMeta, ApiDataFieldMetadataDTO fromApiDataFieldMeta) {
        if (toApiDataFieldMeta.getData_name().equals(fromApiDataFieldMeta.getData_name())) {
            if ("object".equals(toApiDataFieldMeta.getData_type()) && "object".equals(fromApiDataFieldMeta.getData_type())) {
                List<ApiDataFieldMetadataDTO> toApiSubDataFieldMeta = toApiDataFieldMeta.getField();
                List<ApiDataFieldMetadataDTO> fromApiSubDataFieldMeta = fromApiDataFieldMeta.getField();
                putEnumKey(toApiSubDataFieldMeta, fromApiSubDataFieldMeta);
            } else {
                toApiDataFieldMeta.setEnum_key(fromApiDataFieldMeta.getEnum_key());
            }
        }
    }

    private void putEnumKey(List<ApiDataFieldMetadataDTO> toApiDataFieldMetas, List<ApiDataFieldMetadataDTO> fromApiDataFieldMetas) {
        toApiDataFieldMetas.forEach(toApiDataFieldMetadata -> {
            Optional<ApiDataFieldMetadataDTO> fromApiDataFieldMeta = fromApiDataFieldMetas.stream().filter(fromApiDataFieldMetadata -> fromApiDataFieldMetadata.getData_name().equals(toApiDataFieldMetadata.getData_name())).findFirst();
            if (fromApiDataFieldMeta.isPresent())
                putEnumKey(toApiDataFieldMetadata, fromApiDataFieldMeta.get());
        });
    }

    private void logTrace(String actionId, boolean success, String errorMsg) {
        LogDataDto logDataDto = new LogDataDto(actionId, "行动actionId", LogConstant.TYPE_CONFIG, LogConstant.LABEL_ACTION);
        String message = success ? "知识图谱求取行动逻辑图谱成功" : "知识图谱求取行动逻辑图谱失败,失败信息:" + errorMsg;
        LogDto logDto = new LogDto(message, Arrays.asList(logDataDto));
        if(success){
            log.info(logDto.toString());
        }else{
            log.error(logDto.toString());
        }

    }

    // actions的重复问题处理
    private void handleDistinctActions(List<ActionExecutionDTO> actions) {
        if (CollectionUtils.isNotEmpty(actions)) {
            actions.forEach(action -> {
                List<ActionExecutionParamDTO> params = action.getParams();
                List<ActionExecutionParamDTO> uniqueParams = new ArrayList<>();

                // 使用 HashSet 去重
                Set<String> distinctParams = new HashSet<>();

                for (ActionExecutionParamDTO param : params) {
                    if (param instanceof PullingActionExecutionParamDTO) {
                        PullingActionExecutionParamDTO pullingParam = (PullingActionExecutionParamDTO) param;
                        String key = createKey(pullingParam.getName(), pullingParam.getType().toString(), pullingParam.getValue(), pullingParam.getSource());
                        // 根据 key 去重
                        if (!distinctParams.contains(key)) {
                            // actions中的#替换为.
//                            uniqueParams.add(JSON.parseObject(JSON.toJSONString(param).replaceAll("#", "."), PullingActionExecutionParamDTO.class));
                            uniqueParams.add(param);
                            distinctParams.add(key);
                        }
                    } else {
                        String key = createKey(param.getName(), param.getType().toString(), param.getValue(), null);
                        // 根据 key 去重
                        if (!distinctParams.contains(key)) {
                            uniqueParams.add(param);
                            distinctParams.add(key);
                        }
                    }
                }

                action.setParams(uniqueParams);
            });
        }
    }

    private String createKey(String name, String type, String value, String source) {
        return name + type + value + (source != null ? source : "");
    }

    public String postFindLastNodeShapeType(String nodeType,
                                            String reportRelationFir,String reportRelationSec,String reportRelationThi,String reportRelationFou) {

        if(StringUtils.isEmpty(nodeType)){
            return null;
        }

        Map<String,Object> param = new HashMap<>();


        String query = "MATCH (rd:ReportDesign {nodeType: $nodeType})";
        param.put("nodeType",nodeType);
        // 比较："1"，分布："2"，构成："3"，联系："4"
        if ("2".equals(nodeType)) {
            if (reportRelationFir != null) {
                query += "-[:LINK*]->(vis:ReportDistributionVariable {reportRelationFir: $reportRelationFir})";
                param.put("reportRelationFir",reportRelationFir);

                if ("1".equals(reportRelationFir) && StringUtils.isNotEmpty(reportRelationSec)) {  // 变量数为1才会有reportRelationSec
                    query += "-[:LINK]->(rel:ReportDistributionRelation {reportRelationSec: $reportRelationSec})";
                    param.put("reportRelationSec",reportRelationSec);
                }
            }
        }else if ("4".equals(nodeType)) {
            if (reportRelationFir != null) {
                query += "-[:LINK*]->(vis:ReportRelationVariable {reportRelationFir: $reportRelationFir})";
                param.put("reportRelationFir",reportRelationFir);
            }
        }else if ("3".equals(nodeType)) {
            if (StringUtils.isNotEmpty(reportRelationFir)) {
                query += "-[:LINK]->(relationFir:ReportConstituteRelationFir {reportRelationFir: $reportRelationFir})";
                param.put("reportRelationFir",reportRelationFir);
            }
            if (StringUtils.isNotEmpty(reportRelationSec) && "随时间变化".equals(reportRelationSec)) {
                query += "-[:LINK]->(relationSec:ReportConstituteRelationSec {reportRelationSec: $reportRelationSec})";
                param.put("reportRelationSec",reportRelationSec);
            }
            if (StringUtils.isNotEmpty(reportRelationThi)) {
                query += "-[:LINK]->(relationThi:ReportConstituteRelationThi {reportRelationThi: $reportRelationThi})";
                param.put("reportRelationThi",reportRelationThi);
            }

        }else if ("1".equals(nodeType)) {
            if (StringUtils.isNotEmpty(reportRelationFir)) {
                query += "-[:LINK]->(relationFir:ReportCompareRelationFir {reportRelationFir: $reportRelationFir})";
                param.put("reportRelationFir",reportRelationFir);
            }
            if (StringUtils.isNotEmpty(reportRelationSec)) {
                query += "-[:LINK]->(relationSec:ReportCompareRelationSec {reportRelationSec: $reportRelationSec})";
                param.put("reportRelationSec",reportRelationSec);
            }
            if (StringUtils.isNotEmpty(reportRelationThi)) {
                if (!"基于分类".equals(reportRelationFir) || ("基于分类".equals(reportRelationFir) && !"每项目2个变量".equals(reportRelationSec))) {
                    query += "-[:LINK]->(relationThi:ReportCompareRelationThi {reportRelationThi: $reportRelationThi})";
                    param.put("reportRelationThi",reportRelationThi);
                }
            }
            if (StringUtils.isNotEmpty(reportRelationFou) && "少数分类".equals(reportRelationThi)) {
                query += "-[:LINK]->(relationFou:ReportCompareRelationFou {reportRelationFou: $reportRelationFou})";
                param.put("reportRelationFou",reportRelationFou);
            }
        }

        query += "-[:LINK*]->(shape:ReportShape)"
                + " RETURN shape.type AS shapeType"
                + " LIMIT 1";

        Session session = neo4jSessionFactory.openSession();
        Result result = session.query(query, param);
        Iterable<Map<String, Object>> iterableResult =  result.queryResults();
        Iterator<Map<String, Object>> iterator = iterableResult.iterator();
        if (iterator.hasNext()) {
            Map record = iterator.next();
            if (Objects.nonNull(record.get("shapeType"))) {
                // 构成全部对饼图
                return "3".equals(nodeType) ? "饼图" : record.get("shapeType").toString();
            }else {
                return null;
            }
        }
        return null;
    }


    public Object postMetaDataStruct(List<String> actionIds) throws Exception {
        List<DataSourceStructDTO> dataSources = new ArrayList<>();
        String tenantId = AthenaUtils.getTenantId();

        // 查询action的入参 并转Map
        List<ActionExecutionParam> actionExecutionParams = mongoTemplate.find(Query.query(Criteria.where("actionId").in(actionIds)), ActionExecutionParam.class);
        Map<String, List<String>> actionExecutionParamMap = actionExecutionParams.stream().collect(Collectors.toMap(ActionExecutionParam::getActionId, a -> a.getExecutionParam()));

        for (String actionId : actionIds) {
            // 查pulling action的图谱所有的action
            ActionExecutionPathDTO pathDTO = (ActionExecutionPathDTO) this.postQueryExecutionPath(actionId, tenantId, CollectionUtils.isEmpty(actionExecutionParamMap.get(actionId)) ? new ArrayList<>() : actionExecutionParamMap.get(actionId), new ArrayList<>());
            List<ActionDefinitionDTO> actionData = pathDTO.getActionMetadatas();

            dataSources.add(convertActionDefinitionToDataSourceField(actionData,actionId));
        }

        return dataSources;
    }

    // 平铺转换
    public DataSourceStructDTO convertActionDefinitionToDataSourceField(List<ActionDefinitionDTO> actionDefinitions,String actionId) {
        DataSourceStructDTO dataSourceStructDTO = new DataSourceStructDTO();
        dataSourceStructDTO.setActionId(actionId);

        List<FieldDTO> input = new ArrayList<>();
        List<FieldDTO> output = new ArrayList<>();

        for (ActionDefinitionDTO actionDefinition :actionDefinitions) {
            if (actionDefinition.getRequest() != null && !CollectionUtils.isEmpty(actionDefinition.getRequest().getParameters())) {
                for (ApiDataFieldDefinitionDTO param : actionDefinition.getRequest().getParameters()) {
                    input.addAll(convertApiDataFieldWithNestedFieldsToFields(param));
                }
            }

            if (Objects.equals(actionId,actionDefinition.getActionId()) && actionDefinition.getResponse() != null && actionDefinition.getResponse().getData() != null && !org.springframework.util.CollectionUtils.isEmpty(actionDefinition.getResponse().getData().getField())) {
                for (ApiDataFieldDefinitionDTO field : actionDefinition.getResponse().getData().getField()) {
                    output.addAll(convertApiDataFieldWithNestedFieldsToFields(field));
                }
            }
        }

        // 如果出参类型是date且入参已经包含则去掉该重名的出参栏
        output.removeIf(field -> input.stream().anyMatch(inputField ->
                Objects.equals(inputField.getName(), field.getName()) && Objects.equals("date", inputField.getDataType())
        ));

        dataSourceStructDTO.setInput(mergeAdjustFieldParam(input));
        dataSourceStructDTO.setOutput(output);

        return dataSourceStructDTO;
    }

    public List<FieldDTO> convertApiDataFieldWithNestedFieldsToFields(ApiDataFieldDefinitionDTO apiDataField) {
        List<FieldDTO> fields = new ArrayList<>();
        if (!"object".equals(apiDataField.getData_type())) {
            FieldDTO field = convertApiDataFieldToField(apiDataField);
            fields.add(field);
        }

        if (!CollectionUtils.isEmpty(apiDataField.getField())) {
            for (ApiDataFieldDefinitionDTO nestedField : apiDataField.getField()) {
                fields.addAll(convertApiDataFieldWithNestedFieldsToFields(nestedField));
            }
        }
        return fields;
    }


    public FieldDTO convertApiDataFieldToField(ApiDataFieldDefinitionDTO apiDataField) {
        FieldDTO field = new FieldDTO();
        field.setName(apiDataField.getData_name());
        field.setRequired(Boolean.parseBoolean(apiDataField.getRequired()));
        field.setDataType(apiDataField.getData_type());
        // 其他字段的映射
        return field;
    }

    // 合并重复入参
    public List<FieldDTO> mergeAdjustFieldParam(List<FieldDTO> fieldDTOList) {
        Map<String, FieldDTO> mergedFieldMap = fieldDTOList.stream()
                .collect(Collectors.toMap(FieldDTO::getName, field -> field, (existing, replacement) -> existing));

        // 将Map转换为List<FieldDTO>
        List<FieldDTO> mergedFieldList = mergedFieldMap.values().stream()
                .collect(Collectors.toList());

        return mergedFieldList;
    }

    @Override
    public Object postMetricActionData(List<String> actionIds) throws Exception {
        if (CollectionUtils.isEmpty(actionIds)) {
            return null;
        }

        String tenantId = AthenaUtils.getTenantId();
        Map<String ,Object> metricMap = new HashMap<>();

        for (String actionId : actionIds) {
            // 查pulling action的图谱所有的action
            ActionExecutionPathDTO pathDTO = (ActionExecutionPathDTO) this.postQueryExecutionPath(actionId, tenantId, Collections.emptyList(), Collections.emptyList());
            metricMap.put(actionId,pathDTO);
        }

        return metricMap;
    }

}
