package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.log.operation.annotation.DWIgnoreFileLog;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.app.LicenseKeyManager;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.clients.ESPUtils;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.SelectVariableOptionSetting;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.application.*;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.core.app.FunctionCtrl;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import com.digiwin.athena.kg.domain.OpenWindowDefinition;
import com.digiwin.athena.kg.domain.ApplicationCustomizedConfig;
import com.digiwin.athena.knowledgegraph.domain.digitalstaff.DigitalStaff;
import com.digiwin.athena.knowledgegraph.domain.task.TaskMonitorRule;
import com.digiwin.athena.knowledgegraph.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.filter.LoginInfo;
import com.digiwin.athena.knowledgegraph.po.AppRelationBatchPo;
import com.digiwin.athena.knowledgegraph.po.InitMonitorRuleGroup;
import com.digiwin.athena.knowledgegraph.po.dap.*;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.repository.neo4j.ActionRepository;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.knowledgegraph.service.IAppService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_KNOWLEDGE_GRAPH;

@Lang
@Slf4j
@Service
@MyExceptionHandler
public class AppService implements IAppService {

    @Autowired
    private LicenseKeyManager licenseKeyManager;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplate;
    @Autowired
    private IamService iamService;

    @Autowired
    TenantService tenantService;

    @Autowired
    MongoEntityBaseDAO mongoEntityBaseDAO;

    @Autowired
    private MonitorRuleRepository monitorRuleRepository;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    private IMechanismService iMechanismService;

    @Autowired
    private ComponentManager componentManager;

    @Autowired
    ActionRepository actionRepository;

    @Autowired
    TranslateUtils translateUtils;

    @Autowired
    private ESPUtils espUtils;

    @Autowired
    private DataPickService dataPickService;

    @Autowired
    AppMetaCaller appMetaCaller;

    @Override
    public ApplicationRelation getApplicationByTypeAndCode(String type, String code) throws DWBusinessException {
//        Criteria criteria = new Criteria();
//        criteria.and("code").is(code).and("type").is(type);
//        return dataPickService.findOneByCondition(criteria, ApplicationRelation.class, "applicationRelation");
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("code",code);
        RespApplicationRelation resp = appMetaCaller.call("/app/applicationByTypeAndCode","get",map,RespApplicationRelation.class);
        return resp.getResponse();
    }

    @Override
    public ApplicationRelation getApplicationByTypeAndCode(String type, String code, String lang) throws DWBusinessException {
//        ApplicationRelation applicationRelation = getApplicationByTypeAndCode(type, code);
//        Application application = null;
//        try {
//            application = getApplicationByCode(applicationRelation.getAppCode());
//        } catch (Exception e) {
//            log.warn("获取应用异常 for type:{},code:{}", type, code);
//        }
//        if (application != null && application.getLang() != null) {
//            Map nameLangMap = application.getLang().get("name");
//            String language = null == nameLangMap.get(lang) ? application.getName() : (String) nameLangMap.get(lang);
//            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
//        }
//        return applicationRelation;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("code",code);
        map.put("lang",lang);
        RespApplicationRelation resp = appMetaCaller.call("/app/applicationByTypeAndCodeAndLang1","get",map,RespApplicationRelation.class);
        return resp.getResponse();
    }

    @Override
    @DWIgnoreFileLog
    public Map<String, List<ApplicationRelation>> getApplicationsMapByTypeAndCodes(String type,
                                                                                   Collection<String> codes, Map<String, Activity> activityMap) throws DWBusinessException {
//        Map<String, Object> keyConditions = new HashMap<>();
//        keyConditions.put("type", type);
//        Map<String, List<ApplicationRelation>> applicationRelationsMap = mongoEntityBaseDAO.find(keyConditions, "code"
//                , codes, ApplicationRelation.class, activityMap);
//        //Assert.notNull(applicationRelation, "查询结果为空");
//        //[{"type":"1","code":"1"},{"type":"1","code":"1","tenantId":"1"},{"type":"1","code":"2","tenantId":"1"}]
//        return applicationRelationsMap;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("codes", codes);
        map.put("activityMap", activityMap);
        RespMapApplicationList resp = appMetaCaller.call("/app/applicationsMapByTypeAndCodesAndActivityMap","post",map, RespMapApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public Map<String, List<ApplicationRelation>> getApplicationsMapByTypeAndCodes(String type, Collection<String> codes) throws DWBusinessException {
//        Map<String, Object> keyConditions = new HashMap<>();
//        keyConditions.put("type", type);
//        Map<String, List<ApplicationRelation>> applicationRelationsMap = mongoEntityBaseDAO.find(keyConditions, "code", codes, ApplicationRelation.class, new HashMap<>());
//        //Assert.notNull(applicationRelation, "查询结果为空");
//        //[{"type":"1","code":"1"},{"type":"1","code":"1","tenantId":"1"},{"type":"1","code":"2","tenantId":"1"}]
//        return applicationRelationsMap;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("codes", codes);
        RespMapApplicationList resp = appMetaCaller.call("/app/applicationsMapByTypeAndCodes","post",map, RespMapApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationByTypeAndCode(String type, List<String> codeList) throws DWBusinessException {
//        return getApplicationByTypeAndCode(type, null, codeList);
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("codes",codeList);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationByTypeAndCodeList","post",map,RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationByTypeAndCode(String type, String subType, List<String> codeList) throws DWBusinessException {
//        Criteria criteria = Criteria.where("type").is(type)
//                .and("code").in(codeList);
//        if (StringUtils.isNotEmpty(subType)) {
//            criteria.and("subType").is(subType);
//        }
//        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("subType", subType);
        map.put("codes", codeList);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationByTypeAndSubTypeAndCodeList","post",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationsByTypeAndCode(String type, String code) throws DWBusinessException {
//        return getApplicationByTypeAndCode(type, null, Collections.singletonList(code));
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("code",code);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationsByTypeAndCode","get",map,RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<Application> getApplicationsByCodes(Collection<String> codes) throws DWBusinessException {
//        Criteria criteria = Criteria.where("code").in(codes);
//        return dataPickService.find(criteria, Application.class, "application");
        Map<String,Object> map = AppMetaCaller.of("codes",codes);
        RespApplicationList resp = appMetaCaller.call("/app/applicationsByCodes","post",map, RespApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public Application getApplicationByCode(String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return getApplicationByCode(code, tenantId);
//        Map<String,Object> map = AppMetaCaller.of("code",code);
//        RespApplication resp = appMetaCaller.call("/app/applicationByCode","get",map,RespApplication.class);
//        return resp.getResponse();
    }

    @Override
    public Application getApplicationByCode(String code, String tenantId) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").is(code);
        return dataPickService.findOneByCondition(criteria, tenantId, Application.class, "application");
//        Map<String,Object> map = AppMetaCaller.of("code",code);
//        map.put("tenantId", tenantId);
//        RespApplication resp = appMetaCaller.call("/app/applicationByCodeAndTenantId","get",map, RespApplication.class);
//        return resp.getResponse();
    }

    @Override
    public FunctionCtrl getApplicationFunctionCtrlByBizCode(String code) throws DWBusinessException {
        Application application = getApplicationByCode(code);
        if (null == application) {
            throw new DWBusinessException("app not found");
        } else {
            return application.getFunctionCtrl();
        }
    }

    @Override
    public FunctionCtrl getApplicationFunctionCtrlByAppCode(String code) throws DWBusinessException {
        /*Application application = getApplicationByCode(code);
        if (null == application) {
            throw new DWBusinessException("app not found");
        } else {
            return application.getFunctionCtrl();
        }*/
        FunctionCtrl functionCtrl = new FunctionCtrl();
        functionCtrl.setProjectCardCustomizeFlag(true);
        functionCtrl.setTaskCardCustomizeFlag(true);
        functionCtrl.setTaskCardMergeCustomizeFlag(true);
        return functionCtrl;
    }

    @Override
    public List<Map> getApplicationRecommendations() throws DWBusinessException {
//        Locale locale = DWResourceBundleUtils.getCurrentLocale();
//        String localeStr = locale.toString();
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        //String tenantVersion = "init";
//        // 获取租户下有权限的应用
//        List<String> tenantAppCodes = tenantService.getAppCodes();
//        /*List<String> tenantAppCodes = new ArrayList<String>(){{
//            add("PWD");
//            add("PCC");
//        }};*/
//        Criteria criteria = new Criteria();
//        criteria.and("appCode").in(tenantAppCodes).and("version").is(tenantVersion);
//        List<ApplicationRecommendation> applicationRecommendations = mongoTemplateSystem.find(new Query(criteria),
//                ApplicationRecommendation.class);
//        Map<String, List<ApplicationRecommendation>> groupedApplicationRecommendations = null;
//        List<Map> resultList = new LinkedList<>();
//        if (CollectionUtils.isNotEmpty(applicationRecommendations)) {
//            applicationRecommendations.forEach(item -> {
//                if (!org.springframework.util.StringUtils.isEmpty(item.getLang().get("template").get(localeStr))) {
//                    item.setTemplate(item.getLang().get("template").get(localeStr));
//                }
//                if (!org.springframework.util.StringUtils.isEmpty(item.getLang().get("appName").get(localeStr))) {
//                    item.setAppName(item.getLang().get("appName").get(localeStr));
//                }
//            });
//            groupedApplicationRecommendations = applicationRecommendations
//                    .stream().collect(Collectors.groupingBy(s -> s.getAppCode()));
//            groupedApplicationRecommendations.forEach((k, v) -> {
//                Map<String, Object> innerMap = new HashMap<>();
//                innerMap.put("appCode", k);
//                innerMap.put("appName", v.get(0).getAppName());
//                innerMap.put("group", v.stream().sorted(Comparator.comparing(ApplicationRecommendation::getWeight).reversed()).collect(Collectors.toList()));
//                resultList.add(innerMap);
//            });
//        }
//        return resultList;
        RespObject resp = appMetaCaller.call("/app/applicationRecommendations","get",null, RespObject.class);
        return (List<Map>) resp.getResponse();
    }

    @DWIgnoreFileLog
    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type,
                                                                                                  Collection<String> codes, String lang, Map<String, Activity> activityMap) throws DWBusinessException {
        Map<String, List<ApplicationRelation>> applicationRelationsMap = getApplicationsMapByTypeAndCodes(type, codes, activityMap);
        Set<String> applicationsCodes = new HashSet<>();
        applicationRelationsMap.values().forEach(item -> {
            if (!CollectionUtils.isEmpty(item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        List<Application> applications = getApplicationsByCodes(applicationsCodes);
        Map<String, Application> applicationMap = applications.stream().collect(Collectors.toMap(Application::getCode
                , Function.identity(), (a, b) -> b));
        applicationRelationsMap.forEach((k, v) -> {
            v.forEach(applicationRelation -> {
                Application application = applicationMap.get(applicationRelation.getAppCode());
                if (application != null) {
                    applicationRelation.setCommonApp(null == application.getCommonApp() ? false : application.getCommonApp());
                } else {
                    applicationRelation.setCommonApp(false);
                }
                if (application != null && application.getLang() != null) {
                    Map nameLangMap = application.getLang().get("name");
                    String language = null == nameLangMap.get(lang) ? application.getName() :
                            (String) nameLangMap.get(lang);
                    applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ?
                            applicationRelation.getAppName() : language);
                }
            });
        });
        return applicationRelationsMap;
    }


    @Override
    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type, Collection<String> codes, String lang) throws DWBusinessException {
//        //   log.info("getApplicationByTypeAndCodeAndLang");
//        Map<String, List<ApplicationRelation>> applicationRelationsMap = getApplicationsMapByTypeAndCodes(type, codes);
//        Set<String> applicationsCodes = new HashSet<>();
//        applicationRelationsMap.values().forEach(item -> {
//            if (!CollectionUtils.isEmpty(item)) {
//                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
//            }
//        });
//        List<Application> applications = getApplicationsByCodes(applicationsCodes);
//        Map<String, Application> applicationMap = applications.stream().collect(Collectors.toMap(Application::getCode, Function.identity()));
//        applicationRelationsMap.forEach((k, v) -> {
//            v.forEach(applicationRelation -> {
//                Application application = applicationMap.get(applicationRelation.getAppCode());
//                if (application != null && application.getLang() != null) {
//                    Map nameLangMap = application.getLang().get("name");
//                    String language = null == nameLangMap.get(lang) ? application.getName() : (String) nameLangMap.get(lang);
//                    applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
//                }
//            });
//        });
//        return applicationRelationsMap;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("codes", codes);
        map.put("lang", lang);
        RespMapApplicationList resp = appMetaCaller.call("/app/applicationRelationsMapByTypeAndCodesAndLang","post",map, RespMapApplicationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationsByTypeAndCodeAndLang(String type, String code, String lang) throws DWBusinessException {
//        //   log.info("getApplicationByTypeAndCodeAndLang");
//        List<ApplicationRelation> applicationRelations = getApplicationsByTypeAndCode(type, code);
//        if (CollectionUtils.isEmpty(applicationRelations)) {
//            return new LinkedList<>();
//        }
//        applicationRelations.forEach(applicationRelation -> {
//            Application application = null;
//            try {
//                application = getApplicationByCode(applicationRelation.getAppCode());
//            } catch (DWBusinessException e) {
//                log.warn("获取应用异常", e);
//            }
//            if (application != null && application.getLang() != null) {
//                Map nameLangMap = application.getLang().get("name");
//                String language = null == nameLangMap.get(lang) ? application.getName() : (String) nameLangMap.get(lang);
//                applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
//            }
//        });
//        return applicationRelations;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("code", code);
        map.put("lang", lang);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationsByTypeAndCodeAndLang","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public ApplicationRelation getApplicationByTypeAndCodeAndLang(String type, String code, String lang) throws DWBusinessException {
//        //   log.info("getApplicationByTypeAndCodeAndLang");
//        ApplicationRelation applicationRelation = getApplicationByTypeAndCode(type, code);
//        if (null != applicationRelation) {
//            Application application = getApplicationByCode(applicationRelation.getAppCode());
//            if (application == null || application.getLang() == null) {
//                return applicationRelation;
//            }
//            Map nameLangMap = application.getLang().get("name");
//            String language = null == nameLangMap.get(lang) ? application.getName() : (String) nameLangMap.get(lang);
//            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
//        }
//        return applicationRelation;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("code", code);
        map.put("lang", lang);
        RespApplicationRelation resp = appMetaCaller.call("/app/applicationByTypeAndCodeAndLang","get",map, RespApplicationRelation.class);
        return resp.getResponse();
    }

    @Override
    public Map<String, ApplicationRelation> getApplicationRelationsMapByApplicationAndLang(Collection<String> codes, String localeStr) throws DWBusinessException {
//        Map<String, ApplicationRelation> applicationRelations = new HashMap<>();
//        List<Application> applications = getApplicationsByCodes(codes);
//        for (Application item : applications) {
//            if (!codes.contains(item.getCode()) || item.getLang() == null) {
//                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appNotFound") + item.getCode());
//            }
//            Map nameLangMap = item.getLang().get("name");
//            String language = null == nameLangMap.get(localeStr) ? item.getName() : (String) nameLangMap.get(localeStr);
//            ApplicationRelation applicationRelation = new ApplicationRelation();
//            applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
//            applicationRelation.setAppCode(item.getCode());
//            applicationRelations.put(applicationRelation.getCode(), applicationRelation);
//        }
//        return applicationRelations;
        Map<String,Object> map = AppMetaCaller.of("codes",codes);
        map.put("localeStr", localeStr);
        RespMapApplication resp = appMetaCaller.call("/app/applicationRelationsMapByApplicationAndLang","post",map, RespMapApplication.class);
        return resp.getResponse();
    }

    @Override
    public ApplicationRelation getApplicationRelationByApplicationAndLang(String code, String localeStr) throws DWBusinessException {
//        ApplicationRelation applicationRelation = new ApplicationRelation();
//        Application application = getApplicationByCode(code);
//        if (application == null || application.getLang() == null) {
//            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appNotFound") + code);
//        }
//        Map nameLangMap = application.getLang().get("name");
//        String language = null == nameLangMap.get(localeStr) ? application.getName() : (String) nameLangMap.get(localeStr);
//        applicationRelation.setAppName(org.springframework.util.StringUtils.isEmpty(language) ? applicationRelation.getAppName() : language);
//        applicationRelation.setAppCode(code);
//        return applicationRelation;
        Map<String,Object> map = AppMetaCaller.of("code",code);
        map.put("localeStr", localeStr);
        RespApplicationRelation resp = appMetaCaller.call("/app/applicationRelationByApplicationAndLang","get",map, RespApplicationRelation.class);
        return resp.getResponse();
    }

    //   @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getLicenseKey$0", ttlSecs = 7200, loadEmpty = true)
    @Override
    public Object getLicenseKey(String tenantId) throws Exception {
//        //return DWServiceResultBuilder.build(new LicenseKeyManager().getLicenseKey(tenantId));
//        return this.licenseKeyManager.getLicenseKey(tenantId);
        Map<String,Object> map = AppMetaCaller.of("tenantId",tenantId);
        RespObject resp = appMetaCaller.call("/app/licenseKey","get",map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object getLicenseKey(String tenantId, String requestFrom, String key, long timestamp) throws Exception {
//        //  return DWServiceResultBuilder.build(new LicenseKeyManager().getLicenseKey(tenantId,requestFrom,key,timestamp));
//        return this.licenseKeyManager.getLicenseKey(tenantId, requestFrom, key, timestamp);
        Map<String,Object> map = AppMetaCaller.of("tenantId",tenantId);
        map.put("requestFrom", requestFrom);
        map.put("key", key);
        map.put("timestamp", timestamp);
        RespObject resp = appMetaCaller.call("/app/licenseKeyByTenantIdAndRequestFromAndKeyAndTime","get",map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object postSetLicenseKey() throws Exception {
//        String athenaLicenceKey = iamService.getAthenaLicenceKey();
//        String tenantId = AthenaUtils.getTenantId();
//        this.licenseKeyManager.setLicenseKey(tenantId, athenaLicenceKey);
//        return "success";
        RespObject resp = appMetaCaller.call("/app/setLicenseKey","post",null, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object postSetLicenseKey(String tenantId) throws Exception {
//        String athenaLicenceKey = iamService.getAthenaLicenceKey(tenantId);
//        log.info("SetLicenseKeyTenantId:{},athenaLicenceKey:{}", tenantId, athenaLicenceKey);
//        this.licenseKeyManager.setLicenseKey(tenantId, athenaLicenceKey);
//        return "success";
        Map<String,Object> map = AppMetaCaller.of("tenantId",tenantId);
        RespObject resp = appMetaCaller.call("/app/setLicenseKeyByTenantId","post",map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object get(String code) throws Exception {
//        if (code == null || code.isEmpty()) {
//            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.codeEmpty"));
//        }
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        Application app = null;
//        if ("common".equals(code)) {
//            String prefix = "BCB"; // 要匹配的前缀字符串
//            Pattern pattern = Pattern.compile("^" + prefix);
//            Criteria criteria = Criteria.where("code").regex(pattern).and("version").is(tenantVersion);
//            List<Application> apps = dataPickService.find(criteria, Application.class, "application");
//            if (!org.springframework.util.CollectionUtils.isEmpty(apps)) {
//                List<Application> commonApps = apps.stream().filter(application -> application.getCommonApp() != null && application.getCommonApp()).collect(Collectors.toList());
//                if (!org.springframework.util.CollectionUtils.isEmpty(commonApps)) {
//                    app = commonApps.get(0);
//                }
//            }
//        } else {
//            app = getApplicationByCode(code);
//        }
//        /*if (null != app && null != app.getCommonApp() && app.getCommonApp()) {
//            return app;
//        }*/
//        /*if (StringUtils.equalsIgnoreCase("common", code) && ObjectUtils.isEmpty(app)) {
//            return new Application();
//        }*/
//        //设置默认值
//        if (CollectionUtils.isEmpty(app.getParamDescription())) {
//            app.setParamDescription(new ArrayList<>());
//        }
//        for (FieldDescription p : app.getParamDescription()) {
//            if (p.getExecutable() == null) {
//                p.setExecutable(1);//默认打开立即执行按钮
//            }
//        }
//        //从applicationRelation获取侦测规则
//        processMonitorRule(app);
//        //从applicationRelation获取变量
//        processVariable(app);
//        //开窗条件组合
//        Map<String, Map<String, String>> openWin = new HashMap<>();
//        for (FieldDescription p : app.getParamDescription()) {
//            if (p.getFieldOpenWindowMap() != null && !p.getFieldOpenWindowMap().isEmpty()) {
//                Map<String, String> map = new HashMap<>();
//                for (FieldOpenWindowSetting setting : p.getFieldOpenWindowMap()) {
//                    map.put(setting.getColumn(), setting.getOpenWindowKey());
//                }
//                openWin.put(p.getKey(), map);
//            }
//        }
//        // 处理参数对应的开窗信息
//        Map<String, Map<String, OpenWindowDefinition>> openWinInfo = postOpenWinInfo(openWin);
//        for (FieldDescription p : app.getParamDescription()) {
//            Map<String, OpenWindowDefinition> temp = openWinInfo.get(p.getKey());
//            p.setFieldOpenWindowDefinitions(temp);
//        }
//
//        //组装组件过滤
////        this.filterByComponentManager(app);
//
//        //按sequence排序
//        if (CollectionUtils.isNotEmpty(app.getParamDescription())) {
//            app.getParamDescription().sort((o1, o2) -> o1.getSequence().compareTo(o2.getSequence()));
//        }
//
//        return app;
        Map<String,Object> map = AppMetaCaller.of("code",code);
        RespObject resp = appMetaCaller.call("/app","get",map, RespObject.class);
        return resp.getResponse();
    }

    /*private void filterByComponentManager(Application app) throws DWBusinessException {
        List<FieldDescription> list = app.getParamDescription();
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, FieldDescription> map = new HashMap<>();
            List<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<>();
            for (FieldDescription f : list) {
                map.put(f.getKey(), f);
                ComponentBaseInfoBO info = new ComponentBaseInfoBO();
                info.setCode(f.getKey());
                if (StringUtils.equalsIgnoreCase(f.getCategory(), "period")) {
                    info.setType(ComponentTypeEnum.MonitorRule);
                } else if (StringUtils.equalsIgnoreCase(f.getCategory(), "variable")) {
                    info.setType(ComponentTypeEnum.MechanismVariable);
                } else {
                    info.setType(ComponentTypeEnum.ApplicationParam);
                }
                componentBaseInfos.add(info);
            }
            //过滤
            List<ComponentBaseInfoBO> filterComponents = componentManager.FilterByTenantApplicationComponentList(app.getCode(), AthenaUtils.getTenantId(), componentBaseInfos);
            List<FieldDescription> filterParams = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(filterComponents)) {//过滤掉所有数据
                if (list.size() == filterComponents.size()) {//数量相同无需过滤
                    filterParams = list;
                } else {
                    for (ComponentBaseInfoBO c : filterComponents) {
                        filterParams.add(map.get(c.getCode()));
                    }
                }
            }
            app.setParamDescription(filterParams);
        }
    }*/

    protected void processVariable(Application app) throws DWBusinessException {
        List<String> variableList = this.getVariableCode(app.getCode());
        if (variableList != null && !variableList.isEmpty()) {
            if (app.getParamDescription() != null) {
                int seq = 1000;
                for (String code : variableList) {
                    boolean existed = false;
                    for (FieldDescription p : app.getParamDescription()) {
                        if (p.getCategory().toLowerCase(Locale.ROOT).equals("variable") && p.getKey().equals(code)) {
                            existed = true;
                            break;
                        }
                    }
                    if (existed) {
                        continue;
                    } else {
                        FieldDescription para = createVariableParam(code);
                        if (para.getSequence() == null) {
                            para.setSequence(seq);
                            seq += 10;
                        }
                        setFieldDescriptionValue(para);
                        app.getParamDescription().add(para);
                    }
                }
            } else {
                List<FieldDescription> paras = new ArrayList<>();
                int seq = 1000;
                for (String code : variableList) {
                    FieldDescription para = createVariableParam(code);
                    if (para.getSequence() == null) {
                        para.setSequence(seq);
                        seq += 10;
                    }
                    setFieldDescriptionValue(para);
                    paras.add(para);
                }
                app.setParamDescription(paras);
            }
        }
    }

    public FieldDescription createVariableParam(String variableCode) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        FieldDescription para = new FieldDescription();
//        para.setKey(variableCode);
//        para.setCategory("variable");
//        para.setDataType("string");
//        para.setRequired(true);
//        para.setReadOnly(false);
//        para.setIsExecute(true);
//        para.setDisplayType("STRING");
//        para.setName(variableCode);
//        para.setDescription(variableCode);
//
//        // 去variableDefinition表中查找侦测规则code对应的参数信息
//        handleParaFromVariD(variableCode, tenantVersion, para);
//
//        return para;

        return this.createVariableParam(variableCode, null);
    }

    public FieldDescription createVariableParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setCategory("variable");
        para.setDataType("string");
        para.setRequired(true);
        para.setReadOnly(false);
        para.setIsExecute(true);
        para.setDisplayType("STRING");
        para.setName(variableCode);
        para.setDescription(variableCode);

        // 去variableDefinition表中查找侦测规则code对应的参数信息
        handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);

        return para;
    }

    public FieldDescription createDefaultParam(String variableCode) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        FieldDescription para = new FieldDescription();
//        para.setKey(variableCode);
//        para.setDataType("object");
//        para.setRequired(true);
//        para.setReadOnly(false);
//        para.setIsExecute(true);
//        para.setName(variableCode);
//        para.setDescription(variableCode);
//
//        // 去variableDefinition表中查找侦测规则code对应的参数信息
//        FieldDescription fieldDescription = handleParaFromVariD(variableCode, tenantVersion, para);
//
//
//        return fieldDescription == null ? null : para;

        return this.createDefaultParam(variableCode, null);
    }

    public FieldDescription createDefaultParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setDataType("object");
        para.setRequired(true);
        para.setReadOnly(false);
        para.setIsExecute(true);
        para.setName(variableCode);
        para.setDescription(variableCode);

        // 去variableDefinition表中查找侦测规则code对应的参数信息
        FieldDescription fieldDescription = handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);


        return fieldDescription == null ? null : para;
    }

    public FieldDescription createLinkParam(String variableCode) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        FieldDescription para = new FieldDescription();
//        para.setKey(variableCode);
//        para.setCategory("link");
//        para.setDataType("object");
//        para.setRequired(true);
//        para.setReadOnly(false);
//        para.setIsExecute(true);
//        para.setDisplayType("LINK");
//        para.setName(variableCode);
//        para.setDescription(variableCode);
//
//        // 去variableDefinition表中查找侦测规则code对应的参数信息
//        handleParaFromVariD(variableCode, tenantVersion, para);
//
//        return para;
        return this.createLinkParam(variableCode, null);
    }

    public FieldDescription createLinkParam(String variableCode, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        FieldDescription para = new FieldDescription();
        para.setKey(variableCode);
        para.setCategory("link");
        para.setDataType("object");
        para.setRequired(true);
        para.setReadOnly(false);
        para.setIsExecute(true);
        para.setDisplayType("LINK");
        para.setName(variableCode);
        para.setDescription(variableCode);

        // 去variableDefinition表中查找侦测规则code对应的参数信息
        handleParaFromVariD(variableCode, tenantVersion, para, variableDefinitionsMap);

        return para;
    }

    protected void processMonitorRule(Application app) throws DWBusinessException {
        List<String> ruleList = this.getMonitorRuleCode(app.getCode());
        if (ruleList != null && !ruleList.isEmpty()) {
            if (app.getParamDescription() != null) {
                int seq = 1000;
                for (String ruleId : ruleList) {
                    boolean existed = false;
                    for (FieldDescription p : app.getParamDescription()) {
                        if (p.getCategory().toLowerCase(Locale.ROOT).equals("period") && p.getExtendData().equals(ruleId)) {
                            existed = true;
                            break;
                        }
                    }
                    if (existed) {
                        continue;
                    } else {
                        FieldDescription para = createMonitorRuleParam(ruleId, true);
                        if (null == para) {
                            continue;
                        }
                        if (para.getSequence() == null) {
                            para.setSequence(seq);
                            seq += 10;
                        }
                        app.getParamDescription().add(para);
                    }
                }
            } else {
                List<FieldDescription> paras = new ArrayList<>();
                int seq = 1000;
                for (String ruleId : ruleList) {
                    FieldDescription para = createMonitorRuleParam(ruleId, true);
                    if (null == para) {
                        continue;
                    }
                    if (para.getSequence() == null) {
                        para.setSequence(seq);
                        seq += 10;
                    }
                    paras.add(para);
                }
                app.setParamDescription(paras);
            }
        }
    }

    public FieldDescription createMonitorRuleParam(String ruleId, boolean keyPrefix) throws DWBusinessException {
//        //交付设计器暂不考虑个案场景 获取个案新增侦测
//////        List<MonitorRule> monitorRules = this.monitorRuleRepository.getAddedCustomByCode(ruleId, "tenantId");
//////        if (monitorRules == null || monitorRules.isEmpty()) {//不存在个案新增侦测
//////            monitorRules = this.monitorRuleRepository.findByCodeAndVersion(ruleId);//获取标准侦测
//////        }
////        String tenantId = AthenaUtils.getTenantId();
////        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
////        FieldDescription para = new FieldDescription();
////
////        // 去variableDefinition表中查找侦测规则code对应的参数信息
////        handleParaFromVariD(ruleId, tenantVersion, para);
////
////        if(StringUtils.isEmpty(para.getKey())){  //如果没有找到定义，才用下面方式构造，避免无效的查询
////            List<MonitorRule> monitorRules  = this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion);//获取标准侦测
////            if (monitorRules==null || monitorRules.size()==0) {
////                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.monitorNotFound",ruleId));
////            }
////            MonitorRule monitorRule = monitorRules.get(0);
////
////
////            if(keyPrefix){
////                para.setKey("executeTime-"+ruleId);
////            }else{
////                para.setKey(ruleId);
////            }
////
////            para.setDataType("string");
////            para.setCategory("period");
////            para.setDisplayType("PERIODIC");
////            para.setFormat("rule;yyyyMMdd HH:mm;switch");
////            para.setDefaultValue("D;20210801 12:00;true");
////            para.setRequired(true);
////            para.setReadOnly(false);
////            para.setIsExecute(true);
////            para.setExtendData(ruleId);
////            para.setName(monitorRule.getName());
////            para.setDescription(monitorRule.getDescription());
////            para.setLang(monitorRule.getLang());
////            if (monitorRule.getExecutable() == null) {
////                para.setExecutable(1);//默认打开立即执行按钮
////            } else {
////                para.setExecutable(monitorRule.getExecutable());
////            }
////            if (StringUtils.isEmpty(monitorRule.getPeriodEnable())) {
////                para.setPeriodEnable("M;W;D;H;F");//默认打开所有周期级别
////            } else {
////                para.setPeriodEnable(monitorRule.getPeriodEnable());
////            }
////            setEoc(para, ruleId);
////        }
////
////        return para;
        return this.createMonitorRuleParam(ruleId, keyPrefix, null);
    }

    public FieldDescription createMonitorRuleParam(String ruleId, boolean keyPrefix, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        //交付设计器暂不考虑个案场景 获取个案新增侦测
//        List<MonitorRule> monitorRules = this.monitorRuleRepository.getAddedCustomByCode(ruleId, "tenantId");
//        if (monitorRules == null || monitorRules.isEmpty()) {//不存在个案新增侦测
//            monitorRules = this.monitorRuleRepository.findByCodeAndVersion(ruleId);//获取标准侦测
//        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        FieldDescription para = new FieldDescription();

        List<MonitorRule> monitorRules = dataPickService.excludeWithSameCodeAndFilterTenant(this.monitorRuleRepository.findByCodeAndVersion(ruleId, tenantVersion));//获取标准侦测
        boolean ucRemoved = filterUc(monitorRules,tenantId);
        if (monitorRules == null || monitorRules.size() == 0) {
            if (ucRemoved) {
                return null;
            }
            throw new DWBusinessException("P.KG.500.0030", I18nUtils.getValue("knowledgegraph.monitorNotFound", ruleId));
        }
        MonitorRule monitorRule = monitorRules.get(0);

        if (keyPrefix) {
            para.setKey("executeTime-" + ruleId);
        } else {
            para.setKey(ruleId);
        }
        para.setDataType("string");
        para.setCategory("period");
        para.setDisplayType("PERIODIC");
        para.setFormat("rule;yyyyMMdd HH:mm;switch");
        para.setDefaultValue("D;20210801 12:00;true");
        para.setRequired(true);
        para.setReadOnly(false);
        para.setIsDesignerSet(monitorRule.getIsDesignerSet());
        para.setIsExecute(true);
        para.setExtendData(ruleId);
        para.setName(monitorRule.getName());
        para.setDescription(monitorRule.getDescription());
        para.setLang(monitorRule.getLang());
        if (monitorRule.getExecutable() == null) {
            para.setExecutable(1);//默认打开立即执行按钮
        } else {
            para.setExecutable(monitorRule.getExecutable());
        }
        if (StringUtils.isEmpty(monitorRule.getPeriodEnable())) {
            para.setPeriodEnable("M;W;D;H;F;fixInterval");//默认打开所有周期级别
        } else {
            para.setPeriodEnable(monitorRule.getPeriodEnable());
        }
        setEoc(para, ruleId);
        //增加针对实时类型的侦测类型进行默认显示的样式控制
        Query query = Query.query(Criteria.where("category").is(monitorRule.getCategory()));
        InitMonitorRuleGroup initMonitorRuleGroup = mongoTemplate.findOne(query, InitMonitorRuleGroup.class);
        if (!Objects.isNull(initMonitorRuleGroup)) {
            para.setFormat(initMonitorRuleGroup.getFormat());
            para.setDefaultValue(initMonitorRuleGroup.getDefaultValue());
            para.setExecutable(initMonitorRuleGroup.getExecutable());//默认打开立即执行按钮
        }
        // 去variableDefinition表中查找侦测规则code对应的参数信息
        handleParaFromVariD(ruleId, tenantVersion, para, variableDefinitionsMap);

        return para;
    }


    private boolean filterUc(List<MonitorRule> activities, String tenantId) {
        boolean removed = false;
        Iterator<MonitorRule> activityIterator = activities.iterator();
        List<String> ucCodes = new ArrayList<>();
        while (activityIterator.hasNext()) {
            MonitorRule activity = activityIterator.next();
            if (null != activity.getInclusionTenant()) {
                if (!activity.getInclusionTenant().contains(tenantId)) {
                    activityIterator.remove();
                    removed = true;
                } else {
                    if (activity.getCode().startsWith("UC_")) {
                        ucCodes.add(activity.getCode().replace("UC_", ""));
                    }
                }
            }
        }
//        Iterator<Activity> activityIterator2 = activities.iterator();
//        while (activityIterator2.hasNext()){
//            Activity activity  = activityIterator2.next();
//            if(ucCodes.contains(activity.getCode())){
//                activityIterator2.remove();
//            }
//        }

        return removed;
    }

    // 在variableDefinition表中查找变量code/侦测规则code对应的参数信息，如果有值则覆盖初始值
    private FieldDescription handleParaFromVariD(String code, String tenantVersion, FieldDescription para) throws DWBusinessException {
        return this.handleParaFromVariD(code, tenantVersion, para, null);
//        Query query = new Query();
//        Criteria criteria = Criteria.where("code").in(code).and("version").is(tenantVersion);
//        query.addCriteria(criteria);
//        VariableDefinition def = this.mongoTemplate.findOne(query, VariableDefinition.class);
//        if (def != null) {
//            if (StringUtils.isNotEmpty(def.getName())) {
//                para.setName(def.getName());
//            }
//            if (StringUtils.isNotEmpty(def.getDescription())) {
//                para.setDescription(def.getDescription());
//            }
//            if (StringUtils.isNotEmpty(def.getDataType())) {
//                para.setDataType(def.getDataType());
//            }
//            if (!ObjectUtils.isEmpty(def.getDefaultValue())) {
//                para.setDefaultValue(def.getDefaultValue());
//            }
//            if (def.getIsOperation() != null) {
//                para.setIsOperation(def.getIsOperation());
//            }
//            if (def.getEocLevel() != null && !def.getEocLevel().isEmpty()) {
//                para.setEocLevel(def.getEocLevel());
//            }
//            if (StringUtils.isNotEmpty(def.getExtendData())) {
//                para.setExtendData(def.getExtendData());
//            }
//            if (StringUtils.isNotEmpty(def.getDisplayType())) {
//                para.setDisplayType(def.getDisplayType());
//            }
//            if (StringUtils.isNotEmpty(def.getDisplayFormat())) {
//                para.setDisplayFormat(def.getDisplayFormat());
//            }
//            if (!ObjectUtils.isEmpty(def.getValueDisplay())) {
//                para.setValueDisplay(def.getValueDisplay());
//            }
//            if (def.getIsSimulation() != null) {
//                para.setIsSimulation(def.getIsSimulation());
//            }
//            if (def.getIsExecute() != null) {
//                para.setIsExecute(def.getIsExecute());
//            }
//            if (StringUtils.isNotEmpty(def.getExecuteName())) {
//                para.setExecuteName(def.getExecuteName());
//            }
//            if (def.getReadOnly() != null) {
//                para.setReadOnly(def.getReadOnly());
//            }
//            if (def.getRequired() != null) {
//                para.setRequired(def.getRequired());
//            }
//            if (StringUtils.isNotEmpty(def.getPeriodEnable())) {
//                para.setPeriodEnable(def.getPeriodEnable());
//            }
//            if (def.getExecutable() != null) {
//                para.setExecutable(def.getExecutable());
//            }
//            if (def.getSequence() != null) {
//                para.setSequence(def.getSequence());
//            }
//            if (StringUtils.isNotEmpty(def.getValidateScript())) {
//                para.setValidateScript(def.getValidateScript());
//            }
//            if (!ObjectUtils.isEmpty(def.getOptions())) {
//                para.setOptions(def.getOptions());
//            }
//            if (def.getParamVisble() != null && !def.getParamVisble().isEmpty()) {
//                para.setParamVisble(def.getParamVisble());
//            }
//            if (def.getParamVisbleScope() != null && !def.getParamVisbleScope().isEmpty()) {
//                para.setParamVisbleScope(def.getParamVisbleScope());
//            }
//            if (def.getColspan() != null) {
//                para.setColspan(def.getColspan());
//            }
//            if (!ObjectUtils.isEmpty(def.getDynamicCondition())) {
//                para.setDynamicCondition(def.getDynamicCondition());
//            }
//            if (!ObjectUtils.isEmpty(def.getFieldMappings())) {
//                para.setFieldMappings(def.getFieldMappings());
//            }
//            if (StringUtils.isNotEmpty(def.getMechanismCode())) {
//                para.setMechanismCode(def.getMechanismCode());
//            }
//            if (StringUtils.isNotEmpty(def.getCategory())) {
//                para.setCategory(def.getCategory());
//            }
//            if (StringUtils.isNotEmpty(def.getGroup())) {
//                para.setGroup(def.getGroup());
//            }
//            if (def.getLang() != null && !def.getLang().isEmpty()) {
//                para.setLang(def.getLang());
//            }
//            if (!ObjectUtils.isEmpty(def.getVisibleCondition())) {
//                para.setVisibleCondition(def.getVisibleCondition());
//            }
//            if (def.getFieldOpenWindowMap() != null && !def.getFieldOpenWindowMap().isEmpty()){
//                para.setFieldOpenWindowMap(def.getFieldOpenWindowMap());
//            }
//            if (!ObjectUtils.isEmpty(def.getDisplayTypeDefinition())) {
//                para.setDisplayTypeDefinition(def.getDisplayTypeDefinition());
//            }
//            if (!ObjectUtils.isEmpty(def.getForceOpen())) {
//                para.setForceOpen(def.getForceOpen());
//            }
//            if (!ObjectUtils.isEmpty(def.getValue())) {
//                para.setValue(def.getValue());
//            }
//            if (StringUtils.isNotEmpty(def.getFrom())) {
//                para.setFrom(def.getFrom());
//            }
//            if (StringUtils.isNotEmpty(def.getTarget())) {
//                para.setTarget(def.getTarget());
//            }
//            if (StringUtils.isNotEmpty(def.getFormat())) {
//                para.setFormat(def.getFormat());
//            }
//            return para;
//        }else{
//           return null;
//        }
    }

    private FieldDescription handleParaFromVariD(String code, String tenantVersion, FieldDescription para, Map<String, VariableDefinition> variableDefinitionsMap) throws DWBusinessException {
        VariableDefinition def = null;
        if (variableDefinitionsMap == null || !variableDefinitionsMap.containsKey(code)) {
            Query query = new Query();
            Criteria criteria = Criteria.where("code").in(code);
            query.addCriteria(criteria);
            def = dataPickService.findOneByCondition(criteria, VariableDefinition.class, "variableDefinition");
        } else {
            def = variableDefinitionsMap.get(code);
        }

        if (def != null) {
            if (StringUtils.isNotEmpty(def.getApplication())) {
                Application application = getApplicationByCode(def.getApplication());
                // 悬停，只需要个案的
                if (Boolean.TRUE.equals(application.getIndividualAll()) && "SYSTEM".equals(def.getTenantId())) {
                    return null;
                }
            }
            // 把应用 code 放到上下文中，在调用 esp 的地方，透传过去
            LoginInfo loginInfo = KgFilter.getLoginInfo();
            if (Objects.nonNull(loginInfo) && StringUtils.isNotEmpty(def.getApplication())) {
                loginInfo.setApplication(def.getApplication());
            }
            if (StringUtils.isNotEmpty(def.getName())) {
                para.setName(def.getName());
            }
            if (StringUtils.isNotEmpty(def.getDescription())) {
                para.setDescription(def.getDescription());
            }
            if (StringUtils.isNotEmpty(def.getDataType())) {
                para.setDataType(def.getDataType());
            }
            if (!ObjectUtils.isEmpty(def.getDefaultValue())) {
                para.setDefaultValue(def.getDefaultValue());
            }
            if (def.getIsOperation() != null) {
                para.setIsOperation(def.getIsOperation());
            }
            if (def.getEocLevel() != null && !def.getEocLevel().isEmpty()) {
                para.setEocLevel(def.getEocLevel());
            }
            if (StringUtils.isNotEmpty(def.getExtendData())) {
                para.setExtendData(def.getExtendData());
            }
            if (StringUtils.isNotEmpty(def.getDisplayType())) {
                para.setDisplayType(def.getDisplayType());
            }
            if (StringUtils.isNotEmpty(def.getDisplayFormat())) {
                para.setDisplayFormat(def.getDisplayFormat());
            }
            if (!ObjectUtils.isEmpty(def.getValueDisplay())) {
                para.setValueDisplay(def.getValueDisplay());
            }
            if (def.getIsSimulation() != null) {
                para.setIsSimulation(def.getIsSimulation());
            }
            if (def.getIsExecute() != null) {
                para.setIsExecute(def.getIsExecute());
            }
            if (StringUtils.isNotEmpty(def.getExecuteName())) {
                para.setExecuteName(def.getExecuteName());
            }
            if (def.getReadOnly() != null) {
                para.setReadOnly(def.getReadOnly());
            }
            if (def.getRequired() != null) {
                para.setRequired(def.getRequired());
            }
            if (StringUtils.isNotEmpty(def.getPeriodEnable())) {
                para.setPeriodEnable(def.getPeriodEnable());
            }
            if (def.getExecutable() != null) {
                para.setExecutable(def.getExecutable());
            }
            if (def.getSequence() != null) {
                para.setSequence(def.getSequence());
            }
            if (StringUtils.isNotEmpty(def.getValidateScript())) {
                para.setValidateScript(def.getValidateScript());
            }
            if (!Objects.isNull(def.getSelectVariableOptionSetting())) {
                para.setOptions(getOptionsFromApi(def.getSelectVariableOptionSetting()));
            } else if (!ObjectUtils.isEmpty(def.getOptions())) {
                para.setOptions(def.getOptions());
            }
            if (def.getParamVisble() != null && !def.getParamVisble().isEmpty()) {
                para.setParamVisble(def.getParamVisble());
            }
            if (def.getParamVisbleScope() != null && !def.getParamVisbleScope().isEmpty()) {
                para.setParamVisbleScope(def.getParamVisbleScope());
            }
            if (def.getParamDisable() != null && !def.getParamDisable().isEmpty()) {
                para.setParamDisable(def.getParamDisable());
            }
            if (def.getParamDisableScope() != null && !def.getParamDisableScope().isEmpty()) {
                para.setParamDisableScope(def.getParamDisableScope());
            }
            if (def.getColspan() != null) {
                para.setColspan(def.getColspan());
            }
            if (!ObjectUtils.isEmpty(def.getDynamicCondition())) {
                para.setDynamicCondition(def.getDynamicCondition());
            }
            if (!ObjectUtils.isEmpty(def.getFieldMappings())) {
                para.setFieldMappings(def.getFieldMappings());
            }
            if (StringUtils.isNotEmpty(def.getMechanismCode())) {
                para.setMechanismCode(def.getMechanismCode());
            }
            if (StringUtils.isNotEmpty(def.getCategory())) {
                para.setCategory(def.getCategory());
            }
            if (StringUtils.isNotEmpty(def.getGroup())) {
                para.setGroup(def.getGroup());
            }
            if (def.getLang() != null && !def.getLang().isEmpty()) {
                para.setLang(def.getLang());
            }
            if (!ObjectUtils.isEmpty(def.getVisibleCondition())) {
                para.setVisibleCondition(def.getVisibleCondition());
            }
            if (def.getFieldOpenWindowMap() != null && !def.getFieldOpenWindowMap().isEmpty()) {
                para.setFieldOpenWindowMap(def.getFieldOpenWindowMap());
            }
            if (!ObjectUtils.isEmpty(def.getDisplayTypeDefinition())) {
                para.setDisplayTypeDefinition(def.getDisplayTypeDefinition());
            }
            if (!ObjectUtils.isEmpty(def.getForceOpen())) {
                para.setForceOpen(def.getForceOpen());
            }
            if (!ObjectUtils.isEmpty(def.getValue())) {
                para.setValue(def.getValue());
            }
            if (StringUtils.isNotEmpty(def.getFrom())) {
                para.setFrom(def.getFrom());
            }
            if (StringUtils.isNotEmpty(def.getTarget())) {
                para.setTarget(def.getTarget());
            }
            if (StringUtils.isNotEmpty(def.getFormat())) {
                para.setFormat(def.getFormat());
            }
            if (!ObjectUtils.isEmpty(def.getMax())) {
                para.setMax(def.getMax());
            }
            if (!ObjectUtils.isEmpty(def.getMin())) {
                para.setMin(def.getMin());
            }
            if (!ObjectUtils.isEmpty(def.getStep())) {
                para.setStep(def.getStep());
            }
            if (!ObjectUtils.isEmpty(def.getLinkKey())) {
                para.setLinkKey(def.getLinkKey());
            }
            if (!ObjectUtils.isEmpty(def.getLinkOptions())) {
                para.setLinkOptions(def.getLinkOptions());
            }
            if (StringUtils.isNotEmpty(def.getPrecision())) {
                para.setPrecision(def.getPrecision());
            }
            if (!ObjectUtils.isEmpty(def.getRestrictions())) {
                para.setRestrictions(def.getRestrictions());
            }
            if (!ObjectUtils.isEmpty(def.getFilters())) {
                para.setFilters(def.getFilters());
            }
            if (!ObjectUtils.isEmpty(def.getIsSingleOperation())) {
                para.setIsSingleOperation(def.getIsSingleOperation());
            }
            if (!ObjectUtils.isEmpty(def.getOpenWindowTip())) {
                para.setOpenWindowTip(def.getOpenWindowTip());
            }
            para.setValueComputed(MapUtils.isNotEmpty(def.getValueComputed()) ? def.getValueComputed() : null);
            para.setIsTop(Optional.ofNullable(def.getIsTop()).orElse(false));
            para.setLinkageParamEvent(def.getLinkageParamEvent());
            return para;
        } else {
            return null;
        }
    }

    /**
     * 下拉控件选项从api获取
     *
     * @param setting 下拉控件选项配置
     * @return 下拉控件选项数据
     * @throws DWBusinessException 业务异常
     */
    private Object getOptionsFromApi(SelectVariableOptionSetting setting) throws DWBusinessException {
        if ("ESP".equalsIgnoreCase(setting.getOptionApiType())) {
            try {
                Map<String, Object> result = espUtils.execute(AthenaUtils.getHeaderToken(), AthenaUtils.getTenantId(), setting.getOptionApi(), Optional.ofNullable(setting.getOptionApiParams()).orElse(Collections.emptyMap()));
                Map<String, Object> config = setting.getConfig();
                String label = MapUtils.getString(config, "label");
                String value = MapUtils.getString(config, "value");
                String dataKey = MapUtils.getString(config, "dataKey");
                Object data = result.get(dataKey);
                if (!(data instanceof List)) {
                    return Collections.emptyList();
                }
                JSONArray optionData = (JSONArray) data;
                if (CollectionUtils.isEmpty(optionData)) {
                    return Collections.emptyList();
                }
                List<Object> collect = optionData.stream().map(o -> {
                    JSONObject jsonObject = (JSONObject) o;
                    return new JSONObject().fluentPut("label", jsonObject.get(label)).fluentPut("value", jsonObject.get(value));
                }).collect(Collectors.toList());
                String translateStr = translateUtils.translateContent(collect);
                return JSONArray.parseArray(translateStr);
            } catch (Exception e) {
                log.info("查询下拉控件选项列表出错：{}", e.getMessage());
                throw new DWBusinessException(e.getMessage());
            }
        }
        return null;
    }


    private void setEoc(FieldDescription para, String ruleId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        //根据ruleId获取是否存在eocLevel 没有获取到 则为不区分运营单元
        Criteria criteria = Criteria.where("monitorRuleId").in(ruleId)
                .and("version").is(tenantVersion);
        List<MonitorRuleProductConfig> configs = dataPickService.find(criteria, MonitorRuleProductConfig.class, "monitorRuleProductConfig");
        if (configs != null && !configs.isEmpty()) {
            boolean isOperation = false;
            Map eoc = new HashMap<>();
            for (MonitorRuleProductConfig c : configs) {
                if (StringUtils.isNotEmpty(c.getEocLevel())) {
                    eoc.put(c.getProductName(), c.getEocLevel());
                    isOperation = true;
                }
            }
            if (isOperation) {
                para.setEocLevel(eoc);
                para.setIsOperation(true);
            }
        }
    }

    @Override
    public Object getList(Set<String> applicationCodeList) throws Exception {
//        Criteria criteria = Criteria.where("code").in(applicationCodeList);
//        List<Application> applications = dataPickService.find(criteria, Application.class, "application");
//        if (CollectionUtils.isNotEmpty(applications)) {
//            for (Application app : applications) {
//                //从applicationRelation获取侦测规则
//                processMonitorRule(app);
//                //从applicationRelation获取变量
//                processVariable(app);
//                //按sequence排序
//                if (CollectionUtils.isNotEmpty(app.getParamDescription())) {
//                    app.getParamDescription().sort((o1, o2) -> o1.getSequence().compareTo(o2.getSequence()));
//                }
//            }
//        }
//
//        return applications;
        Map<String,Object> map = AppMetaCaller.of("applicationCodeList",applicationCodeList);
        RespObject resp = appMetaCaller.call("/app/list","post",map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object getByNameAndTags(String applicationName, List<String> tags) throws Exception {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        Query query = new Query();
//        Criteria criteria = null;
//        if (StringUtils.isNotEmpty(applicationName)) {
//            criteria = Criteria.where("name").regex(".*?\\" + applicationName + ".*");
//        }
//        if (CollectionUtils.isNotEmpty(tags)) {
//            if (criteria != null) {
//                criteria = criteria.and("tags.key").in(tags);
//            } else {
//                criteria = Criteria.where("tags.key").in(tags);
//            }
//        }
//        if (criteria != null) {
//            criteria = criteria.and("version").is(tenantVersion);
//            query.addCriteria(criteria);
//        } else {
//            query.addCriteria(Criteria.where("version").is(tenantVersion));
//        }
//        query.with(Sort.by(Sort.Order.desc("editDate")));
//        List<Application> applications = this.mongoTemplate.find(query, Application.class);
//        return dataPickService.excludeWithSameCode(applications);
        Map<String,Object> map = AppMetaCaller.of("applicationName",applicationName);
        map.put("tags",tags);
        RespObject resp = appMetaCaller.call("/app/byNameAndTags","post",map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object getApplicationMechanismByApplicationCode(String applicationCode) throws Exception {
//        Query query = new Query();
//        Criteria criteria = Criteria.where("applicationCode").is(applicationCode);
//        query.addCriteria(criteria);
//        List<ApplicationMechanism> applicationMechanisms = this.mongoTemplate.find(query, ApplicationMechanism.class);
//        return applicationMechanisms;


        List<ApplicationMechanism> result = new ArrayList<>();
        List<String> relations = this.getMechanismCode(applicationCode);
        for (String c : relations) {
            ApplicationMechanism am = new ApplicationMechanism();
            am.setApplicationCode(applicationCode);
            am.setMechanismCode(c);
            result.add(am);
        }
        return result;
    }

    /**
     * 批量查询应用机制集合
     *
     * @param applicationCodes 应用code集合
     */
    @Override
    public Object postApplicationMechanismByApplicationCodes(List<String> applicationCodes) throws Exception {
        List<String> appCodes = tenantService.getAppCodes(AthenaUtils.getTenantId());

        //过滤appCode
        List<String> finalAppCodes=new ArrayList<>(applicationCodes);
        finalAppCodes.retainAll(appCodes);

        StopWatch relationTime=new StopWatch();
        relationTime.start();
        List<ApplicationRelation> relations = dataPickService.applicationRelations(finalAppCodes, "mechanism", null, null, null);
        relationTime.stop();

        //非空判断
        if(CollectionUtils.isEmpty(relations)){
            return null;
        }

        //拿到机制code集合
        List<String> codeList = relations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());

        //查询机制数据
        return iMechanismService.postQueryMechanismByCode(codeList, null, false);
    }

    @Override
    public Object getApplicationMechanismByMechanismCode(String mechanismCode) throws Exception {
//        Query query = new Query();
//        Criteria criteria = Criteria.where("mechanismCode").is(mechanismCode);
//        query.addCriteria(criteria);
//        List<ApplicationMechanism> applicationMechanisms = this.mongoTemplate.find(query, ApplicationMechanism.class);
//        return applicationMechanisms;

        List<ApplicationMechanism> result = new ArrayList<>();
        List<ApplicationRelation> relations = this.getAppCodeByMechanismCode(mechanismCode);
        for (ApplicationRelation r : relations) {
            ApplicationMechanism am = new ApplicationMechanism();
            am.setMechanismCode(mechanismCode);
            am.setApplicationCode(r.getAppCode());
            result.add(am);
        }

        return result;
    }

    @Override
    public Application getApplicationInfo(String code) throws DWBusinessException {
//        Application application = dataPickService.findOneByCondition(Criteria.where("code").is(code), Application.class, "application");
//        if (application != null) {
//            //获取语言别
//            Locale locale = DWResourceBundleUtils.getCurrentLocale();
//            String localeStr = locale.toString();
//            if (application.getLang() != null && !application.getLang().isEmpty()) {//设置多语言
//                for (Map.Entry<String, Map<String, String>> i : application.getLang().entrySet()) {
//                    Map<String, String> lang = i.getValue();
//                    if (lang != null && !lang.isEmpty()) {
//                        if (lang.containsKey(localeStr)) {
//                            try {
//                                Field field = Application.class.getDeclaredField(i.getKey());
//                                field.setAccessible(true);
//                                field.set(application, lang.get(localeStr));
//                            } catch (NoSuchFieldException ex) {//允许因配置错误找不到对应的字段设置
//                            } catch (IllegalAccessException ex) {//允许因配置错误设置对应的字段异常
//                            } catch (Exception ex) {
//                                throw ex;
//                            }
//                        }
//                    }
//                }
//            }
//        }
//
//        return application;
        Map<String,Object> map = AppMetaCaller.of("code",code);
        RespApplication resp = appMetaCaller.call("/app/applicationInfo","get",map, RespApplication.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getTaskCode(String appCode) throws DWBusinessException {
//        List<String> codes = new ArrayList<>();
//        List<String> appCodes = tenantService.getAppCodes(AthenaUtils.getTenantId());
//        if (!appCodes.contains(appCode)) {
//            return codes;
//        }
//        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "task", null, null, null);
//        relations.forEach(r -> codes.add(r.getCode()));
//        return codes;
        Map<String,Object> map = AppMetaCaller.of("appCode",appCode);
        RespStringList resp = appMetaCaller.call("/app/taskCode","get",map, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getMechanismCode(String appCode) throws DWBusinessException {
//        List<String> codes = new ArrayList<>();
//        List<String> appCodes = tenantService.getAppCodes(AthenaUtils.getTenantId());
//        if (!appCodes.contains(appCode)) {
//            return codes;
//        }
//        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "mechanism", null, null, null);
//        relations.forEach(r -> codes.add(r.getCode()));
//        return codes;
        Map<String,Object> map = AppMetaCaller.of("appCode",appCode);
        RespStringList resp = appMetaCaller.call("/app/mechanismCode","get",map, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getMonitorRuleCode(String appCode) throws DWBusinessException {
//        return getMonitorRuleCode(appCode, null);
        Map<String,Object> map = AppMetaCaller.of("appCode",appCode);
        RespStringList resp = appMetaCaller.call("/app/monitorRuleCode","get",map, RespStringList.class);
        return resp.getResponse();
    }

    public List<String> getMonitorRuleCode(String appCode, String tenantId) throws DWBusinessException {
        tenantId = StringUtils.isEmpty(tenantId) ? AthenaUtils.getTenantId() : tenantId;
        List<String> codes = new ArrayList<>();
        List<String> appCodes = tenantService.getAppCodes(tenantId);
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "monitorRule", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        //查找application下配置的侦测
        Application application = getApplicationByCode(appCode, tenantId);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (StringUtils.equalsIgnoreCase("period", fieldDescription.getCategory())
                    && StringUtils.isNotEmpty(fieldDescription.getExtendData()) && !codes.contains(fieldDescription.getExtendData())) {
                codes.add(fieldDescription.getExtendData());
            }
        }
        return codes;
    }

    public List<String> getMonitorRuleCodeByAppAndVersion(String appCode, String version) throws DWBusinessException {
        List<String> codes = new ArrayList<>();
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "monitorRule", null, null, version);
        relations.forEach(r -> codes.add(r.getCode()));
        //查找application下配置的侦测
        Application application =getApplicationByCode(appCode);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (StringUtils.equalsIgnoreCase("period", fieldDescription.getCategory())
                    && StringUtils.isNotEmpty(fieldDescription.getExtendData()) && !codes.contains(fieldDescription.getExtendData())) {
                codes.add(fieldDescription.getExtendData());
            }
        }
        return codes;
    }

    public List<String> getMonitorRuleCodeByAppAndVersion(String version) throws DWBusinessException {
        List<String> codes = new ArrayList<>();
        List<MonitorRule> monitorRules = monitorRuleRepository.getCommonByVersion(version);
        if (!org.springframework.util.CollectionUtils.isEmpty(monitorRules)) {
            codes = monitorRules.stream().map(MonitorRule::getCode).collect(Collectors.toList());
        }
        return codes;
    }

    @Override
    public List<ApplicationRelation> postApplicationRelationsByCodesAndType(@RequestBody ApplicationRelationQueryDTO applicationRelationQueryDTO) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<String> appCodes = tenantService.getAppCodes(AthenaUtils.getTenantId());
//        if (appCodes.isEmpty()) {
//            return new ArrayList<>();
//        }
//        Criteria criteria = Criteria.where("type").is(applicationRelationQueryDTO.getType())
//                .and("code").in(applicationRelationQueryDTO.getCodes())
//                .and("version").is(tenantVersion);
//        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        Map<String,Object> map = AppMetaCaller.of("applicationRelationQueryDTO",applicationRelationQueryDTO);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationsByCodesAndType","post",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getAppCodeByTaskCode(String code) throws DWBusinessException {
//        List<String> appCodes = tenantService.getAppCodes(AthenaUtils.getTenantId());
//        if (appCodes.isEmpty()) {
//            return new ArrayList<>();
//        }
//        Criteria criteria = Criteria.where("type").is("task")
//                .and("code").is(code)
//                .and("appCode").in(appCodes);
//        List<ApplicationRelation> relations = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
//
//        //获取对应多语言的application name
//        proccessAppNameLanguage(relations);
//
//        return relations;
        Map<String,Object> map = AppMetaCaller.of("code",code);
        RespApplicationRelationList resp = appMetaCaller.call("/app/appCodeByTaskCode","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getAppCodeByMechanismCode(String code) throws DWBusinessException {
//        List<String> appCodes = tenantService.getAppCodes(AthenaUtils.getTenantId());
//        if (appCodes.isEmpty()) {
//            return new ArrayList<>();
//        }
//        Criteria criteria = Criteria.where("type").is("mechanism")
//                .and("code").is(code)
//                .and("appCode").in(appCodes);
//        List<ApplicationRelation> relations = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
//
//        //获取对应多语言的application name
//        proccessAppNameLanguage(relations);
//
//        return relations;
        Map<String,Object> map = AppMetaCaller.of("code",code);
        RespApplicationRelationList resp = appMetaCaller.call("/app/appCodeByMechanismCode","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getAppCodeByMonitorRuleCode(String code) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        List<String> appCodes = tenantService.getAppCodes(AthenaUtils.getTenantId());
//        if (appCodes.isEmpty()) {
//            return new ArrayList<>();
//        }
//        Criteria criteria1 = Criteria.where("type").is("monitorRule")
//                .and("code").is(code)
//                .and("appCode").in(appCodes);
//        List<ApplicationRelation> relations = dataPickService.find(criteria1, ApplicationRelation.class, "applicationRelation");
//
//        //当applicationRelation中没有配置和monitorRule的关系时，查找下Application中直接配置再paramDescription中的数据
//        if (CollectionUtils.isEmpty(relations)) {
//            Criteria criteria = Criteria.where("paramDescription.extendData").is(code);
//            List<Application> applications = dataPickService.find(criteria, Application.class, "application");
//            for (Application application : applications) {
//                ApplicationRelation applicationRelation = new ApplicationRelation();
//                applicationRelation.setAppCode(application.getCode());
//                applicationRelation.setAppName(application.getName());
//                applicationRelation.setCode(code);
//                applicationRelation.setType("monitorRule");
//                relations.add(applicationRelation);
//            }
//
//        }
//
//        //获取对应多语言的application name
//        proccessAppNameLanguage(relations);
//
//
//        return relations;
        Map<String,Object> map = AppMetaCaller.of("code",code);
        RespApplicationRelationList resp = appMetaCaller.call("/app/appCodeByMonitorRuleCode","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    private void proccessAppNameLanguage(List<ApplicationRelation> relations) throws DWBusinessException {
        //使用application中定义的应用名称 处理对应多语言
        if (CollectionUtils.isNotEmpty(relations)) {
            for (ApplicationRelation i : relations) {
                Application app = this.getApplicationInfo(i.getAppCode());
                if (app != null) {
                    i.setAppName(app.getName());
                    Map<String, Map<String, String>> appLang = app.getLang();
                    if (appLang != null) {
                        if (i.getLang() != null) {
                            i.getLang().put("appName", appLang.get("name"));
                        } else {
                            Map<String, Map<String, String>> lang = new HashMap<>();
                            lang.put("appName", appLang.get("name"));
                            i.setLang(lang);
                        }
                    }
                }
            }
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelation(List<String> codes, String tenantVersion) throws DWBusinessException {
//        Criteria criteria = Criteria.where("code").in(codes);
//        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        Map<String,Object> map = AppMetaCaller.of("codes",codes);
        map.put("tenantVersion",tenantVersion);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationByCodesAndTenantVersion","post",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationRelation(List<String> appCodes, List<String> codes, String type, String subType) throws DWBusinessException {
//        Criteria criteria = Criteria.where("code").in(codes).and("appCode").in(appCodes);
//        if (StringUtils.isNotEmpty(type)) {
//            criteria.and("type").is(type);
//        }
//        if (StringUtils.isNotEmpty(subType)) {
//            criteria.and("subType").is(subType);
//        }
//        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        Map<String,Object> map = AppMetaCaller.of("appCodes",appCodes);
        map.put("codes",codes);
        map.put("type",type);
        map.put("subType",subType);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationByAppCodesAndCodesAndTypeAndSubType","post",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> postApplicationRelation(List<String> appCodes) throws DWBusinessException {
//        return dataPickService.applicationRelations(appCodes, null, null, null, null);
        Map<String,Object> map = AppMetaCaller.of("appCodes",appCodes);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelation","post",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getFlowCode(String appCode) throws DWBusinessException {
//        List<String> codes = new ArrayList<>();
//        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "flow", null, null, null);
//        relations.forEach(r -> codes.add(r.getCode()));
//        return codes;
        Map<String,Object> map = AppMetaCaller.of("appCode",appCode);
        RespStringList resp = appMetaCaller.call("/app/flowCode","get",map, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getAppCodeByFlowCode(String code) throws DWBusinessException {
//        Criteria criteria = Criteria.where("type").is("flow").and("code").is(code);
//        return dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        Map<String,Object> map = AppMetaCaller.of("code",code);
        RespApplicationRelationList resp = appMetaCaller.call("/app/appCodeByFlowCode","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getVariableCode(String appCode) throws DWBusinessException {
//        List<String> re = new ArrayList<>();
//        List<String> appCodes = tenantService.getAppCodes(AthenaUtils.getTenantId());
//        if (!appCodes.contains(appCode)) {
//            return re;
//        }
//        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "variable", null, null, null);
//        relations.forEach(r -> re.add(r.getCode()));
//        return re;
        Map<String,Object> map = AppMetaCaller.of("appCode",appCode);
        RespStringList resp = appMetaCaller.call("/app/variableCode","get",map, RespStringList.class);
        return resp.getResponse();
    }

    /**
     * getAllAppCode()这个方法不要关联版本信息，仅仅是租户初始化时获取系统有哪些应用code的方法，如果想要有版本信息，请另写方法
     */
    @Override
    public List<String> getAllAppCode() throws DWBusinessException {
////        String tenantId = AthenaUtils.getTenantId();
////        String tenantVersion = tenantService.getTenantVersion(tenantId);
//        Query query = new Query();
//        query.fields().include("code");
////        Criteria criteria = Criteria.where("version").is(tenantVersion);
////        query.addCriteria(criteria);
//        List<Application> app = this.mongoTemplate.find(query, Application.class);
//        return app.stream().map(Application::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        RespStringList resp = appMetaCaller.call("/app/allAppCode","get",null, RespStringList.class);
        return resp.getResponse();
    }

    @Override
    public List<String> getNotCommonAppCode() throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = tenantService.getTenantVersion(tenantId);
        Query query = new Query();
        query.fields().include("code");
//        Criteria criteria = Criteria.where("version").is(tenantVersion);
//        query.addCriteria(criteria);
        List<Application> app = this.mongoTemplate.find(query, Application.class);
        List<String> collect = app.stream().filter(item -> null == item.getCommonApp() || false == item.getCommonApp()).map(Application::getCode).distinct().collect(Collectors.toList());
        return collect;
//        RespStringList resp = appMetaCaller.call("/app/notCommonAppCode","get",null, RespStringList.class);
//        return resp.getResponse();
    }

    @Override
    public List<String> getMonitorRulesRelatedToTask(String appCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<String> result = new ArrayList<>();
        List<String> taskCodList = this.getTaskCode(appCode);
        if (CollectionUtils.isNotEmpty(taskCodList)) {
            for (String taskCode : taskCodList) {
                Query query = new Query();
                Criteria criteria = Criteria.where("taskCode").is(taskCode).and("version").is(tenantVersion);
                query.addCriteria(criteria);
                List<TaskMonitorRule> taskMechanism = this.mongoTemplate.find(query, TaskMonitorRule.class, "taskMonitorRule");
                if (!CollectionUtils.isEmpty(taskMechanism)) {
                    List<String> collect = taskMechanism.stream().map(TaskMonitorRule::getMonitorRuleCode).collect(Collectors.toList());
                    result.addAll(collect);
                }
            }
        }
        return result;
    }

    @Override
    public Map<String, List> postQueryDigitalStaffByCode(Set<String> codeList, Set<String> enhanceCodeList) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Map<String, List> re = new HashMap();
        if (CollectionUtils.isEmpty(codeList)) {
            return re;
        }
        if (CollectionUtils.isEmpty(enhanceCodeList)) {//必须传入增强应用code
            return re;
        }

        //查询数字员工类型的增强应用
        Criteria criteria = Criteria.where("code").in(enhanceCodeList)
                .and("extendType").is("digitalStaff");
        List<Application> enhanceApp = dataPickService.find(criteria, Application.class, "application");
        if (CollectionUtils.isEmpty(enhanceApp)) {
            return re;
        }
        //获取数字员工code
        Map<String, String> enhanceStaff = new HashMap();
        Map<String, String> enhanceName = new HashMap<>();
        List<String> staffCodeList = new ArrayList<>();
        for (Application i : enhanceApp) {
            enhanceStaff.put(i.getCode(), i.getExtendData());
            enhanceName.put(i.getCode(), i.getName());
            if (!staffCodeList.contains(i.getExtendData())) {
                staffCodeList.add(i.getExtendData());
            }
        }
        //查询数字员工名称
        Query query = new Query();
        query.fields().include("code");
        query.fields().include("name");
        criteria = Criteria.where("code").in(staffCodeList)
                .and("version").is(tenantVersion);
        query.addCriteria(criteria);
        List<DigitalStaff> digitalStaffs = this.mongoTemplate.find(query, DigitalStaff.class);
        Map<String, String> staffName = new HashMap();
        if (CollectionUtils.isNotEmpty(digitalStaffs)) {
            for (DigitalStaff i : digitalStaffs) {
                staffName.put(i.getCode(), i.getName());
            }
        }
        //将数字员工code替换为名称
        for (Map.Entry<String, String> i : enhanceStaff.entrySet()) {
            enhanceStaff.put(i.getKey(), staffName.get(i.getValue()));
        }

        List<ApplicationRelation> relations = dataPickService.applicationRelations(new ArrayList<>(codeList), "enhance", null, null, null);
        if (CollectionUtils.isNotEmpty(relations)) {
            for (ApplicationRelation i : relations) {
                if (enhanceCodeList.contains(i.getCode())) {//仅处理入参包含的enhance 经过授权过滤
                    if (re.containsKey(i.getAppCode())) {
                        Map tmp = new HashMap();
                        tmp.put("staff", enhanceStaff.get(i.getCode()));
                        tmp.put("job", enhanceName.get(i.getCode()));
                        re.get(i.getAppCode()).add(tmp);
                    } else {
                        List<Map> lst = new ArrayList<>();
                        Map tmp = new HashMap();
                        tmp.put("staff", enhanceStaff.get(i.getCode()));
                        tmp.put("job", enhanceName.get(i.getCode()));
                        lst.add(tmp);
                        re.put(i.getAppCode(), lst);
                    }
                }
            }
        }
        return re;
    }

    public List<String> getEnhanceCodeByAppCode(String appCode, String version) throws DWBusinessException {
        List<ApplicationRelation> relations = dataPickService.applicationRelations(appCode, "enhance", null, null, null);
        if (CollectionUtils.isEmpty(relations)) {
            return new ArrayList<>();
        }
        return relations.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
    }

    @Override
    public List<Application> getEnhanceByAppCode(String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<Application> apps = new ArrayList<>();
        List<ApplicationRelation> relations = dataPickService.applicationRelations(code, "enhance", null, null, null);
        if (CollectionUtils.isNotEmpty(relations)) {
            Set<String> appCode = new HashSet<>();
            for (ApplicationRelation i : relations) {
                appCode.add(i.getCode());
            }
            Query query = new Query();
            Criteria criteria = Criteria.where("code").in(appCode)
                    .and("category").is("enhance");
            query.addCriteria(criteria);
            apps = dataPickService.find(criteria, Application.class, "application");

            if (CollectionUtils.isNotEmpty(apps)) {
                Set<String> staffCode = new HashSet<>();
                for (Application i : apps) {
                    if (StringUtils.equalsIgnoreCase("digitalstaff", i.getExtendType())) {
                        staffCode.add(i.getExtendData());
                    }
                }
                query = new Query();
                criteria = Criteria.where("code").in(staffCode)
                        .and("version").is(tenantVersion);
                query.addCriteria(criteria);
                List<DigitalStaff> staffs = this.mongoTemplate.find(query, DigitalStaff.class);
                Map<String, String> staffName = new HashMap();
                if (CollectionUtils.isNotEmpty(staffs)) {
                    for (DigitalStaff i : staffs) {
                        staffName.put(i.getCode(), i.getName());
                    }
                }
                for (Application i : apps) {
                    i.setExtendDisplay(staffName.get(i.getExtendData()));
                    // 增加 参数开窗信息
                    Map<String, Map<String, String>> openWin = new HashMap<>();
                    for (FieldDescription p : i.getParamDescription()) {
                        if (p.getFieldOpenWindowMap() != null && !p.getFieldOpenWindowMap().isEmpty()) {
                            Map<String, String> map = new HashMap<>();
                            for (FieldOpenWindowSetting setting : p.getFieldOpenWindowMap()) {
                                map.put(setting.getColumn(), setting.getOpenWindowKey());
                            }
                            openWin.put(p.getKey(), map);
                        }
                    }
                    Map<String, Map<String, OpenWindowDefinition>> openWinInfo = postOpenWinInfo(openWin);
                    for (FieldDescription p : i.getParamDescription()) {
                        Map<String, OpenWindowDefinition> temp = openWinInfo.get(p.getKey());
                        p.setFieldOpenWindowDefinitions(temp);
                    }
                }
            }
        }
        return apps;
    }

    @Override
    public List<Application> getEnhanceByMechanismCode(String code) throws DWBusinessException {
        List<Application> apps = new ArrayList<>();
        List<ApplicationRelation> relations = this.getAppCodeByMechanismCode(code);
        if (CollectionUtils.isNotEmpty(relations)) {
            String appCode = relations.get(0).getAppCode();//一个机制只会对应一个应用
            apps = this.getEnhanceByAppCode(appCode);
        }

        return apps;
    }

    @Override
    public List<ApplicationRelation> getAppCodeByTypeAndCode(String type, String code) throws Exception {
//        List<ApplicationRelation> applicationRelationList = getApplicationByTypeAndCode(type, null, Collections.singletonList(code));
//
//        if (CollectionUtils.isEmpty(applicationRelationList)) {
//            return applicationRelationList;
//        }
//        //从application获取应用名称
//        List<Application> all = this.mongoTemplateSystem.findAll(Application.class);
//        Map<String, Application> collect = dataPickService.excludeWithSameCode(all).stream().collect(Collectors.toMap(Application::getCode, Function.identity(), (a, b) -> a));
//        applicationRelationList.forEach(e -> {
//            Application application = collect.get(e.getAppCode());
//            if (application != null && application.getLang() != null && application.getLang().containsKey("name")) {
//                e.setAppName(application.getName());
//                Map<String, Map<String, String>> lang = e.getLang();
//                if (lang == null) {
//                    lang = new HashMap<>();
//                    e.setLang(lang);
//                }
//                lang.put("appName", application.getLang().get("name"));
//
//            }
//        });
//
//        return applicationRelationList;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("code",code);
        RespApplicationRelationList resp = appMetaCaller.call("/app/appCodeByTypeAndCode","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getParadigmByTypeAndAppCode(String type, String appCode) throws Exception {
//        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(appCode, type, null, null, null);
//        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : applicationRelationList;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("appCode",appCode);
        RespApplicationRelationList resp = appMetaCaller.call("/app/paradigmByTypeAndAppCode","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    /**
     * 通过参数的开窗条件列名称查找开窗信息
     */
    @Override
    public Map<String, Map<String, OpenWindowDefinition>> postOpenWinInfo(Map<String, Map<String, String>> openWin) throws DWBusinessException {
//        Map<String, Map<String, OpenWindowDefinition>> result = new HashMap<>();
//        for (Map.Entry<String, Map<String, String>> entry0 : openWin.entrySet()) {
//            Map<String, OpenWindowDefinition> openWindowInfo = new HashMap<>();
//            if (entry0.getValue() != null) {
//                for (Map.Entry<String, String> entry1 : entry0.getValue().entrySet()) {
//                    OpenWindowDefinition openWindowDefinition = dataPickService.findOneByCondition(Criteria.where("key").is(entry1.getValue()), OpenWindowDefinition.class, "openWindowDefinition");
//                    openWindowInfo.put(entry1.getKey(), openWindowDefinition);
//                }
//            }
//            result.put(entry0.getKey(), openWindowInfo);
//        }
//        return result;
        Map<String,Object> map = AppMetaCaller.of("openWin",openWin);
        RespMapMapOpenWindowDefinition resp = appMetaCaller.call("/app/openWinInfo","post",map, RespMapMapOpenWindowDefinition.class);
        return resp.getResponse();
    }

    @Override
    public String getAppCodeByApplication(String application) throws Exception {
//        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(Collections.singletonList(application), null, null, null, null);
//        return CollectionUtils.isEmpty(applicationRelationList) ? null : applicationRelationList.get(0).getAppCode();
        Map<String,Object> map = AppMetaCaller.of("application",application);
        RespString resp = appMetaCaller.call("/app/appCodeByApplication","get",map, RespString.class);
        return resp.getResponse();
    }

    public Map<String, String> getAppCodeByApplication() throws DWBusinessException {
        Criteria criteria = new Criteria();
        List<ApplicationRelation> applicationRelationList = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return applicationRelationList.stream().filter(e -> StringUtils.isNotEmpty(e.getApplication()) && StringUtils.isNotEmpty(e.getAppCode()))
                .collect(Collectors.toMap(ApplicationRelation::getApplication, ApplicationRelation::getAppCode, (a, b) -> a));
    }

    public void checkRelatedAppHasExpired(String type, String code) throws DWBusinessException {
        //校验关联的应用是否过期
        List<ApplicationRelation> applicationRelations = this.getApplicationRelationsByTypeAndCodeAndLang(type, code, AthenaUtils.getCurrentLocale());
        List<String> appCodes = this.tenantService.getAppCodes();
        List<ApplicationRelation> collect = applicationRelations.stream().filter(e -> !appCodes.contains(e.getAppCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect) && collect.size() == applicationRelations.size()) {
            throw new DWBusinessException(Constants.RELATED_APP_EXPIRED, collect.get(0).getAppName());
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String type, String appCode) throws Exception {
//        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(appCode, type, null, null, null);
//        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : applicationRelationList;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("appCode",appCode);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationByTypeAndAppCode","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCodeAndVersion(String type, String appCode, String version) throws Exception {
        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(appCode, type, null, null, null);
        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : applicationRelationList;
//        return getApplicationRelationByTypeAndAppCode(null, type, appCode);
//        Map<String,Object> map = AppMetaCaller.of("type",type);
//        map.put("appCode",appCode);
//        map.put("version",version);
//        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationByTypeAndAppCodeAndVersion","get",map, RespApplicationRelationList.class);
//        return resp.getResponse();
    }


    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String type, List<String> appCodes) throws Exception {
//        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(appCodes, type, null, null, null);
//        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : applicationRelationList;
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("appCodes",appCodes);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationByTypeAndAppCodes","post",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> postQueryApplicationRelationByTypeAndAppCode(String type, List<String> appCodes) throws Exception {
//        return getApplicationRelationByTypeAndAppCode(type, appCodes);
        Map<String,Object> map = AppMetaCaller.of("type",type);
        map.put("appCodes",appCodes);
        RespApplicationRelationList resp = appMetaCaller.call("/app/queryApplicationRelationByTypeAndAppCode","post",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String tenantId, String type, String appCode) throws DWBusinessException {
//        List<ApplicationRelation> applicationRelationList = dataPickService.applicationRelations(appCode, type, null, null, null);
//        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : applicationRelationList;
        Map<String,Object> map = AppMetaCaller.of("tenantId",tenantId);
        map.put("type",type);
        map.put("appCode",appCode);
        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationByTenantIdAndTypeAndAppCode","get",map, RespApplicationRelationList.class);
        return resp.getResponse();
    }

    @Override
    public Object postAppRelationUpdate(AppRelationBatchPo request) throws Exception {
//        if (Boolean.TRUE.equals(request.getCleanDuplicate())) {
//            Map map = new HashMap();
//            List<ApplicationRelation> applicationRelations = mongoTemplateSystem.findAll(ApplicationRelation.class);
//            applicationRelations = dataPickService.filterApplicationRelations(applicationRelations);
//            Set<String> cleaned = new HashSet<>();
//            List<ApplicationRelation> newList = new ArrayList<>();
//            applicationRelations.forEach(app -> {
//                if (newList.contains(app)) {
//                    cleaned.add(app.getCode());
//                    mongoTemplateSystem.remove(app);
//                } else {
//                    newList.add(app);
//                }
//            });
//            map.put("codes", cleaned);
//            map.put("count", cleaned.size());
//
//            return map;
//        }
//
//
//        List<ApplicationRelation> relations = request.getList();
//        if (null == relations) {
//            return null;
//        }
//        List<Pair<Query, Update>> updateList = new ArrayList();
//
//        relations.forEach(data -> {
//            Query query = new Query(new Criteria("code").is(data.getCode()).and("type").is(data.getType()).and("appCode").is(data.getAppCode()));
//            Update update = new Update();
//            update.set("code", data.getCode());
//            update.set("type", data.getType());
//            update.set("application", data.getApplication());
//            update.set("appName", data.getAppName());
//            update.set("appCode", data.getAppCode());
//            update.set("source", data.getSource());
//            update.set("version", data.getVersion());
//            update.set("name", data.getName());
//            update.set("tenantId", data.getTenantId());
//            update.set("sourceLevel", data.getSourceLevel());
//            Pair<Query, Update> updatePair = Pair.of(query, update);
//            updateList.add(updatePair);
//        });
//        BulkWriteResult result = mongoTemplateSystem.bulkOps(BulkOperations.BulkMode.UNORDERED, ApplicationRelation.class).upsert(updateList).execute();
//
//        int count = result.getDeletedCount() + result.getModifiedCount();
//        return count;
        Map<String,Object> map = AppMetaCaller.of("request",request);
        RespObject resp = appMetaCaller.call("/app/appRelationUpdate","post",map, RespObject.class);
        return resp.getResponse();
    }


    public List<String> getNeedUserCheckApp(String tenantId) throws DWBusinessException {
        String tenantVersion = "2.0";
        if (StringUtils.isNotEmpty(tenantId)) {
            try {
                tenantVersion = kgInnerService.getTenantVersion(tenantId);
            } catch (Exception e) {
                log.error("getNeedUserCheckApp tenantId:{},e:{}", tenantId, e);
            }
        }

        List<String> appCodes = this.tenantService.getAppCodes(tenantId);
        Set<String> appCodesSet = appCodes.stream().collect(Collectors.toSet());

//        List<Application> all = this.mongoTemplateSystem.findAll(Application.class);
        Query query = new Query();
        query.fields().include("code").include("feature");
        Criteria criteria = Criteria.where("version").is(tenantVersion).and("code").in(appCodesSet);
        query.addCriteria(criteria);
        List<Application> all = this.mongoTemplate.find(query, Application.class);
        all = dataPickService.excludeWithSameCode(all);
        if (CollectionUtils.isEmpty(all)) {
            return Collections.emptyList();
        }

        List<String> collect = all.stream().filter(e -> appCodesSet.contains(e.getCode()) && this.needNeedUserCheck(e)).map(Application::getCode)
                .distinct().collect(Collectors.toList());
        return collect;

    }

    private boolean needNeedUserCheck(Application application) {
        return application.getFeature() == null
                || application.getFeature().get("userIntegrityCheck") == null
                || Boolean.parseBoolean(String.valueOf(application.getFeature().get("userIntegrityCheck")));

    }

    /**
     * 　* @description: 当DisplayType为复合型时：GROUP，查询所有子组件，并设置到FieldDescription
     * 　* @param [para]
     * 　* @return void
     * 　* @throws
     * 　* @author linc
     * 　* @date 2023/5/10 17:53
     */
    public void setFieldDescriptionValue(FieldDescription para) throws DWBusinessException {
        if ("GROUP".equalsIgnoreCase(para.getDisplayType())) {
            List<FieldDescription> childFieldDescriptions = new ArrayList<>();
            List<String> codeList = (List<String>) para.getDefaultValue();

            for (String code : codeList) {
                FieldDescription childFieldDescription = createVariableParam(code);
                childFieldDescriptions.add(childFieldDescription);
            }
            para.setParameters(childFieldDescriptions);
        }
    }

    @Override
    public List<ApplicationRelation> getApplicationRelationByType(String type) throws Exception {
        Criteria criteria = Criteria.where("type").is(type);
        List<ApplicationRelation> applicationRelationList = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return CollectionUtils.isEmpty(applicationRelationList) ? new ArrayList<>() : dataPickService.filterApplicationRelations(applicationRelationList);
//        Map<String,Object> map = AppMetaCaller.of("type",type);
//        RespApplicationRelationList resp = appMetaCaller.call("/app/applicationRelationByType","get",map, RespApplicationRelationList.class);
//        return resp.getResponse();
    }

    @Override
    public List<ApplicationCustomizedConfig> postConfigByApplicationCustomized() {
//        String version = kgInnerService.currentTenantVersion();
//        Query query = new Query();
//        Criteria criteria = Criteria.where("version").is(version);
//        query.addCriteria(criteria);
//        List<ApplicationCustomizedConfig> configList = this.mongoTemplateSystem.find(query, ApplicationCustomizedConfig.class);
//        return CollectionUtils.isEmpty(configList) ? Collections.emptyList() : dataPickService.excludeWithSameCode(configList);
        RespApplicationCustomizedConfigList resp = appMetaCaller.call("/app/configByApplicationCustomized","post",null, RespApplicationCustomizedConfigList.class);
        return resp.getResponse();
    }

    @Override
    public List<ApplicationCustomizedConfig> postConfigByGroupApplicationCustomized() {
//        String version = kgInnerService.currentTenantVersion();
//        Query query = new Query();
//        Criteria criteria = Criteria.where("version").is(version);
//        query.addCriteria(criteria);
//        List<ApplicationCustomizedConfig> configList = this.mongoTemplateSystem.find(query, ApplicationCustomizedConfig.class);
//        configList = dataPickService.excludeWithSameCode(configList);
//        // name -> tenantId -> appId集合
//        Map<String, Map<String, List<String>>> nameTenantIdAppIdListMap = configList.stream()
//                .filter(o -> StringUtils.isNotBlank(o.getName()) && StringUtils.isNotBlank(o.getTenantId()))
//                .collect(Collectors.groupingBy(
//                        ApplicationCustomizedConfig::getName,
//                        Collectors.groupingBy(ApplicationCustomizedConfig::getTenantId,
//                                Collectors.mapping(ApplicationCustomizedConfig::getAppId, Collectors.toList())))
//                );
//        // key：name + tenantId，value：第一个配置
//        LinkedHashMap<String, ApplicationCustomizedConfig> nameMap = configList.stream()
//                .filter(o -> StringUtils.isNotBlank(o.getName()) && StringUtils.isNotBlank(o.getTenantId()))
//                .collect(Collectors.toMap(
//                        o -> o.getName() + o.getTenantId(),
//                        Function.identity(),
//                        (existingValue, newValue) -> existingValue,
//                        LinkedHashMap::new
//                ));
//        nameMap.forEach((name, config) -> {
//            config.setRelationAppIds(nameTenantIdAppIdListMap.getOrDefault(config.getName(), Collections.emptyMap()).get(config.getTenantId()));
//        });
//        return Lists.newArrayList(nameMap.values());
        RespApplicationCustomizedConfigList resp = appMetaCaller.call("/app/configByGroupApplicationCustomized","post",null, RespApplicationCustomizedConfigList.class);
        return resp.getResponse();
    }

    @Override
    public List<Application> postAllApplications() {
//        Query query = new Query();
//        Criteria criteria = Criteria.where("version").is("2.0");
//        query.addCriteria(criteria);
//        query.fields().include("code");
//        query.fields().include("name");
//        query.fields().include("description");
//        query.fields().include("lang");
//        List<Application> applicationList = this.mongoTemplateSystem.find(query, Application.class);
//        return CollectionUtils.isEmpty(applicationList) ? Collections.emptyList() : dataPickService.excludeWithSameCode(applicationList);
        RespApplicationList resp = appMetaCaller.call("/app/allApplications","post",null, RespApplicationList.class);
        return resp.getResponse();
    }


    @Override
    public Object postApplicationRelationByTypeAndCode(String tenantId, String type, String code) throws DWBusinessException {
//        Map<String, String> data = new HashMap<>();
//        data.put("code", code);
//        data.put("appCode", "");
//        Map<String, String> convertType = new HashMap<String, String>();
//        convertType.put("project", "task");
//        convertType.put("task", "activity");
//        convertType.put("monitorRule", "monitorRule");
//        String codeType = convertType.get(type);
//        try {
//            if (StringUtils.isEmpty(codeType) && Objects.equals("action", type)) {
//                List<Action> actions = dataPickService.excludeWithSameCode(actionRepository.findByActionId(code));
//                if (CollectionUtils.isNotEmpty(actions)) {
//                    Optional<Action> actionOptional = actions.stream().filter(list -> Objects.equals(list.getVersion(), "1.0")).findFirst();
//                    if (actionOptional.isPresent()) {
//                        data.put("appCode", actionOptional.get().getNameSpace());
//                    }
//                }
//            } else if (Objects.equals("monitorRule", type)) {
//                List<MonitorRule> monitorRules = dataPickService.excludeWithSameCodeAndFilterTenant(monitorRuleRepository.findByCodeAndVersion(code, "1.0", tenantId));
//                if (CollectionUtils.isNotEmpty(monitorRules)) {
//                    Optional<MonitorRule> monitorRuleOptional = monitorRules.stream().filter(list -> Objects.equals(list.getVersion(), "1.0")).findFirst();
//                    if (monitorRuleOptional.isPresent()) {
//                        data.put("appCode", monitorRuleOptional.get().getNameSpace());
//                    }
//                }
//            } else {
//                Set<String> codes = Collections.singleton(code);
//                Map<String, Object> profile = new HashMap<>();
//                profile.put("tenantId", tenantId);
//                DWServiceContext.getContext().setProfile(profile);
//                profile.put("tenantId", tenantId);
//                Map<String, List<ApplicationRelation>> relationsMap = this.getApplicationRelationsMapByTypeAndCodesAndLang(codeType, codes, AthenaUtils.getCurrentLocale());
//                Optional<ApplicationRelation> relations = relationsMap.entrySet().stream()
//                        .map(Map.Entry::getValue)
//                        .filter(list -> !CollectionUtils.isEmpty(list))
//                        .flatMap(List::stream).findFirst();
//                if (relations.isPresent()) {
//                    data.put("appCode", relations.get().getAppCode());
//                }
//            }
//        } catch (Exception e) {
//            log.error("postApplicationRelationByTypeAndCode error:{}", e);
//        }
//        return data;
        Map<String,Object> map = AppMetaCaller.of("tenantId",tenantId);
        map.put("type",type);
        map.put("code",code);
        RespObject resp = appMetaCaller.call("/app/applicationRelationByTypeAndCode","post",map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public Object postApplicationRelationByDDSM(AppRelationBatchPo request) throws DWBusinessException {
//        String version = kgInnerService.currentTenantVersion();
//        List<ApplicationRelation> applicationRelations = request.getList();
//        String applicationRelationStr = translateUtils.translateContent(applicationRelations);
//        applicationRelations = JSONArray.parseArray(applicationRelationStr, ApplicationRelation.class);
//        if (CollectionUtils.isNotEmpty(applicationRelations)) {
//            for (ApplicationRelation applicationRelation : applicationRelations) {
//                Query query = new Query();
//                Criteria criteria = Criteria.where("type").is(applicationRelation.getType()).and("code").is(applicationRelation.getCode()).and("appCode").is(applicationRelation.getAppCode()).and("version").is(version);
//                query.addCriteria(criteria);
//                List<ApplicationRelation> applicationRelationList = this.mongoTemplateSystem.find(query, ApplicationRelation.class);
//                if (CollectionUtils.isNotEmpty(applicationRelationList)) {
//                    this.mongoTemplateSystem.remove(query, ApplicationRelation.class);
//                }
//                this.mongoTemplateSystem.save(applicationRelation);
//            }
//        }
//        return "success";
        Map<String,Object> map = AppMetaCaller.of("request",request);
        RespObject resp = appMetaCaller.call("/app/applicationRelationByDDSM","post",map, RespObject.class);
        return resp.getResponse();
    }

    @Override
    public List<Map<String, String>> postQueryApplicationsNameByCodeList(List<String> codes, Integer appType) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").in(codes).and("appType").is(appType);
        List<Application> applications = mongoTemplate.find(new Query(criteria), Application.class);

        List<Map<String, String>> result = new ArrayList<>();
        if (CollectionUtils.isEmpty(applications)) {
            return result;
        }
        applications.forEach(app -> {
            Map<String, String> data = new HashMap<>();
            data.put("code", app.getCode());
            data.put("name", app.getName());
            data.put("version", app.getVersion());
            result.add(data);
        });
        return result;
        /*Map<String,Object> map = AppMetaCaller.of("codes",codes);
        map.put("appType",appType);
        RespObject resp = appMetaCaller.call("/app/queryApplicationsNameByCodeList","post",map, RespObject.class);
        return (List<Map<String, String>>) resp.getResponse();*/
    }

    @Override
    public Application getAppByMechanismCode(String mechanismCode) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<String> appCodes = tenantService.getAppCodes(tenantId);
//        if (appCodes.isEmpty()) {
//            throw new DWBusinessException(String.format("authorizations Application is empty, mechanismCode: %s, tenantId: %s", mechanismCode, tenantId));
//        }
//        ApplicationRelation relation = dataPickService.findOneByCondition(Criteria.where("type").is("mechanism")
//                .and("code").is(mechanismCode)
//                .and("appCode").in(appCodes)
//                .and("version").is(tenantVersion), ApplicationRelation.class, "applicationRelation");
//        if (relation == null) {
//            throw new DWBusinessException("applicationRelation is empty, mechanismCode: " + mechanismCode);
//        }
//        Criteria criteria = Criteria.where("code").is(relation.getAppCode()).and("version").is(tenantVersion);
//        Application application = dataPickService.findOneByCondition(criteria, Application.class, "application");
//        if (application == null) {
//            throw new DWBusinessException("application is empty, code: " + relation.getAppCode());
//        }
//        return application;
        Map<String,Object> map = AppMetaCaller.of("mechanismCode",mechanismCode);
        RespApplication resp = appMetaCaller.call("/app/appByMechanismCode","get",map, RespApplication.class);
        return resp.getResponse();
    }

    @Override
    public Application getAppByActivityId(String activityId) throws DWBusinessException {
//        ApplicationRelation relation = dataPickService.findOneByCondition(Criteria.where("code").is(activityId), ApplicationRelation.class, "applicationRelation");
//        if (relation == null) {
//            throw new DWBusinessException("applicationRelation is empty, activityId: " + activityId);
//        }
//        Criteria criteria = Criteria.where("code").is(relation.getAppCode());
//        Application application = dataPickService.findOneByCondition(criteria, Application.class, "application");
//        if (application == null) {
//            throw new DWBusinessException("application is empty, code: " + relation.getAppCode());
//        }
//        return application;
        Map<String,Object> map = AppMetaCaller.of("activityId",activityId);
        RespApplication resp = appMetaCaller.call("/app/appByActivityId","get",map, RespApplication.class);
        return resp.getResponse();
    }

    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getActivityCode$0", ttlSecs = 86400L)
    public List<String> getActivityCode(String tenantId) throws DWBusinessException {
        List<String> appCodes = tenantService.getAppCodes(tenantId);
        Criteria criteria = Criteria.where("type").in("task", "activity")
                .and("appCode").in(appCodes);
        List<ApplicationRelation> relations = dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return relations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
    }

    @Override
    public Object postQueryApplicationsByCodes(Set<String> codes) {
        String tenantVersion = kgInnerService.currentTenantVersion();
        List<Map> applications = mongoTemplate.find(Query.query(Criteria.where("version").is(tenantVersion).and("code").in(codes)), Map.class, "application");

        if (CollectionUtils.isEmpty(applications)) {
            return Collections.emptyMap();
        }
        return applications.stream()
                .collect(Collectors.toMap(
                        app -> (String) app.get("code"), // 使用 "code" 作为键
                        app -> app // 使用整个 application 作为值
                ));
    }
}
