package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kg.report.hz.model.assistDimension.AssistDimensionConfig;
import com.digiwin.athena.kg.report.hz.model.assistDimension.AssistDimensionTenantConfig;
import com.digiwin.athena.knowledgegraph.service.IAssistDimensionService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Lang
@Service
@Slf4j
@MyExceptionHandler
public class AssistDimensionService implements IAssistDimensionService {

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    KgInnerService kgInnerService;

    @Override
    public Object postQueryAssistDimension(String appCode,List<String> dimensions) throws Exception {
        String tenantVersion = kgInnerService.currentTenantVersion();
        String tenantId = AthenaUtils.getTenantId();

        Map<String, List<String>> resultMap = dimensions.stream()
                .collect(Collectors.toMap(
                        dimension -> dimension,
                        dimension -> Collections.emptyList(),
                        (existing, replacement) -> existing // 处理重复键的方式，这里选择保留已存在的值
                ));

        List<AssistDimensionConfig> assistDimensionConfigs = mongoTemplate.find(
                Query.query(Criteria.where("key").in(dimensions)
                        .and("appCode").is(appCode)
                        .and("version").is(tenantVersion)), AssistDimensionConfig.class);

        if (!CollectionUtils.isEmpty(assistDimensionConfigs)) {
            resultMap.putAll(assistDimensionConfigs.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll));
        }

        List<AssistDimensionTenantConfig> assistDimensionTenantConfigs = mongoTemplateUser.find(
                Query.query(Criteria.where("key").in(dimensions)
                        .and("appCode").is(appCode)
                        .and("tenantId").is(tenantId)), AssistDimensionTenantConfig.class);

        if (!CollectionUtils.isEmpty(assistDimensionTenantConfigs)) {
            resultMap.putAll(assistDimensionTenantConfigs.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll));
        }

        return resultMap;
    }

}
