package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.component.ComponentInitManager;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.service.IComponentService;
import com.digiwin.athena.knowledgegraph.support.SignOffAppHolder;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.OperationRecordUtil;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Lang
@Service
@Slf4j
public class ComponentService implements IComponentService {

    @Autowired
    ComponentManager componentManager;

    @Autowired
    ComponentInitManager componentInitManager;

    @Autowired
    OperationRecordUtil recordUtil;

    @Override
    public Object getBaseFunctionComponentStructuredList(String appCode, String paradigm) throws Exception {
        return componentManager.findBaseFunctionComponentStructuredList(appCode, paradigm, "2.0", null);
    }
    @Override
    public Object getBaseFunctionComponentStructuredList(String appCode, String paradigm,String version) throws Exception {
        return componentManager.findBaseFunctionComponentStructuredList(appCode, paradigm, version, null);
    }
    @Override
    public Object getMechanismComponentStructuredList(String mechanismCode) throws Exception {
        return componentManager.findMechanismComponentStructuredList(mechanismCode);
    }

    @Override
    public Object getTenantApplicationComponentList(String appCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return componentManager.findTenantComponentList(appCode, tenantId);
    }

    @Override
    public void postInitializeTenantApplicationComponentList(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigm, mechanismCodes);
    }

    @Override
    public void postInitializeTenantApplicationComponentList(String appCode, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigms, mechanismCodes);
    }

    @Override
    public void postUpdateTenantApplicationComponentListByMechanism(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        //注意：此接口目前可以在初始化完成后再新增机制，第一版此接口公开人工调用，没有做检查，存在授权上的漏洞，即有机会新增未购买的机制，但后续此接口应该不会再公开，改成内部与CAC做授权同步，根据购买的机制来取得mechanismCodes
        String tenantId = AthenaUtils.getTenantId();
        componentManager.UpdateTenantApplicationComponentListByMechanism(appCode, tenantId, paradigm, mechanismCodes, null);
    }

    @Override
    public void postUpdateTenantApplicationComponentListByMechanism(String appCode, List<String> paradigms, List<String> mechanismCodes) throws DWBusinessException {
        //注意：此接口目前可以在初始化完成后再新增机制，第一版此接口公开人工调用，没有做检查，存在授权上的漏洞，即有机会新增未购买的机制，但后续此接口应该不会再公开，改成内部与CAC做授权同步，根据购买的机制来取得mechanismCodes
        String tenantId = AthenaUtils.getTenantId();
        componentManager.UpdateTenantApplicationComponentListByMechanism(appCode, tenantId, paradigms, mechanismCodes, null);
    }

    @Override
    public void postInitializeApplicationComponentList(String appCode, String paradigm,String version) throws DWBusinessException {
        //用来初始化应用组件清单
        componentInitManager.initializeApplicationComponentList(appCode, paradigm, version);
    }

    @Override
    public Object postQueryComponent(String tenantId, String appCode, String eventType, List<String> component) throws DWBusinessException {
        Map<String, Object> map = new HashMap<>();
        try {
            log.info("queryComponentRequest tenantId:{}, appCode:{}, eventType:{}, component:{}", tenantId, appCode,
                    eventType, component);
            if (StringUtils.isEmpty(tenantId) || StringUtils.isEmpty(appCode) || StringUtils.isEmpty(eventType)) {
                throw new DWBusinessException("tenantId or appCode or eventType can not be null");
            }
            if (!Constants.AppNoticeType.RENEW.equals(eventType) && !Constants.AppNoticeType.CLEAN.equals(eventType)
                    && !Constants.AppNoticeType.EXPIRE.equals(eventType)) {
                throw new DWBusinessException("eventType error");
            }
            SignOffAppHolder.setSignOffAppFlag(appCode);
            map = componentInitManager.queryComponent(tenantId, appCode, eventType, component);
        } catch (Exception e){
            map.put("errorMessage", e.toString());
        } finally {
            recordUtil.recordInfo(OperationRecord.builder()
                    .type(OperationRecordType.CALLBACK + "-" + eventType)
                    .tenantId(tenantId)
                    .application(appCode)
                    .supplementaryContent(ImmutableMap.of(
                            "request", component,
                            "response", map
                    )).build());
            SignOffAppHolder.removeSignOffAppFlag();
        }
        return  map;
    }

    @Override
    public void postClearTenantApplicationComponentListByMechanism(String appCode, String paradigm, List<String> mechanismCodes) throws DWBusinessException {
        //清除范式
        String tenantId = AthenaUtils.getTenantId();
        componentManager.clearTenantApplicationComponentListByMechanism(appCode, tenantId, paradigm, mechanismCodes);
    }

    @Override
    public void postUpdateApplicationComponentList(String appCode, String version) throws DWBusinessException{
        log.info("postUpdateApplicationComponentList appCode:{}, version:{},", appCode, version);
        componentInitManager.updateApplicationComponentList(appCode, version, null);
    }

    @Override
    public void postUpdateApplicationComponentList(String appCode, List<String> tenantIds, String version) throws DWBusinessException {
        log.info("postUpdateApplicationComponentList appCode:{}, tenantIds:{}, version:{},", appCode, JSON.toJSONString(tenantIds), version);
        componentInitManager.updateApplicationComponentList(appCode, tenantIds, version);
    }

}