package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kg.report.hz.model.dataCollect.QueryConfigDTO;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.dto.report.dataBoard.DataBoardConfig;
import com.digiwin.athena.knowledgegraph.service.IDataBoardService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import io.seata.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;
@Lang
@Service
@Slf4j
@MyExceptionHandler
public class DataBoardService implements IDataBoardService {

    public static final String FAIL_MSG = "fail";

    public static final String SUCCESS_MSG = "success";

    // 将最大收藏问题数定义为常量
    private static final int MAX_SAVED_QUESTIONS = 8;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    SceneService sceneService;

    @Override
    public Object postAddDataBoardConfig(DataBoardConfig config) throws Exception {
        if (StringUtils.isEmpty(config.getTenantId()) || StringUtils.isEmpty(config.getUserId())
                || CollectionUtils.isEmpty(config.getDataBoardQuestions())) {
            return FAIL_MSG;
        }
        String boardId = config.getBoardId();
        String currentLocale = AthenaUtils.getCurrentLocale();

        // 控制重名
        if (!StringUtils.isEmpty(boardId)) {
            List<DataBoardConfig> configs = this.getQueryDataBoardConfig(config.getAsaCode());
            if (!CollectionUtils.isEmpty(configs)) {
                for (DataBoardConfig oldConfig : configs) {
                    if (!Objects.equals(oldConfig.getBoardId(), boardId) && Objects.equals(config.getBoardName(), oldConfig.getBoardName())) {
                        if (Objects.equals("zh_TW", currentLocale)) {
                            throw new DWException("P.KG.500.99999", "數據看板名稱不能重復，請修改");
                        }
                        throw new DWException("P.KG.500.99999", "数据看板名称不能重复，请修改");
                    }
                }
            }
        }

        if (StringUtils.isEmpty(boardId)) { // 新增看板
            boardId = "board_" + UUID.randomUUID().toString().replace("-", "");
            config.setBoardId(boardId);
            DataBoardConfig.DataBoardQuestions boardQuestion = config.getDataBoardQuestions().get(0);
            boardQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
            config.setDataBoardQuestions(Collections.singletonList(boardQuestion));
            this.mongoTemplateUser.save(config);
        } else { // 更新看板
            List<DataBoardConfig.DataBoardQuestions> dataBoardQuestions = config.getDataBoardQuestions();
            if (dataBoardQuestions.size() > MAX_SAVED_QUESTIONS) {
                if (Objects.equals("zh_TW", currentLocale)) {
                    throw new DWException("P.KG.500.99999", "當前數據看板最多收藏8個問題");
                }
                throw new DWException("P.KG.500.99999", "当前数据看板最多收藏8个问题");
            }
            for (DataBoardConfig.DataBoardQuestions boardQuestion : dataBoardQuestions) {
                if (StringUtils.isEmpty(boardQuestion.getQuestionId())) {
                    boardQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
                }
            }
            updateDataBoardConfig(boardId, config, dataBoardQuestions);
        }
        return SUCCESS_MSG;
        /*List<DataBoardConfig> dataBoardConfigs = getQueryDataBoardConfig();

        if (StringUtils.isEmpty(boardQuestion.getQuestionId())) {

        }
        // 对应的租户和用户没有数据就新增
        if (CollectionUtils.isEmpty(dataBoardConfigs)) {
            config.setBoardId("board_" + UUID.randomUUID().toString().replace("-", ""));
            config.setDataBoardQuestions(Collections.singletonList(boardQuestion));
            this.mongoTemplateUser.save(config);
        } else {
            // 默认单个看板
            List<DataBoardConfig.DataBoardQuestions> dataBoardQuestions = dataBoardConfigs.get(0).getDataBoardQuestions();

            processDataBoardQuestions(config, dataBoardQuestions);

            // 默认后续数据都插入头部，按收藏顺序倒序显示
            dataBoardQuestions.add(0, boardQuestion);
            updateDataBoardConfig(dataBoardConfigs.get(0).getBoardId(), config, dataBoardQuestions);
        }*/
    }

    @Override
    public List<DataBoardConfig> getQueryDataBoardConfig() throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query(Criteria.where("tenantId").is(tenantId)
                .and("userId").is(userId));

        return this.mongoTemplateUser.find(query, DataBoardConfig.class);
    }

    @Override
    public List<DataBoardConfig> getQueryDataBoardConfig(String asaCode) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query(Criteria.where("tenantId").is(tenantId)
                .and("userId").is(userId).and("asaCode").is(asaCode));

        return this.mongoTemplateUser.find(query, DataBoardConfig.class);
    }

    @Override
    public Object postQueryBoardStep(String questionId) {
        DataBoardConfig dataCollectConfigs = mongoTemplateUser.findOne(Query.query(Criteria.where("dataBoardQuestions.questionId").is(questionId)), DataBoardConfig.class);
        if (ObjectUtils.isEmpty(dataCollectConfigs)) {
            return Collections.emptyMap();
        }

        List<DataBoardConfig.DataBoardQuestions> collectConfigs = dataCollectConfigs.getDataBoardQuestions();
        if (CollectionUtils.isEmpty(collectConfigs)) {
            return Collections.emptyMap();
        }

        List<DataBoardConfig.DataBoardQuestions> filteredList = collectConfigs.stream()
                .filter(collectConfig -> Objects.equals(questionId, collectConfig.getQuestionId()))
                .collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredList) || filteredList.get(0) == null) {
            return Collections.emptyMap();
        }
        Map<String, Object> map  = new HashMap<>();
        map.put("questionId", filteredList.get(0).getQuestionId());
        map.put("solutionStep", filteredList.get(0).getSolutionStep());
        map.put("question", filteredList.get(0).getQuestion());
        map.put("snapshotId", filteredList.get(0).getSnapshotId());
        map.put("showType", filteredList.get(0).getShowType());
        map.put("boardId", dataCollectConfigs.getBoardId());
        map.put("appCode", filteredList.get(0).getAppCode());

        return map;
    }


    @Override
    public Object postQueryBoardById(String boardId) throws Exception {
        return mongoTemplateUser.findOne(Query.query(Criteria.where("boardId").is(boardId)), DataBoardConfig.class);
    }

    @Override
    public Object postQueryDataBoardConfig(QueryConfigDTO queryConfig) throws Exception {
        List<DataBoardConfig> dataCollectConfigs = this.getQueryDataBoardConfig(queryConfig.getAsaCode());

        if (StringUtils.isEmpty(queryConfig.getGroupId()) || CollectionUtils.isEmpty(dataCollectConfigs)) {
            return dataCollectConfigs;
        }

        List<DataBoardConfig.DataBoardQuestions> collectConfigs = dataCollectConfigs.get(0).getDataBoardQuestions();
        if (null != collectConfigs) {
            /*List<DataBoardConfig.DataBoardQuestions> filteredList = collectConfigs.stream()
                    .filter(collectConfig -> Objects.equals(queryConfig.getGroupId(), collectConfig.getGroupId()))
                    .collect(Collectors.toList());*/
            dataCollectConfigs.get(0).setDataBoardQuestions(collectConfigs);
        }
        return sceneService.getTranslateContent(dataCollectConfigs);
    }

    @Override
    public Object postRemoveDataBoardConfig(String boardId) throws Exception {
        if (StringUtils.isEmpty(boardId)) {
            return SUCCESS_MSG;
        }

        mongoTemplateUser.remove(Query.query(Criteria.where("boardId").is(boardId)), DataBoardConfig.class);

        return SUCCESS_MSG;
    }

    /*private void processDataBoardQuestions(DataBoardConfig config, List<DataBoardConfig.DataBoardQuestions> dataCollectQuestions) throws Exception {
        // 默认单个看板
        String currentLocale = AthenaUtils.getCurrentLocale();
        DataBoardConfig.DataBoardQuestions collectQuestion = config.getDataBoardQuestions().get(0);
        Map<String, List<DataBoardConfig.DataBoardQuestions>> groupToQuestionsMap = dataCollectQuestions.stream()
                .collect(Collectors.groupingBy(DataBoardConfig.DataBoardQuestions::getGroupId));
        if (*//*CollectionUtils.isNotEmpty(dataCollectQuestions)
                && dataCollectQuestions.size() == MAX_SAVED_QUESTIONS
                && !dataCollectQuestions.contains(collectQuestion) &&  StringUtils.isBlank(collectQuestion.getGroupValue())*//*
                !groupToQuestionsMap.isEmpty() &&
                groupToQuestionsMap.get(collectQuestion.getGroupId()).size() >= MAX_SAVED_QUESTIONS) {

            if (Objects.equals("zh_TW", currentLocale)) {
                throw new DWException("P.KG.500.99999", "當前數據看板最多收藏8個問題");
            }
            throw new DWException("P.KG.500.99999", "当前数据看板最多收藏8个问题");
        }
    }*/

    public void updateDataBoardConfig(String boardId, DataBoardConfig config, List<DataBoardConfig.DataBoardQuestions> dataBoardQuestions) throws Exception {
        // 默认单个看板
        Query query = Query.query(Criteria.where("tenantId").is(config.getTenantId())
                .and("boardId").is(boardId)
                .and("userId").is(config.getUserId()));
        Update update = new Update();
        update.set("dataBoardQuestions", dataBoardQuestions);
        update.set("boardName", config.getBoardName());
        update.set("asaCode", config.getAsaCode());
        this.mongoTemplateUser.updateMulti(query, update, DataBoardConfig.class);
    }

    public void postRemoveDataBoardConfig(List<String> groupIds) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query(Criteria.where("tenantId").is(tenantId)
                .and("userId").is(userId));

        List<DataBoardConfig> dataCollectConfigs = this.mongoTemplateUser.find(query, DataBoardConfig.class);

        if (CollectionUtils.isEmpty(dataCollectConfigs)) {
            return;
        }

        // 默认单个看板
        List<DataBoardConfig.DataBoardQuestions> dataCollectQuestions = dataCollectConfigs.get(0).getDataBoardQuestions();
        // 默认一个个问题单独删除
        if (CollectionUtils.isEmpty(dataCollectQuestions)) {
            return;
        }

//        dataCollectQuestions.removeIf(dataCollectQuestion -> groupIds.contains(dataCollectQuestion.getGroupId()));
        updateDataBoardConfig(dataCollectConfigs.get(0).getBoardId(), dataCollectConfigs.get(0), dataCollectQuestions);
    }


    @Override
    public Object postRemoveDataBoardQuestion(String questionId) throws Exception {
        if (StringUtils.isEmpty(questionId)) {
            return SUCCESS_MSG;
        }

        DataBoardConfig configs = mongoTemplateUser.findOne(Query.query(Criteria.where("dataBoardQuestions.questionId").is(questionId)), DataBoardConfig.class);
        if (Objects.isNull(configs)) {
            return SUCCESS_MSG;
        }

        List<DataBoardConfig.DataBoardQuestions> questions = configs.getDataBoardQuestions();
        if (CollectionUtils.isEmpty(questions)) {
            return SUCCESS_MSG;
        }
        configs.getDataBoardQuestions().removeIf(dataBoardQuestion -> Objects.equals(questionId, dataBoardQuestion.getQuestionId()));

        updateDataBoardConfig(configs.getBoardId(), configs, configs.getDataBoardQuestions());
        return SUCCESS_MSG;
    }
}
