package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.TranslateUtil;
import com.digiwin.athena.knowledgegraph.po.DeployMessagePO;
import com.digiwin.athena.knowledgegraph.service.IDeployService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.ConvertObjectMapper;
import com.digiwin.athena.knowledgegraph.vo.DeployRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author tang jie cheng
 * @date 2023-02-13 9:48
 */
@Lang
@Service
@Slf4j
public class DeployService implements IDeployService {
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSys;
    @Autowired
    private ConvertObjectMapper convertObjectMapper;
    @Autowired
    TenantService tenantService;

    @Override
    public Object postQueryDeploy(DeployRequest request) throws Exception {
        Query query = new Query();
        //筛选条件
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty(request.getMongoId())) {
            criteria.and("_id").is(request.getMongoId());
            query.addCriteria(criteria);
            List<DeployMessagePO> deployMessages = mongoTemplateSys.find(query, DeployMessagePO.class);
            TranslateUtil.dealLangRecusive(deployMessages, AthenaUtils.getCurrentLocale());
            return convertObjectMapper.deployPoToVo(deployMessages);
        }

        if (ObjectUtils.isEmpty(request.getEndTime())) {
            criteria.and("updateTime").gte(request.getStartTime());
        } else {
            criteria.and("updateTime").gte(request.getStartTime()).lte(request.getEndTime());
        }

        ArrayList<Object> codeList = new ArrayList<>();
        //查询当前租户下的应用code 默认添加平台code
        codeList.add("athena");
        List<String> appCodes = tenantService.getAppCodes();
        codeList.addAll(appCodes);
        criteria.and("code").in(codeList);

        if (CollectionUtils.isNotEmpty(request.getFiled())) {
            for (String filed : request.getFiled()) {
                query.fields().include(filed);
            }
        }
        // 查询总数
        query.addCriteria(criteria);
        long count = mongoTemplateSys.count(query, DeployMessagePO.class);
        if (count <= 0) {
            request.setTotalCount(0);
            return new ArrayList<>();
        }
        //排序和分页条件
        query.with(Sort.by(Sort.Order.desc("updateTime"))).skip((long) (request.getPageNum() - 1) * request.getPageNum()).limit(request.getPageSize());
        List<DeployMessagePO> deployMessages = mongoTemplateSys.find(query, DeployMessagePO.class);
        //多语言替换
        TranslateUtil.dealLangRecusive(deployMessages, AthenaUtils.getCurrentLocale());
        return convertObjectMapper.deployPoToVo(deployMessages);
    }

    @Override
    public Object put(List<DeployMessagePO> deployMessagePOList) throws Exception {
        mongoTemplateSys.insert(deployMessagePOList, DeployMessagePO.class);
        return "success";
    }

    @Override
    public Object delete(List<String> ids) throws Exception {
        for (String id : ids) {
            Query query = new Query();
            Criteria criteria = new Criteria();
            criteria.and("_id").is(new ObjectId(id));
            query.addCriteria(criteria);
            mongoTemplateSys.remove(query, DeployMessagePO.class);
        }
        return "success";
    }
}
