package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kg.dict.Dictionary;
import com.digiwin.athena.knowledgegraph.po.dap.RespApplicationRelation;
import com.digiwin.athena.knowledgegraph.po.dap.RespObject;
import com.digiwin.athena.knowledgegraph.service.AppMetaCaller;
import com.digiwin.athena.knowledgegraph.service.IDictService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Lang
@Service
@Slf4j
public class DictService implements IDictService {

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate sysMongoTemplate;
    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    AppMetaCaller appMetaCaller;

    @Override
    public Object getDictByKey(String key) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
//        log.info("getDictByKey locale:{}",locale);
//        Query query = new Query();
//        query.addCriteria(Criteria.where("key").is(key).and("version").is(tenantVersion));
//        query.with(Sort.by(Sort.Order.asc("code")));
//        List<Dictionary> dicts = this.sysMongoTemplate.find(query, Dictionary.class, "dictionary");
//        try {
//            LanguageUtil.processLocaleLanguage(dicts, locale);
//        } catch (Exception e) {
//            log.error(e.toString());
//        }
//        return dicts;
        Map<String,Object> map = AppMetaCaller.of("key",key);
        RespObject respObject = appMetaCaller.call("/dict/dictByKey","get",map,RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object getDictByKeyAndCode(String key, String code) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
//        log.info("getDictByKeyAndCode locale:{}",locale);
//        Query query = new Query();
//        query.addCriteria(Criteria.where("key").is(key).and("code").is(code).and("version").is(tenantVersion));
//        Dictionary dict = this.sysMongoTemplate.findOne(query, Dictionary.class, "dictionary");
//        try {
//            LanguageUtil.processLocaleLanguage(dict, locale);
//        } catch (Exception e) {
//            log.error(e.toString());
//        }
//        return dict;
        Map<String,Object> map = AppMetaCaller.of("key",key);
        map.put("code",code);
        RespObject respObject = appMetaCaller.call("/dict/dictByKeyAndCode","get",map,RespObject.class);
        return respObject.getResponse();
    }

    @Override
    public Object postFindDictByKeyList(List<String> keyList) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        if(CollectionUtils.isEmpty(keyList)){
//            return null;
//        }
//        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
//        log.info("getDictByKeyList locale:{}",locale);
//        Query query = new Query();
//        query.addCriteria(Criteria.where("key").in(keyList).and("version").is(tenantVersion));
//        query.with(Sort.by(Sort.Order.asc("key"), Sort.Order.asc("code")));
//        List<Dictionary> dicts = this.sysMongoTemplate.find(query, Dictionary.class, "dictionary");
//        if(CollectionUtils.isEmpty(dicts)){
//            log.info("getDictByKeyList is null keys:{}",keyList);
//            return null;
//        }
//        try {
//            LanguageUtil.processLocaleLanguage(dicts, locale);
//        } catch (Exception e) {
//            log.error(e.toString());
//        }
//        Map<String, List<Dictionary>> collect = dicts.stream().collect(Collectors.groupingBy(Dictionary::getKey));
//
//        return collect;
        Map<String,Object> map = AppMetaCaller.of("keyList",keyList);
        RespObject respTenantEntity = appMetaCaller.call("/dict/findDictByKeyList","post",map,RespObject.class);
        return respTenantEntity.getResponse();
    }


}
