package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.knowledgegraph.domain.task.EmailView;
import com.digiwin.athena.knowledgegraph.dto.BusinessLogicBasic;
import com.digiwin.athena.knowledgegraph.po.ViewRequest;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IEmailService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2022-01-26 16:23
 **/
@Lang
@Slf4j
@Service
public class EmailService implements IEmailService {

    @Autowired
    ViewService viewService;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplateSystem;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    TenantService tenantService;

    @Autowired
    private DataPickService dataPickService;

    @Override
    public Object getEmail(String emailCode, String locale) throws DWException {
        return viewService.getEmail(emailCode,locale);
    }

    @Override
    public Object postEmails(ViewRequest request) throws DWException {

        if(null!=request.getTaskCode() && null!=request.getProjectCode()){
            Activity activity = kgInnerService.activityBasic(request.getProjectCode(), request.getTaskCode());
            if(null!=activity){
                if(null!=activity.getConfig() && null!=activity.getConfig().get("businessLogic")){
                    List<BusinessLogicBasic> logics = JSON.parseArray(JSON.toJSONString(activity.getConfig().get("businessLogic")),BusinessLogicBasic.class);
                    for(BusinessLogicBasic logic:logics){
                        if(BusinessLogicBasic.emailTemplateKey.equalsIgnoreCase(logic.getKey())){
                            return  findEmailViewByTemplateCode(logic.getTemplateCode());
                        }
                    }
                }
                return null;
            }
        }

        if(null!=request.getTaskCode()){
            try {
                Object templateCode = dataMapService.postEmailTemplateCode(request);
                if(null!=templateCode){
                    return findEmailViewByTemplateCode((String)templateCode);
                }
            }catch (Exception dme){
                log.error("find emails from datamap failed",dme);
            }

        }

        return null;
    }

    List<EmailView> findEmailViewByTemplateCode(String templateCode) throws DWBusinessException {

        if(null==templateCode){return null;}
        String tenantId = AthenaUtils.getTenantId();
        String locale =AthenaUtils.getCurrentLocale();
        String version = tenantService.getTenantVersion(tenantId);
        Query query = Query.query(Criteria.where("templateCode").is(templateCode).and("version").is(version));
        Query query2 = Query.query(Criteria.where("templateCode").is(templateCode).and("version").is(version).and("tenantId").is(tenantId));
        List<EmailView> emailViewsSystem = dataPickService.filterByIndividual(mongoTemplateSystem.find(query, EmailView.class), null, EmailView::getApplication);
        List<EmailView> emailViewsUser = mongoTemplateUser.find(query2, EmailView.class);

        for(EmailView ev:emailViewsSystem){
            for(EmailView ev2 : emailViewsUser){
                if(ev.getCode().equals(ev2.getCode())){
                    AthenaUtils.mergeObject(ev2,ev);
                    break;
                }
            }
        }
        if(null!=locale){
            emailViewsSystem.forEach(viewSystem->{
                if(null!=viewSystem.getConfig()){
                    if(null!=viewSystem.getConfig().getTables()){
                        viewSystem.getConfig().getTables().forEach(table->{
                            if(null!=table.getLang() && null!=table.getLang().get("name") && null!=table.getLang().get("name").get(locale)){
                                table.setName(table.getLang().get("name").get(locale));
                            }
                            if(null!=table.getFields()){
                                table.getFields().forEach(
                                        field->{
                                            if(null!=field.getLang() && null!=field.getLang().get("name") && null!=field.getLang().get("name").get(locale)){
                                                field.setName(field.getLang().get("name").get(locale));
                                            }
                                        }
                                );
                            }
                        });
                    }
                }
            });
        }

        return emailViewsSystem;
    }

    @Override
    public Object postEmailUpdate(EmailView data) throws DWException {

        String tenantId = AthenaUtils.getTenantId();
        String id = data.getId();
        if(id==null){ throw new DWBusinessException("id is null");}
        EmailView indb = mongoTemplateUser.findById(data.getId(),EmailView.class);
        if (indb==null){
            indb = dataPickService.findOneByCondition(Criteria.where("code").is(data.getId()), EmailView.class, "emailView");
            if(indb==null){
                //这部分数据一定来自kg
                throw new DWArgumentException("id","cant not find data by id:"+id);
              //  dataMapService.postEmailUpdate(data);
            }else {
                //因为系统级和租户级不是同一条记录,需要判断用户点击提交修改后没有刷新页面再次修改的情况,这时候id仍然是系统级的但是已经产生了一条租户级记录了
                Query query = Query.query(Criteria.where("code").is(indb.getCode()).and("version").is(indb.getVersion()).and("tenantId").is(tenantId));
                EmailView indb2 = mongoTemplateUser.findOne(query,EmailView.class);
                if(null!=indb2){
                    AthenaUtils.mergeObject(data,indb2);
                    mongoTemplateUser.save(indb2);
                }else {
                    data.setTenantId(tenantId);
                    data.setId(null); //找不到时重新设置id
                    data.setTemplateCode(indb.getTemplateCode());
                    data.setCode(indb.getCode());
                    data.setVersion(indb.getVersion());
                    mongoTemplateUser.save(data);
                }
            }
        }else{
            AthenaUtils.mergeObject(data,indb);
            mongoTemplateUser.save(indb);
        }
        return "success";
    }
}
