package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.domain.common.IndexStructure;
import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.knowledgegraph.service.IIndexService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.OperationRecordUtil;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Lang
@Service
@Slf4j
public class IndexService implements IIndexService {

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplateSystem;
    @Autowired
    OperationRecordUtil operationRecordUtil;


    /**
     * {@link IndexStructure}
     */
    @Override
    public Object postIndexCheck() {
        List<String> databaseList = AthenaUtils.indexFiledName(Objects.requireNonNull(ServiceUtils.class.getResource(
                "/index")).getPath());
        ArrayList<Object> check = new ArrayList<>();
        for (String database : databaseList) {
            String defaultIndex = AthenaUtils.loadStream("/index/" + database);
            List<IndexStructure> indexStructures = JSON.parseArray(defaultIndex, IndexStructure.class);
            String databaseName = database.replace(".json", "");
            if (CollectionUtils.isEmpty(indexStructures)) {
                continue;
            }
            for (IndexStructure indexStructure : indexStructures) {
                MongoCollection<Document> collection =
                        mongoTemplateSystem.getMongoDbFactory().getDb(databaseName).getCollection(indexStructure.getCollectionName());
                ListIndexesIterable<Document> documents = collection.listIndexes();
                boolean needCreate = true;
                for (Document document : documents) {
                    if ("_id_".equals(document.get("name"))) {
                        continue;
                    }
                    boolean keyEquals =
                            JSON.parseObject(JSON.toJSONString(document.get("key")), Map.class).keySet().containsAll(indexStructure.getKey());
                    //key 相同时 不会重新创建 哪怕name不一样
                    if (keyEquals) {
                        needCreate = false;
                    }
                }
                if (needCreate) {
                    check.add(databaseName + "," + indexStructure);
                }
            }
        }
        if (!CollectionUtils.isEmpty(check)) {
            operationRecordUtil.recordInfo(OperationRecord.builder()
                    .type(OperationRecordType.INDEX.toString())
                    .path(this.getClass().getName())
                    .supplementaryContent(check).build());
        }
        return "ok";
    }

    @Override
    public Object postIndexCreate() throws DWException {
        List<String> databaseList = AthenaUtils.indexFiledName(Objects.requireNonNull(ServiceUtils.class.getResource(
                "/index")).getPath());
        for (String database : databaseList) {
            String defaultIndex = AthenaUtils.loadStream("/index/" + database);
            List<IndexStructure> indexStructures = JSON.parseArray(defaultIndex, IndexStructure.class);
            String databaseName = database.replace(".json", "");
            if (CollectionUtils.isEmpty(indexStructures)) {
                continue;
            }
            for (IndexStructure indexStructure : indexStructures) {
                MongoCollection<Document> collection =
                        mongoTemplateSystem.getMongoDbFactory().getDb(databaseName).getCollection(indexStructure.getCollectionName());
                ListIndexesIterable<Document> documents = collection.listIndexes();
                String indexName = String.join("_", indexStructure.getKey());
                boolean needCreate = true;
                for (Document document : documents) {
                    if ("_id_".equals(document.get("name"))) {
                        continue;
                    }
                    boolean keyEquals =
                            JSON.parseObject(JSON.toJSONString(document.get("key")), Map.class).keySet().containsAll(indexStructure.getKey());
                    //key 相同时 不会重新创建 哪怕name不一样
                    if (keyEquals) {
                        needCreate = false;
                    }
                }
                //collection.dropIndex((String) document.get("name"));
                if (needCreate) {
                    IndexOptions indexOptions =
                            new IndexOptions().name(indexName).unique(indexStructure.getUnique()).background(true);
                    collection.createIndex(Indexes.ascending(indexStructure.getKey()), indexOptions);
                }
            }
        }
        return "ok";
    }

}
