package com.digiwin.athena.knowledgegraph.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.druid.support.json.JSONUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.domain.MechanismApplyRecord;
import com.digiwin.athena.domain.common.BaseEntity;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.MechanismPrincipleDetailComponentBO;
import com.digiwin.athena.domain.component.bo.StructuredComponentBO;
import com.digiwin.athena.kg.domain.OperationUnitV2;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.constant.ComponentConstants;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.data.MongoEntityBaseDAO;
import com.digiwin.athena.knowledgegraph.domain.ComponentStructuredList;
import com.digiwin.athena.knowledgegraph.domain.MechanismSettings;
import com.digiwin.athena.knowledgegraph.domain.MechanismTenantVariable;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.domain.mechanism.*;
import com.digiwin.athena.knowledgegraph.domain2.base.AbsEntityDict;
import com.digiwin.athena.knowledgegraph.domain2.base.Dimension;
import com.digiwin.athena.kg.action.Variable;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismAchiveRecord;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismItemRecord;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismOld;
import com.digiwin.athena.knowledgegraph.domain2.mechanism.MechanismScene;
import com.digiwin.athena.knowledgegraph.mechanism.partparsers.AdvancedAssignDefinitionParser;
import com.digiwin.athena.knowledgegraph.po.MechanismUserDesignerInfo;
import com.digiwin.athena.knowledgegraph.repo.MechanismAchiveRecordRepository;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.OperationUnitService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.inner.MechanismGraphService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.knowledgegraph.support.AbstractionHandler;
import com.digiwin.athena.knowledgegraph.support.CompositeMechanismCustomer;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.Utils;
import com.digiwin.athena.knowledgegraph.utils.VersionUtil;
import com.digiwin.athena.knowledgegraph.vo.*;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.pre.MechanismCapacity;
import com.digiwin.athena.mechanism.pre.MechanismTheory;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.assign.AdvancedUserDefinitionWidget;
import com.digiwin.athena.repository.neo4j.MechanismRepository;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.mongodb.client.model.Filters.and;
import static com.mongodb.client.model.Filters.eq;

@Lang
@Slf4j
@Service
@MyExceptionHandler
public class MechanismService implements IMechanismService {
    private static final String MECHANISM_VARIABLE_COLLECTION_NAME = "mechanismVariable";
    private static final String MECHANISM_VARIABLE_ID_KEY_NAME = "variableId";
    private static final String MECHANISM_VARIABLE_VALUE_FIELD_NAME = "value";
    private static final String TENANT_ID_KEY_NAME = "tenantId";
    private static final String MECHANISM_VARIABLE_INDEX_NAME = "mechanismVariable";
    private static final String MECHANISM_TENANT_PARADIGM = "mechanismTenantParadigm";
    private static final String SYSTEM = "SYSTEM";


    @Autowired
    MechanismGraphService mechanismGraphService;

    @Autowired
    private MechanismRepository mechanismRepository;

    @Autowired
    AbstractionHandler abstractionHandler;

    @Autowired
    MechanismAchiveRecordRepository mechanismAchiveRecordRepository;

    @Autowired
    ComponentManager componentManager;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplate2;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired
    CompositeMechanismCustomer compositeMechanismCustomer;
    @Autowired
    OperationUnitService operationUnitService;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    TenantService tenantService;

    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    AppService appService;

    @Autowired
    MongoEntityBaseDAO mongoEntityBaseDAO;

    @Autowired
    ProductService productService;

    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    DataMapService dataMapService;
    @Autowired
    MechanismDesignService mechanismDesignService;
    @Autowired
    KgHelpService kgHelpService;
    @Autowired
    @Qualifier("baseExecutor")
    Executor executor;
    @Autowired
    AdvancedAssignDefinitionParser advancedAssignDefinitionParser;
    @Autowired
    private DataPickService dataPickService;

    @Autowired
    private IAMUtils iamUtils;

    @Override
    public Object getVariable(String variableName, String tenantId) throws DWBusinessException {
        log.info("enter getVariable");
        Map<String, Object> result = getStringObjectMap(variableName, tenantId, true);
        //  return DWServiceResultBuilder.build(true, result);
        return result;
    }

    @Override
    public Object postQueryVariable(VariableQueryVO queryData) throws DWBusinessException {
        String variableName = queryData.getVariableName();
        String tenantId = queryData.getTenantId();
        if (StringUtils.isEmpty(variableName) || StringUtils.isEmpty(tenantId)) {
            throw new DWBusinessException("P.KG.500.0033", I18nUtils.getValue("knowledgegraph.variableOrtenantEmpty"));
        }
        String eocLevel = queryData.getEocLevel();

        return getStringObjectMap(variableName, tenantId, true, this.transEocMap(queryData.getEocMap(), eocLevel));
    }

    private OperationUnit transEocMap(Map<String, Object> orgEocMap, String eocLevel) {
        OperationUnit operationUnit = new OperationUnit();
        if (orgEocMap == null) {
            return operationUnit;
        }
        Map operationUnitV2 = MapUtils.getMap(orgEocMap, "operation_unit_v2");
        if (operationUnitV2 != null && operationUnitV2.get("eoc_mapping_id")!= null) {
            OperationUnitV2 unitV2 = new OperationUnitV2();
            unitV2.setEoc_mapping_id(MapUtils.getString(operationUnitV2, "eoc_mapping_id"));
            operationUnit.setOperation_unit_v2(unitV2);
            return operationUnit;
        }
        if (StringUtils.isEmpty(eocLevel)) {
            return operationUnit;
        }
        if (StringUtils.equalsIgnoreCase(eocLevel, "company")) {
            String eocCompanyId = MapUtils.getString(orgEocMap, "eoc_company_id");
            if (StringUtils.isNotEmpty(eocCompanyId)) {
                operationUnit.setEoc_company_id(eocCompanyId);
            } else {
                operationUnit.setEoc_company_id(MapUtils.getString(orgEocMap, "eocCompanyId"));
            }
        } else if (StringUtils.equalsIgnoreCase(eocLevel, "site")) {
            String eocCompanyId = MapUtils.getString(orgEocMap, "eoc_company_id");
            if (StringUtils.isNotEmpty(eocCompanyId)) {
                operationUnit.setEoc_company_id(eocCompanyId);
            } else {
                operationUnit.setEoc_company_id(MapUtils.getString(orgEocMap, "eocCompanyId"));
            }
            String eocSiteId = MapUtils.getString(orgEocMap, "eoc_site_id");
            if (StringUtils.isNotEmpty(eocSiteId)) {
                operationUnit.setEoc_site_id(eocSiteId);
            } else {
                operationUnit.setEoc_site_id(MapUtils.getString(orgEocMap, "eocSiteId"));
            }

        } else if (StringUtils.equalsIgnoreCase(eocLevel, "region")) {
            String eocRegionId = MapUtils.getString(orgEocMap, "eoc_region_id");
            if (StringUtils.isNotEmpty(eocRegionId)) {
                operationUnit.setEoc_region_id(eocRegionId);
            } else {
                operationUnit.setEoc_region_id(MapUtils.getString(orgEocMap, "eocRegionId"));
            }
        } else {
            return operationUnit;
        }

        return operationUnit;
    }

    /**
     * 根据机制参数变量code获取数值，数值先取mechanismVariable值，没有取预设值VariableDefinition
     *
     * @param variableName 机制code
     * @param tenantId     租户
     * @param isGetDefault 是否取预设值
     * @param eocMap       eoc信息
     * @return
     * @throws DWBusinessException
     */
    private Map<String, Object> getStringObjectMap(String variableName, String tenantId, boolean isGetDefault, OperationUnit eocMap) throws DWBusinessException {
        Map<String, Object> result = new HashMap<String, Object>();
        //add by srj 6609需求，是否依赖地端根据用户是否设置产品的公司或域信息确认
        if (StringUtils.equals(variableName, "hasGroundEnd")) {
            Object hasGroundEnd = this.getHasGroundEnd();
            result.put(variableName, hasGroundEnd);
            result.put(TENANT_ID_KEY_NAME, tenantId);
            return result;
        }
        boolean missingTenantSet = true;
        Query query = new Query();
        query.fields().include(MECHANISM_VARIABLE_VALUE_FIELD_NAME);
        Criteria criteria = Criteria.where(MECHANISM_VARIABLE_ID_KEY_NAME).is(variableName).and(TENANT_ID_KEY_NAME).is(tenantId);
        Criteria criteria1 = this.operationUnitService.addOperationToCriteria(eocMap, criteria);
        query.addCriteria(criteria1);
        Map resultMap = this.mongoTemplate2.findOne(query, Map.class, MECHANISM_VARIABLE_COLLECTION_NAME);
        if (resultMap != null) {
            missingTenantSet = false;
            Object val = resultMap.get(MECHANISM_VARIABLE_VALUE_FIELD_NAME);
            if (isGetDefault) {//需要设默认值 则尝试获取variableDefition做比对
                val = getDefValue(val, variableName);
            }
            result.put(variableName, val);
            result.put(TENANT_ID_KEY_NAME, tenantId);
        } else {
            if (!isGetDefault) {
                return result;
            }

            //没有找到租户下的参数变量值 则使用预设值
            VariableDefinition def = getDefinition(variableName);
            if (def != null) {
                result.put(variableName, def.getDefaultValue());
                result.put(TENANT_ID_KEY_NAME, tenantId);
            }
        }
        result.put("missingTenantSet", missingTenantSet);
        return result;
    }

    /**
     * 根据机制变量code获取机制变量详情数据
     * @param variableName 机制变量code
     * @param tenantId     租户id
     * @param isGetDefault 是否获取默认值
     * @return
     * @throws DWBusinessException
     */
    private Map<String, Object> getStringObjectMap(String variableName, String tenantId, boolean isGetDefault) throws DWBusinessException {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty"));
        }
        Map<String, Object> result = new HashMap<String, Object>();
        //add by srj 6609需求，是否依赖地端根据用户是否设置产品的公司或域信息确认
        if (StringUtils.equals(variableName, "hasGroundEnd")) {
            Object hasGroundEnd = this.getHasGroundEnd();
            result.put(variableName, hasGroundEnd);
            result.put(TENANT_ID_KEY_NAME, tenantId);
            return result;
        }
        MongoCollection<Document> col = this.mongoTemplate2.getCollection(MECHANISM_VARIABLE_COLLECTION_NAME);
        //改为使用公用mongodb
        Document doc = col.find(and(eq(MECHANISM_VARIABLE_ID_KEY_NAME, variableName), eq(TENANT_ID_KEY_NAME,
                tenantId))).first();

        if (doc != null) {
            Object val = doc.get(MECHANISM_VARIABLE_VALUE_FIELD_NAME);
            if (isGetDefault) {//需要设默认值 则尝试获取variableDefition做比对
                val = getDefValue(val, variableName);
            }
            result.put(variableName, val);
            result.put(TENANT_ID_KEY_NAME, doc.get("tenantId"));
        } else {
            if (!isGetDefault) {
                return result;
            }
            //没有找到租户下的参数变量值 则使用预设值
            VariableDefinition def = getDefinition(variableName);
            if (def != null) {
                result.put(variableName, def.getDefaultValue());
                result.put(TENANT_ID_KEY_NAME, tenantId);
            }
        }
        return result;
    }

    private Object getDefValue(Object val, String variableName) throws DWBusinessException {
        //存值为List的情况下处理
        if (val instanceof List) {
            //获取 key
            String key = null;
            String valKey = null;
            VariableDefinition def = getDefinition(variableName);
            if (def != null) {
                if (StringUtils.equals(def.getDisplayType(), "TABLE") && def.getDisplayTypeDefinition() != null && def.getDisplayTypeDefinition() instanceof Map) {
                    Map typeDef = (Map) def.getDisplayTypeDefinition();
                    //仅处理 TABLE 且为 radioboxgroup 的参数
                    if (typeDef.get("category").equals("radioboxgroup") && typeDef.get("columns") instanceof List) {
                        List cols = (List) typeDef.get("columns");
                        if (!CollectionUtils.isEmpty(cols) && cols.get(0) instanceof Map) {
                            Map col = (Map) cols.get(0);
                            key = (String) col.get("key");
                            List exts = (List) col.get("extends");
                            if (!CollectionUtils.isEmpty(exts) && exts.get(0) instanceof Map) {
                                Map ext = (Map) exts.get(0);
                                valKey = (String) ext.get("key");
                            }
                        }
                    }
                }

                if (StringUtils.isEmpty(key) || StringUtils.isEmpty(valKey)) {
                    return val;
                }

                if (def.getDefaultValue() != null && def.getDefaultValue() instanceof List) {
                    List<Map> defValList = (List<Map>) def.getDefaultValue();
                    List<Map> valList = (List<Map>) val;
                    for (Map defVal : defValList) {
                        boolean exist = false;
                        for (Map v : valList) {
                            if (defVal.get(key).equals(v.get(key))) {
                                exist = true;
                                break;
                            }
                        }
                        if (!exist) {//在已存的值里没有找到的默认值 添加到返回值中
                            Map d = new HashMap();
                            d.put(key, defVal.get(key));
                            d.put(valKey, defVal.get(valKey));
                            valList.add(d);
                        }
                    }
                }
            }
        }
        return val;
    }

    private VariableDefinition getDefinition(String variableName) throws DWBusinessException {
        return dataPickService.findByCode(variableName, VariableDefinition.class, "variableDefinition");
    }

    @Override
    public Object postVariableList(VariableBean map) throws Exception {
        List<VariableVo> list = map.getVariableVoList();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = tenantService.getTenantVersion(tenantId);
        //String tenantId = "athenaPaasW";
        for (VariableVo variableVo : list) {
            Map variableMap = getStringObjectMap(variableVo.getVariableId(), tenantId, map.isNeedGetDefault(), map.getEocMap());
            Object value = variableMap.get(variableVo.getVariableId());
            List<GlobalMessagePageTypeVO> globalMessagePageTypeVOS = new ArrayList<>();
            HashMap<String, Object> resVo = new HashMap<>();
            if (variableVo.getVariableId().equals("globalMessagePageType")) {
                Criteria criteria = Criteria.where("code").is(variableVo.getVariableId());
                //系统级的报表定义存储 数据从tbb来
                VariableDefinition vo = dataPickService.findOneByCondition(criteria, VariableDefinition.class, "variableDefinition");
                if (vo == null) {
                    throw new DWException("P.KG.500.0034", I18nUtils.getValue("knowledgegraph.globalMessagePageTypeMiss"));
                }
                Map defaultValue = (Map) vo.getDefaultValue();
                globalMessagePageTypeVOS = JSON.parseArray(JSONUtils.toJSONString(defaultValue.get("dataList")),
                        GlobalMessagePageTypeVO.class);
                globalMessagePageTypeVOS.sort(Comparator.comparing(GlobalMessagePageTypeVO::getSequence));
                resVo.put("dataList", globalMessagePageTypeVOS);
                if (value instanceof Map) {
                    Map value1 = (Map) value;
                    resVo.put("chooseList", value1.get("chooseList"));
                }
                value = resVo;
            }
            String category = variableVo.getCategory() == null ? "" : variableVo.getCategory();
            switch (category) {
                case "global-table"://此表格类型需要取typeCode   此分支已废弃(已通知小ai)
                    Object o = loopValue(value, variableVo.getFieldNameList());
                    variableVo.setResult(o);
                    break;
                case "reportList":
                    handleReportRes(resVo, globalMessagePageTypeVOS, variableVo);
                    break;
                default://默认类型直接给value:
                    variableVo.setResult(value);
            }
        }
        return list;
    }

    @Override
    public Object postVariableListSimple(VariableBean map) throws Exception {
        Map<String, Object> result = new HashMap<>();
        if (CollectionUtils.isEmpty(map.getVariableIds())) {
            return result;
        }
        String tenantId = AthenaUtils.getTenantId();
        for (String vid : map.getVariableIds()) {
            Map variableMap = getStringObjectMap(vid, tenantId, true, map.getEocMap());
            Object value = variableMap.get(vid);
            result.put(vid, value);
        }

        return result;
    }

    /**
     * 查询到的变量转换为经管面板报表需要的结构
     */
    private void handleReportRes(HashMap<String, Object> res, List<GlobalMessagePageTypeVO> globalMessagePageTypeVOS,
                                 VariableVo vo) {
        if (!res.containsKey("chooseList") || ObjectUtils.isEmpty(res.get("chooseList"))) {
            //没租户级的时候没有默认选择的报表
            vo.setResult(null);
            return;
        }
        if (ObjectUtils.isEmpty(globalMessagePageTypeVOS)) {
            vo.setResult(I18nUtils.getValue("knowledgegraph.typeNotSupport"));
        }
        List<String> strings = JSON.parseArray(JSONUtils.toJSONString(res.get("chooseList")), String.class);
        List<GlobalMessagePageTypeVO> collect =
                globalMessagePageTypeVOS.stream().filter(v -> strings.contains(v.getChartId())).collect(Collectors.toList());
        vo.setResult(collect);
    }

    private <T> Map loopValue(T obj, List<String> fieldNameList) {
        if (CollectionUtils.isEmpty(fieldNameList) || obj == null) {
            return null;
        }
        Map res;
        if (obj instanceof List) {
            for (Object vo : ((List<?>) obj)) {
                res = loopValue(vo, fieldNameList);
                if (res != null && !res.isEmpty()) {
                    return res;
                }
            }
        }
        if (obj instanceof Map) {
            Map<String, Object> resMap = new HashMap<>();
            for (String fieldName : fieldNameList) {
                for (Map.Entry<Object, Object> entry : ((Map<Object, Object>) obj).entrySet()) {
                    if (entry.getKey() instanceof String && entry.getKey().equals(fieldName)) {
                        if (!resMap.containsKey(fieldName)) {
                            resMap.put(fieldName, entry.getValue());
                        }
                        break;
                    }
                    res = loopValue(entry.getValue(), Collections.singletonList(fieldName));
                    if (null != res && !res.isEmpty() && !resMap.containsKey(fieldName)) {
                        resMap.put(fieldName, res.get(fieldName));
                        break;
                    }
                }
            }
            return resMap;
        }
        return null;
    }

    @Override
    public Object putVariable(String variableName, String tenantId, Object value) throws Exception {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty"));
        }
        Document doc = new Document();
        doc.append(MECHANISM_VARIABLE_ID_KEY_NAME, variableName);
        doc.append(TENANT_ID_KEY_NAME, tenantId);
        doc.append("value", value);

        try {
            MongoCollection<Document> col = getVariableCollection();
            col.insertOne(doc);
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }

        //  return DWServiceResultBuilder.build(true, null);
        return null;
    }

    @Override
    public Object postVariable(String variableName, String tenantId, Object value) throws Exception {
        return this.postVariable(variableName, tenantId, null, value);
    }

    @Override
    public Object postVariable(String variableName, String tenantId, OperationUnit operationUnit, Object value) throws Exception {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty"));
        }

        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(tenantId).and("variableId").is(variableName);
        if (operationUnit != null && !operationUnit.isEmpty()) {
            criteria1 = operationUnit.addOperationToCriteria(criteria1);
        }
        query.addCriteria(criteria1);
        Update update = new Update();
        update.set("value", value);
        try {
            mongoTemplate2.upsert(query, update, MechanismTenantVariable.class);
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }

        // return DWServiceResultBuilder.build(true, null);
        return null;
    }

    /**
     * 获取流程变量参数值
     *
     * @param variableCode code码
     * @param tenantId     租户信息
     * @return
     */
    @Override
    public Object postSelectVariable(String variableCode, String tenantId) {
        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(tenantId).and("variableId").is(variableCode);
        query.addCriteria(criteria1);
        MechanismTenantVariable variable = mongoTemplate2.findOne(query, MechanismTenantVariable.class);
        if (null == variable) {
            new DWBusinessException("P.KG.500.0001", I18nUtils.getValue("knowledgegraph.selectVariable is null"));
            return null;
        }
        return variable.getValue();
    }

    //获取机制的详细数据
    @Override
    public Object postMechanism(String key, String tenantId, String product) throws DWBusinessException {

        MechanismOld me = getDetail(tenantId, key);
        Dimension d = new Dimension();
        d.setProduct(product);
        d.setTenant(tenantId);
        abstractionHandler.dealWithAbstraction(me, d);

        return me;
    }

    //获取机制各项配置数据(平铺)
    @Override
    public Object postMechanismMaterialConfig(String key, String tenantId, String product) throws DWBusinessException {

        MechanismOld me = getDetail(tenantId, key);
        Dimension d = new Dimension();
        d.setProduct(product);
        d.setTenant(tenantId);
        abstractionHandler.dealWithAbstraction(me, d);
        Map<String, Object> data = new HashMap<>();
        if (null != me.getClassifications()) {
            me.getClassifications().forEach(classfy -> {
                data.put(classfy.getKey(), classfy.getCondition());
                if (null != classfy.getConditions()) {
                    classfy.getConditions().forEach(cond -> {
                        data.put(cond.getKey(), cond.getCondition());
                    });
                }
            });
        }
        if (null != me.getScenes()) {
            me.getScenes().forEach(sce -> {

                if (null != sce.getSuggests()) {
                    sce.getSuggests().forEach(sug -> {
                        data.put(sug.getKey(), sug.getValue());

                    });
                }
            });
        }
        if (null != me.getDataAction()) {
            me.getDataAction().forEach(action -> {
                if (null != action.getParams()) {
                    action.getParams().forEach(param -> {
                        data.put(param.getKey(), param.getValue());
                    });
                }
            });
        }

        if (null != me.getTaskConfigs()) {
            me.getTaskConfigs().forEach(task -> {
                data.put(task.getKey(), task.getCondition());
            });
        }
//            MechanismContext context = new MechanismContext();
//            context.setMechanismKey(key);
//            context.setMechanism(me);
//            context.setAttach(data);
//            compositeMechanismCustomer.innerDoMechanismMaterialConfig(context);


        return data;
    }


    @Override
    public MechanismAchiveRecord findOne(String instanceId) {
        List<MechanismAchiveRecord> records = mechanismAchiveRecordRepository.findByInstanceId(instanceId);
        if (records.size() == 1) {
            return records.get(0);
        } else if (records.size() > 0) {
            Collections.sort(records);
            MechanismAchiveRecord r = records.get(0);
            for (int i = 1; i < records.size(); i++) {
                mongoTemplate2.remove(Query.query(Criteria.where("instanceId").is(instanceId).and("updateTime").is(records.get(i).getUpdateTime())), MechanismAchiveRecord.class);
            }
            mongoTemplate2.remove(Query.query(Criteria.where("instanceId").is(instanceId).and("updateTime").ne(r.getUpdateTime())), MechanismItemRecord.class);
            return r;
        }
        return null;
    }

    //保持机制流程中产出的数据
    @Override
    public Object postMechanismRecordSave(MechanismAchiveRecord param) throws DWBusinessException {
        MechanismAchiveRecord record = findOne(param.getInstanceId());
        if (record != null) {
            record.setBatchAll(param.getBatchAll());
            if (null != param.getStatus()) {
                record.setStatus(param.getStatus());
                if (record.getStatus() == 3) {
                    record.setRecordStatus(2);
                }
            }
            if (null != param.getRemark()) {
                record.setRemark(param.getRemark());
            }
            if (null != param.getValue()) {
                record.setValue(param.getValue());
            }

            saveRecord(record);

            //判断是否审核通过
            if (null != param.getStatus() && param.getStatus() == 3) {
                MechanismContext context = new MechanismContext();
                context.setMechanismKey(param.getMechanismKey());
                context.setKey(param.getKey());
                context.setTenant(param.getTenantId());
                context.setRecord(record);
                Object obj = compositeMechanismCustomer.notifyApproveSuccess(context);
                if (null != obj) {
                    return obj;
                }
            }

        } else {
            param.setCreateTime(new Date());
            saveRecord(param);
        }


        return null;
    }


    //获取机制流程中产出的数据
    @Override
    public Object postMechanismRecordGet(String instanceId) {

        MechanismAchiveRecord record = findOne(instanceId);
        if (null != record && Boolean.TRUE.equals(record.getValueIsArray())) {
            Query query = Query.query(Criteria.where("instanceId").is(instanceId));
            List<MechanismItemRecord> items = mongoTemplate2.find(query, MechanismItemRecord.class);
            if (items != null) {
                List<Object> list = new ArrayList<>();
                for (MechanismItemRecord r : items) {
                    list.add(r.getValue());

                }
                record.setValue(list);
            }
        }

        return record;
    }

    @Override
    public Object postNotifyChange(MechanismContext data) throws DWBusinessException {

        Object result = compositeMechanismCustomer.notifyChange(data);
        return result;
    }

    @Override
    public Object postMechanismWithContext(MechanismContext data) throws DWBusinessException {
        if (null == data.getMechanismKey() || null == data.getInstanceId()) {
            throw new IllegalArgumentException(I18nUtils.getValue("knowledgegraph.mechanismKeyOrInstanceIdEmpty"));
        }
        Object result = null;
        MechanismOld me = getDetail(data.getTenant(), data.getMechanismKey());
        abstractionHandler.dealWithAbstraction(me, data);
        MechanismAchiveRecord record = findOne(data.getInstanceId());
        Map<String, Object> map = new HashMap<>();
        map.put("mechanism", me);
        map.put("record", record);
        data.setAttach(map);

        Object processed = compositeMechanismCustomer.filter(data);
        if (null != processed) {
            result = processed;
        } else {
            result = map;
        }

        return result;
    }

    @Override
    public Object postReadMechanismMaterialConfig(String mechanismCode, String tenantId) throws DWBusinessException {
        AbsEntityDict dic = this.getAbsEntityDict(mechanismCode, tenantId);
        List<Variable> variables = new ArrayList<>();
        if (dic != null) {
            if (dic.getAbstraction().getParams() != null) {
                for (Variable v : dic.getAbstraction().getParams()) {
                    if (v.getSourceType() != null && v.getSourceType().equals("1")) {//sourceType为1常量
                        variables.add(v);
                    }
                }
            }
        }

        return variables;
    }

    @Override
    public Object postReadMechanismMaterialConfig(String mechanismCode, String tenantId, OperationUnit operationUnit) throws DWBusinessException {
        AbsEntityDict dic = this.getAbsEntityDict(mechanismCode, tenantId, operationUnit);
        List<Variable> variables = new ArrayList<>();
        if (dic != null) {
            if (dic.getAbstraction().getParams() != null) {
                for (Variable v : dic.getAbstraction().getParams()) {
                    if (v.getSourceType() != null && v.getSourceType().equals("1")) {//sourceType为1常量
                        variables.add(v);
                    }
                }
            }
        }

        return variables;
    }

    @Override
    public Object postSaveMechanismMaterialConfig(String mechanismCode, String tenantId, Map<String, Object> variables) throws DWBusinessException {
        if (variables == null || variables.isEmpty()) {
            throw new DWArgumentException("variables", I18nUtils.getValue("knowledgegraph.variablesEmpty"));
        }
        AbsEntityDict dic = this.getAbsEntityDict(mechanismCode, tenantId);
        if (dic.getAbstraction().getParams() != null) {
            for (Variable v : dic.getAbstraction().getParams()) {
                if (variables.containsKey(v.getKey())) {
                    v.setValue(variables.get(v.getKey()));
                }
            }
        }
        this.mongoTemplate2.save(dic);

        return null;
    }

    @Override
    public Object postSaveMechanismMaterialConfig(String mechanismCode, String tenantId, Map<String, Object> variables, OperationUnit operationUnit) throws DWBusinessException {
        if (variables == null || variables.isEmpty()) {
            throw new DWArgumentException("variables", I18nUtils.getValue("knowledgegraph.variablesEmpty"));
        }
        AbsEntityDict dic = this.getAbsEntityDict(mechanismCode, tenantId, operationUnit);
        if (dic.getAbstraction().getParams() != null) {
            for (Variable v : dic.getAbstraction().getParams()) {
                if (variables.containsKey(v.getKey())) {
                    v.setValue(variables.get(v.getKey()));
                }
            }
        }
        this.mongoTemplate2.save(dic);

        return null;
    }

    private AbsEntityDict getAbsEntityDict(String mechanismCode, String tenantId) {
        Query query = new Query();
        Criteria c1 = Criteria.where("tenant").is(tenantId);
        Criteria c2 = Criteria.where("category").is("MechanismAction");
        Criteria c3 = Criteria.where("status").is(1);
        Criteria c4 = Criteria.where("abstraction.mechanismKey").is(mechanismCode);
        Criteria c5 = Criteria.where("operationUnit").is(null);
        query.addCriteria(new Criteria().andOperator(c1, c2, c3, c4, c5));

        return this.mongoTemplate2.findOne(query, AbsEntityDict.class);
    }

    private AbsEntityDict getAbsEntityDict(String mechanismCode, String tenantId, OperationUnit operationUnit) {
        Query query = new Query();
        Criteria c1 = Criteria.where("tenant").is(tenantId);
        Criteria c2 = Criteria.where("category").is("MechanismAction");
        Criteria c3 = Criteria.where("status").is(1);
        Criteria c4 = Criteria.where("abstraction.mechanismKey").is(mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria(new Criteria().andOperator(c1, c2, c3, c4));

        return this.mongoTemplate2.findOne(query, AbsEntityDict.class);
    }

    private MongoCollection<Document> getVariableCollection() throws DWBusinessException {
        return this.mongoTemplate2.getCollection(MECHANISM_VARIABLE_COLLECTION_NAME);//改为使用公用mongodb
    }

    @Override
    public MechanismScene getScene(MechanismOld mechanism, String[] keys) {

        if (null != mechanism && null != mechanism.getScenes() && null != keys) {
            Arrays.sort(keys);
            for (MechanismScene s : mechanism.getScenes()) {
                if (null != s.getKeys()) {
                    Collections.sort(s.getKeys());
                    if (Arrays.equals(keys, s.getKeys().toArray())) {
                        return s;
                    }
                }

            }
        }

        return null;
    }

    @Override
    public MechanismOld getDetail(String tenantId, String key) throws DWBusinessException {
        Session session = sessionFactory.openSession();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        MechanismOld me = mechanismRepository.findMechanism(tenantId, key, tenantVersion);
        Assert.notNull(me, "cant find MechanismOld by tenantId:" + tenantId + " and key:" + key);
        me = session.load(MechanismOld.class, me.getNeo4jId(), -1);
        Assert.notNull(me, "can`t find MechanismOld by tenantId:" + tenantId + " and version:" + me.getVersion());
        return me;
    }


    private void saveRecord(MechanismAchiveRecord param) {

        long time = System.currentTimeMillis();

        if (param.getValue() instanceof List) {
            List<Map<String, Object>> value = (List<Map<String, Object>>) param.getValue();
            param.setValue(null);
            param.setValueIsArray(true);
            if (Boolean.TRUE.equals(param.getBatchAll())) {
                mongoTemplate2.remove(Query.query(Criteria.where("instanceId").is(param.getInstanceId())), MechanismItemRecord.class);
                List<MechanismItemRecord> records = new ArrayList<>();
                for (Map<String, Object> item : value) {
                    MechanismItemRecord record = new MechanismItemRecord();
                    record.setInstanceId(param.getInstanceId());
                    record.setUpdateTime(time);
                    record.setValue(item);
                    records.add(record);
                }
                mongoTemplate2.insert(records, MechanismItemRecord.class);
            } else {
                for (Map<String, Object> item : value) {
                    if (null != param.getValueKeys()) {
                        Query query = new Query();
                        query.addCriteria(Criteria.where("instanceId").is(param.getInstanceId()));
                        boolean hasValue = false;
                        for (String key : param.getValueKeys()) {
                            Object v = item.get(key);
                            if (null != v) {
                                query.addCriteria(Criteria.where("value." + key).is(v));
                                hasValue = true;
                            }
                        }
                        if (!hasValue) {
                            continue;//说明该条数据有问题,丢弃掉
                        }
                        Document doc = new Document();
                        doc.put("instanceId", param.getInstanceId());
                        doc.put("updateTime", time);
                        doc.put("value", item);
                        mongoTemplate2.remove(query, MechanismItemRecord.class);
                        MechanismItemRecord record = new MechanismItemRecord();
                        record.setInstanceId(param.getInstanceId());
                        record.setValue(item);
                        record.setUpdateTime(time);
                        mongoTemplate2.save(record);
                    } else {
                        MechanismItemRecord record = new MechanismItemRecord();
                        record.setInstanceId(param.getInstanceId());
                        record.setValue(item);
                        record.setUpdateTime(time);
                        mongoTemplate2.save(record);
                    }
                }
            }

        }

        if (null != param.getId() && param.getUpdateTime() > 0) {
            Query query = new Query();
            query.addCriteria(Criteria.where("instanceId").is(param.getInstanceId()).and("updateTime").is(param.getUpdateTime()));
            mongoTemplate2.updateMulti(query, Update.update("updateTime", time), MechanismItemRecord.class);
        }


        param.setUpdateTime(time);
        mongoTemplate2.save(param);
     //   mechanismAchiveRecordRepository.save(param);


    }

    @Override
    public Object deleteVariable(String variableName, String tenantId) throws Exception {
        if (variableName == null || variableName.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty"));
        }
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWArgumentException("tenantId", I18nUtils.getValue("knowledgegraph.tenantIdEmpty"));
        }

        Query query = new Query();
        Criteria criteria1 = Criteria.where("tenantId").is(tenantId);
        Criteria criteria2 = Criteria.where("variableId").is(variableName);
        query.addCriteria(new Criteria().andOperator(criteria1, criteria2));
        try {
            mongoTemplate2.remove(query, MechanismTenantVariable.class);
        } catch (Exception e) {
            throw new DWBusinessException(e.getLocalizedMessage());
        }

        // return DWServiceResultBuilder.build(true, null);
        return null;
    }

    @Override
    public Object postSaveMechanismExecuteParam(String mechanismCode, Map<String, Object> parameters) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        Query query = new Query();
//        Criteria c1 = Criteria.where("tenantId").is(tenantId).and("mechanismCode").is(mechanismCode);
//        query.addCriteria(c1);
//
//        Update update = new Update();
//        update.addToSet("params", parameters);
//
//        this.mongoTemplate2.upsert(query, update, "mechanismExecuteParams");
//        return null;
        this.postSaveMechanismExecuteParam(mechanismCode, parameters, new OperationUnit());
        return null;
    }

    @Override
    public Object postSaveMechanismExecuteParam(String mechanismCode, Map<String, Object> parameters, OperationUnit operationUnit) throws DWBusinessException {
        if (CollectionUtils.isEmpty(parameters)) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        Criteria c1 = Criteria.where("tenantId").is(tenantId).and("mechanismCode").is(mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria(c1);

        Set<Map.Entry<String, Object>> entries = parameters.entrySet();
        Update update = new Update();
        update.set("params", Arrays.asList(parameters));
//        for(Map.Entry<String, Object> entry :entries){
//            update.set("params.$." + entry.getKey(), entry.getValue());
//        }


        this.mongoTemplate2.upsert(query, update, "mechanismExecuteParams");
        return null;
    }

    @Override
    public Object postReadMechanismExecuteParam(String mechanismCode) throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        Query query = new Query();
//        Criteria c1 = Criteria.where("tenantId").is(tenantId).and("mechanismCode").is(mechanismCode);
//        query.addCriteria(c1);
//
//        Map mechanismExecuteParams = this.mongoTemplate2.findOne(query, Map.class, "mechanismExecuteParams");
//        if(mechanismExecuteParams == null){
//            return null;
//        }else{
//            return mechanismExecuteParams.get("params");
//        }

        return this.postReadMechanismExecuteParam(mechanismCode, new OperationUnit());
    }

    @Override
    public Object postReadMechanismExecuteParam(String mechanismCode, OperationUnit operationUnit) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        Criteria c1 = Criteria.where("tenantId").is(tenantId).and("mechanismCode").is(mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria(c1);
        Map mechanismExecuteParams = this.mongoTemplate2.findOne(query, Map.class, "mechanismExecuteParams");
        if (mechanismExecuteParams == null) {
            return null;
        } else {
            return mechanismExecuteParams.get("params");
        }

    }

    @Override
    public Object postCopyMechanismExecuteParam(String mechanismCode, OperationUnit sourceOperationUnit, OperationUnit operationUnit, List<String> monitorRuleIds) throws DWBusinessException {
        //复制机制下的侦测
        List<MonitorRuleTenantConfig> sourceMonitoerList = null;
        if (!CollectionUtils.isEmpty(monitorRuleIds)) {
            Query query = new Query();
            Criteria criteria = Criteria.where("tenantId").is(AthenaUtils.getTenantId()).and("monitorRuleId").in(monitorRuleIds);
            criteria = this.operationUnitService.addEocMapToCriteria(sourceOperationUnit, criteria);
            query.addCriteria(criteria);
            sourceMonitoerList = this.mongoTemplate2.find(query, MonitorRuleTenantConfig.class);
        }
        if (!CollectionUtils.isEmpty(sourceMonitoerList)) {
            for (MonitorRuleTenantConfig tenantConfig : sourceMonitoerList) {
                MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
                config.setStatus(tenantConfig.getStatus());
                config.setTenantId(tenantConfig.getTenantId());
                config.setEocMap(this.operationUnitService.transToEocMapDTO(operationUnit));
                config.setMonitorRuleId(tenantConfig.getMonitorRuleId());
                config.setProductName(tenantConfig.getProductName());
                config.setStandardPollingRule(JSON.parseObject(JSON.toJSONString(tenantConfig.getStandardPollingRule()), TriggerDTO.class));

                try {
                    this.monitorRuleConfigService.post(config);
                } catch (Exception e) {
                    log.error(e.toString());
                }

            }
        }

        //复制机制下的参数
        Object o = this.postReadMechanismExecuteParam(mechanismCode, sourceOperationUnit);
        if (!ObjectUtils.isEmpty(o)) {
            Map map = JSON.parseObject(JSON.toJSONString(o), Map.class);
            this.postSaveMechanismExecuteParam(mechanismCode, map, operationUnit);
        }

        Object o1 = this.postReadMechanismMaterialConfig(mechanismCode, AthenaUtils.getTenantId(), sourceOperationUnit);
        if (!ObjectUtils.isEmpty(o1)) {
            Map map = JSON.parseObject(JSON.toJSONString(o1), Map.class);
            this.postSaveMechanismMaterialConfig(mechanismCode, AthenaUtils.getTenantId(), map, operationUnit);
        }

        return null;
    }

    @Override
    public Object postCopyMechanismParam(String appCode, List<String> mechanismCodes, OperationUnit operationUnit,
                                         String tenantId,
                                         String copyTenantId) throws DWBusinessException {
        //mechanism
        for (String mechanismCode : mechanismCodes) {
            copyMechanism(mechanismCode, operationUnit, tenantId, copyTenantId);
            //mechanismExecuteParams
            copyMechanismExecuteParams(mechanismCode, operationUnit, tenantId, copyTenantId);
        }
        //mechanismTenantParadigm
        //copyMechanismTenantParadigm(appCode, operationUnit, tenantId, copyTenantId);
        return null;
    }

    private void copyMechanismTenantParadigm(String appCode, OperationUnit operationUnit, String tenantId, String copyTenantId) {
        Query query = new Query();
        Criteria c1 = Criteria.where("tenantId").is(tenantId).and("code").is(appCode);
        query.addCriteria(c1);
        Map mechanismMap = this.mongoTemplate2.findOne(query, Map.class, "mechanismTenantParadigm");
        if (mechanismMap != null) {
            Query query2 = new Query();
            Criteria c2 = Criteria.where("tenantId").is(copyTenantId).and("code").is(appCode);
            query2.addCriteria(c2);
            Update update = new Update();
            mechanismMap.remove("_id");
            mechanismMap.forEach((key, value) -> update.set((String) key, value));
            mongoTemplate2.upsert(query2, update, "mechanismTenantParadigm");
        }
    }

    private void copyMechanism(String mechanismCode, OperationUnit operationUnit, String tenantId, String copyTenantId) {
        Query query = new Query();
        Criteria c1 = Criteria.where("tenantId").is(tenantId).and("code").is(mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria(c1);
        Map mechanismMap = this.mongoTemplate2.findOne(query, Map.class, "mechanism");
        if (mechanismMap != null) {
            Query query2 = new Query();
            Criteria c2 = Criteria.where("tenantId").is(copyTenantId).and("code").is(mechanismCode);
            c2 = this.operationUnitService.addOperationToCriteria(operationUnit, c2);
            query2.addCriteria(c2);
            Update update = new Update();
            mechanismMap.remove("_id");
            mechanismMap.forEach((key, value) -> update.set((String) key, value));
            mongoTemplate2.upsert(query2, update, "mechanism");
        }
    }

    private void copyMechanismExecuteParams(String mechanismCode, OperationUnit operationUnit, String tenantId, String copyTenantId) {
        Query query = new Query();
        Criteria c1 = Criteria.where("tenantId").is(tenantId).and("mechanismCode").is(mechanismCode);
        c1 = this.operationUnitService.addOperationToCriteria(operationUnit, c1);
        query.addCriteria(c1);
        Map mechanismMap = this.mongoTemplate2.findOne(query, Map.class, "mechanismExecuteParams");
        if (mechanismMap != null) {
            Query query2 = new Query();
            Criteria c2 = Criteria.where("tenantId").is(copyTenantId).and("code").is(mechanismCode);
            c2 = this.operationUnitService.addOperationToCriteria(operationUnit, c2);
            query2.addCriteria(c2);
            Update update = new Update();
            mechanismMap.remove("_id");
            mechanismMap.forEach((key, value) -> update.set((String) key, value));
            mongoTemplate2.upsert(query2, update, "mechanismExecuteParams");
        }
    }

    @Override
    public Object postTimeIntervalCode() throws DWBusinessException {
        return this.postTimeIntervalCode("TraceMaterialMechanism");
    }

    @Override
    public Object postTimeIntervalCode(String mechanismCode) throws DWBusinessException {
        Object obj = this.postReadMechanismExecuteParam(mechanismCode);
        if (ObjectUtils.isEmpty(obj)) {
            return new TraceMaterialIntervalVO();
        }
//        TraceMaterialIntervalVO traceMaterialIntervalVO = JSON.parseObject(JSON.toJSONString(obj), TraceMaterialIntervalVO.class);
        JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(obj));
        if (jsonArray == null || jsonArray.size() == 0) {
            return new ArrayList<>();
        }
        for (int i = 0; i < jsonArray.size(); i++) {

            JSONObject jsonObject1 = jsonArray.getJSONObject(i);
            if (!ObjectUtils.isEmpty(jsonObject1.get("traceMaterialInterval"))) {
                TraceMaterialIntervalVO traceMaterialIntervalVO = JSON.parseObject(JSON.toJSONString(jsonObject1), TraceMaterialIntervalVO.class);
                return traceMaterialIntervalVO;
            }
        }

        return new ArrayList<>();
    }

    @Override
    public Object getTimeIntervalDetailByCode(String code) throws DWBusinessException {
        Object obj = this.postReadMechanismExecuteParam("TraceMaterialMechanism");
        if (ObjectUtils.isEmpty(obj)) {
            return null;
        }
        JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(obj));
        if (jsonArray == null || jsonArray.size() == 0) {
            return null;
        }
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject1 = jsonArray.getJSONObject(i);
            if (!ObjectUtils.isEmpty(jsonObject1.get("traceMaterialInterval"))) {
                JSONArray jsonArray1 = JSONArray.parseArray(JSON.toJSONString(jsonObject1.get("traceMaterialInterval")));
                for (int j = 0; j < jsonArray1.size(); j++) {
                    JSONObject jsonObject = jsonArray1.getJSONObject(j);
                    if (StringUtils.equalsIgnoreCase(jsonObject.getString("timeIntervalCode"), code)) {
                        return jsonObject.getString("detail");
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Object getMechanismExecuteTableParam(String code, String key, String column) throws DWBusinessException {
        Map<String, Object> result = new HashMap<>();
        Object obj = this.postReadMechanismExecuteParam(code);
        if (ObjectUtils.isEmpty(obj)) {
            return result;
        }
        JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(obj));
        if (jsonArray == null || jsonArray.size() == 0) {
            return result;
        }

        List<Map> resultList = new ArrayList<>();
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject1 = jsonArray.getJSONObject(i);
            if (!ObjectUtils.isEmpty(jsonObject1.get(key))) {
                JSONArray jsonArray1 = JSON.parseArray(JSON.toJSONString(jsonObject1.get(key)));
                for (int j = 0; j < jsonArray1.size(); j++) {
                    Map<String, String> map = new HashMap<>();
                    String o = jsonArray1.getJSONObject(j).getString(column);
                    map.put(column, o);
                    resultList.add(map);
                }
            }
        }
        result.put(key, resultList);
        return result;
    }

    @Override
    public Object getVariableTableParam(String variableName, String tenantId, String keyColumn, String key, String valueColumn) throws DWBusinessException {
        Object re = null;
        Map<String, Object> map = (Map<String, Object>) this.getVariable(variableName, tenantId);
        if (map != null && !map.isEmpty()) {
            JSONArray jsonArray = JSON.parseArray(JSON.toJSONString(map.get(variableName)));
            if (jsonArray == null || jsonArray.size() == 0) {
                return re;
            }

            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject obj = jsonArray.getJSONObject(i);
                if (StringUtils.equals((String) obj.get(keyColumn), key)) {
                    re = obj.get(valueColumn);
                    break;
                }
            }
        }
        return re;
    }

    @Override
    public Object postQueryMechanismByCode(String code, OperationUnit operationUnit) throws DWBusinessException {
        return postQueryMechanismByCode(code, operationUnit, false);
    }

    @Override
    public Object postQueryMechanismByCode(String code, OperationUnit operationUnit, Boolean queryWithEocLevel) throws DWBusinessException {

        log.info("Route==>MechanismService  method=postQueryMechanismByCode code:{},ThreadId:{}", code, Thread.currentThread().getId());
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria;
        if (queryWithEocLevel) {
            String eocLevel = operationUnitService.getEocLevel(operationUnit);
            criteria = Criteria.where("code").is(code).and("eocLevel").is(eocLevel).and("version").is(tenantVersion);
        } else {
            criteria = Criteria.where("code").is(code).and("version").is(tenantVersion);
        }

        query.addCriteria(criteria);

        Mechanism mechanism = dataPickService.findOneByCondition(criteria, Mechanism.class, "mechanism");
        if (mechanism == null) { //当找不到系统级的配置时，直接返回null
            log.info("Route==>MechanismService  method=postQueryMechanismByCode tenantVersion:{}", tenantVersion);
            return null;
        }

        // 查询租户级机制数据
        Mechanism tenantMechanism = this.getTenantMechanism(tenantId, code, operationUnit);
//
//        //设置mechanismRelation中定义的侦测
//        processMonitorRule(mechanism);
//        //设置mechanismRelation中定义的参数
//        processVariable(mechanism);
        //从系统级机制组件表中获取组件数据，并根据组件类型补充机制原理，机制原理详情和机制变量参数数据
        MechanismMergeVO mechanismMergeVO = setMechanismPrinciple(mechanism, tenantMechanism == null ? null : tenantMechanism.getMergeVersion());

        if (tenantMechanism != null) { //当有租户级的配置
//            mechanism.setPrinciples(tenantMechanism.getPrinciples());
            //将系统级和租户级的机制数据进行合并，主要是处理机制原理和参数
            this.mergeMechanismPrinciple(mechanism, tenantMechanism, mechanismMergeVO);
        }
        //合并机制设计，将开发平台和交付设计器设置的机制能力做合并
        mechanism.setMergeVersion(mechanismMergeVO == null ? null : mechanismMergeVO.getCurrentHighestMergeVersion());

        this.mechanismDesignService.mergeMechanismDesignInfo(mechanism, Constants.MechanismDesignState.PUBLISHED);
        return mechanism;
    }

    public Object postQueryMechanismByCode(List<String> codeList, OperationUnit operationUnit, Boolean queryWithEocLevel) throws DWBusinessException {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }

        log.info("Route==>MechanismService  method=postQueryMechanismByCode codeList:{}", JSON.toJSONString(codeList));
        DWServiceContext context = DWServiceContext.getContext();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        List<Object> result = new CopyOnWriteArrayList<>();
        List<String> collect = codeList.stream().distinct().collect(Collectors.toList());
        CompletableFuture
                .allOf(
                        collect.stream().map(code ->
                                        CompletableFuture.completedFuture(code).runAsync(() -> {
                                            DWServiceContext.setContext(context);
                                            try {
                                                RequestContextHolder.setRequestAttributes(requestAttributes);
                                                log.info("Route==>MechanismService  method=postQueryMechanismByCodeFuture code:{},ThreadId:{}", code, Thread.currentThread().getId());
                                                Object o = this.postQueryMechanismByCode(code, operationUnit, queryWithEocLevel);
                                                if (!ObjectUtils.isEmpty(o)) {
                                                    result.add(o);
                                                }
                                                log.info("Route==>MechanismService  method=postQueryMechanismByCodeFuture o:{},ThreadId:{}", JSON.toJSONString(o), Thread.currentThread().getId());
                                            } catch (Exception e) {
                                                log.error("postQueryMechanismByCode error:", e);
                                            }
                                        }, Constants.APP_EXECUTE_POOL))
                                .toArray(CompletableFuture[]::new))
                .join();

//        Set<String> querySet = new HashSet<>();
//        for(String code : codeList){
//            if(querySet.contains(code)){
//                continue;
//            }
//            querySet.add(code);
//            Object o = this.postQueryMechanismByCode(code, operationUnit);
//            if(!ObjectUtils.isEmpty(o)){
//                result.add(o);
//            }
//        }

        log.info("Route==>MechanismService  method=postQueryMechanismByCode response:{}", JSON.toJSONString(result));
        return result;
    }

    public Object postQueryMechanismByCode(List<String> codeList, OperationUnit operationUnit) throws DWBusinessException {
        return postQueryMechanismByCode(codeList, operationUnit, false);
    }

    /**
     * 将系统级机制和租户级机制合并
     *
     * @param mechanism        系统级机制
     * @param tenantMechanism  租户级机制
     * @param mechanismMergeVO 机制系统级合并信息
     */
    private void mergeMechanismPrinciple(com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism mechanism, com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism tenantMechanism, MechanismMergeVO mechanismMergeVO) {
        if (tenantMechanism == null) {
            return;
        }

        if (mechanism.getPrinciples() == null) {
            mechanism.setPrinciples(tenantMechanism.getPrinciples());
            return;
        }

        if (tenantMechanism.getPrinciples() == null) {
            return;
        }

        Set<String> tenantAllRelatedParamKeys = new HashSet<>();
        Set<String> tenantAllPdCodes = new HashSet<>();
        tenantMechanism.getPrinciples().forEach(e -> {
            List<PrincipleDetail> details = e.getDetails();
            if (!CollectionUtils.isEmpty(details)) {
                for (PrincipleDetail pd : details) {
                    if (!CollectionUtils.isEmpty(pd.getRelatedParamKeys())) {
                        tenantAllRelatedParamKeys.addAll(pd.getRelatedParamKeys());
                    }
                    tenantAllPdCodes.add(pd.getCode());
                }
            }
        });
        Set<String> highMergeVersionMPSet = mechanismMergeVO == null ? new HashSet<>()
                : (mechanismMergeVO.getHighMergeVersionMPSet() == null ? new HashSet<>() : mechanismMergeVO.getHighMergeVersionMPSet());
        Set<String> highMergeVersionMPDSet = mechanismMergeVO == null ? new HashSet<>()
                : (mechanismMergeVO.getHighMergeVersionMPDSet() == null ? new HashSet<>() : mechanismMergeVO.getHighMergeVersionMPDSet());
        List<Principle> result = new ArrayList<>();
        for (Principle principle : mechanism.getPrinciples()) {
            Principle tenantPrincipleByCode = this.getTenantPrincipleByCode(tenantMechanism.getPrinciples(), principle.getCode());
            if (tenantPrincipleByCode == null) { //新增的原理
                if (highMergeVersionMPSet.contains(principle.getCode())) {
                    List<PrincipleDetail> toAddDetails = getPrincipleDetails(tenantAllRelatedParamKeys, highMergeVersionMPDSet, principle, tenantPrincipleByCode);
                    principle.setDetails(toAddDetails);
                    result.add(principle);
                }

            } else {
                List<PrincipleDetail> toAddDetails = getPrincipleDetails(tenantAllRelatedParamKeys, highMergeVersionMPDSet, principle, tenantPrincipleByCode);
                tenantPrincipleByCode.setDetails(toAddDetails);
                result.add(tenantPrincipleByCode);
            }
        }
        mechanism.setPrinciples(result);

    }

    /**
     * 处理机制原理详情中关联的参数
     *
     * @param tenantAllRelatedParamKeys 租户级机制关联参数
     * @param highMergeVersionMPDSet    系统级合并版本
     * @param principle                 系统级机制原理
     * @param tenantPrincipleByCode     租户级机制原理
     * @return
     */
    private List<PrincipleDetail> getPrincipleDetails(Set<String> tenantAllRelatedParamKeys, Set<String> highMergeVersionMPDSet, Principle principle, Principle tenantPrincipleByCode) {
        List<PrincipleDetail> details = principle.getDetails();
        List<PrincipleDetail> toAddDetails = new ArrayList<>();
        for (PrincipleDetail principleDetail : details) {
            PrincipleDetail tenantPrincipleDetailByCode = this.getTenantPrincipleDetailByCode(tenantPrincipleByCode, principleDetail.getCode());
            if (tenantPrincipleDetailByCode == null) {
                if (highMergeVersionMPDSet.contains(principleDetail.getCode())) { //新增的pd
                    List<String> newRelatedParamKeys = this.getNewRelatedParamKeys(principleDetail.getRelatedParamKeys(), null, tenantAllRelatedParamKeys);
                    principleDetail.setRelatedParamKeys(newRelatedParamKeys);
                    toAddDetails.add(principleDetail);
                }
            } else { //原来就存在的pd,检查下是否有新增关联的参数
                List<String> newRelatedParamKeys = this.getNewRelatedParamKeys(principleDetail.getRelatedParamKeys(), tenantPrincipleDetailByCode.getRelatedParamKeys(), tenantAllRelatedParamKeys);
                tenantPrincipleDetailByCode.setRelatedParamKeys(newRelatedParamKeys);
                toAddDetails.add(tenantPrincipleDetailByCode);
            }
        }
        return toAddDetails;
    }

    // TODO liugla 2024/11/26 11:12

    /**
     * @param sysKeys                   系统级
     * @param tenantKeys                租户级
     * @param tenantAllRelatedParamKeys
     * @return
     */
    private List<String> getNewRelatedParamKeys(List<String> sysKeys, List<String> tenantKeys, Set<String> tenantAllRelatedParamKeys) {
        if (CollectionUtils.isEmpty(sysKeys)) {
            return tenantKeys;
        }
        if (tenantKeys == null) {
            tenantKeys = new ArrayList<>();
        }
        List<String> toAdd = new ArrayList<>();
        for (String key : sysKeys) {
            if (!tenantKeys.contains(key) && !tenantAllRelatedParamKeys.contains(key)) {
                toAdd.add(key);
            }
        }
        if (!CollectionUtils.isEmpty(toAdd)) {
            tenantKeys.addAll(toAdd);
        }
        return tenantKeys;
    }

    /**
     * 根据机制原理code获取租户级机制原理
     *
     * @param tenantPrinciple 租户级机制原理
     * @param code            机制原理详情code
     * @return
     */
    private PrincipleDetail getTenantPrincipleDetailByCode(Principle tenantPrinciple, String code) {
        if (tenantPrinciple == null || CollectionUtils.isEmpty(tenantPrinciple.getDetails()) || StringUtils.isEmpty(code)) {
            return null;
        }
        Optional<PrincipleDetail> first = tenantPrinciple.getDetails().stream().filter(e -> StringUtils.equals(code, e.getCode())).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    /**
     * 根据机制原理code获取租户级机制原理
     *
     * @param tenantPrinciple 租户级机制原理
     * @param code            机制原理code
     * @return
     */
    private Principle getTenantPrincipleByCode(List<Principle> tenantPrinciple, String code) {
        if (CollectionUtils.isEmpty(tenantPrinciple) || StringUtils.isEmpty(code)) {
            return null;
        }
        Optional<Principle> first = tenantPrinciple.stream().filter(e -> StringUtils.equals(code, e.getCode())).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    /**
     * 设置机制原理，数据范围来源于ComponentStructuredList，详情来源于机制原理表以及详情表
     *
     * @param mechanism          系统级机制
     * @param tenantMergeVersion 当前租户合并版本
     * @return
     * @throws DWBusinessException
     */
    private MechanismMergeVO setMechanismPrinciple(com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism mechanism, String tenantMergeVersion) throws DWBusinessException {

        MechanismMergeVO mechanismMergeVO = new MechanismMergeVO();
        Set<String> highMergeVersionMPSet = new HashSet<>();
        Set<String> highMergeVersionMPDSet = new HashSet<>();
        mechanismMergeVO.setHighMergeVersionMPSet(highMergeVersionMPSet);
        mechanismMergeVO.setHighMergeVersionMPDSet(highMergeVersionMPDSet);

        ComponentStructuredList mechanismComponentStructuredList = null;
        String tenantId = AthenaUtils.getTenantId();
        String version = kgInnerService.getTenantVersion(tenantId);
        try {
            mechanismComponentStructuredList = this.componentManager.findMechanismComponentStructuredList(mechanism.getCode(), version, tenantId);
        } catch (DWBusinessException e) {
            log.info("未在组件清单中找到数据" + e.getMessage());
            //TODO set tenantMechanism Principle
            return mechanismMergeVO;
        }


        if (mechanismComponentStructuredList != null) {
            List<StructuredComponentBO> components = mechanismComponentStructuredList.getComponents();
            List<Principle> principles = new ArrayList<>();
            List<FieldDescription> paramDescriptionList = new ArrayList<>();
            List<ComponentBO> paramDescriptionComponentList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(components)) {
                for (StructuredComponentBO structuredComponentDO : components) {
                    ComponentTypeEnum type = structuredComponentDO.getType();
                    // 机构层次为{机制：{机制原理：{关联的参数}}}
                    if (ComponentTypeEnum.MechanismPrinciple.equals(type)) {
                        // 获取机制原理code
                        String code = structuredComponentDO.getCode();
                        Principle principle = this.getPrincipleByCode(code);
                        if(principle == null){
                            continue;
//                            throw new DWBusinessException(String.format("No available principle of [%s] in mechanism [%s]", code, mechanism.getCode()));
                        }
                        String mergeVersion = structuredComponentDO.getConfigs() == null
                                ? null : ObjectUtils.isEmpty(structuredComponentDO.getConfigs().get("mergeVersion")) ? null : String.valueOf(structuredComponentDO.getConfigs().get("mergeVersion"));
                        if (VersionUtil.compareVersion(mergeVersion, tenantMergeVersion) > 0) {
                            highMergeVersionMPSet.add(code);
                            mechanismMergeVO.compareAndSetMergeVersion(mergeVersion);
                        }
                        List<StructuredComponentBO> subComponents = structuredComponentDO.getSubComponents();
                        if (!CollectionUtils.isEmpty(subComponents)) {
                            List<PrincipleDetail> principleDetails = new ArrayList<>();
                            for (StructuredComponentBO subComponent : subComponents){
                                if (ComponentTypeEnum.MechanismPrincipleDetail.equals(subComponent.getType())) {
                                    PrincipleDetail principleDetail = this.getPrincipleDetailByComponent(subComponent);
                                    if (principleDetail == null) {
                                        continue;
//                                        throw new DWBusinessException(String.format("No available principleDetail of [%s] in mechanism [%s]", subComponent.getCode(), mechanism.getCode()));
                                    }
                                    String mergeVersion2 = subComponent.getConfigs() == null
                                            ? null : ObjectUtils.isEmpty(subComponent.getConfigs().get("mergeVersion")) ? null : String.valueOf(subComponent.getConfigs().get("mergeVersion"));
                                    if (VersionUtil.compareVersion(mergeVersion2, tenantMergeVersion) > 0) {
                                        highMergeVersionMPDSet.add(subComponent.getCode());
                                        mechanismMergeVO.compareAndSetMergeVersion(mergeVersion2);
                                    }
                                    List<StructuredComponentBO> pdSubComponents = subComponent.getSubComponents();
                                    if (!CollectionUtils.isEmpty(pdSubComponents)) {
                                        // 将组件code全部加入到relatedParamKeys
                                        List<String> relatedParamKeys = new ArrayList<>();
                                        for (StructuredComponentBO pdSubComponent : pdSubComponents) {
                                            relatedParamKeys.add(pdSubComponent.getCode());
                                            if (BooleanUtils.isNotTrue(pdSubComponent.getHidden())) { //当hidden是true的时候，不用把参数加到机制中给显示
                                                paramDescriptionComponentList.add(pdSubComponent);
                                                // modify by srj 不一个个得获取，通过this.componentManager.generateParamDescriptionList同意获取然后设置值
//                                                FieldDescription fieldDescriptionByComponent = this.componentManager.createFieldDescriptionByComponent(pdSubComponent);
//                                                if (fieldDescriptionByComponent != null) {
//                                                    paramDescriptionList.add(fieldDescriptionByComponent);
//                                                }
                                            }
                                        }
                                        principleDetail.setRelatedParamKeys(relatedParamKeys);
                                    }
                                    principleDetails.add(principleDetail);
                                }
                            }
                            principle.setDetails(principleDetails);
                        }
                        principles.add(principle);
                    }

                }
            }
            mechanism.setPrinciples(principles);
//            mechanism.setParamDescription(paramDescriptionList);
            mechanism.setParamDescription(this.componentManager.generateParamDescriptionList(paramDescriptionComponentList));
        }

        return mechanismMergeVO;
    }


    /**
     * 根据机制原理code获取机制原理
     *
     * @param code 机制原理code
     * @return 返回机制原理
     */
    @Override
    public Principle getPrincipleByCode(String code) throws DWBusinessException {
        return dataPickService.findOneByCondition(Criteria.where("code").is(code), Principle.class, "principle");
    }

    @Override
    public PrincipleDetail getPrincipleDetailByComponent(StructuredComponentBO subComponent) throws DWBusinessException {
        if(subComponent instanceof MechanismPrincipleDetailComponentBO){
            // 正常的参数都是保存再relatedParamKeys中，otherParamKeys用于保存机制交付物中不需要在机制辅导页展示的参数
            List<String> otherParamKeys = ((MechanismPrincipleDetailComponentBO) subComponent).getOtherParamKeys();
            PrincipleDetail principleDetailByCode = this.getPrincipleDetailByCode(subComponent.getCode());
            principleDetailByCode.setOtherParamKeys(otherParamKeys);
            return principleDetailByCode;
        } else {
            return getPrincipleDetailByCode(subComponent.getCode());
        }

    }

    /**
     * 根据机制原理详情获取机制原理详情
     *
     * @param code 机制原理详情code
     * @return 机制原理详情
     */
    public PrincipleDetail getPrincipleDetailByCode(String code) throws DWBusinessException {
        return dataPickService.findOneByCondition(Criteria.where("code").is(code), PrincipleDetail.class, "principleDetail");
    }

    @Override
    public Object postQueryTenantMechanismByCode(String code, OperationUnit operationUnit) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return this.getTenantMechanism(tenantId, code, operationUnit);
    }

    /**
     * 查询租户级机制
     *
     * @param tenantId      租户id
     * @param code          机制code
     * @param operationUnit 运营单元
     * @return 返回机制数据
     */
    private com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism getTenantMechanism(String tenantId, String code, OperationUnit operationUnit) {
        Query query = new Query();
        Criteria criteria = Criteria.where("code").is(code).and("tenantId").is(tenantId);//根据主机制code查询
        Criteria criteria1 = this.operationUnitService.addEocMapToCriteria(operationUnit, criteria);
        query.addCriteria(criteria1);


        return this.mongoTemplate2.findOne(query, com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism.class);
    }

    @Override
    public List<String> getVariableCode(String mechanismCode) throws DWBusinessException {
        List<String> re = new ArrayList<>();

        List<MechanismRelation> relations = dataPickService.find(Criteria.where("type").is("variable").and("mechanismCode").is(mechanismCode), MechanismRelation.class, "mechanismRelation");
        relations.forEach(r -> re.add(r.getCode()));
        return re;
    }

    @Override
    public List<String> getMonitorRuleCode(String mechanismCode) throws DWBusinessException {
        List<String> codes = new ArrayList<>();

        List<MechanismRelation> relations = dataPickService.find(Criteria.where("type").is("monitorRule").and("mechanismCode").is(mechanismCode), MechanismRelation.class, "mechanismRelation");
        relations.forEach(r-> codes.add(r.getCode()));

        return codes;
    }

    @Override
    public Map<String, String> postParadigmCode(List<String> mechanismCode) throws DWBusinessException {
//        MechanismRelation relations = mongoTemplateSystem.findOne(Query.query(Criteria.where("type").is("paradigm")
//                .and("mechanismCode").is(mechanismCode)
//                .and("version").is(tenantVersion)),MechanismRelation.class);
//        return relations == null ? "" : relations.getCode();
        String version = kgInnerService.getTenantVersion(AthenaUtils.getTenantId());
        List<ComponentStructuredList> mechanismComponentStructuredList =
                this.componentManager.findMechanismComponentStructuredList(mechanismCode, version, null);
        if (CollectionUtils.isEmpty(mechanismComponentStructuredList)) {
            return null;
        }
        return mechanismComponentStructuredList.stream().collect(Collectors.toMap(ComponentStructuredList::getMechanismCode, ComponentStructuredList::getParadigm, (a, b) -> a));
    }

    @Override
    public List<Paradigm> postParadigmNameAndCode(List<String> paradigmTypeCodeList) throws DWBusinessException {
        return dataPickService.find(Criteria.where("code").in(paradigmTypeCodeList), Paradigm.class, "paradigm");
    }

    private void processMonitorRule(com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism mechanism) throws DWBusinessException {
        List<String> ruleList = this.getMonitorRuleCode(mechanism.getCode());
        if (ruleList != null && !ruleList.isEmpty()) {
            if (mechanism.getParamDescription() != null) {
                int seq = 1000;
                for (String ruleId : ruleList) {
                    boolean existed = false;
                    for (FieldDescription p : mechanism.getParamDescription()) {
                        if (p.getCategory().toLowerCase(Locale.ROOT).equals("period") && p.getExtendData().equals(ruleId)) {
                            existed = true;
                            break;
                        }
                    }
                    if (existed) {
                        continue;
                    } else {
                        FieldDescription para = appService.createMonitorRuleParam(ruleId, false);
                        para.setSequence(seq);
                        seq += 10;
                        mechanism.getParamDescription().add(para);
                    }
                }
            } else {
                List<FieldDescription> paras = new ArrayList<>();
                int seq = 1000;
                for (String ruleId : ruleList) {
                    FieldDescription para = appService.createMonitorRuleParam(ruleId, false);
                    para.setSequence(seq);
                    paras.add(para);
                    seq += 10;
                }
                mechanism.setParamDescription(paras);
            }
        }
    }

    private void processVariable(com.digiwin.athena.knowledgegraph.domain.mechanism.Mechanism mechanism) throws DWBusinessException {
        List<String> variableList = this.getVariableCode(mechanism.getCode());
        if (variableList != null && !variableList.isEmpty()) {
            if (mechanism.getParamDescription() != null) {
                int seq = 1000;
                for (String code : variableList) {
                    boolean existed = false;
                    for (FieldDescription p : mechanism.getParamDescription()) {
                        if (p.getCategory().toLowerCase(Locale.ROOT).equals("variable") && p.getKey().equals(code)) {
                            existed = true;
                            break;
                        }
                    }
                    if (existed) {
                        continue;
                    } else {
                        FieldDescription para = appService.createVariableParam(code);
                        para.setSequence(seq);
                        mechanism.getParamDescription().add(para);
                        seq += 10;
                    }
                }
            } else {
                List<FieldDescription> paras = new ArrayList<>();
                int seq = 1000;
                for (String code : variableList) {
                    FieldDescription para = appService.createVariableParam(code);
                    para.setSequence(seq);
                    paras.add(para);
                    seq += 10;
                }
                mechanism.setParamDescription(paras);
            }
        }
    }

    @Override
    public Object postUpdateTenantMechanism(String code, String name, List<Principle> principles, OperationUnit operationUnit) throws DWBusinessException {
        this.postUpdateTenantMechanism(code, name, principles, operationUnit, null);

        return null;
    }

    private void syncTenantMechanism(String mechanismCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = tenantService.getTenantVersion(tenantId);
        Query sysMechanismQuery = new Query();
        sysMechanismQuery.addCriteria(Criteria.where("mechanismCode").is(mechanismCode).and("tenantId").is(SYSTEM).and("version").is(tenantVersion));
        // 根据机制code查询系统级机制能力数据
        List<MechanismCapacity> sysMechanismCapacities = mongoTemplateSystem.find(sysMechanismQuery, MechanismCapacity.class);
        sysMechanismCapacities = dataPickService.excludeWithSameCode(sysMechanismCapacities, BaseEntity::getCode, MechanismCapacity::getSourceLevel);
        Set<String> sysCapacityCodes = sysMechanismCapacities.stream().map(MechanismCapacity::getCode).collect(Collectors.toSet());
        // 仅处理来自于开发平台的租户能力
        // 根据机制code查询租户级机制能力数据
        List<MechanismCapacity> userMechanismCapacities = mongoTemplate2.find(Query.query(Criteria.where("mechanismCode").is(mechanismCode).and("tenantId").is(tenantId).and("createdByDevPlatform").is(true)), MechanismCapacity.class);
        // 删除系统级能力数据中存在租户级能力数据，但租户级数据未被删除的能力数据
        List<MechanismCapacity> canRemovedCapacities = userMechanismCapacities.stream().filter(each -> sysCapacityCodes.contains(each.getCode())).collect(Collectors.toList());
        if (!canRemovedCapacities.isEmpty()) {
            mongoTemplate2.remove(Query.query(Criteria.where("tenantId").is(tenantId).and("code").in(canRemovedCapacities.stream().map(MechanismCapacity::getCode).collect(Collectors.toList()))), MechanismCapacity.class);
            mongoTemplate2.remove(Query.query(Criteria.where("tenantId").is(tenantId).and("code").in(canRemovedCapacities.stream().map(MechanismCapacity::getCode).collect(Collectors.toList()))), MechanismLogic.class);
        }
        // 存在于租户级但不存在于系统能力中得数据，打上删除标志，在后面步骤会将数据删除
        List<MechanismCapacity> needToUnapplyCapacity = userMechanismCapacities.stream().filter(each -> !sysCapacityCodes.contains(each.getCode())).collect(Collectors.toList());
        if (!needToUnapplyCapacity.isEmpty()) {
            mongoTemplate2.updateMulti(
                    Query.query(Criteria.where("tenantId").is(tenantId).and("code").in(needToUnapplyCapacity.stream().map(MechanismCapacity::getCode).collect(Collectors.toList()))),
                    Update.update("deletedByDevPlatform", true), MechanismCapacity.class);
        }
        if (sysMechanismCapacities.isEmpty()) {
            return;
        }
        // 找到用户修改过的系统级能力
        // 后期会开放交付设计器修改机制能力，对于修改过得机制能力，会将createdByDevPlatform修改为false，对于这部分数据就不需要再用系统级数据覆盖
        List<MechanismCapacity> userModifiedCapacities = mongoTemplate2.find(Query.query(Criteria.where("tenantId").is(tenantId).and("code").in(sysCapacityCodes).and("createdByDevPlatform").is(false)), MechanismCapacity.class);
        List<String> userModifiedCapacityCodes = userModifiedCapacities.stream().map(MechanismCapacity::getCode).collect(Collectors.toList());
        List<MechanismCapacity> needSyncCapacities = sysMechanismCapacities.stream().filter(each -> !userModifiedCapacityCodes.contains(each.getCode())).collect(Collectors.toList());
        if (needSyncCapacities.isEmpty()) {
            return;
        }
        List<MechanismCapacity> mechanismCapacities = new ArrayList<>(needSyncCapacities.size());
        Map<String, MechanismCapacity> tentRemovedCapacity = canRemovedCapacities.stream().collect(Collectors.toMap(MechanismCapacity::getCode, Function.identity(), (a, b) -> a));
        for (MechanismCapacity sysMechanismCapacity : needSyncCapacities) {
            MechanismCapacity mechanismCapacity = kgHelpService.convert(sysMechanismCapacity, MechanismCapacity.class);
            mechanismCapacity.setTenantId(tenantId);
            mechanismCapacity.setVersion(tenantVersion);
            mechanismCapacity.setHasApply(tentRemovedCapacity.containsKey(sysMechanismCapacity.getCode()) ? tentRemovedCapacity.get(sysMechanismCapacity.getCode()).getHasApply() : false);
            mechanismCapacity.setId(null);
            mechanismCapacities.add(mechanismCapacity);
        }
        mongoTemplate2.insertAll(mechanismCapacities);
        List<String> needSyncMechanismCodes = needSyncCapacities.stream().map(MechanismCapacity::getCode).collect(Collectors.toList());
        Query sysMechanismLogicCodes = Query.query(Criteria.where("tenantId").is("SYSTEM").and("version").is(tenantVersion).and("code").in(needSyncMechanismCodes));
        List<MechanismLogic> sysLogics = mongoTemplateSystem.find(sysMechanismLogicCodes, MechanismLogic.class);
        sysLogics = dataPickService.excludeWithSameCode(sysLogics, BaseEntity::getCode, MechanismLogic::getSourceLevel);
        List<MechanismLogic> mechanismLogics = new ArrayList<>(sysLogics.size());
        for (MechanismLogic sysLogic : sysLogics) {
            MechanismLogic mechanismLogic = kgHelpService.convert(sysLogic, MechanismLogic.class);
            mechanismLogic.setTenantId(tenantId);
            mechanismLogic.setVersion(tenantVersion);
            mechanismLogics.add(mechanismLogic);
            mechanismLogic.setId(null);
        }
        mongoTemplate2.insertAll(mechanismLogics);
    }

    @Override
    public Object postUpdateTenantMechanism(String code, String name, List<Principle> principles, OperationUnit operationUnit, String mergeVersion) throws DWBusinessException {
        // 根据系统级机制一次编译结果，生成对应的租户级别的机制
        syncTenantMechanism(code);
        String tenantId = AthenaUtils.getTenantId();

        MechanismUserDesignerInfo mechanismUserDesignerInfo = this.extractUserDesignMechanismCapacity(principles);
        mechanismUserDesignerInfo.setMechanismCode(code);

        Query query = new Query();
        Criteria criteria = Criteria.where("code").is(code).and("tenantId").is(tenantId);
        Criteria criteria1 = this.operationUnitService.addOperationToCriteria(operationUnit, criteria);
        query.addCriteria(criteria1);

        Update update = new Update();
        update.set("name", name);
        update.set("principles", principles);
        update.set("mergeVersion", mergeVersion);

        this.mongoTemplate2.upsert(query, update, "mechanism");

        this.dataMapService.mechanismPluginMerge(tenantId, Arrays.asList(code));

        updateTenantComponentList(code, tenantId);

        this.mechanismDesignService.updateUserDesignMechanismInfo(mechanismUserDesignerInfo);

        return null;
    }


    private MechanismUserDesignerInfo extractUserDesignMechanismCapacity(List<Principle> principles) {
        MechanismUserDesignerInfo mechanismUserDesignerInfo = new MechanismUserDesignerInfo();
        List<MechanismTheory> mechanismTheoryList = new ArrayList<>();
        List<MechanismCapacity> mechanismCapacityList = new ArrayList<>();
        mechanismUserDesignerInfo.setCapacity(mechanismCapacityList);
        mechanismUserDesignerInfo.setTheory(mechanismTheoryList);

        if (!CollectionUtils.isEmpty(principles)) {
            Iterator<Principle> iterator = principles.iterator();
            while (iterator.hasNext()) {
                Principle next = iterator.next();
                //当整个原理是用户设计时设计，则底下的能力必定也是用户设计
                if (MechanismDesignService.FROM_USER.equals(next.getFrom())) {
                    MechanismTheory mechanismTheory = new MechanismTheory();
                    mechanismTheory.setTitle(next.getTitle());
                    mechanismTheory.setCode(next.getCode());
                    mechanismTheory.setLang(next.getLang());

                    mechanismTheoryList.add(mechanismTheory);

                    List<PrincipleDetail> details = next.getDetails();
                    if (!CollectionUtils.isEmpty(details)) {
                        details.forEach(e -> {
                            if (e.getCode().startsWith(MechanismDesignService.UD_THEORY_DETAIL_PREFIX)) {
                                com.digiwin.athena.mechanism.pre.PrincipleDetail principleDetail = JSON.parseObject(JSON.toJSONString(e), com.digiwin.athena.mechanism.pre.PrincipleDetail.class);
                                mechanismTheory.setDetails(Arrays.asList(principleDetail));
                            } else {
                                mechanismCapacityList.add(this.transToMechanismCapacity(e, next.getCode()));
                            }
                        });
                    }
                    iterator.remove();
                } else {
                    //查看是否有机制能力来源于用户设计
                    List<PrincipleDetail> details = next.getDetails();
                    if (!CollectionUtils.isEmpty(details)) {
                        Iterator<PrincipleDetail> pdIterator = details.iterator();
                        while (pdIterator.hasNext()) {
                            PrincipleDetail principleDetail = pdIterator.next();
                            if (MechanismDesignService.FROM_USER.equals(principleDetail.getFrom())) {

                                mechanismCapacityList.add(this.transToMechanismCapacity(principleDetail, next.getCode()));
                                pdIterator.remove();
                            }
                        }
                    }

                }
            }
        }
        return mechanismUserDesignerInfo;
    }

    private MechanismCapacity transToMechanismCapacity(PrincipleDetail principleDetail, String pCode) {
        MechanismCapacity capacity = new MechanismCapacity();
        capacity.setMechanismTheoryCode(pCode);
        capacity.setCode(principleDetail.getCode());
        capacity.setName(principleDetail.getTitle());
        capacity.setDescription(principleDetail.getDescription());
        capacity.setLang(principleDetail.getLang());
        return capacity;
    }

    @Override
    public Object getMechanismTenantParadigm(String code, String tenantId) throws DWBusinessException {
        Query query = new Query();
        Criteria criteria = new Criteria().andOperator(Criteria.where("code").is(code),
                Criteria.where("tenantId").is(tenantId));
        query.fields().include("value");
        query.addCriteria(criteria);
        Map ten = this.mongoTemplate2.findOne(query, Map.class, MECHANISM_TENANT_PARADIGM);
        return ten == null ? new ArrayList<>() : (CollectionUtils.isEmpty((List) ten.get("value")) ?
                new ArrayList<>() : (List) ten.get("value"));
    }

    @Override
    public Object postMechanismTenantParadigm(String code, String tenantId, List<String> value) throws DWBusinessException {
        Query query = new Query();
        query.addCriteria(Criteria.where("tenantId").is(tenantId).and("code").is(code));
        Update update = Update.update("value", value);

        return mongoTemplate2.upsert(query, update, MECHANISM_TENANT_PARADIGM);
    }

    @Override
    public Object postClearTenantMechanism(String code, OperationUnit operationUnit) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        Criteria criteria = Criteria.where("code").is(code).and("tenantId").is(tenantId);
        Criteria criteria1 = this.operationUnitService.addOperationToCriteria(operationUnit, criteria);
        query.addCriteria(criteria1);

        this.mongoTemplate2.remove(query, "mechanism");
        updateTenantComponentList(code, tenantId);
        // 同时清理能力数据
        postClearTenantMechanismCapacity(code, operationUnit);
        return null;
    }

    /**
     * 清理租户级机制能力数据
     * @param code 机制code
     * @param operationUnit 运营单元
     * @throws DWBusinessException
     */
    private void postClearTenantMechanismCapacity(String code, OperationUnit operationUnit) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query query = new Query();
        Criteria criteria = Criteria.where("mechanismCode").is(code).and("tenantId").is(tenantId);
        Criteria criteria1 = this.operationUnitService.addOperationToCriteria(operationUnit, criteria);
        query.addCriteria(criteria1);
        this.mongoTemplate2.remove(query, "mechanismCapacity");
    }

    @Override
    public Object postSaveMechanismLogic(MechanismLogic logic) throws DWBusinessException {

        Query query = Query.query(Criteria.where("code").is(logic.getCode()));
        Update update = Utils.toUpdate(logic);
        mongoTemplateSystem.upsert(query, update, MechanismLogic.class);

        return null;
    }

    @Override
    public Object getMechanismLogic(String code) throws DWBusinessException {

        Query query = Query.query(Criteria.where("code").is(code));
        MechanismLogic logic = mongoTemplateSystem.findOne(query, MechanismLogic.class);
        return logic;
    }

    @Override
    public Object getDeleteMechanismLogic(String code) throws DWBusinessException {

        Query query = Query.query(Criteria.where("code").is(code));
        mongoTemplateSystem.remove(query, MechanismLogic.class);
        return null;
    }

    @Override
    public Object getHasGroundEnd() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List<String> allSteadyProductList = (List<String>) this.productService.getAllSteadyProduct();
        try {
            Object o = this.productNameResolver.tenantProductOperationList(tenantId);
            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(o));
            JSONArray gateways = jsonObject.getJSONArray("prod_eoc_mapping");
            if (gateways == null) {
                return "N";
            }
            for (int i = 0; i < gateways.size(); i++) {
                String prod_name = gateways.getJSONObject(i).getString("prod_name");
                if (allSteadyProductList.contains(prod_name)) {
                    if (iamUtils.isTenantOperationUnitV2()) {
                        // V2租户返回值不一样
                        return ObjectUtils.isEmpty(gateways.getJSONObject(i).get("eoc_mapping_id")) ? "Y" : "N";
                    }
                    return (!ObjectUtils.isEmpty(gateways.getJSONObject(i).get("org_type_company"))
                            || !ObjectUtils.isEmpty(gateways.getJSONObject(i).get("org_type_region"))) ? "Y" : "N";
                }

            }
        } catch (Exception e) {
            log.error("hasGroundEnd获取产品信息失败:{}", e);
            return "N";
        }
        return "N";
    }

    @Override
    public Object getBuildGraph(String mechanismCode) throws DWBusinessException {

        String nodeId = mechanismGraphService.buildMechanismGraph(mechanismCode);
        return nodeId;
    }


    @Override
    public Object getMechanismSort(String appCode) throws DWBusinessException {
        MechanismSettings res = dataPickService.findOneByCondition(Criteria.where("appCode").is(appCode), MechanismSettings.class, "mechanismSettings");
        return res != null ? res.getSort() : null;
    }

    @Override
    public Object getMechanismAndParadigmSort(String appCode) throws DWBusinessException {
        return dataPickService.findOneByCondition(Criteria.where("appCode").is(appCode), MechanismSettings.class, "mechanismSettings");
    }

    /**
     * 更新租户级机制数据以及组件数据
     *
     * @param mechanismCode 机制code
     * @param tenantId      租户id
     * @throws DWBusinessException
     */
    private void updateTenantComponentList(String mechanismCode, String tenantId) throws DWBusinessException {

        List<ApplicationRelation> relations = appService.getAppCodeByMechanismCode(mechanismCode);
        if (relations.size() == 0) {
            return;
        }
        String appCode = relations.get(0).getAppCode();

        List mechanismList = (List) getMechanismTenantParadigm(appCode, tenantId);
        List<String> mechanismCodes = new ArrayList<String>();
        mechanismList.forEach((mechanism) -> {
            mechanismCodes.add(mechanism.toString());
        });

        try {
            //直接查机制对应的范式
            String version = kgInnerService.getTenantVersion(tenantId);
            ComponentStructuredList mechanismComponentStructuredList = this.componentManager.findMechanismComponentStructuredList(mechanismCode, version, tenantId);

            String paradigm = mechanismComponentStructuredList == null ? null : mechanismComponentStructuredList.getParadigm();
//            if (mechanismCodes.size() > 0) {
//                paradigm = postParadigmCode(Collections.singletonList(mechanismCodes.get(0))).get(mechanismCodes.get(0));
//            }
            if (paradigm == null) {
                log.error("paradigm not found or not mechanisms found  of tenant {} componentList for {}", tenantId, appCode);
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.paradigmNotFound"));
            }

            componentManager.UpdateTenantApplicationComponentListByMechanism(appCode, tenantId, paradigm, mechanismCodes, mechanismCode);
        } catch (Exception ex) {
            log.error("error while updating component list of tenant {} componentList for {}", tenantId, appCode);
            log.error(ex.getMessage(), ex);
        }
    }

    /**
     * 临时修数据用：批量找到已生效过机制的租户，通知datamap绑定机制插件
     *
     * @param mechanismCode
     * @return
     */
    @Override
    public Object postMechanismPluginsMerge(String mechanismCode) {
        Query query = new Query();
        query.addCriteria(Criteria.where("code").is(mechanismCode));
        query.fields().include("tenantId");

        List<Map> mechanismList = this.mongoTemplate2.find(query, Map.class, "mechanism");

        if (!CollectionUtils.isEmpty(mechanismList)) {
            for (Map map : mechanismList) {
                try {
                    String tenantId = String.valueOf(map.get("tenantId"));
                    log.info("mechanismPluginMerge tenantId:{}, plugins:{}", tenantId, mechanismCode);
                    this.dataMapService.mechanismPluginMerge(tenantId, Arrays.asList(mechanismCode));
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    @Override
    public Object postMechanismApplyRecord(Map query) throws Exception {

        String tenantId = AthenaUtils.getTenantId();
        query.put("tenantId", tenantId);

        Query q = kgHelpService.buildQuery(query);

        List<MechanismApplyRecord> records = mongoTemplate2.find(q, MechanismApplyRecord.class);

        return records;
    }


    /**
     * 　* @description: 交付设计器增加列单选功能修正历史数据
     * 　* @param [tenantId]
     * 　* @return java.lang.Object
     * 　* @throws
     * 　* @author linc
     * 　* @date 2023/5/11 13:18
     */
    @Override
    public Object postMechanismExecuteParamsUpdate(String tenantId) {
        // 定义查询条件
        Criteria criteria = Criteria.where("mechanismCode").is("TraceMaterialLevelMechanism");

        if (StringUtils.isNotEmpty(tenantId)) {
            criteria.and("tenantId").is(tenantId);
        }
        Query query = new Query(criteria);

        // 定义更新操作
        MongoCollection<Document> collection = mongoTemplate2.getCollection("mechanismExecuteParams");
        MongoCursor<Document> cursor = collection.find(query.getQueryObject()).iterator();
        Integer count = 0;
        while (cursor.hasNext()) {
            Document doc = cursor.next();
            Document traceMaterialLevel = (Document) doc.get("params", List.class).get(0);
            List<Document> onTimeArrivalLevels = traceMaterialLevel.get("traceMaterialLevel", List.class);
            for (Document onTimeArrivalLevel : onTimeArrivalLevels) {
                String level = onTimeArrivalLevel.getString("onTimeArrivalLevel");
                Object defaultAdmissionLevel = onTimeArrivalLevel.get("defaultAdmissionLevel");
                if ("A".equals(level) && ObjectUtils.isEmpty(defaultAdmissionLevel)) {
                    onTimeArrivalLevel.append("defaultAdmissionLevel", true);
                    collection.replaceOne(Filters.eq("_id", doc.get("_id")), doc);
                    count++;
                }
            }
        }
        return count;
    }

    /**
     * 查询pwd定制机制参数
     *
     * @param variableCode 参数code
     * @param tenantId     租户id
     * @return 参数值
     * @throws DWBusinessException 业务异常
     */
    @Override
    public Object getPwdCustomizeVariable(String variableCode, String tenantId) throws DWBusinessException {
        if (variableCode == null || variableCode.isEmpty()) {
            throw new DWArgumentException("variable", I18nUtils.getValue("knowledgegraph.variableEmpty"));
        }
        Query query = new Query(Criteria.where(MECHANISM_VARIABLE_ID_KEY_NAME).is(variableCode).and(TENANT_ID_KEY_NAME).is(tenantId));
        // 查询租户级数据
        MechanismTenantVariable tenantVariable = this.mongoTemplate2.findOne(query, MechanismTenantVariable.class);
        Object val = null;
        if (tenantVariable == null) {
            // 没有找到租户下的参数变量值 则使用预设值
            Map<String, Object> keyConditions = new HashMap<>();
            keyConditions.put("code", variableCode);

            VariableDefinition def = dataPickService.findOneByCondition(Criteria.where("code").is(variableCode), VariableDefinition.class, "variableDefinition");
            if (def != null) {
                val = def.getDefaultValue();
            }
        } else {
            val = tenantVariable.getValue();
        }
        Map<String, Object> result = new HashMap<>();
        result.put(variableCode, pwdCustomizeValConvert(variableCode, val));
        return result;
    }

    /**
     * PWD定制表格参数格式转换
     *
     * @param variableName 参数code
     * @param val          参数值
     */
    private Object pwdCustomizeValConvert(String variableName, Object val) {
        if (!"material_recovery_plan".equals(variableName) || val == null) {
            return val;
        }
        JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(val));
        Map<Integer, JSONArray> map = new Hashtable<>();
        int index = 0;
        if (jsonArray != null && !jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject.containsKey("times")) {
                    JSONArray array = new JSONArray();
                    Object value = jsonObject.getJSONObject("beforeDays").get("value");
                    if (value != null) {
                        value = NumberUtil.parseInt(String.valueOf(value));
                    }
                    array.add(value);
                    map.put(i, array);
                    index = i;
                } else {
                    // 找到最后一个map节点
                    map.computeIfAbsent(index, k -> new JSONArray());
                    Object value = jsonObject.getJSONObject("beforeDays").get("value");
                    if (value != null) {
                        value = NumberUtil.parseInt(String.valueOf(value));
                    }
                    map.get(index).add(value);
                }
                for (String key : jsonObject.keySet()) {
                    if (key.equals("beforeDays")) {
                        continue;
                    }
                    Object value = jsonObject.getJSONObject(key).get("value");
                    if (value != null) {
                        value = NumberUtil.parseInt(String.valueOf(value));
                    }
                    jsonObject.put(key, value);
                }
            }
            JSONArray result = new JSONArray();
            for (int i = 0; i < jsonArray.size(); i++) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (jsonObject.containsKey("times")) {
                    jsonObject.put("beforeDays", map.get(i));
                    result.add(jsonObject);
                }
            }
            return result;
        }
        return val;
    }

    @Override
    public Object postQuerySmartDataVariable(List<String> variableIds, String tenantId) {
        Criteria criteria = Criteria.where("tenantId").is(tenantId).and("code").in(variableIds);
        Query query = new Query(criteria);
        List<Map> tenantVariableList = mongoTemplate2.find(query, Map.class, "agiledata_business_variables_value");

        Map<String, Object> resultMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(tenantVariableList)) {
            // 将查询结果映射为 Map
            for (Map<String, Object> map : tenantVariableList) {
                resultMap.put(map.get("code").toString(), map);
            }
        }
        // 将所有 variableIds 映射到 null（如果未找到对应值）
        variableIds.forEach(variableId -> resultMap.putIfAbsent(variableId, null));

        return resultMap;
    }

    @Override
    public List<ActivityWidget> postGeneratePreActivities(AdvancedUserDefinitionWidget advancedUserDefinitionWidget, String capacityCode) throws DWBusinessException {
        MechanismCapacity mechanismCapacity = mongoTemplate2.findOne(Query.query(Criteria.where("code").is(capacityCode).and("tenantId").is(AthenaUtils.getTenantId())), MechanismCapacity.class);
        if (null == mechanismCapacity) {
            return Collections.emptyList();
        }
        List<ActivityWidget> activityWidgets = advancedAssignDefinitionParser.generatePreActivities(advancedUserDefinitionWidget, mechanismCapacity);
        return activityWidgets;
    }

    @Override
    public Object postCopyTenantMechanismInfo(List<String> codes, String sourceTenantId, String targetTenantId) throws DWBusinessException {
        if (null == codes || codes.isEmpty() || StringUtils.isEmpty(sourceTenantId) || StringUtils.isEmpty(targetTenantId)) {
            throw new DWBusinessException("P.KG.500.0100", I18nUtils.getValue("knowledgegraph.copyTenantMechanism.parameterError"));
        }
        // 定义返回
        Map<String, Object> results = new HashMap<>();
        for (String mechanismCode : codes) {
            // 查询源租户下机制能力信息
            Query query = new Query(Criteria.where("mechanismCode").is(mechanismCode).and("tenantId").is(sourceTenantId).and("status").is(Constants.MechanismDesignState.PUBLISHED));
            List<Document> sourceMechanismCapacityList = mongoTemplate2.find(query, Document.class, "mechanismCapacity");
            if (!sourceMechanismCapacityList.isEmpty()) {
                // 定义mechanismCapacity复制结果返回
                List<Map<String, List<Map<String, UpdateResult>>>> mechanismResults = new ArrayList<>();
                // 定义mechanismCapacity复制结果返回
                Map<String, List<Map<String, UpdateResult>>> mechanismCapacityMap = new HashMap<>();
                // 定义mechanismCapacity复制结果
                List<Map<String, UpdateResult>> mechanismCapacityResults = new ArrayList<>(sourceMechanismCapacityList.size());
                // 机制能力code集合
                List<String> mechanismCapacityCodes = new ArrayList<>(sourceMechanismCapacityList.size());
                // 复制机制能力信息
                for (Document sMechanismCapacity : sourceMechanismCapacityList) {
                    sMechanismCapacity.remove("_id");
                    String mechanismCapacityCode = sMechanismCapacity.get("code").toString();
                    mechanismCapacityCodes.add(mechanismCapacityCode);
                    // 查询目标租户下机制信息条件
                    Query targetQuery = new Query(Criteria.where("code").is(mechanismCapacityCode).and("tenantId").is(targetTenantId));
                    Update update = new Update();
                    sMechanismCapacity.forEach(update::set);
                    update.set("tenantId", targetTenantId);
                    UpdateResult updateResult = mongoTemplate2.upsert(targetQuery, update, "mechanismCapacity");
                    Map<String, UpdateResult> resultMap = new HashMap<>();
                    resultMap.put(mechanismCapacityCode, updateResult);
                    mechanismCapacityResults.add(resultMap);
                }
                mechanismCapacityMap.put("mechanismCapacity", mechanismCapacityResults);
                mechanismResults.add(mechanismCapacityMap);
                // 查询源租户下机制logic信息
                Query sourceLogicQueryQuery = new Query(Criteria.where("code").in(mechanismCapacityCodes).and("tenantId").is(sourceTenantId));
                List<Document> sourceMechanismLogicList = mongoTemplate2.find(sourceLogicQueryQuery, Document.class, "mechanismLogic");
                if (!sourceMechanismLogicList.isEmpty()) {
                    // 定义mechanismLogic复制结果返回
                    Map<String, List<Map<String, UpdateResult>>> mechanismLogicMap = new HashMap<>();
                    // 定义mechanismLogic复制结果
                    List<Map<String, UpdateResult>> mechanismLogicResults = new ArrayList<>(sourceMechanismLogicList.size());
                    // 复制机制logic信息
                    for (Document sMechanismLogic : sourceMechanismLogicList) {
                        sMechanismLogic.remove("_id");
                        String mechanismLogicCode = sMechanismLogic.get("code").toString();
                        // 查询目标租户下机制logic信息条件
                        Query targetLogicQuery = new Query(Criteria.where("code").is(mechanismLogicCode).and("tenantId").is(targetTenantId));
                        Update update = new Update();
                        sMechanismLogic.forEach(update::set);
                        update.set("tenantId", targetTenantId);
                        UpdateResult updateResult = mongoTemplate2.upsert(targetLogicQuery, update, "mechanismLogic");
                        Map<String, UpdateResult> resultMap = new HashMap<>();
                        resultMap.put(mechanismLogicCode, updateResult);
                        mechanismLogicResults.add(resultMap);
                    }
                    mechanismLogicMap.put("mechanismLogic", mechanismLogicResults);
                    mechanismResults.add(mechanismLogicMap);
                }
                results.put(mechanismCode, mechanismResults);
            }
        }

        return results;
    }

    @Override
    public Object postParadigmAndMechanismByApp(String appCode, OperationUnit operationUnit, Boolean queryWithEocLevel) throws Exception {
        log.info("getMechanismByApp appCode:{},operationUnit:{}， queryWithEocLevel:{}", appCode, JSON.toJSONString(operationUnit), queryWithEocLevel);
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria;
        if (queryWithEocLevel) {
            String eocLevel = operationUnitService.getEocLevel(operationUnit);
            criteria = Criteria.where("application").is(appCode).and("eocLevel").is(eocLevel).and("version").is(tenantVersion);
        } else {
            criteria = Criteria.where("application").is(appCode).and("version").is(tenantVersion);
        }

        query.addCriteria(criteria);
        Criteria tenantCriteria = new Criteria().andOperator(Criteria.where("code").is(appCode),
                Criteria.where("tenantId").is(tenantId));
        query.fields().include("value");
        JSONObject mechanismTenantParadigm = this.mongoTemplate2.findOne(Query.query(tenantCriteria), JSONObject.class, MECHANISM_TENANT_PARADIGM);
        List<Mechanism> mechanisms = dataPickService.find(criteria, Mechanism.class, "mechanism");
        if (mechanismTenantParadigm != null && mechanismTenantParadigm.containsKey("value")) {
            JSONArray values = mechanismTenantParadigm.getJSONArray("value");
            if (!CollectionUtils.isEmpty(values)) {
                mechanisms.forEach(mechanism -> {
                    if (values.contains(mechanism.getCode())) {
                        mechanism.setParadigmChecked(true);
                    }
                });
            }

        }
        Map<String, Object> result = new HashMap<>();
        result.put("mechanisms", mechanisms);
        //查询应用code下的范式集合数据
        List<ApplicationRelation> paradigmByTypeAndAppCode = appService.getParadigmByTypeAndAppCode(ComponentConstants.PARADIGM, appCode);
        if (!CollectionUtils.isEmpty(paradigmByTypeAndAppCode)) {
            result.put("paradigms", paradigmByTypeAndAppCode.stream().map(ApplicationRelation::getCode).collect(Collectors.toList()));
        } else {
            result.put("paradigms", new ArrayList<>());
        }
        return result;
    }
}