package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.kg.report.hz.model.standardParams.PermissionSchemas;
import com.digiwin.athena.kg.report.hz.model.standardParams.StandardParams;
import com.digiwin.athena.kg.report.hz.model.standardParams.StandardParamsDTO;
import com.digiwin.athena.knowledgegraph.dto.report.ReportSceneDTOs;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import com.digiwin.athena.knowledgegraph.service.IParameterService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import io.seata.common.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.*;

@Lang
@Service
@Slf4j
@MyExceptionHandler
public class ParameterService implements IParameterService {
    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    SceneService sceneService;

    public static final List<String> OPERATOR_TYPE =  Arrays.asList("eq", "ne", "like", "rl", "nrl", "ll", "nll", "gt", "gte", "lt", "lte", "between", "in", "nin", "null", "nn");

    @Override
    public Object getParameter(String appCode, String tenantId) {
        String tenantVersion = "1.0";
        PermissionSchemas permissionSchemas = new PermissionSchemas();
        if (StringUtils.isNotBlank(tenantId)) {
            tenantVersion = kgInnerService.getTenantVersion(tenantId);
        }

        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("version").is(tenantVersion)
                .and("application").is(appCode)
                .and("data_type").is("string");
        query.addCriteria(criteria);
        List<StandardParams> standardParams = mongoTemplate.find(query, StandardParams.class);

        if (CollectionUtils.isEmpty(standardParams)) {
            return Collections.singletonList(permissionSchemas);
        }

        List<StandardParamsDTO> standardParamsDTOS = new ArrayList<>();
        standardParams.forEach(item -> {
            standardParamsDTOS.add(StandardParamsDTO.builder()
                    .id(item.getData_name())
                    .name(item.getName())
                    .dataType(item.getData_type())
                    .dataSource("api")
                    .filterType(item.getOperator()).build());
        });
        permissionSchemas.setFields(standardParamsDTOS);
        return Collections.singletonList(permissionSchemas);
    }

    @Override
    public Object getParameter(String appId, String tenantId, String moduleId, String actionId) throws DWBusinessException {
        KgFilter.getLoginInfo().setTenantId(tenantId);
        String tenantVersion = "1.0";
        PermissionSchemas permissionSchemas = new PermissionSchemas();
        if (StringUtils.isNotBlank(tenantId)) {
            tenantVersion = kgInnerService.getTenantVersion(tenantId);
        }
        ReportSceneDTOs dataSet = mongoTemplate.findOne(Query.query(Criteria.where("version").is(tenantVersion).and("appCode").is(appId).and("code").is(actionId)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if(Objects.isNull(dataSet)) {
            ReportSceneDTO reportScene = sceneService.querySceneMaps(Collections.singletonList(actionId), tenantVersion);
            if (Objects.isNull(reportScene) || !Objects.equals(reportScene.getViewType(), "dataset")) {
                Query query = new Query();
                Criteria criteria = new Criteria();
                criteria.and("version").is(tenantVersion)
                        .and("application").is(appId)
                        .and("data_type").is("string");
                query.addCriteria(criteria);
                List<StandardParams> standardParams = mongoTemplate.find(query, StandardParams.class);

                if (CollectionUtils.isEmpty(standardParams)) {
                    return Collections.singletonList(permissionSchemas);
                }

                List<StandardParamsDTO> standardParamsDTOS = new ArrayList<>();
                standardParams.forEach(item -> {
                    standardParamsDTOS.add(StandardParamsDTO.builder()
                            .id(item.getData_name())
                            .name(item.getName())
                            .dataType(item.getData_type())
                            .dataSource("api")
                            .filterType(item.getOperator()).build());
                });
                permissionSchemas.setFields(standardParamsDTOS);
            } else {
                List<Object> fieldSchemas = reportScene.getFieldSchema();

                List<StandardParamsDTO> standardParamsDTOS = new ArrayList<>();

                for (Object fieldSchema : fieldSchemas) {
                    Map item = (Map) fieldSchema;
                    standardParamsDTOS.add(StandardParamsDTO.builder()
                            .id(item.get("name").toString())
                            .name(item.get("title").toString())
                            .dataType(item.get("dataType").toString())
                            .dataSource("api")
                            .filterType(OPERATOR_TYPE).build());
                }
                permissionSchemas.setFields(standardParamsDTOS);
                permissionSchemas.setName(reportScene.getSceneTitle());
                permissionSchemas.setId(reportScene.getCode());
            }

        }else { // 敏数旗舰版应用获取数据集
            List<Object> dimensions = dataSet.getDimensions();
            dimensions.addAll(dataSet.getMeasures());

            List<StandardParamsDTO> standardParamsDTOS = new ArrayList<>();

            for (Object dimension : dimensions) {
                Map item = (Map) dimension;
                standardParamsDTOS.add(StandardParamsDTO.builder()
                        .id(item.get("data_name").toString())
                        .name(item.getOrDefault("name","").toString())
                        .dataType(item.get("data_type").toString())
                        .dataSource("api")
                        .filterType(OPERATOR_TYPE).build());
            }
            permissionSchemas.setFields(standardParamsDTOS);
            permissionSchemas.setName(dataSet.getName());
            permissionSchemas.setId(dataSet.getCode());
        }
        return Collections.singletonList(permissionSchemas);
    }
}
