package com.digiwin.athena.knowledgegraph.service.impl;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.knowledgegraph.domain.Product;
import com.digiwin.athena.knowledgegraph.service.IProductService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Lang
@Slf4j
@Service
public class ProductService implements IProductService {

    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplate;

    @Override
    public Object getAllSteadyProduct() throws DWBusinessException {
//        List<String> names = new ArrayList<>();
        Query query = new Query();
        query.fields().include("product");
        List<Product> products = this.mongoTemplate.find(query, Product.class);
/*        products.forEach(r->{
            names.add(r.getProduct());
        });*/
        return products.stream()
                .map(Product::getProduct)
                .distinct()
                .collect(Collectors.toList());
    }

    @Override
    public Object getSteadyProduct(String productCode) throws DWBusinessException {
        Query query = new Query();
        Criteria criteria = Criteria.where("product").is(productCode);
        query.addCriteria(criteria);
        Product product = this.mongoTemplate.findOne(query, Product.class);
        return product;
    }


}
