package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfigDTO.BkInfo;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfigDTO;
import com.digiwin.athena.knowledgegraph.service.IScreenService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

@Lang
@Slf4j
@Service
@MyExceptionHandler
public class ScreenService implements IScreenService {

    @Autowired
    private IamService iamService;

    @Autowired
    CACUtils cacUtils;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    SceneService sceneService;

    @Autowired
    TenantService tenantService;

    @Autowired
    SectorService sectorService;

    public static final String FAIL_MSG = "fail";

    public static final String SUCCESS_MSG = "success";

    // 查询用户授权敏捷数据应用的鼎捷云授权
    @Override
    public List<String> getUserPermissionScreen(List<String> type) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        List<Application> applications = tenantService.getUserMetricApplication();
        List<String> appCodes = applications.stream().map(Application::getCode).collect(Collectors.toList());
        Map<String, Object> userPermission = iamService.batchQueryUserAppPermission(appCodes, userId);
        return resolvePermission(userPermission,type);
    }

    @Override
    public List<String> getUserPermissionScreen(String userId,List<String> type, List<String> appCodes) throws DWBusinessException {
        if (StringUtils.isEmpty(userId)) {
            userId = AthenaUtils.getUserId();
        }
        Map<String, Object> userPermission = iamService.batchQueryUserAppPermission(appCodes, userId);
        return resolvePermission(userPermission,type);
    }

    // 根据租户和应用查询大屏场景
    @Override
    public List<ReportSceneDTO> postQuerySceneByApp(List<String> appCodes) throws Exception {
        List<ReportSceneDTO> reportScenes = new ArrayList<>();
        if (CollectionUtils.isEmpty(appCodes)) {
            return reportScenes;
        }

        String tenantVersion = kgInnerService.currentTenantVersion();
        // 根据应用和版本查询大屏场景
        return sceneService.querySceneByAppAndTag(appCodes,"screen",tenantVersion);
    }


    private List<String> resolvePermission(Map<String, Object> userPermission,List<String> type){
        List<String> result = new ArrayList<>();

        for (Map.Entry<String, Object> permission : userPermission.entrySet()) {

            JSONObject responseJson = JSONObject.parseObject(JSON.toJSONString(permission.getValue()));
            String code = responseJson.getString("code");
            if(!"200".equals(code) ){  //查询权限异常，则无权限
                continue;
            }

            JSONArray permissions = responseJson.getJSONArray("data");
            for(int i = 0; i < permissions.size(); i++) {
                JSONObject permissionJson = permissions.getJSONObject(i);
                String effect = permissionJson.getString("effect");
                String moduleId = permissionJson.getString("moduleId");
                String id = permissionJson.getString("id");

                if(Objects.equals("allow", effect)
                        /*&& !CollectionUtils.isEmpty(type)
                        && type.contains(moduleId)*/
                        && StringUtils.isNotEmpty(id)){
                    result.add(id);
                }

                /*JSONObject conditions = permissionJson.getJSONObject("conditions");
                String dbTarget = permissionJson.getString("target");*/
//                if (StringUtils.equals(dbTarget, USER_PERMISSION_TARGET_PREFIX + appCode + ":" + target)) {  //如果不是对应的模组，则跳过

/*                    if(StringUtils.isNotEmpty(conditionKey)){
                        JSONObject moduleJsonObject = conditions.getJSONObject(USER_PERMISSION_TARGET_PREFIX + appCode + ":" + target);
                        if(moduleJsonObject == null){
                            continue;
                        }else{
                            String psermissionResult = moduleJsonObject.getString(conditionKey);
                            return StringUtils.equals("allow", psermissionResult);
                        }
                    }*/

//                }

            }
        }

        return result;
    }


    @Override
    public Object postAddUserScreen(UserScreenConfigDTO config) throws Exception {
        if (ObjectUtils.isEmpty(config)) {
            return FAIL_MSG;
        }
        String userId = AthenaUtils.getUserId();
        Query queryExists = Query.query(Criteria
                .where("name").is(config.getName())
                .and("userId").is(userId)
                .and("code").ne(config.getCode()));

        boolean result = mongoTemplateUser.exists(queryExists, UserScreenConfig.class);
        if (result) {
            String currentLocale = AthenaUtils.getCurrentLocale();
            if (Objects.equals("zh_TW", currentLocale)) {
                throw new DWBusinessException("P.KG.500.99999", "看板名稱已存在");
            }
            throw new DWBusinessException("P.KG.500.99999", "看板名称已存在");
        }

        Date now = null;
        if (StringUtils.isEmpty(config.getCode())) {
            now = new Date();
            config.setCode("userScreen_" + UUID.randomUUID().toString().replace("-", ""));
        }

        List<BkInfo> bkInfo =config.getBkInfo();
        if (CollectionUtils.isEmpty(bkInfo)) {
            return FAIL_MSG;
        }

        String actionIds = bkInfo.stream()
                .map(BkInfo::getActionId)
                .distinct()
                .collect(Collectors.joining(","));
        String bkCodes = bkInfo.stream()
                .map(BkInfo::getBkCode)
                .distinct()
                .collect(Collectors.joining(","));

        Query query = Query.query(Criteria
                .where("code").is(config.getCode())
                .and("userId").is(userId));

        Update update = new Update()
                .set("code", config.getCode())
                .set("name", config.getName())
                .set("actionId", actionIds)
                .set("bkCode", bkCodes)
                .set("layoutId", config.getLayoutId())
                .set("tenantId", config.getTenantId())
                .set("bkInfo", bkInfo)
//                .set("createDate", new Date())
                .set("userId", userId);
        if (!ObjectUtils.isEmpty(now)) {
            update.set("createDate", new Date());
        }
        mongoTemplateUser.bulkOps(BulkOperations.BulkMode.UNORDERED, UserScreenConfig.class)
                .upsert(query, update)
                .execute();

        return SUCCESS_MSG;
    }

    @Override
    public Object postDeleteUserScreen(List<String> codes) throws Exception {
        if (CollectionUtils.isEmpty(codes)) {
            return FAIL_MSG;
        }
        Query query = Query.query(Criteria
                .where("code").in(codes)
                .and("userId").is(AthenaUtils.getUserId()));
        mongoTemplateUser.remove(query, UserScreenConfig.class);
        return SUCCESS_MSG;
    }

    @Override
    public UserScreenConfig postQueryUserScreen(String code) throws Exception {
        Query query = Query.query(Criteria
                .where("code").is(code)
                .and("userId").is(AthenaUtils.getUserId()));
        return mongoTemplateUser.findOne(query, UserScreenConfig.class);
    }


    @Override
    public Object postQueryUserScreenByCode(String code) throws Exception {
        UserScreenConfig userScreen = this.postQueryUserScreen(code);
        if (ObjectUtils.isEmpty(userScreen)) {
            return null;
        }
        return sectorService.getReportSceneByBkCode(AthenaUtils.getTenantId(), userScreen);
    }
}
