package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.kg.monitorRule.secondCalculate.QueryStepDTO;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfigDTO;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.aspect.MyExceptionHandler;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.service.ISectorService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Lang
@Slf4j
@Service
@MyExceptionHandler
public class SectorService implements ISectorService {

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    CACUtils cacUtils;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    SceneService sceneService;

    /*
     * @description: 查询用户授权应用的板块
     */
    @Override
    public Object getUserSectors() throws Exception {
        String userId = AthenaUtils.getUserId();
        List<String> appCodes = cacUtils.getAppAuth(userId);
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyList();
        }
        String tenantVersion = kgInnerService.currentTenantVersion();
        Criteria criteria = Criteria.where("version").is(tenantVersion).and("appCode").in(appCodes);
        Query query = new Query(criteria);
        List<Map> userSectorList = mongoTemplate.find(query, Map.class,"agiledata_section_config");
        if (CollectionUtils.isEmpty(userSectorList)) {
            return Collections.emptyList();
        }

        return sceneService.getTranslateContent(userSectorList);
    }

    public List<Map> getSectorByCode(List<String> bkCodes,String tenantVersion) {
        Criteria criteria = Criteria.where("version").is(tenantVersion).and("bkCode").in(bkCodes);
        Query query = new Query(criteria);
        List<Map> userSectorList = mongoTemplate.find(query, Map.class,"agiledata_section_config");
        if (CollectionUtils.isEmpty(userSectorList)) {
            return Collections.emptyList();
        }
        return userSectorList;
    }

    public ReportSceneDTO getReportSceneByBkCode(String tenantId,UserScreenConfig userScreen) {
        List<String> bkCodes = Arrays.asList(userScreen.getBkCode().split(","));
        String tenantVersion = kgInnerService.currentTenantVersion();
        List<Map> userSectorList = this.getSectorByCode(bkCodes,tenantVersion);
        if (CollectionUtils.isEmpty(userSectorList)) {
            return null;
        }
        // 提取showType集合
        /*List<Object> showTypeList = userSectorList.stream()
                .map(map -> map.get("showType"))
                .filter(Objects::nonNull)
                .collect(Collectors.toList());*/

        // 提取show集合
        /*List<Object> showList = userSectorList.stream()
                .map(map ->  map.get("show"))
                .filter(Objects::nonNull)
                .collect(Collectors.toList());*/

        List<Object> showList = new ArrayList<>();

        List<Object> showTypeList = new ArrayList<>();

        for (Object o : userSectorList) {
            Map<String, Object> jsonObject = (Map) o;
            if (Objects.nonNull(jsonObject.get("show"))) {
                showList.addAll((Collection<?>) jsonObject.get("show"));
            }
            if (Objects.nonNull(jsonObject.get("showType"))) {
                showTypeList.addAll((Collection<?>) jsonObject.get("showType"));
            }
        }

        // 提取recast
        List<Object> recastList = userSectorList.stream()
                .map(map -> map.get("recast"))
                .filter(Objects::nonNull)
                .collect(Collectors.toList());
        Map<String, List<QueryStepDTO>> result = new HashMap<>();
        for (Object o : recastList) {
            Map<String, Object> jsonObject = (Map) o;
            for (String key : jsonObject.keySet()) {
                result.put(key, (List<QueryStepDTO>) jsonObject.get(key));
            }
        }

        List<String> appCodes = userSectorList.stream()
                .map(map -> map.get("appCode"))
                .filter(Objects::nonNull)
                .map(Object::toString)
                .collect(Collectors.toList());

        List<Object> bkInfo = userScreen.getBkInfo();

        Map<String, String> userSectorMap = userSectorList.stream()
                .collect(Collectors.toMap(
                        map -> (String) map.get("bkCode"),
                        map -> (String) map.get("actionId")
                ));

        Map<String, Object> bkCodeToActionIdMap = bkInfo.stream()
                .map(map -> JSONObject.parseObject(JSON.toJSONString(map), UserScreenConfigDTO.BkInfo.class))
                .collect(Collectors.toMap(
                        UserScreenConfigDTO.BkInfo::getBkCode,
                        map -> {
                            String bkCode = map.getBkCode();
                            return userSectorMap.getOrDefault(bkCode, bkCode);
                        },
                        (existing, replacement) -> existing,
                        LinkedHashMap::new
                ));


        String actionIds = bkCodeToActionIdMap.values().stream()
                .map(Object::toString)
                .collect(Collectors.joining(","));

        ReportSceneDTO reportScene = new ReportSceneDTO();
        //再查租户数据，设置应用级标题和频率等
        BigScreenViewConfig appBigScreenViewConfigs = mongoTemplateUser.findOne(Query.query(Criteria.where("appCode").in(appCodes)
                .and("tenantId").is(tenantId).and("type").is("custom")), BigScreenViewConfig.class);

        if (Objects.nonNull(appBigScreenViewConfigs)) {
            reportScene.setFlashFrequency(Optional.ofNullable(appBigScreenViewConfigs.getFlashFrequency()).orElse(5));
            reportScene.setPageTurningFrequency(Optional.ofNullable(appBigScreenViewConfigs.getPageTurningFrequency()).orElse(30));
        }

        reportScene.setCode(userScreen.getCode());
        reportScene.setSceneTitle(userScreen.getName());
        reportScene.setActionId(actionIds);
        reportScene.setShowType(CollectionUtils.isEmpty(showTypeList) ? new ArrayList<>() : showTypeList);
        reportScene.setShow(CollectionUtils.isEmpty(showList) ? new ArrayList<>() : showList);
        reportScene.setViewType("userScreen");
        reportScene.setLayoutId(userScreen.getLayoutId());
        reportScene.setBkInfo(bkInfo);
        reportScene.setRecast(result);
        return reportScene;
    }
}
