package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.domain.component.bo.ComponentStructuredListType;
import com.digiwin.athena.domain.log.OperationRecord;
import com.digiwin.athena.domain.log.OperationRecordType;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import com.digiwin.athena.knowledgegraph.action.dao.TenantServiceConfigDAO;
import com.digiwin.athena.kmservice.action.execution.ProductNameResolver;
import com.digiwin.athena.knowledgegraph.app.LicenseKeyManager;
import com.digiwin.athena.knowledgegraph.cache.CacheService;
import com.digiwin.athena.knowledgegraph.clients.CACUtils;
import com.digiwin.athena.knowledgegraph.clients.CacService;
import com.digiwin.athena.knowledgegraph.clients.EocService;
import com.digiwin.athena.kmservice.utils.IAMUtils;
import com.digiwin.athena.knowledgegraph.component.ComponentInitManager;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.knowledgegraph.configuration.ModuleConfiguration;
import com.digiwin.athena.knowledgegraph.constant.ComponentConstants;
import com.digiwin.athena.knowledgegraph.constant.Constants;
import com.digiwin.athena.knowledgegraph.domain.*;
import com.digiwin.athena.kg.activity.Activity;
import com.digiwin.athena.domain.core.app.Application;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.knowledgegraph.domain.config.ProductTemplateTenant;
import com.digiwin.athena.knowledgegraph.domain.mechanism.ParadigmInitConfig;
import com.digiwin.athena.knowledgegraph.domain.rule.TenantServiceConfig;
import com.digiwin.athena.knowledgegraph.domain.valueobject.VirtualTenantParams;
import com.digiwin.athena.knowledgegraph.dto.TenantAppNoticeDTO;
import com.digiwin.athena.knowledgegraph.dto.report.ReportSceneDTOs;
import com.digiwin.athena.knowledgegraph.dto.report.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.knowledgegraph.po.InitMonitorRuleParam;
import com.digiwin.athena.knowledgegraph.po.TenantInitParam;
import com.digiwin.athena.knowledgegraph.po.TenantInitResp;
import com.digiwin.athena.knowledgegraph.po.dap.*;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.repository.neo4j.TaskRepository;
import com.digiwin.athena.kg.report.hz.model.sence.BigScreenViewDTO;
import com.digiwin.athena.kg.report.hz.model.sence.PermissionSceneDTO;
import com.digiwin.athena.kg.report.hz.model.sence.ReportSceneDTO;
import com.digiwin.athena.kg.report.hz.model.userScreen.UserScreenConfig;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleManager;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.kg.monitorRule.MonitorRuleTenantConfig;
import com.digiwin.athena.knowledgegraph.service.*;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.kg.monitorRule.EocMapDTO;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.knowledgegraph.synonym.domain.BigScreenViewConfig;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.OperationRecordUtil;
import com.digiwin.athena.knowledgegraph.utils.TenantInitResultUtil;
import com.digiwin.athena.kg.authority.AppAuthorizationsResponse;
import com.digiwin.athena.kg.authority.AppPurchaseInfo;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.transaction.Transaction;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_KNOWLEDGE_GRAPH;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-07-07 09:32
 **/
@Lang
@Slf4j
@Service
public class TenantService implements ITenantService {


    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    SessionFactory sessionFactory;

    @Autowired(required=false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain1;

    @Autowired(required=false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain2;

    @Autowired
    private AppService applicationService;

    @Autowired
    DutyService dutyService;

    @Autowired
    MechanismService mechanismService;

    @Autowired
    CacService cacService;

    @Autowired
    TaskService taskService;

    @Autowired
    TaskRepository taskRepository;

    @Autowired
    AppService appService;
    @Autowired
    LicenseKeyManager licenseKeyManager;
    @Autowired
    ProductNameResolver productNameResolver;
    @Autowired
    IamService iamService;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    MonitorRuleRepository monitorRuleRepository;
    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;
    @Autowired
    OperationUnitService operationUnitService;
    @Autowired
    RedisLock redisLock;
    @Autowired
    CacheService cacheService;
    @Autowired
    ILevelService levelService;
    @Autowired
    ComponentInitManager componentInitManager;
    @Autowired
    IAMUtils iamUtils;
    @Autowired
    RabbitTemplate rabbitTemplate;
    @Autowired
    ComponentManager componentManager;
    @Autowired
    EocService eocService;

    @Autowired
    ATMCService atmcService;

    @Autowired
    IIMService imService;

    @Autowired
    ProductService productService;

    @Autowired
    OperationRecordUtil recordUtil;

    @Autowired
    DataSubscriptionService dataSubscriptionService;

    @Autowired
    CACUtils cacUtils;

    @Autowired
    private TenantServiceConfigDAO tenantServiceConfigDAO;

    @Autowired
    SceneService sceneService;

    @Autowired
    IScreenService  iScreenService;

    @Autowired
    MonitorRuleManager monitorRuleManager;

    @Autowired
    private DataPickService dataPickService;
    @Autowired
    AppMetaCaller appMetaCaller;

    @Autowired
    private ScreenService screenService;

    //private static ThreadLocal<String> tenantVersionHolder = new ThreadLocal<>();

    @Override
    public  List<TenantEntity> getAllTenant() {
        RespTenantEntityList respTenantEntity = appMetaCaller.call("/tenant/allTenant","get",null,RespTenantEntityList.class);
        return respTenantEntity.getResponse();
       // return mongoTemplate.find(Query.query(Criteria.where("ifCommon").in(null, false)), TenantEntity.class);
    }

    @Override
    public TenantEntity getTenant(String tenantId) {

        RespTenantEntity respTenantEntity = appMetaCaller.call("/tenant/tenant","get",AppMetaCaller.of("tenantId",tenantId),RespTenantEntity.class);
        return respTenantEntity.getResponse();
      //  return mongoTemplate.findOne(new Query(Criteria.where("tenantId").is(tenantId)), TenantEntity.class);
    }

    @Override
    // @Cache(key = "TenantVersion$0", namespace = REDIS_KNOWLEDGE_GRAPH, ttlSecs = 86400)
    public String getTenantVersion(String tenantId) {
        return kgInnerService.getTenantVersion(tenantId);
    }


    @Override
    public Object postConnectVirtualTenantToNodes(VirtualTenantParams virtualTenantParams) throws DWArgumentException {
//        String application = virtualTenantParams.getApplication();
//        String appVersion = virtualTenantParams.getAppVersion();
//        String tenantVersion = virtualTenantParams.getTenantVersion();
//        AppEntity appEntity;
//        if ("espCommon".equals(application)) {
//            appEntity = new AppEntity();
//            appEntity.setNamespace("espCommon");
//            appEntity.setCommonApp(true);
//        } else {
//            appEntity = repository.appEntity(application);
//        }
//        if (appEntity == null || StringUtils.isEmpty(appEntity.getNamespace()) || null == appEntity.getCommonApp() || !appEntity.getCommonApp()) {
//            log.error("appEntity节点不存在或者appEntity节点中nameSpace为空，或非公共应用，请先创建后再初始化!");
//            throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist"));
//        }
//        String appNameSpace = appEntity.getNamespace();
//        createVirtualRelation(sessionFactoryDomain1, appNameSpace, application, appVersion, tenantVersion);
//        createVirtualRelation(sessionFactoryDomain2, appNameSpace, application, appVersion, tenantVersion);
        return null;
    }

    private Application getApplication(String appCode) throws DWBusinessException {
        Application application;
        if ("espCommon".equals(appCode)) {
            application = new Application();
            application.setCode("espCommon");
            application.setCommonApp(true);
        } else {
            application = appService.getApplicationByCode(appCode);
        }
        if (application == null ||  null == application.getCommonApp() || !application.getCommonApp()) {
            log.error("appEntity节点不存在或者appEntity节点中nameSpace为空，或非公共应用，请先创建后再初始化!");
            throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist"));
        }
        return application;
    }

    private void createVirtualRelation(SessionFactory sessionFactory, String appNameSpace, String application, String appVersion, String tenantVersion) throws DWArgumentException {
        if(sessionFactory == null){
            return;
        }
        List<TenantEntity> tenantEntities = mongoTemplate.find(new Query(Criteria.where("version").is(tenantVersion).and("ifCommon").in(null, false)), TenantEntity.class);
        Session session = sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        //查询common应用的nameSpace
        //根据nameSpace查询所有对应版本的Activity,Action,Monitor进行关联
        try {
            session.query("match (te:TenantEntity{ifCommon:true,version:'" + tenantVersion + "'}) " +
                    "match (monitorRule:MonitorRule) where monitorRule.version='" + appVersion + "' " +
                    "and (monitorRule.nameSpace='" + appNameSpace + "' or monitorRule.athena_namespace = '" + application + "' " +
                    "or monitorRule.relation_namespace = '" + appNameSpace + "') and (monitorRule.inclusionTenant is null and monitorRule.notInclusionTenant is null) " +
                    "merge (te)-[:USE]->(monitorRule)", new HashMap<>());
            session.query("match (te:TenantEntity{ifCommon:true,version:'" + tenantVersion + "'}) " +
                    "match (activity:Activity) where activity.version='" + appVersion + "' " +
                    "and (activity.nameSpace='" + appNameSpace + "' or activity.athena_namespace = '" + application + "' " +
                    "or activity.relation_namespace = '" + appNameSpace + "') and (activity.inclusionTenant is null and activity.notInclusionTenant is null) " +
                    "merge (te)-[:ACTIVITY]->(activity)", new HashMap<>());
            session.query("match (te:TenantEntity{ifCommon:true,version:'" + tenantVersion + "'}) " +
                    "match (action:Action) where action.version='" + appVersion + "' " +
                    "and (action.nameSpace='" + appNameSpace + "' or action.athena_namespace = '" + application + "' " +
                    "or action.relation_namespace = '" + appNameSpace + "') and (action.inclusionTenant is null and action.notInclusionTenant is null) " +
                    "merge (te)-[:ACTION]->(action)", new HashMap<>());
            List<String> tenantIdList = tenantEntities.stream().filter(e -> StringUtils.isNotEmpty(e.getTenantId()))
                    .map(TenantEntity::getTenantId).distinct().collect(Collectors.toList());
            Map<String, Object> params = new HashMap<>();
            params.put("tenantIdList", tenantIdList);
            //个案处理
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'}) where te.tenantId in $tenantIdList " +
                    " match (monitorRule:MonitorRule) where monitorRule.version='" + appVersion + "' " +
                    "and (monitorRule.nameSpace='" + appNameSpace + "' or monitorRule.athena_namespace = '" + application + "' " +
                    "or monitorRule.relation_namespace = '" + appNameSpace + "') " +
                    "and ((monitorRule.inclusionTenant is not null and te.tenantId in monitorRule.inclusionTenant) or " +
                    "(monitorRule.notInclusionTenant is not null and not te.tenantId in monitorRule.notInclusionTenant)) " +
                    "merge (te)-[:USE]->(monitorRule)", params);
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'}) where te.tenantId in $tenantIdList " +
                    "match (activity:Activity) where activity.version='" + appVersion + "' " +
                    "and (activity.nameSpace='" + appNameSpace + "' or activity.athena_namespace = '" + application + "' " +
                    "or activity.relation_namespace = '" + appNameSpace + "') " +
                    "and ((activity.inclusionTenant is not null and te.tenantId in activity.inclusionTenant) or " +
                    "(activity.notInclusionTenant is not null and not te.tenantId in activity.notInclusionTenant)) " +
                    "merge (te)-[:ACTIVITY]->(activity)", params);
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'}) where te.tenantId in $tenantIdList " +
                    "match (action:Action) where action.version='" + appVersion + "' " +
                    "and (action.nameSpace='" + appNameSpace + "' or action.athena_namespace = '" + application + "' " +
                    "or action.relation_namespace = '" + appNameSpace + "') " +
                    "and ((action.inclusionTenant is not null and te.tenantId in action.inclusionTenant) or " +
                    "(action.notInclusionTenant is not null and not te.tenantId in action.notInclusionTenant)) " +
                    "merge (te)-[:ACTION]->(action)", params);
            transaction.commit();
        } catch (Exception e) {
            // 发生异常时回滚事务
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }finally {
            session.clear();
        }


    }

    @Override
    public Object postDeleteVirtualTenantToNodes(VirtualTenantParams virtualTenantParams) throws DWBusinessException {
        String appCode = virtualTenantParams.getApplication();
        String appVersion = virtualTenantParams.getAppVersion();
        String tenantVersion = virtualTenantParams.getTenantVersion();
        Application application = getApplication(appCode);
        String appNameSpace = application.getCode();
        deleteVirtualRelation(sessionFactoryDomain1, appNameSpace, appCode, appVersion, tenantVersion);
        deleteVirtualRelation(sessionFactoryDomain2, appNameSpace, appCode, appVersion, tenantVersion);
        return null;
    }

    private void deleteVirtualRelation(SessionFactory sessionFactory, String appNameSpace, String application, String appVersion, String tenantVersion) {
        if(sessionFactory == null){
            return;
        }
        Session session = sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        //查询common应用的nameSpace
        //根据nameSpace查询所有对应版本的Activity,Action,Monitor进行关联
        try {
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'})" +
                    "-[r:USE]->(monitorRule:MonitorRule) where monitorRule.version='" + appVersion + "' " +
                    "and (monitorRule.nameSpace='" + appNameSpace + "' or monitorRule.athena_namespace = '" + application + "' " +
                    "or monitorRule.relation_namespace = '" + appNameSpace + "') " +
                    "DELETE r", new HashMap<>());
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'})" +
                    "-[r:ACTIVITY]->(activity:Activity) where activity.version='" + appVersion + "' " +
                    "and (activity.nameSpace='" + appNameSpace + "' or activity.athena_namespace = '" + application + "' " +
                    "or activity.relation_namespace = '" + appNameSpace + "') " +
                    "DELETE r", new HashMap<>());
            session.query("match (te:TenantEntity{version:'" + tenantVersion + "'})" +
                    "-[r:ACTION]->(action:Action) where action.version='" + appVersion + "' " +
                    "and (action.nameSpace='" + appNameSpace + "' or action.athena_namespace = '" + application + "' " +
                    "or action.relation_namespace = '" + appNameSpace + "') " +
                    "DELETE r", new HashMap<>());
            transaction.commit();
        } catch (Exception e) {
            // 发生异常时回滚事务
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }finally {
            session.clear();
        }
    }


    private List<String> findTemplateTenant(List<String> products, String appCode){
        log.info("findTemplateTenant appCode:{}, products:{}", appCode, products);
        if(CollectionUtils.isEmpty(products)){
            return null;
        }
        List<String> resultList = new ArrayList<>();
        Set<String> existTenant = new HashSet<>();
        Query query = new Query();
        query.addCriteria(Criteria.where("app").is(appCode));
        List<ProductTemplateTenant> templateTenants = mongoTemplate.find(query, ProductTemplateTenant.class);
        if(CollectionUtils.isEmpty(templateTenants)){
            return null;
        }
        Map<String, String> collect = templateTenants.stream().collect(Collectors.toMap(ProductTemplateTenant::getProduct, ProductTemplateTenant::getTenantId));
        for(String str : products){
            String s = collect.get(str);
            if(StringUtils.isNotEmpty(s) && !existTenant.contains(s)){
                resultList.add(s);
                existTenant.add(s);
            }
        }
        return resultList;
    }

    private List<String> findTemplateTenant(String product, String appCode){
        log.info("findTemplateTenant appCode:{}, product:{}", appCode, product);
        if(StringUtils.isEmpty(product)){
            return null;
        }
        List<String> resultList = new ArrayList<>();
        Query query = new Query();
        query.addCriteria(Criteria.where("app").is(appCode).and("product").is(product));
        List<ProductTemplateTenant> templateTenants = mongoTemplate.find(query, ProductTemplateTenant.class);
        if(CollectionUtils.isEmpty(templateTenants)){
            return null;
        }
        resultList.add(templateTenants.get(0).getTenantId());
        return resultList;
    }



    @Override
    public Object postInitTenantInfoV2(TenantInitParam param) throws DWBusinessException {

        TenantInitResp resp = new TenantInitResp();
        if (StringUtils.isEmpty(param.getTenantId()) || StringUtils.isEmpty(param.getAppCode())) {
            throw new DWBusinessException("param", I18nUtils.getValue("knowledgegraph.tenantOrAppCodeEmpty"));
        }
        String initType = param.getInitType();
        Short initPartFlag = param.getInitPartFlag() == null ? 1 : param.getInitPartFlag();

        String tenantId = param.getTenantId();
        // 分布式锁key增加redis规范appId前缀
        String tenantInitLockKey = ComponentConstants.REDIS_KNOWLEDGE_GRAPH + ":tenantInitLock:" + tenantId;
        String tenantInitLock = null;
        try {
            //保证一个租户同一时间只会对一个应用进行初始化，避免同一个租户并发的时候，数据异常
            while ((tenantInitLock = redisLock.tryLock(tenantInitLockKey, 2 * 60 * 1000)) == null) {
                log.info("当前租户:{}正在初始化其他应用的数据，等待...", tenantId);
                try {
                    TimeUnit.SECONDS.sleep(5);
                 }catch (InterruptedException e) {
                    log.error("租户初始化等待异常：{}", e.getMessage());
                    // Restore interrupted state...
                    Thread.currentThread().interrupt();
                }
            }

            //判断是否是第一次初始化
            List<String> initializedApps = dataPickService.tenantInitializedAppCodes(tenantId);
            boolean isFirstInit = CollectionUtils.isEmpty(initializedApps);
            log.info("开始进行初始化租户:" + tenantId);
            String appCode = param.getAppCode();
            Application application = appService.getApplicationByCode(appCode,tenantId);
            if (application == null) {
                log.error("appEntity节点不存在或者appEntity节点中nameSpace为空，请先创建后再初始化!");
                throw new DWArgumentException("appEntity", I18nUtils.getValue("knowledgegraph.appEntity.notExist"));
            }
            String appNameSpace = application.getCode();
//            String version = appEntity.getVersion();
            //modify for 开发平台切版，当是新租户时，直接设置版本号为2.0, 当是老租户，版本号保持不变
            String version = null;
            TenantEntity tenant = this.getTenant(tenantId);
            if(tenant == null){
                version = "2.0";
            }else{
                version = tenant.getVersion();
            }

            Object loginResponse = null;
            String tenantToken = null;
            try {
                loginResponse = this.iamService.login(tenantId);
                tenantToken = this.iamService.getTenantToken(tenantId, loginResponse);
            } catch (Exception e) {
                log.error("初始化租户:{}获取token出错，出错原因：{}", tenantId, e.toString());
            }

            log.info("通过应用地端产品查找模板租户信息");
            List<String> templateTenant = null;
            List<String> cloudProductNamesWithRetry = null;
            if (StringUtils.isEmpty(param.getProduct())) {
                try {
                    DWServiceContext.getContext().getRequestHeader().put("token", tenantToken);
                    cloudProductNamesWithRetry = this.productNameResolver.getCloudProductNamesWithRetry(tenantId, 3);
                } catch (Exception e) {
                    log.error(e.toString());
                    throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.searchProductFail"));
                }
                templateTenant = this.findTemplateTenant(cloudProductNamesWithRetry, param.getAppCode());
            } else {
                templateTenant = this.findTemplateTenant(param.getProduct(), param.getAppCode());
                cloudProductNamesWithRetry = Arrays.asList(param.getProduct());
            }
            log.info("通过应用地端产品查找模板租户信息:{}", templateTenant);
            resp.setTemplateTenantIds(templateTenant);
            if(CollectionUtils.isEmpty(templateTenant) || templateTenant.size() > 1){
                //没找到或找到多个
                initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_NO_FLOW_TEMPLATE);
            }else{
                initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_NO_FLOW_TEMPLATE);
            }


            createTenantAppRelation(tenantId,param.getTenantName(),version,appCode,param.getCustomerServiceCode());
              if (StringUtils.equals(param.getInitType(), "RENEW") ) { //如果只需同步流程,则查到模板信息后直接返回
                //删除租户的应用缓存
                this.deleteTenantAppCodeCache(tenantId);

                log.info("==========create neo4j entity==========");


                //初始化租户的licenseKey信息 z
                final String directLicenseKey = this.licenseKeyManager.getDirectLicenseKeyCanNull(tenantId);
                if (StringUtils.isEmpty(directLicenseKey)) {
                    log.info("初始化租户:{}的licenseKey信息", tenantId);
                    try {
                        appService.postSetLicenseKey(tenantId);
                    } catch (Exception e) {
                        log.error("set LicenseKey error:{}", e);
//                throw new DWBusinessException("set LicenseKey error:" + e.getMessage());
                    }
                }


//                this.createNeo4jEntity(sessionFactoryDomain1, tenantId, version, appNameSpace, appCode, param.getTenantName(), param.getCustomerServiceCode());
//                log.info("==========finishCreateNeo4jEntityForDomain1==========");
//                this.createNeo4jEntity(sessionFactoryDomain2, tenantId, version, appNameSpace, appCode, param.getTenantName(), param.getCustomerServiceCode());
//                log.info("==========finishCreateNeo4jEntityForDomain2==========");
//                //neo4j-租户
//                log.info("==========finishCreateNeo4jEntity==========");

                initTenantParadigm(appCode, tenantId);
            }



            //创建需要自动启用的侦测
            if(TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_INIT_MONITORRULE)) {
                try {
                    int initMonitorRuleResult = this.initMonitorRule(cloudProductNamesWithRetry, param.getAppCode(), param.getTenantId(), version);
                    if(initMonitorRuleResult < 0){ // initMonitorRuleResult < 0 表示有报错
                        initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_MONITORRULE);
                    }else{
                        initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_MONITORRULE);
                    }
                } catch (Exception e) {
                    initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_MONITORRULE);
                    log.error("初始化租户:{}侦测出错，出错原因:{}", tenantId, e.toString());
                }
            }

//            if (StringUtils.equals(param.getInitType(), "ONLY_FLOW")) {
//                return resp;
//            }



            //同步共通职能
            if(TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_SYNC_DUTY)) {
                try {
//                String tenantToken = this.iamService.getTenantToken(tenantId);
                    //暂不需要,判断是否是个人租户
                    //if (!judgeIfPersonalTenant(tenantToken)) {
                    log.info("初始化租户:{}的共通职能信息", tenantId);
                    //同步共通职能
                    dutyService.syncAllDuty(tenantToken, appCode, tenantId);
                    initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_SYNC_DUTY);
                    //}
                } catch (Exception e) {
                    log.error("初始化租户:{}的共通职能信息出错，出错原因：{}", tenantId, e.toString());
                    initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_SYNC_DUTY);
                }
            }

            //初始化核决层级
            if(TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_SYNC_LEVEL)) {
                try {
                    if (isFirstInit) {
                        levelService.syncDefaultLevel(tenantToken);
                        initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_SYNC_LEVEL);
                    }
                } catch (Exception e) {
                    log.error("初始化租户:{}的核决层级信息出错，出错原因：{}", tenantId, e.toString());
                    initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_SYNC_LEVEL);
                }
            }

            //初始化任务引擎信息
            if(TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_INIT_DATAMAP)) {
                try {
                    Object dataMapResponse;
                    log.info("初始化租户:{}任务引擎信息app:{}", tenantId, appNameSpace);
                    if (StringUtils.isEmpty(param.getRouterKey())) {
                        dataMapResponse = dataMapService.initTenantInfo(tenantId, appNameSpace, null, appCode);
                    } else {
                        dataMapResponse = dataMapService.initTenantInfo(tenantId, appNameSpace, param.getRouterKey(), appCode);
                    }
                    log.info("初始化租户:{}任务引擎信息app:{},result:{}", tenantId, appNameSpace, dataMapResponse);
                    if(dataMapResponse == null){ //返回结果为空，表示datamap未初始化成功
                        initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_DATAMAP);
                    }else{
                        initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_DATAMAP);
                    }
                } catch (Exception e) {
                    initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_INIT_DATAMAP);
                    log.error(e.getMessage(), e);
                }
            }

            //通知开启企业运营
            if(TenantInitResultUtil.needExecute(initType, initPartFlag, TenantInitResultUtil.ERROR_START_ENTERPRISE_OPERATION)) {
                try {
                    String tenantType = this.iamService.getTenantType(tenantId, loginResponse);
                    if (StringUtils.isNotEmpty(tenantType) && !StringUtils.equals(tenantType, "0")) {
                        //排除个人租户，通知开启企业运营
                        log.info("初始化租户:{}开启企业运营", tenantId);
                        this.iamService.startEnterpriseOperation(tenantToken);
                        initPartFlag = TenantInitResultUtil.deductErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_START_ENTERPRISE_OPERATION);
                    }
                } catch (Exception e) {
                    log.error("初始化租户:{}开启企业运营出错，出错原因：{}", tenantId, e.toString());
                    initPartFlag = TenantInitResultUtil.addErrorFlag(initPartFlag, TenantInitResultUtil.ERROR_START_ENTERPRISE_OPERATION);
                }
            }

        } finally {
            if (tenantInitLock != null) {
                log.info("释放锁kgTenantInitLock：{}", tenantInitLock);
                redisLock.unlock(tenantInitLockKey, tenantInitLock);
            }
        }

        resp.setFlag(initPartFlag);
        return resp;

    }

    private boolean judgeIfPersonalTenant(String token) {
        try {
            Integer type = iamUtils.getTenantType(token);
            if (0 == type.intValue()) {
                return true;
            }
            return false;
        } catch (IOException e) {
            return true;
        }
    }

    private void createTenantAppRelation(String tenantId,String tenantName,String version,String appCode,String  customerServiceCode){
        com.digiwin.athena.domain.core.tenant.TenantEntity entity = mongoTemplate.findOne(new Query(Criteria.where("tenantId").is(tenantId)), com.digiwin.athena.domain.core.tenant.TenantEntity.class);
        TenantAppRelation tenantAppRelation = mongoTemplate.findOne(new Query(Criteria.where("tenantId").is(tenantId).and("appCode").is(appCode)), TenantAppRelation.class);
        if(null==entity){
            entity = new com.digiwin.athena.domain.core.tenant.TenantEntity();
            entity.setTenantId(tenantId);
            entity.setTenantName(tenantName);
            entity.setVersion(version);
            entity.setCustomerServiceCode(customerServiceCode);
            mongoTemplate.save(entity);
        }else{
            if (null!=customerServiceCode){
                entity.setCustomerServiceCode(customerServiceCode);
                mongoTemplate.save(entity);
            }
        }
        if(null==tenantAppRelation){
            TenantAppRelation relation = new TenantAppRelation();
            relation.setTenantId(tenantId);
            relation.setAppCode(appCode);
            mongoTemplate.save(relation);
        }

    }

    private void removeTenantAppRelation(String tenantId,String appCode){
        mongoTemplate.remove(new Query(Criteria.where("tenantId").is(tenantId).and("appCode").is(appCode)), TenantAppRelation.class);
    }

    private void createNeo4jEntity(SessionFactory sessionFactory, String tenantId, String version, String appNameSpace, String appCode, String tenantName,String  customerServiceCode){
        if(sessionFactory == null){
            return;
        }
        log.info("=========createNeo4jEntity=========");
        Session session = sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        if(StringUtils.isEmpty(customerServiceCode)){
            session.query("merge (te:TenantEntity{tenantId:'" + tenantId + "'}) set te.tenantName = '" + tenantName + "', te.version='" + version + "'", new HashMap<>());
        }else{
            session.query("merge (te:TenantEntity{tenantId:'" + tenantId + "'}) set te.tenantName = '" + tenantName + "', te.version='" + version + "', te.customerServiceCode='" + customerServiceCode + "'", new HashMap<>());
        }
        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match (app:AppEntity{code:'" + appCode + "'}) merge (te)-[:USE]->(app)", new HashMap<>());
      //  session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match (action:Action) where action.nameSpace in['espCommon','common'] and action.version=te.version and action.tenantId is null merge (te)-[:ACTION]->(action)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(task:Task) where task.nameSpace='common' and task.version=te.version merge (te)-[:TASK]->(task)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(task2:Task) where (task2.nameSpace = '" + appNameSpace + "' or task2.athena_namespace = '"+ appCode +"' or task2.relation_namespace = '"+ appNameSpace +"') and task2.version=te.version and task2.tenantId is null and task2.inclusionTenant is null and task2.notInclusionTenant is null merge (te)-[:TASK]->(task2)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(task3:Task) where (task3.nameSpace = '" + appNameSpace + "' or task3.athena_namespace = '"+ appCode +"' or task3.relation_namespace = '"+ appNameSpace +"') and task3.version=te.version and task3.tenantId is not null and task3.tenantId = 'SYSTEM' merge (te)-[:TASK]->(task3)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(task4:Task) where (task4.nameSpace = '" + appNameSpace + "' or task4.athena_namespace = '"+ appCode +"' or task4.relation_namespace = '"+ appNameSpace +"') and task4.version=te.version and task4.inclusionTenant is not null and task4.notInclusionTenant is null and te.tenantId in task4.inclusionTenant   merge (te)-[:TASK]->(task4)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(task5:Task) where (task5.nameSpace = '" + appNameSpace + "' or task5.athena_namespace = '"+ appCode +"' or task5.relation_namespace = '"+ appNameSpace +"') and task5.version=te.version and task5.inclusionTenant is null and task5.notInclusionTenant is not null and not te.tenantId in task5.notInclusionTenant   merge (te)-[:TASK]->(task5)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(activity:Activity) where activity.nameSpace = 'common' and activity.version=te.version merge (te)-[:ACTIVITY]->(activity)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(activity2:Activity) where (activity2.nameSpace = '" + appNameSpace + "' or activity2.athena_namespace = '"+ appCode +"' or activity2.relation_namespace = '"+ appNameSpace +"') and activity2.version=te.version and activity2.inclusionTenant is null and activity2.tenantId is null and activity2.notInclusionTenant is null merge (te)-[:ACTIVITY]->(activity2)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(activity3:Activity) where (activity3.nameSpace = '" + appNameSpace + "' or activity3.athena_namespace = '"+ appCode +"' or activity3.relation_namespace = '"+ appNameSpace +"') and activity3.version=te.version and activity3.tenantId is not null and activity3.tenantId = 'SYSTEM' merge (te)-[:ACTIVITY]->(activity3)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(activity4:Activity) where (activity4.nameSpace = '" + appNameSpace + "' or activity4.athena_namespace = '"+ appCode +"' or activity4.relation_namespace = '"+ appNameSpace +"') and activity4.version=te.version and activity4.inclusionTenant is not null and activity4.notInclusionTenant is null and te.tenantId in activity4.inclusionTenant merge (te)-[:ACTIVITY]->(activity4)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(activity5:Activity) where (activity5.nameSpace = '" + appNameSpace + "' or activity5.athena_namespace = '"+ appCode +"' or activity5.relation_namespace = '"+ appNameSpace +"') and activity5.version=te.version and activity5.inclusionTenant is  null and activity5.notInclusionTenant is not null and not te.tenantId  in activity5.notInclusionTenant merge (te)-[:ACTIVITY]->(activity5)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(me:MechanismOld) where (me.nameSpace = '" + appNameSpace + "' or me.athena_namespace = '"+ appCode +"' or me.relation_namespace = '"+ appNameSpace +"') and me.version=te.version and me.tenantId is null merge (te)-[:MECHANISM]->(me)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(me2:MechanismOld) where (me2.nameSpace = '" + appNameSpace + "' or me2.athena_namespace = '"+ appCode +"' or me2.relation_namespace = '"+ appNameSpace +"')  and me2.version=te.version and me2.tenantId is not null and me2.tenantId = 'SYSTEM' merge (te)-[:MECHANISM]->(me2)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(action2:Action) where (action2.nameSpace = '" + appNameSpace + "' or action2.athena_namespace = '"+ appCode +"'  or action2.relation_namespace = '"+ appNameSpace +"') and action2.version=te.version  and action2.tenantId is null merge (te)-[:ACTION]->(action2)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(action3:Action) where (action3.nameSpace = '" + appNameSpace + "' or action3.athena_namespace = '"+ appCode +"'  or action3.relation_namespace = '"+ appNameSpace +"') and action3.version=te.version  and action3.tenantId is not null and action3.tenantId = 'SYSTEM' merge (te)-[:ACTION]->(action3)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'}) match(monitorRule:MonitorRule) where monitorRule.version=te.version and monitorRule.nameSpace='common' merge (te)-[:USE]->(monitorRule)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'})  match(monitorRule2:MonitorRule) where  monitorRule2.version=te.version and (monitorRule2.nameSpace='" + appNameSpace + "' or monitorRule2.athena_namespace = '"+ appCode +"' or monitorRule2.relation_namespace = '"+ appNameSpace +"') and monitorRule2.inclusionTenant is null and monitorRule2.tenantId is null and monitorRule2.notInclusionTenant is null merge (te)-[:USE]->(monitorRule2)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'})  match(monitorRule3:MonitorRule) where  monitorRule3.version=te.version and (monitorRule3.nameSpace='" + appNameSpace + "' or monitorRule3.athena_namespace = '"+ appCode +"' or monitorRule3.relation_namespace = '"+ appNameSpace +"') and monitorRule3.inclusionTenant is not null and monitorRule3.notInclusionTenant is null and te.tenantId in monitorRule3.inclusionTenant merge (te)-[:USE]->(monitorRule3)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'})  match(monitorRule4:MonitorRule) where  monitorRule4.version=te.version and (monitorRule4.nameSpace='" + appNameSpace + "' or monitorRule4.athena_namespace = '"+ appCode +"' or monitorRule4.relation_namespace = '"+ appNameSpace +"') and monitorRule4.tenantId is not null and monitorRule4.tenantId = 'SYSTEM' merge (te)-[:USE]->(monitorRule4)", new HashMap<>());
//        session.query("match (te:TenantEntity{tenantId:'" + tenantId + "'})  match(monitorRule5:MonitorRule) where  monitorRule5.version=te.version and (monitorRule5.nameSpace='" + appNameSpace + "' or monitorRule5.athena_namespace = '"+ appCode +"' or monitorRule5.relation_namespace = '"+ appNameSpace +"') and monitorRule5.inclusionTenant is  null and monitorRule5.notInclusionTenant is not null and not te.tenantId  in monitorRule5.notInclusionTenant merge (te)-[:USE]->(monitorRule5)", new HashMap<>());
        transaction.commit();
//
//        this.statAfterCreateNeo4jEntity(session, tenantId, version, appNameSpace, appCode);

        session.clear();
    }

    private void statAfterCreateNeo4jEntity(Session session, String tenantId, String version, String appNameSpace, String appCode){
        try {
            Integer cntActivity = session.queryForObject(Integer.class, "match (t:TenantEntity{tenantId:'" + tenantId + "'})-[:ACTIVITY]->(activity:Activity) where activity.nameSpace = '" + appNameSpace + "' or activity.athena_namespace = '"+ appCode +"' or activity.relation_namespace = '"+ appNameSpace +"' and activity.version='"+ version +"' return count(activity)", new HashMap<>());
            Integer cntTask = session.queryForObject(Integer.class, "match (t:TenantEntity{tenantId:'" + tenantId + "'})-[:TASK]->(task:Task) where task.nameSpace = '" + appNameSpace + "' or task.athena_namespace = '"+ appCode +"' or task.relation_namespace = '"+ appNameSpace +"' and task.version='"+ version +"' return count(task)", new HashMap<>());
            Integer cntMR = session.queryForObject(Integer.class, "match (t:TenantEntity{tenantId:'" + tenantId + "'})-[:USE]->(mr:MonitorRule) where mr.nameSpace = '" + appNameSpace + "' or mr.athena_namespace = '"+ appCode +"' or mr.relation_namespace = '"+ appNameSpace +"' and mr.version='"+ version +"' return count(mr)", new HashMap<>());
            Integer cntAction = session.queryForObject(Integer.class, "match (t:TenantEntity{tenantId:'" + tenantId + "'})-[:ACTION]->(action:Action) where action.nameSpace = '" + appNameSpace + "' or action.athena_namespace = '"+ appCode +"' or action.relation_namespace = '"+ appNameSpace +"' and action.version='"+ version +"' return count(action)", new HashMap<>());
            log.info("statAfterCreateNeo4jEntity:{} , activityCnt:{}, TaskCnt:{}, MonitorRuleCnt:{}, ActionCnt:{}",tenantId,cntActivity,cntTask,cntMR,cntAction);
        }catch (Exception e){}


    }

    private void initTenantParadigm(String appCode, String tenantId) throws DWBusinessException {
        log.info("initTenantParadigm appCode:{},tenantId:{}", appCode, tenantId);
        Query query = new Query();
        query.addCriteria(Criteria.where("appCode").is(appCode));
        List<ParadigmInitConfig> paradigmInitConfigList = this.mongoTemplate.find(query, ParadigmInitConfig.class, "paradigmInitConfig");
        if(CollectionUtils.isNotEmpty(paradigmInitConfigList)){
            for(ParadigmInitConfig paradigmInitConfig : paradigmInitConfigList){
                if(StringUtils.isEmpty(paradigmInitConfig.getParadigmCode())){
                    continue;
                }

                Boolean onlyInitAppComponent = paradigmInitConfig.getOnlyInitAppComponent();
                if(BooleanUtils.isTrue(onlyInitAppComponent)){ //如果只初始化范式下应用组件，即不加入机制
                    try {
                        this.componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigmInitConfig.getParadigmCode(), new ArrayList<>());
                    } catch (DWBusinessException e) {
                        log.error("postInitializeTenantApplicationComponentList error:{}", e.getMessage());
                    }
                }else {
                    //查询应用范式下的机制
                    Query query2 = new Query();
                    Criteria criteria = Criteria.where(ComponentManager.APP_CODE).is(appCode)
                            .and(ComponentManager.PARADIGM).is(paradigmInitConfig.getParadigmCode())
                            .and(ComponentManager.TYPE).is(ComponentStructuredListType.Mechanism);
                    query2.addCriteria(criteria);
                    List<ComponentStructuredList> componentStructuredList = dataPickService.find(criteria, tenantId, ComponentStructuredList.class, "componentStructuredList");
                    if (CollectionUtils.isNotEmpty(componentStructuredList)) {
                        List<String> mechanismList = componentStructuredList.stream().filter(e -> !StringUtils.isEmpty(e.getMechanismCode()))
                                .map(ComponentStructuredList::getMechanismCode).collect(Collectors.toList());
                        try {
                            this.componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigmInitConfig.getParadigmCode(), mechanismList);
                        } catch (DWBusinessException e) {
                            log.error("postInitializeTenantApplicationComponentList error:{}", e.getMessage());
                        }
                    }else{
                        try {
                            this.componentManager.InitializeTenantApplicationComponentList(appCode, tenantId, paradigmInitConfig.getParadigmCode(), new ArrayList<>());
                        } catch (DWBusinessException e) {
                            log.error("postInitializeTenantApplicationComponentList error:{}", e.getMessage());
                        }
                    }
                }
            }
        }

    }

    public Object postCleanTenantInfo(TenantInitParam param) throws DWBusinessException {
//        TenantInitResp resp = new TenantInitResp();
//        String tenantId = AthenaUtils.getTenantId();
//        Session session = sessionFactory.openSession();
//        String cleanCypher = "MATCH (n:TenantEntity)  where n.tenantId='"+tenantId+"' detach delete n";
//        session.query(cleanCypher,new HashMap<>());
//        session.clear();
//        mongoTemplateUser.remove(Query.query(Criteria.where("tenant").is(tenantId)),AbsEntityDict.class);
//        return resp;
        RespObject respTenantEntity = appMetaCaller.call("/tenant/cleanTenantInfo","post",AppMetaCaller.of("param",param),RespObject.class);
        return respTenantEntity.getResponse();
    }

    @Override
    public List<String> getAppCodes() throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        return cacService.getAuthorizationsApplication(tenantId);
        RespStringList respTenantEntity = appMetaCaller.call("/tenant/appCodes","get",null,RespStringList.class);
        return respTenantEntity.getResponse();
    }

    /**
     * 根据租户id获取有权限的应用
     * @param tenantId
     * @return
     * @throws DWBusinessException
     */
    @Cache(namespace = REDIS_KNOWLEDGE_GRAPH, key = "getAppCodes$0",  ttlSecs = 86400L)
    public List<String> getAppCodes(String tenantId) throws DWBusinessException {

        return cacService.getAuthorizationsApplication(tenantId);
    }

    private void deleteTenantAppCodeCache(String tenantId){
        log.info("deleteTenantAppCodeCache tenantId:{}", tenantId);
        String key = REDIS_KNOWLEDGE_GRAPH + ":SYSTEM:SYSTEM:zh_CN:getAppCodes$" + tenantId;
        try {
            Object o = this.cacheService.deleteKeys(Collections.singletonList(key));
            log.info("deleteTenantAppCodeCache tenantId:{}, result:{}", tenantId, o);
        } catch (Exception e) {
            log.error(e.toString());
        }
    }


    @Override
    public Object getApps() throws DWBusinessException {
//        String tenantId = AthenaUtils.getTenantId();
//        Object res = cacService.authorizationsTenants(tenantId);
//        if(ObjectUtils.isEmpty(res)){
//            return res;
//        }else{
//            List<Object> objectList = new ArrayList<>();
//            JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(res));
//            for(int i=0; i<jsonArray.size(); i++){
//                JSONObject jsonObject = jsonArray.getJSONObject(i);
//                String code = jsonObject.getString("code");
//                Application applicationInfo = this.appService.getApplicationInfo(code);
//                if(applicationInfo != null){ //能找到应用的定义，则替换名字（为了语系正确）并返回
//                    jsonObject.put("displayName", applicationInfo.getName());
//                    objectList.add(jsonObject);
//                }
//            }
//            return objectList;
//        }


        RespObject respTenantEntity = appMetaCaller.call("/tenant/apps","get",null,RespObject.class);
        return respTenantEntity.getResponse();
    }



    @Override
    public Map<String,Object>  getAllTaskAndActivity() throws Exception {
        Map<String,Object> resp = new HashMap<>();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<String> appCodes = cacService.getAuthorizationsApplication(tenantId);
        List<ApplicationRelation> relations = applicationService.postApplicationRelation(appCodes);
        List<String> codes = new ArrayList<>();
        for(ApplicationRelation r :relations){
            if("task".equals(r.getType())){
                codes.add(r.getCode());
            }
        }

        List<Object> tasks = new ArrayList<>();
        for(String code:codes){
            Object t = taskService.getDefinitionWithMultiLanguage(code);
            tasks.add(t);
        }
        resp.put("tasks",tasks);
        //TODO check tenantId?
        List<Activity> activities1 = taskRepository.findManualActivities(codes, tenantVersion);
        for(Activity a:activities1){
            Activity ba = taskService.findBetterActivity(tenantId,a.getCode(),a.getVersion());
            AthenaUtils.mergeObject(ba,a);
        }
        resp.put("activities",activities1);

        return resp;
    }

    public int initMonitorRule(List<String> products, String appCode, String tenantId, String version) throws Exception{
        log.info("initMonitorRule appCode:{}, products:{}, tenantId:{}", appCode, products, tenantId);
        //租户可能没有稳态产品，也需要看看是否有和稳态无关的侦测需要自动创建
//        if(CollectionUtils.isEmpty(products)){
//            return -1;
//        }
        List<String> allMonitorRuleList = new ArrayList<>();
        Set<String> commonAotoRunMonitorRules = new HashSet<>();
        List<String> monitorRuleCode = appService.getMonitorRuleCode(appCode, tenantId);

        // 查询neo4j数据并合并
        List<ComponentBO> appComponent = componentInitManager.getComponentList(Collections.singletonList(appCode), version, tenantId, ComponentTypeEnum.MonitorRule);
        List<String> appCollect = appComponent.stream().map(ComponentBO::getCode).collect(Collectors.toList());
        monitorRuleCode = mergeAndDistinctLists(monitorRuleCode,appCollect);

        //查找公共的侦测
        List<String> common = appService.getMonitorRuleCodeByAppAndVersion(version);

        // 查询neo4j数据并合并
        List<ComponentBO> commonComponent =  componentInitManager.getCommonComponentList(version, tenantId, ComponentTypeEnum.MonitorRule);
        List<String> collect = commonComponent.stream().map(ComponentBO::getCode).collect(Collectors.toList());
        common = mergeAndDistinctLists(common,collect);

        if(CollectionUtils.isEmpty(monitorRuleCode) && CollectionUtils.isEmpty(common)){
            return 0;
        }
        if(!CollectionUtils.isEmpty(monitorRuleCode)){
            allMonitorRuleList.addAll(monitorRuleCode);
        }
        if(!CollectionUtils.isEmpty(common)){
            allMonitorRuleList.addAll(common);
            commonAotoRunMonitorRules.addAll(common);
        }
        List<MonitorRule> monitorRules = dataPickService.excludeWithSameCode(monitorRuleRepository.queryAutoRunMonitorRuleList(allMonitorRuleList, version,tenantId));

        int i = this.initMonitorRuleProcess(products, monitorRules, tenantId, version, commonAotoRunMonitorRules);
        return i;
    }

    public List<String> mergeAndDistinctLists(List<String> aList, List<String> bList) {
        Set<String> mergedSet = new HashSet<>(aList);
        mergedSet.addAll(bList);
        return new ArrayList<>(mergedSet);
    }

    private int initMonitorRuleProcess(List<String> products, List<MonitorRule> monitorRules, String tenantId, String version, Set<String> commonMonitorRules) throws Exception{
        if(CollectionUtils.isEmpty(monitorRules)){ //如果没有需要自动生效的，则直接返回
            return 0;
        }
        List<String> autoRunMonitorRuleCodes = monitorRules.stream().map(MonitorRule::getCode).collect(Collectors.toList());

        int hasSuccessInitAutoRunMonitorRuleCnt = 0;
        List<MonitorRuleProductConfig> monitorRuleProductConfigs = monitorRuleManager.getMonitorRuleProductConfigsById(autoRunMonitorRuleCodes, tenantId, version);

        Map<String, List<MonitorRuleProductConfig>> monitorProductMap = monitorRuleProductConfigs.stream().collect(Collectors.toMap(MonitorRuleProductConfig::getMonitorRuleId,
                p -> {
                    List<MonitorRuleProductConfig> productConfigList = new ArrayList<>();
                    productConfigList.add(p);
                    return productConfigList;
                },
                (List<MonitorRuleProductConfig> v1, List<MonitorRuleProductConfig> v2) -> {
                    v1.addAll(v2);
                    return v1;
                }
        ));

        Object loginResponse = null;
        String tenantToken = null;
        try {
            loginResponse = this.iamService.login(tenantId);
            tenantToken = this.iamService.getTenantToken(tenantId, loginResponse);
        } catch (Exception e) {
            log.error("初始化租户:{}获取token出错，出错原因：{}", tenantId, e.toString());
        }

        List<MonitorRuleTenantConfig> monitorRuleTenantConfigList = new ArrayList<>();
        boolean hasProductError = false;
        for(MonitorRule monitorRule : monitorRules){
            MonitorRuleProductConfig productConfig = null;
            try {
                productConfig = this.getProductConfig(monitorRule.getCode(), monitorProductMap, tenantId, products,commonMonitorRules);
            } catch (Exception e) {
                hasProductError = true;
                log.error(e.getMessage());
                continue;
            }

            //此处查询没有加上eoc的信息
            Query query1 = new Query();
            query1.addCriteria(Criteria.where("monitorRuleId").is(monitorRule.getCode()).and("tenantId").is(tenantId));
            List<MonitorRuleTenantConfig> tenantConfigList = this.mongoTemplateUser.find(query1, MonitorRuleTenantConfig.class);
            String tenantOperationUnitVersion = iamUtils.getTenantOperationUnitVersion(tenantToken);
            boolean tenantOperationUnitV2 = "v2".equals(tenantOperationUnitVersion);
            if(StringUtils.isNotEmpty(productConfig.getEocLevel())){
                if (tenantOperationUnitV2) {
                    // v2租户不支持非集团级的侦测
                    continue;
                }
//                List<EocMapDTO> eocMap = this.monitorRuleConfigService.getEocMap(productConfig.getEocLevel(), tenantId, productConfig.getProductName());
                //这边换成和交付设计器首页上获取公司工厂同样的方法;这边不用通过稳态产品查到对应的eoc信息；eoc是云端的
                List<EocMapDTO> eocMap = this.monitorRuleConfigService.getEocMapWithOutProduct(productConfig.getEocLevel(), tenantId, tenantToken);
                if(CollectionUtils.isEmpty(eocMap)){  // 当此侦测是eoc级别，但没有找到eoc信息时，不进行初始化的工作
                    continue;
                }

                hasSuccessInitAutoRunMonitorRuleCnt++;
                if(CollectionUtils.isNotEmpty(tenantConfigList)){ //当租户表已经存在此这个租户对应的侦测了，则跳过
                    continue;
                }
                for(EocMapDTO eocMapDTO : eocMap){
                    MonitorRuleTenantConfig monitorRuleTenantConfig = new MonitorRuleTenantConfig();
                    monitorRuleTenantConfig.setTenantId(tenantId);
                    monitorRuleTenantConfig.setMonitorRuleId(monitorRule.getCode());
                    monitorRuleTenantConfig.setProductName(productConfig.getProductName());
                    TriggerDTO triggerDTO = null;
                    if(monitorRule.getStandardPollingRule() == null){
                        triggerDTO = new TriggerDTO();
                        triggerDTO.setFrequency(1);
                        triggerDTO.setRepeat_type(3);
                    }else{
                        triggerDTO = JSON.parseObject(monitorRule.getStandardPollingRule(), TriggerDTO.class);
                    }
//                    TriggerDTO triggerDTO = JSON.parseObject(monitorRule.getStandardPollingRule(), TriggerDTO.class);
//                    if(BooleanUtils.isFalse(monitorRule.getExecuteOnStartup())){ //不需要立即执行 2021-07-23 00:00:00
//                        String format = LocalDateTime.now().plusMinutes(2).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
//                        triggerDTO.setStart_time(format);
//                    }else{ //立即执行
//                        String format = LocalDateTime.now().minusDays(2).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
//                        triggerDTO.setStart_time(format);
//                    }
                    if(StringUtils.isEmpty(triggerDTO.getStart_time())) {
                        String format = LocalDateTime.now().plusMinutes(2).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                        triggerDTO.setStart_time(format);
                    }
                    monitorRuleTenantConfig.setStandardPollingRule(triggerDTO);
                    monitorRuleTenantConfig.setStatus(1);
                    if(StringUtils.isNotEmpty(monitorRule.getBacktrackDate())){
                        monitorRuleTenantConfig.setBacktrackDate(monitorRule.getBacktrackDate());
                    }
                    monitorRuleTenantConfig.setTransactionId(UUID.randomUUID().toString());
                    monitorRuleTenantConfig.setEocMap(eocMapDTO);

                    monitorRuleTenantConfigList.add(monitorRuleTenantConfig);
                }

            }else{  //非eoc层级的侦测
                hasSuccessInitAutoRunMonitorRuleCnt++;
                if(CollectionUtils.isNotEmpty(tenantConfigList)){ //当租户表已经存在此这个租户对应的侦测了，则跳过
                    continue;
                }

                MonitorRuleTenantConfig monitorRuleTenantConfig = new MonitorRuleTenantConfig();
                monitorRuleTenantConfig.setTenantId(tenantId);
                monitorRuleTenantConfig.setMonitorRuleId(monitorRule.getCode());
                monitorRuleTenantConfig.setProductName(productConfig.getProductName());
                // v2版本租户如果侦测是集团级那么只发起根节点的侦测
                if(tenantOperationUnitV2){
                    EocMapDTO eocMap = this.monitorRuleConfigService.getRootEocMapWithOutProductV2(tenantToken);
                    if (eocMap == null) {
                        // 没有根节点，跳过该租户
                        continue;
                    }
                    monitorRuleTenantConfig.setEocMap(eocMap);
                }
                TriggerDTO triggerDTO = null;
                if(monitorRule.getStandardPollingRule() == null){
                    triggerDTO = new TriggerDTO();
                    triggerDTO.setFrequency(1);
                    triggerDTO.setRepeat_type(3);
                }else{
                    triggerDTO = JSON.parseObject(monitorRule.getStandardPollingRule(), TriggerDTO.class);
                }
//                TriggerDTO triggerDTO = JSON.parseObject(monitorRule.getStandardPollingRule(), TriggerDTO.class);
//                if(BooleanUtils.isFalse(monitorRule.getExecuteOnStartup())){ //不需要立即执行 2021-07-23 00:00:00
//                    String format = LocalDateTime.now().plusMinutes(2).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
//                    triggerDTO.setStart_time(format);
//                }else{ //立即执行
//                    String format = LocalDateTime.now().minusDays(2).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
//                    triggerDTO.setStart_time(format);
//                }
                if(StringUtils.isEmpty(triggerDTO.getStart_time())) {
                    String format = LocalDateTime.now().plusMinutes(2).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                    triggerDTO.setStart_time(format);
                }
                monitorRuleTenantConfig.setStandardPollingRule(triggerDTO);
//                monitorRuleTenantConfig.setStandardPollingRule(JSON.parseObject(monitorRule.getStandardPollingRule(), TriggerDTO.class));
                monitorRuleTenantConfig.setStatus(1);
                if(StringUtils.isNotEmpty(monitorRule.getBacktrackDate())){
                    monitorRuleTenantConfig.setBacktrackDate(monitorRule.getBacktrackDate());
                }
                monitorRuleTenantConfig.setTransactionId(UUID.randomUUID().toString());
                monitorRuleTenantConfigList.add(monitorRuleTenantConfig);
            }

        }

        if(CollectionUtils.isEmpty(monitorRuleTenantConfigList)){
            return hasProductError ? -1 : (hasSuccessInitAutoRunMonitorRuleCnt - autoRunMonitorRuleCodes.size());
        }
        this.mongoTemplateUser.insert(monitorRuleTenantConfigList, "monitorRuleTenantConfig");
        TimeUnit.SECONDS.sleep(1); //等待1秒，荣俊要求添加，防止SD查询mongo主从未同步导致的问题
        for(MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList){
            String msg = this.monitorRuleConfigService.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(),
                    monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.CREATED, null, monitorRuleTenantConfig.getBacktrackDate(), null, monitorRuleTenantConfig.getTransactionId());
            this.monitorRuleConfigService.recordPreMonitorRuleTenantConfig(monitorRuleTenantConfig.getTransactionId(), "MQ", msg, false, null, monitorRuleTenantConfig.getMonitorRuleId());
        }


        return hasSuccessInitAutoRunMonitorRuleCnt - autoRunMonitorRuleCodes.size();
    }

    private MonitorRuleProductConfig getProductConfig(String ruleId, Map<String, List<MonitorRuleProductConfig>> monitorProductMap, String tenantId, List<String> cloudProductNames, Set<String> commonMonitorRules) throws Exception{
        if(cloudProductNames == null){
            cloudProductNames = new ArrayList<>();
        }
        List<MonitorRuleProductConfig> productConfigList = monitorProductMap.get(ruleId);
        if(CollectionUtils.isEmpty(productConfigList)){
            throw new Exception(I18nUtils.getValue("knowledgegraph.ruleNotFoundInMonitorRuleProductConfigs",ruleId));
        }
        List<String> products = (List<String>) productService.getAllSteadyProduct();
        if(!commonMonitorRules.contains(ruleId) && productConfigList.size() == 1 && !products.contains(productConfigList.get(0).getProductName())){ //当不是公用的侦测，且产品表只有一条数据则直接返回
            return productConfigList.get(0);
        }
        //当产品表有多条数据，或者侦测是公共的侦测，则需对稳态产品进行匹配
        for(MonitorRuleProductConfig ruleProduct : productConfigList){
            for(String cloudProduct : cloudProductNames){
                if(StringUtils.equals(ruleProduct.getProductName(), cloudProduct)){
                    return ruleProduct;
                }
            }
        }
        throw new Exception(I18nUtils.getValue("knowledgegraph.tenantNotMatchRule",tenantId,ruleId));
    }

    public Object postInitMonitorRuleForExistsTenant(InitMonitorRuleParam param) throws Exception{
        log.info("startInitMonitorRuleForExistsTenant:{}", JSON.toJSONString(param));
        if(StringUtils.isEmpty(param.getAppCode())){
            throw new Exception(I18nUtils.getValue("knowledgegraph.appCodeEmpty"));
        }
        if(CollectionUtils.isEmpty(param.getRuleIdList())){
            throw new Exception(I18nUtils.getValue("knowledgegraph.ruleIdListEmpty"));
        }
        Set<String> commonAotoRunMonitorRules = new HashSet<>();
        List<AppPurchaseInfo> allAppPurchaseInfoList = new ArrayList<>();
        //common一般不用,不处理
        if(StringUtils.equalsIgnoreCase(param.getAppCode(), "common")){ //如果新增的是公用的侦测，则对所有已有应用下的租户进行处理
            List<String> allAppCode = this.appService.getNotCommonAppCode();
            if(CollectionUtils.isNotEmpty(allAppCode)){
                for(String appCode : allAppCode){
                    if(StringUtils.equalsIgnoreCase("common", appCode)){
                        continue;
                    }
                    AppAuthorizationsResponse allEffectiveTenantAndAppInfo = this.cacService.getAllEffectiveTenantAndAppInfo(appCode);
                    log.info("通过cac查询还没失效的应用：{} 租户信息共：{} 条", appCode, allEffectiveTenantAndAppInfo.getTotal());
                    if(CollectionUtils.isNotEmpty(allEffectiveTenantAndAppInfo.getList())){
                        allAppPurchaseInfoList.addAll(allEffectiveTenantAndAppInfo.getList());
                    }
                }
            }
            commonAotoRunMonitorRules.addAll(param.getRuleIdList());
        }else {
            //查询应用下还有效的租户
            AppAuthorizationsResponse allEffectiveTenantAndAppInfo = this.cacService.getAllEffectiveTenantAndAppInfo(param.getAppCode());
            log.info("通过cac查询还没失效的应用：{} 租户信息共：{} 条", param.getAppCode(), allEffectiveTenantAndAppInfo.getTotal());
            if(CollectionUtils.isNotEmpty(allEffectiveTenantAndAppInfo.getList())){
                allAppPurchaseInfoList.addAll(allEffectiveTenantAndAppInfo.getList());
            }
        }
        Set<String> tenantHasInitSet = new HashSet<>();
        Map<String, List<MonitorRule>> versionMonitorRuleMap = new HashMap<>();
        for(AppPurchaseInfo appPurchaseInfo : allAppPurchaseInfoList){
            String tenantId = appPurchaseInfo.getTenantId();
            if(tenantHasInitSet.contains(tenantId)){ //如果已经初始化过，则跳过
                continue;
            }
            //个案如果不包括该租户则跳过
            if(CollectionUtils.isNotEmpty(param.getTenantIds())){
                if(!param.getTenantIds().contains(tenantId)){
                    continue;
                }
            }
            try {
                String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
                List<MonitorRule> monitorRules = versionMonitorRuleMap.get(tenantVersion);
                if(CollectionUtils.isEmpty(monitorRules)){
                    monitorRules = dataPickService.excludeWithSameCode(monitorRuleRepository.queryAutoRunMonitorRuleList(param.getRuleIdList(), tenantVersion,tenantId));
                }
                if(CollectionUtils.isEmpty(monitorRules)){
                    continue;
                }
                versionMonitorRuleMap.put(tenantVersion, monitorRules); //缓存下数据，避免多次查询

                List<String> cloudProductNamesWithRetry = new ArrayList<>();
                try {
                    cloudProductNamesWithRetry = this.productNameResolver.getCloudProductNamesWithRetry(tenantId, 3);
                    //                cloudProductNamesWithRetry = Arrays.asList("WFGP");
                } catch (Exception e) {
                    log.error("查询租户:{}的地端产品信息失败,失败原因：{}", tenantId, e.getMessage() );
                }

                /*if(CollectionUtils.isEmpty(cloudProductNamesWithRetry)){
                    log.error("没有查询到租户:{}的地端产品信息", tenantId);
                    continue;
                }*/
                int i = this.initMonitorRuleProcess(cloudProductNamesWithRetry, monitorRules, tenantId, tenantVersion, commonAotoRunMonitorRules);
                log.info("租户：{}初始化侦测结果：{}" , tenantId, i==0 ? "SUCCESS" : "FAILURE");
            } catch (Exception e) {
                log.error("租户：{}初始化侦测失败，原因：{}", tenantId, e.getMessage());
            }
            tenantHasInitSet.add(tenantId);
        }
        log.info("finishInitMonitorRuleForExistsTenant:{}", JSON.toJSONString(param));
        return null;
    }


    /**
     *租户购买应用过期处理
     * 暂时先处理侦测:暂停侦测
     */
    @Override
    public Object postHandleTenantAppExpire(TenantInitParam param) throws DWBusinessException{
        if(StringUtils.isEmpty(param.getTenantId()) && CollectionUtils.isEmpty(param.getTenantIdList())){
            log.error("postHandleTenantAppExpire没有租户信息");
            return null;
        }
        if(StringUtils.isNotEmpty(param.getTenantId())){
            List<String> tenantIdList = param.getTenantIdList();
            if(CollectionUtils.isEmpty(tenantIdList)){
                tenantIdList = new ArrayList<>();
                param.setTenantIdList(tenantIdList);
            }
            tenantIdList.add(param.getTenantId());
        }
        Map<String, List<String>> appVersionMonitorRuleMap = new HashMap<>();
        for(String tenantId : param.getTenantIdList()) {
            this.log.info("=========startHandleTenantAppExpire tenantId:{}, appCode:{}", tenantId, param.getAppCode());
            String appCode = param.getAppCode();
//            String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//
//            List<String> enhanceCodeList = this.applicationService.getEnhanceCodeByAppCode(appCode, tenantVersion);
//
//            List<String> monitorRuleCodeList = appVersionMonitorRuleMap.get(tenantVersion);
//
//            if(CollectionUtils.isEmpty(monitorRuleCodeList)){
//                monitorRuleCodeList = this.applicationService.getMonitorRuleCodeByAppAndVersion(appCode, tenantVersion);
//                //查找增强应用的侦测
//                List<String> enhanceMonitorRuleList = new ArrayList<>();
//                if(CollectionUtils.isNotEmpty(enhanceCodeList)){
//                    for(String enhanceAppCode : enhanceCodeList){
//                        List<String> monitorRuleCodeByAppAndVersion = this.applicationService.getMonitorRuleCodeByAppAndVersion(enhanceAppCode, tenantVersion);
//                        if(CollectionUtils.isNotEmpty(monitorRuleCodeByAppAndVersion)){
//                            enhanceMonitorRuleList.addAll(monitorRuleCodeByAppAndVersion);
//                        }
//                    }
//                }
//                if (CollectionUtils.isEmpty(monitorRuleCodeList) && CollectionUtils.isEmpty(enhanceMonitorRuleList)) {
//                    this.logger.info("=========startHandleTenantAppExpire appCode:{},version:{} 没有侦测",  param.getAppCode(),tenantVersion);
//                    continue;
//                }else{
//                    if(CollectionUtils.isNotEmpty(enhanceMonitorRuleList)){
//                        monitorRuleCodeList.addAll(enhanceMonitorRuleList);
//                    }
//                    appVersionMonitorRuleMap.put(tenantVersion, monitorRuleCodeList);
//                }
//            }

//            TenantAppInfoDTO tenantAppInfoDTO = this.tenantEntityRepository.tenantWithAppEntity(tenantId, appCode);
//            if(tenantAppInfoDTO == null){
//                return 0;
//            }
            List<String> monitorCodes = new ArrayList<>();
            //add by srj  用queryComponent找侦测信息
//            List<String> appMonitorCodes = monitorRuleRepository.getCodeByTenantAndAppNameSpace(tenantId, tenantAppInfoDTO.getNamespace());
//            List<String> codeByTenantAndAppCode = monitorRuleRepository.getCodeByTenantAndAppCode(param.getTenantId(), param.getAppCode());
//            if(CollectionUtils.isNotEmpty(appMonitorCodes)){
//                monitorCodes.addAll(appMonitorCodes);
//            }
//            if(CollectionUtils.isNotEmpty(codeByTenantAndAppCode)){
//                monitorCodes.addAll(codeByTenantAndAppCode);
//            }

            //TODO 如果放开次此处，则初始化的时候，启动通用的侦测逻辑需要修改下
//            List<TenantAppInfoDTO> tenantAppInfoDTOS = this.tenantEntityRepository.tenantAppEntity(tenantId);
//            if(tenantAppInfoDTOS != null && tenantAppInfoDTOS.size() == 1 && StringUtils.equals(tenantAppInfoDTOS.get(0).getAppCode(), appCode)){
//                //有且只有这一个应用的时候，把公共的侦测也停止
//                List<String> commonMonitorCodes = monitorRuleRepository.getCodeByTenantAndAppNameSpace(tenantId, "common");
//                if(CollectionUtils.isNotEmpty(commonMonitorCodes)){
//                    monitorCodes.addAll(commonMonitorCodes);
//                }
//            }

            Map<String, Object> queryComponent = null;
            try {
                queryComponent = this.componentInitManager.queryComponent(tenantId, appCode, Constants.AppNoticeType.EXPIRE,
                        Arrays.asList(ComponentTypeEnum.MonitorRule.toString()));

                Object monitorRuleObj = queryComponent.get(ComponentTypeEnum.MonitorRule.toString());
                if(!ObjectUtils.isEmpty(monitorRuleObj)){
                    monitorCodes = (List<String>) monitorRuleObj;

                }
            } catch (DWBusinessException e) {
                log.error(e.getMessage(), e);
            }



            if(CollectionUtils.isEmpty(monitorCodes)){
                this.log.info("=========startHandleTenantAppExpire appCode:{} tenantId:{}没有侦测",  appCode, tenantId);
                return null;
            }

            Query query = new Query();
            Criteria criteria = Criteria.where("tenantId").is(tenantId).and("monitorRuleId").in(monitorCodes).and("closed").ne(true);
            query.addCriteria(criteria);
            List<MonitorRuleTenantConfig> monitorRuleTenantConfigList = mongoTemplateUser.find(query, MonitorRuleTenantConfig.class);
            if (CollectionUtils.isEmpty(monitorRuleTenantConfigList)) {
                return null;
            }
            for (MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList) {
                try {
                    String uuid = UUID.randomUUID().toString();
                    log.info("HandleTenantAppExpire tenantId:{}, monitorRuleId:{}, eocMap:{}", monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), JSON.toJSONString(monitorRuleTenantConfig.getEocMap()));
                    Query query2 = new Query();
                    Criteria criteria2 = Criteria.where("tenantId").is(tenantId).and("monitorRuleId").is(monitorRuleTenantConfig.getMonitorRuleId());
                    criteria2 = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(monitorRuleTenantConfig.getEocMap()), criteria2);
                    query2.addCriteria(criteria2);

                    Update update = new Update();
                    update.set("status", 0).set("transactionId", uuid).set("closed", true).set("beforeClosedStatus", monitorRuleTenantConfig.getStatus());

                    this.mongoTemplateUser.updateMulti(query2, update, "monitorRuleTenantConfig");
                    //按sd要求，过期时直接传DELETED 不用用CLOSED
//                    String msg = this.monitorRuleConfigService.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.DELETED, null, null, "MQ", uuid);
//                    this.monitorRuleConfigService.recordPreMonitorRuleTenantConfig(uuid, "MQ", msg, false, monitorRuleTenantConfig, monitorRuleTenantConfig.getMonitorRuleId());

                } catch (Exception e) {
                    log.error("HandleTenantAppExpireError tenantId:{}, monitorRuleId:{}, eocMap:{}, error:{}", monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), JSON.toJSONString(monitorRuleTenantConfig.getEocMap()), e.getMessage());
                }

            }
            this.log.info("=========finishHandleTenantAppExpire tenantId:{}, appCode:{}", tenantId, param.getAppCode());
        }
        return null;
    }

    public void postHandleTenantAppExpire(){
        String handleTenantAppExpireLock = null;
        int dayBeforeNow = 2;
        // 分布式锁key增加redis规范appId前缀
        String kgHandleTenantAppExpireLock = ComponentConstants.REDIS_KNOWLEDGE_GRAPH + ":handleTenantAppExpireLock";
        try {
            handleTenantAppExpireLock = redisLock.tryLock(kgHandleTenantAppExpireLock, 5 * 60 * 1000);
            if (handleTenantAppExpireLock != null) {
                log.info("=======拿到处理租户应用过期的锁{}:{}=======", kgHandleTenantAppExpireLock, handleTenantAppExpireLock);
                log.info("===========开始HandleTenantAppExpire过程==========");
//                List<String> allAppCodes = this.applicationService.getNotCommonAppCode();
                List<String> allAppCodes = this.applicationService.getAllAppCode();
                for(String appCode : allAppCodes){
                    if(StringUtils.equalsIgnoreCase("common", appCode)){
                        continue;
                    }
                    try {
                        AppAuthorizationsResponse allExpiredTenantAndAppInfo = this.cacService.getAllExpiredTenantAndAppInfo(appCode, 1, 1);
                        log.info("通过cac查询{}天内失效的应用：{} 租户信息共：{} 条", dayBeforeNow, appCode, allExpiredTenantAndAppInfo.getTotal());
                        if(CollectionUtils.isNotEmpty(allExpiredTenantAndAppInfo.getList())){
                            List<String> collectTenantIds = allExpiredTenantAndAppInfo.getList().stream().map(AppPurchaseInfo::getTenantId).collect(Collectors.toList());
                            for(String tenantId : collectTenantIds){
                                //1.发送队列消息
                                String appExpireChangeMessage = this.getAppExpireChangeMessage(appCode, tenantId, Constants.AppNoticeType.EXPIRE);
                                log.info("appExpireChangeMessage:{}", appExpireChangeMessage);
                                rabbitTemplate.convertAndSend(ModuleConfiguration.APP_EXPIRE_EXCHANGE, null, appExpireChangeMessage);
                                recordUtil.recordInfo(OperationRecord.builder()
                                        .type(OperationRecordType.MQ + "-" + Constants.AppNoticeType.EXPIRE)
                                        .tenantId(tenantId)
                                        .application(appCode)
                                        .path(this.getClass().getName())
                                        .supplementaryContent(ImmutableMap.of(
                                                "message", appExpireChangeMessage,
                                                "exchange", ModuleConfiguration.APP_EXPIRE_EXCHANGE
                                        )).build());
                                //2.发送IM消息
                                try {
                                    imService.noticeAppExpired(tenantId, appCode);
                                } catch (Exception e) {
                                    log.error("send im message failed for tenant-[{}] appCode-[{}]", tenantId, appCode);
                                }
                                //3.清空应用缓存
                                this.deleteTenantAppCodeCache(tenantId);

                                // 4.清空排程的订阅
                                List<DataSubscriptionRule> dataSubscriptionRules = dataSubscriptionService.postQueryExpireDataSubscriptionConfig(tenantId,"","",appCode);
                                if (CollectionUtils.isNotEmpty(dataSubscriptionRules)) {
                                    dataSubscriptionService.postRemoveDataSubscription(dataSubscriptionRules,"update");
                                }
                            }
                            TenantInitParam param = new TenantInitParam();
                            param.setAppCode(appCode);
                            param.setTenantIdList(collectTenantIds);

                            this.postHandleTenantAppExpire(param);
                        }
                    } catch (Exception e) {
                        log.error(e.toString());
                    }
                }
                log.info("===========结束HandleTenantAppExpire过程==========");
            }else{
                log.info("=======没有拿到处理租户应用过期的锁{}，应用的其他实例正在处理=======", kgHandleTenantAppExpireLock);
            }
        }catch (Exception e) {
            log.error(e.toString());
        } finally {
            if(handleTenantAppExpireLock != null){
                log.info("释放锁{}：{}", kgHandleTenantAppExpireLock, handleTenantAppExpireLock);
                redisLock.unlock(kgHandleTenantAppExpireLock, handleTenantAppExpireLock);
            }
        }
    }

    @Override
    public Object postAppRenewNotice(TenantInitParam param) throws DWBusinessException{
        log.info("postAppRenewNotice：{}", param);
        if(StringUtils.isEmpty(param.getAppCode()) || StringUtils.isEmpty(param.getTenantId())){
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.appCodeOrTenantEmpty"));
        }

        //删除租户的应用缓存
        this.deleteTenantAppCodeCache(param.getTenantId());

        //1.发送队列消息
        String appExpireChangeMessage = this.getAppExpireChangeMessage(param.getAppCode(), param.getTenantId(), Constants.AppNoticeType.RENEW);
        log.info("appExpireChangeMessage:{}", appExpireChangeMessage);
        rabbitTemplate.convertAndSend(ModuleConfiguration.APP_EXPIRE_EXCHANGE, null, appExpireChangeMessage);
        recordUtil.recordInfo(OperationRecord.builder()
                .type(OperationRecordType.MQ + "-" + Constants.AppNoticeType.RENEW)
                .tenantId(param.getTenantId())
                .application(param.getAppCode())
                .supplementaryContent(ImmutableMap.of(
                        "message", appExpireChangeMessage,
                        "exchange", ModuleConfiguration.APP_EXPIRE_EXCHANGE
                )).build());

        String startTime = param.getEffectiveTime();

        // 查找租户下应用续约的敏捷报表的订阅数据
        List<DataSubscriptionRule> dataSubscriptionRules = dataSubscriptionService.postQueryExpireDataSubscriptionConfig(param.getTenantId(),"","",param.getAppCode());
        if (CollectionUtils.isNotEmpty(dataSubscriptionRules)) {
            dataSubscriptionService.postAppRenewDataSubscription(dataSubscriptionRules);
        }

        //查找租户应用下的所有侦测（包含通用的侦测）
//        TenantAppInfoDTO tenantAppInfoDTO = this.tenantEntityRepository.tenantWithAppEntity(param.getTenantId(), param.getAppCode());
//        if(tenantAppInfoDTO == null){
//            return 0;
//        }


        List<String> monitorCodes = new ArrayList<>();
//        List<String> codeByTenantAndAppNameSpace = monitorRuleRepository.getCodeByTenantAndAppNameSpace(param.getTenantId(), tenantAppInfoDTO.getNamespace());
//        List<String> commonMonitorCodes = monitorRuleRepository.getCodeByTenantAndAppNameSpace(param.getTenantId(), "common");
//        List<String> codeByTenantAndAppCode = monitorRuleRepository.getCodeByTenantAndAppCode(param.getTenantId(), param.getAppCode());
//        if(CollectionUtils.isNotEmpty(codeByTenantAndAppNameSpace)){
//            monitorCodes.addAll(codeByTenantAndAppNameSpace);
//        }
//        if(CollectionUtils.isNotEmpty(commonMonitorCodes)){
//            monitorCodes.addAll(commonMonitorCodes);
//        }
//        if(CollectionUtils.isNotEmpty(codeByTenantAndAppCode)){
//            monitorCodes.addAll(codeByTenantAndAppCode);
//        }



        Map<String, Object> queryComponent = null;
        try {
            queryComponent = this.componentInitManager.queryComponent(param.getTenantId(), param.getAppCode(), Constants.AppNoticeType.RENEW,
                    Arrays.asList(ComponentTypeEnum.MonitorRule.toString()));
        } catch (DWBusinessException e) {
            log.error(e.getMessage(), e);
        }
        Object monitorRuleObj = queryComponent.get(ComponentTypeEnum.MonitorRule.toString());
        if(!ObjectUtils.isEmpty(monitorRuleObj)){
            monitorCodes = (List<String>) monitorRuleObj;

        }

        if(CollectionUtils.isEmpty(monitorCodes)){
            log.info("postAppRenewNotice not find monitor rule in app:{}", param.getAppCode());
            return 1;
        }
        //看哪些是closed的，通知sd OPEN
        Query query = new Query();
        Criteria in = Criteria.where("tenantId").is(param.getTenantId()).and("closed").is(true).and("monitorRuleId").in(monitorCodes);
        query.addCriteria(in);

        List<MonitorRuleTenantConfig> monitorRuleTenantConfigList = mongoTemplateUser.find(query, MonitorRuleTenantConfig.class);
        Set<String> hasDeal = new HashSet<>();
        for(MonitorRuleTenantConfig monitorRuleTenantConfig : monitorRuleTenantConfigList){
            try {
                if(hasDeal.contains(this.getTenantMonitorRuleKey(monitorRuleTenantConfig.getMonitorRuleId(),monitorRuleTenantConfig.getEocMap()))){
                    //避免有重复数据时候，重复处理并发消息给SD
                    continue;
                }
                String uuid = UUID.randomUUID().toString();
                Query query2 = new Query();
                Criteria criteria2 = Criteria.where("tenantId").is(param.getTenantId()).and("monitorRuleId").is(monitorRuleTenantConfig.getMonitorRuleId());
                criteria2 = this.operationUnitService.addEocMapToCriteria(this.operationUnitService.transToOperationUnit(monitorRuleTenantConfig.getEocMap()), criteria2);
                query2.addCriteria(criteria2);

                Integer beforeClosedStatus = monitorRuleTenantConfig.getBeforeClosedStatus();
                if(beforeClosedStatus == null){
                    beforeClosedStatus = 1;
                }

                Update update = new Update();
                update.set("status", beforeClosedStatus).set("transactionId", uuid).set("closed", false).set("beforeClosedStatus", null);
                Object tenantConfigStandardPollingRule = monitorRuleTenantConfig.getStandardPollingRule();
                if(StringUtils.isNotEmpty(startTime) && !ObjectUtils.isEmpty(tenantConfigStandardPollingRule)){
                    TriggerDTO triggerDTO = JSON.parseObject(JSON.toJSONString(tenantConfigStandardPollingRule), TriggerDTO.class);
                    triggerDTO.setStart_time(this.getNewStartTime(startTime, triggerDTO.getStart_time()));
                    update.set("standardPollingRule",triggerDTO);
                }
                Object standardPollingRules = monitorRuleTenantConfig.getStandardPollingRules();
                if(StringUtils.isNotEmpty(startTime) && !ObjectUtils.isEmpty(standardPollingRules)){
                    List<TriggerDTO> triggerDTOS = JSON.parseArray(JSON.toJSONString(standardPollingRules), TriggerDTO.class);
                    for(TriggerDTO triggerDTO : triggerDTOS){
                        triggerDTO.setStart_time(this.getNewStartTime(startTime, triggerDTO.getStart_time()));
                    }
                    update.set("standardPollingRules", triggerDTOS);
                }
                boolean enableStatus = beforeClosedStatus == 1 ? true : false;
                UpdateResult updateResult = this.mongoTemplateUser.updateMulti(query2, update, "monitorRuleTenantConfig");
                log.info("postAppRenewNotice monitorRuleId:{} , updateResult:{}",monitorRuleTenantConfig.getMonitorRuleId(), updateResult.getModifiedCount());
                String msg = this.monitorRuleConfigService.sendMessage(monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), monitorRuleTenantConfig.getEocMap(), ConfigChangeTypeEnum.CREATED, enableStatus, startTime, "MQ", uuid);
                this.monitorRuleConfigService.recordPreMonitorRuleTenantConfig(uuid, "MQ", msg, false, monitorRuleTenantConfig, monitorRuleTenantConfig.getMonitorRuleId());
                hasDeal.add(this.getTenantMonitorRuleKey(monitorRuleTenantConfig.getMonitorRuleId(),monitorRuleTenantConfig.getEocMap()));
            } catch (Exception e) {
                log.error("postAppRenewNoticeError tenantId:{}, monitorRuleId:{}, eocMap:{}, error:{}", monitorRuleTenantConfig.getTenantId(), monitorRuleTenantConfig.getMonitorRuleId(), JSON.toJSONString(monitorRuleTenantConfig.getEocMap()), e.getMessage());
            }
        }

        return 1;
    }

    /**
     * 调用aim续约接口
     * @param tenantId 租户id
     * @param appCode 应用Code
     */
    @Override
    public Object postAppAddPurchaseNotice(String tenantId ,String appCode) {

        log.info("postAppAddPurchaseNotice tenantId:{},appCode:{}", tenantId,appCode);
        //2.发送IM消息
        try {
            imService.noticeAppRenew(tenantId, appCode);
        } catch (Exception e) {
            log.error("send im message failed for tenant-[{}] appCode-[{}] error:{}", tenantId, appCode,e.getMessage());
            return 500;
        }
        return 0;
    }

    @Override
    public Object postTenantExpiredNotice(TenantAppNoticeDTO param) throws Exception {
        //缓冲期发送IM消息
        imService.noticeAppRestricted(param.getTenantId(), param.getAppCode());
        return null;
    }

    @Override
    public Object postTenantAppMaterialRemainNotice(TenantAppNoticeDTO param) throws Exception {
        //缓冲期发送IM消息
        imService.noticeAppExpired(param.getTenantId(), param.getAppCode());
        return null;
    }

    @Override
    public Object postTenantAppRenewNotice(TenantAppNoticeDTO param) throws Exception {
        //缓冲期发送IM消息
        imService.noticeAppRenew(param.getTenantId(), param.getAppCode());
        return null;
    }

    private String getTenantMonitorRuleKey(String monitorRuleId, EocMapDTO eocMap){
        if(eocMap == null){
            return monitorRuleId;
        }
        return monitorRuleId + eocMap.toString();

    }

    private String getNewStartTime(String startTime, String oldStartTime){
        if(StringUtils.isEmpty(oldStartTime)){
            return startTime;
        }
        String[] s = oldStartTime.split(" ");
        if(s.length != 2){
            return startTime;
        }
        if(StringUtils.isEmpty(startTime)){
            return oldStartTime;
        }
        String startDate = startTime.split(" ")[0];
        return startDate + " " + s[1];
    }

    public void postHandleTenantAppExpireRetainDaysAfter() {
        String handleTenantAppExpireRetainDaysAfterLock = null;
        // 分布式锁key增加redis规范appId前缀
        String kgHandleTenantAppExpireRetainDaysAfterLock = ComponentConstants.REDIS_KNOWLEDGE_GRAPH + ":handleTenantAppExpireRetainDaysAfterLock";
        try {
            handleTenantAppExpireRetainDaysAfterLock = redisLock.tryLock(kgHandleTenantAppExpireRetainDaysAfterLock, 5 * 60 * 1000);
            if (handleTenantAppExpireRetainDaysAfterLock != null) {
                log.info("=======拿到处理租户应用过期的锁{}:{}=======", kgHandleTenantAppExpireRetainDaysAfterLock, handleTenantAppExpireRetainDaysAfterLock);
                log.info("===========开始HandleTenantAppExpire过程==========");
//                List<String> allAppCodes = this.applicationService.getNotCommonAppCode();
                List<String> allAppCodes = this.applicationService.getAllAppCode();
                for(String appCode : allAppCodes){
                    if(StringUtils.equalsIgnoreCase("common", appCode)){
                        continue;
                    }
                    try {
                        AppAuthorizationsResponse allExpiredTenantAndAppInfo = this.cacService.getAllExpiredTenantAndAppInfo(appCode,
                                Constants.AppNoticeType.RETAIN_DAYS + 1, Constants.AppNoticeType.RETAIN_DAYS + 1);
                        log.info("通过cac查询已失效：{}天的应用：{} 租户信息共：{} 条", Constants.AppNoticeType.RETAIN_DAYS, appCode, allExpiredTenantAndAppInfo.getTotal());
                        if(CollectionUtils.isNotEmpty(allExpiredTenantAndAppInfo.getList())){

                            for(AppPurchaseInfo appPurchaseInfo : allExpiredTenantAndAppInfo.getList()){
                                try {
                                    //1.发送队列消息
                                    String appExpireChangeMessage = this.getAppExpireChangeMessage(appCode, appPurchaseInfo.getTenantId(), Constants.AppNoticeType.CLEAN);
                                    log.info("appExpireChangeMessage:{}", appExpireChangeMessage);
                                    rabbitTemplate.convertAndSend(ModuleConfiguration.APP_EXPIRE_EXCHANGE, null, appExpireChangeMessage);
                                    recordUtil.recordInfo(OperationRecord.builder()
                                            .type(OperationRecordType.MQ + "-" + Constants.AppNoticeType.CLEAN)
                                            .tenantId(appPurchaseInfo.getTenantId())
                                            .application(appCode)
                                            .supplementaryContent(ImmutableMap.of(
                                                    "message", appExpireChangeMessage,
                                                    "exchange", ModuleConfiguration.APP_EXPIRE_EXCHANGE
                                                    )).build());
                                    //2.清理kg的租户数据
                                    this.doClean(appPurchaseInfo.getTenantId(), appCode);
                                } catch (Exception e) {
                                    log.error("postHandleTenantAppExpireRetainDaysAfter error:{}", e.getMessage());
                                }
                            }
                        }
                    } catch (Exception e) {
                        log.error("postHandleTenantAppExpireRetainDaysAfter error:{}", e.getMessage());
                    }
                }
                log.info("===========结束HandleTenantAppExpire过程==========");
            }else{
                log.info("=======没有拿到处理租户应用过期的锁{}，应用的其他实例正在处理=======", kgHandleTenantAppExpireRetainDaysAfterLock);
            }
        }catch (Exception e) {
            log.error("postHandleTenantAppExpireRetainDaysAfter error:{}", e.getMessage());
        } finally {
            if(handleTenantAppExpireRetainDaysAfterLock != null){
                log.info("释放锁{}：{}", kgHandleTenantAppExpireRetainDaysAfterLock, handleTenantAppExpireRetainDaysAfterLock);
                redisLock.unlock(kgHandleTenantAppExpireRetainDaysAfterLock, handleTenantAppExpireRetainDaysAfterLock);
            }
        }
    }

    /**
     * 应用缓冲期过了后数据清理工作
     * @param tenantId
     * @param appCode
     */
    private void doClean(String tenantId, String appCode){
        log.info("doClean...tenantId:{}, appCode:{}", tenantId, appCode);
        this.deleteTenantAppCodeCache(tenantId);

        Map<String, Object> queryComponent = null;
        try {
            queryComponent = this.componentInitManager.queryComponent(tenantId, appCode, Constants.AppNoticeType.CLEAN,
                    Arrays.asList(ComponentTypeEnum.MonitorRule.toString()));
        } catch (DWBusinessException e) {
            log.error(e.getMessage(), e);
        }
        if(queryComponent != null){
            //清理侦测数据
            Object monitorRuleObj = queryComponent.get(ComponentTypeEnum.MonitorRule.toString());
            if(!ObjectUtils.isEmpty(monitorRuleObj)){
                log.info("delete monitorRule:{}, tenantId:{}",monitorRuleObj, tenantId);
                List<String> monitorRuleCodeList = (List<String>) monitorRuleObj;
                Query query = new Query();
                query.addCriteria(Criteria.where("tenantId").is(tenantId).and("monitorRuleId").in(monitorRuleCodeList).and("closed").is(true));
                DeleteResult monitorRuleTenantConfig = this.mongoTemplateUser.remove(query, "monitorRuleTenantConfig");//把已经停止的侦测定义删除
                log.info("delete monitorRule:{}, tenantId:{}, count:{}",monitorRuleCodeList,  tenantId, monitorRuleTenantConfig.getDeletedCount());
            }
        }

        try {
            //清理neo4j中租户和AppEntity的关系
//            String cypher = "match (te:TenantEntity{tenantId:'" + tenantId + "'})-[r:USE]->(app:AppEntity {code:'" + appCode + "'}) delete r";
//            this.executeCypher(Arrays.asList(cypher), sessionFactoryDomain1);
//            this.executeCypher(Arrays.asList(cypher), sessionFactoryDomain2);
            removeTenantAppRelation(tenantId,appCode);
        } catch (Exception e) {
            log.error("delete tenantEntityAndAppRelation error:{}", e.getMessage());
        }

        //清理租户设置的范式条件
        List<ApplicationRelation> paradigmList = this.getApplicationRelation("paradigm", appCode);
        if(CollectionUtils.isNotEmpty(paradigmList)){
            List<String> collect = paradigmList.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
            Query query = new Query();
            Criteria criteria = Criteria.where("paradigmCode").in(collect).and("tenantId").is(tenantId);
            query.addCriteria(criteria);
            DeleteResult paradigmCondition = this.mongoTemplateUser.remove(query, "paradigmCondition");
            log.info("delete paradigmCondition:{}, tenantId:{}, count:{}",collect,  tenantId, paradigmCondition.getDeletedCount());
        }
        //清理租户的机制
        List<ApplicationRelation> mechanismList = this.getApplicationRelation("mechanism", appCode);
        if(CollectionUtils.isNotEmpty(mechanismList)){
            List<String> collect = paradigmList.stream().map(ApplicationRelation::getCode).collect(Collectors.toList());
            Query query = new Query();
            Criteria criteria = Criteria.where("code").in(collect).and("tenantId").is(tenantId);
            query.addCriteria(criteria);
            DeleteResult mechanism = this.mongoTemplateUser.remove(query, "mechanism");
            log.info("delete mechanismList:{},  tenantId:{},count:{}",collect, tenantId, mechanism.getDeletedCount());
        }

        // 清理敏捷数据的用户订阅
        List<DataSubscriptionRule> dataSubscriptionRules = dataSubscriptionService.postQueryExpireDataSubscriptionConfig(tenantId,"","",appCode);
        if (CollectionUtils.isNotEmpty(dataSubscriptionRules)) {
            dataSubscriptionService.postRemoveDataSubscription(dataSubscriptionRules,"delete");
        }

    }


    private List<ApplicationRelation> getApplicationRelation(String type, String appCode){
        Query query = new Query();
        Criteria criteria = Criteria.where("type").is(type).and("appCode").is(appCode);
        query.addCriteria(criteria);
        List<ApplicationRelation> applicationRelationList = this.mongoTemplate.find(query, ApplicationRelation.class);
        return applicationRelationList;
    }

    public boolean checkAllAppExpired(String tenantId, String appCode, String eventType){
        try {
            List<String> aithorizationsApplication = cacService.getAuthorizationsApplication(tenantId);
            if(Constants.AppNoticeType.RENEW.equalsIgnoreCase(eventType)){
                //当renew的时候
                List<String> appCodes = dataPickService.tenantInitializedAppCodes(AthenaUtils.getTenantId());
                if(CollectionUtils.isEmpty(appCodes)
                        || (appCodes.size() == 1 && appCodes.get(0).equalsIgnoreCase(appCode))){
                    //当租户节点和应用节点已经没有关系，或者只有本身应用和租户之间有关系连线，则表示是应用都过期60天后的第一次renew，
                    return true;
                }else{
                    for(String tenantAppCode : appCodes){
                        if(StringUtils.equalsIgnoreCase(appCode, tenantAppCode)){
                            continue;
                        }
                        if(aithorizationsApplication.contains(tenantAppCode)){
                            //如果有其他应用还没有过期
                            return false;
                        }
                    }
                    return true;
                }

            }

            List<String> allAppCode = this.appService.getNotCommonAppCode();

            List<String> intersection = (List<String>)CollectionUtils.intersection(allAppCode, aithorizationsApplication);
            if(!ObjectUtils.isEmpty(intersection)){ //如果有未过期的应用，直接返回false
                return false;
            }

            if(Constants.AppNoticeType.CLEAN.equalsIgnoreCase(eventType)){ //当是clean的时候，判断是否都过期60天
                String tenantToken = this.iamService.getTenantToken(tenantId);
                Object o = this.iamService.listAllTenantApplications(tenantToken);
                JSONArray jsonArray = JSONArray.parseArray(JSON.toJSONString(o));

                for(int i = 0; i <jsonArray.size(); i++){
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String id = jsonObject.getString("id");
                    if(allAppCode.contains(id)){ //是与Athena相关的应用
                        String expiredTime = jsonObject.getString("expiredTime");
                        LocalDate expireTimeLocalDate = LocalDate.parse(expiredTime.substring(0, 10), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                        long cha = LocalDate.now().toEpochDay() - expireTimeLocalDate.toEpochDay();
                        if( cha < Constants.AppNoticeType.RETAIN_DAYS + 1){
                            return false;
                        }
                    }
                }
            }


        } catch (Exception e) {
            log.error("checkAllAppExpired error:{}", e.getMessage());
            return false;
        }

        return true;
    }

    private void executeCypher(List<String> cypherList, SessionFactory sessionFactory){
        if(CollectionUtils.isEmpty(cypherList)){
            return;
        }
        if(sessionFactory == null){
            return;
        }
        Session session1 = sessionFactory.openSession();
        Transaction transaction1 = session1.beginTransaction();
        cypherList.forEach(cypher->session1.query(cypher, new HashMap<>()));
        transaction1.commit();
        session1.clear();
    }

    public String getAppExpireChangeMessage(String appCode, String tenantId, String eventType){
        Map<String, String> result = new HashMap<>();
        result.put("tenantId", tenantId);
        result.put("appCode", appCode);
        result.put("eventType", eventType);
        return JSON.toJSONString(result);
    }

    @Override
    public Object getUserIntegrityCheck() throws DWBusinessException {
        String userIntegrityCheck = DWApplicationConfigUtils.getProperty(Constants.USER_INTEGRITY_CHECK_SWITCH);
        log.info("userIntegrityCheck:{}", userIntegrityCheck);
        if(StringUtils.equalsIgnoreCase(userIntegrityCheck, "false")){ //当开关关闭时，不进行校验，直接返回完整
            Map<String, Object> result = new HashMap<>();
            result.put("userRole", "common");
            result.put("userIntegrity", true);
            return result;
        }
//        //获取租户下未过期的应用
//        List<String> appCodes = this.getAppCodes(AthenaUtils.getTenantId());
//        //获取应用下所有的职能
//        Query query = new Query();
//        Criteria criteria = Criteria.where("type").is("duty").and("appCode").in(appCodes);
//        query.addCriteria(criteria);
//        List<ApplicationRelation> applicationRelationList = this.mongoTemplate.find(query, ApplicationRelation.class);
//        List<String> dutyList = applicationRelationList.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
        //单个用户校验不需要检查职能
        List<String> dutyList = new ArrayList<>();

        List<String> needUserCheckApp = this.applicationService.getNeedUserCheckApp(AthenaUtils.getTenantId());
        if(CollectionUtils.isEmpty(needUserCheckApp)){ //空的时候不用调用eoc校验了了，直接返回
            log.info("userIntegrityCheck needUserCheckApp is empty:{}", AthenaUtils.getTenantId());
            Map<String, Object> result = new HashMap<>();
            result.put("userRole", "common");
            result.put("userIntegrity", true);
            return result;
        }

        //调用eoc接口
        log.info("call checkByUser tenantId:{}, userId:{}, duty:{}, appIds:{}", AthenaUtils.getTenantId(), AthenaUtils.getUserId(), dutyList, needUserCheckApp);
        Object response = this.eocService.checkByUser(AthenaUtils.getHeaderToken(), dutyList, needUserCheckApp);
        JSONObject checkByUserResp = JSON.parseObject(JSON.toJSONString(response));
        JSONObject data = checkByUserResp.getJSONObject("data");
        Map<String, Object> result = new HashMap<>();
        result.put("userRole", (data != null && data.getBooleanValue("superadmin")) ? "super" : "common");
        result.put("userIntegrity", StringUtils.equals(checkByUserResp.getString("code"), "200"));

        return result;
    }

    @Override
    public void getTenantUsersIntegrityCheck(){
        String userIntegrityCheck = DWApplicationConfigUtils.getProperty(Constants.USER_INTEGRITY_CHECK_SWITCH);
        log.info("scheduleUserIntegrityCheck:{}", userIntegrityCheck);
        if(StringUtils.equalsIgnoreCase(userIntegrityCheck, "false")){ //当开关关闭时，不进行校验，直接返回
            return;
        }
        // 分布式锁key增加redis规范appId前缀
        String kgTenantUsersIntegrityCheckLock = ComponentConstants.REDIS_KNOWLEDGE_GRAPH + ":tenantUsersIntegrityCheckLock";
        String tenantUsersIntegrityCheckLock = null;
        try {
            tenantUsersIntegrityCheckLock = redisLock.tryLock(kgTenantUsersIntegrityCheckLock, 5 * 60 * 1000);
            if (tenantUsersIntegrityCheckLock != null) {
                log.info("=======拿到检查用户完整性的锁{}:{}=======", kgTenantUsersIntegrityCheckLock, tenantUsersIntegrityCheckLock);
                log.info("===========开始TenantUsersIntegrityCheck过程==========");

                List<TenantEntity> tenantEntities = getAllTenant();
                List<String> tenantIdList = tenantEntities.stream().filter(e->StringUtils.isNotEmpty(e.getTenantId()))
                        .map(TenantEntity::getTenantId).distinct().collect(Collectors.toList());
                log.info("===========tenantIdList count:{}", tenantIdList.size());

                List<Map> requestParamList = new ArrayList<>();
                for(String tenantId : tenantIdList){
                    //获取租户下未过期的应用
                    try {
//                        List<String> appCodes = this.getAppCodes(tenantId);
                        List<String> appCodes = this.appService.getNeedUserCheckApp(tenantId);
                        if(CollectionUtils.isEmpty(appCodes)){
                            log.info("tenantHasNoEffectiveApp:{}", tenantId);
                            continue;
                        }
                        //获取应用下所有的职能
                        Query query = new Query();
                        Criteria criteria = Criteria.where("type").is("duty").and("appCode").in(appCodes);
                        query.addCriteria(criteria);
                        List<ApplicationRelation> applicationRelationList = this.mongoTemplate.find(query, ApplicationRelation.class);
                        List<String> dutyList = applicationRelationList.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
                        Map<String, Object> map = new HashMap<>();
                        map.put("tenantId", tenantId);
                        map.put("dutyIds", dutyList);
                        map.put("appIds", appCodes);
                        map.put("version", "v2");
                        requestParamList.add(map);
                    } catch (DWBusinessException e) {
                        log.error("generate userCheckParam error:{}", e.getMessage());
                    }
                }
                List<List<Map>> partitions = Lists.partition(requestParamList, 10);//每10个租户去调用下eoc
                for(List<Map> partition : partitions){
                    try {
                        //获取一个租户的集成用户token
                        String tenantToken = null;
                        int tryTimes = 0;
                        while(tenantToken == null && tryTimes < 3) {
                            tryTimes++;
                            tenantToken = this.iamService.getTenantToken(String.valueOf(partition.get(0).get("tenantId")));
                        }
                        if(StringUtils.isEmpty(tenantToken)){
                            log.error("tenantTokenIsEmpty:{}, params:{}", partition.get(0).get("tenantId"), partition);
                            continue;
                        }
                        Object o = this.eocService.checkByUsers(tenantToken, partition);
                        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(o));
                        if(!StringUtils.equals(jsonObject.getString("code"), "200")){ //校验没有通过
                            JSONArray data = jsonObject.getJSONArray("data");
                            if(data != null){
                                for(int i=0; i<data.size(); i++){
                                    JSONObject jsonObject1 = data.getJSONObject(i);
                                    //发送IM和email消息
                                    this.atmcService.noticeSuperAdminUserIntegrityCheckResult(jsonObject1);
                                }
                            }
                        }
                    } catch (Exception e) {
                        log.error("call checkByUsers error:{}", e.getMessage());
                    }

                }
                log.info("===========结束TenantUsersIntegrityCheck过程==========");
            }else{
                log.info("=======没有拿到检查用户完整性的锁{}，应用的其他实例正在处理=======", kgTenantUsersIntegrityCheckLock);
            }
        }catch (Exception e) {
            log.error("tenantUsersIntegrityCheck error:{}", e.getMessage());
        } finally {
            if(tenantUsersIntegrityCheckLock != null){
                log.info("释放锁{}：{}", kgTenantUsersIntegrityCheckLock, tenantUsersIntegrityCheckLock);
                redisLock.unlock(kgTenantUsersIntegrityCheckLock, tenantUsersIntegrityCheckLock);
            }
        }
    }

    @Override
    public void postMockNoticeSuperAdminUserIntegrityCheckResult(JSONObject param) throws DWBusinessException{
        this.atmcService.noticeSuperAdminUserIntegrityCheckResult(param);
    }

    // 语义获取租户购买的应用信息和租户版本信息
    @Override
    public Object getAppsInfo() throws DWBusinessException {
//        Map<String,Object> appInfo = new HashMap<>();
//        List<TenantAppRelation> tenantAppRelations = dataPickService.tenantInitializedApps(AthenaUtils.getTenantId());
//        appInfo.put("tenantAppInfos", tenantAppRelations);
//        appInfo.put("tenantVersion",kgInnerService.currentTenantVersion());
//        return appInfo;

        RespObject respTenantEntity = appMetaCaller.call("/tenant/appsInfo","get",null,RespObject.class);
        return respTenantEntity.getResponse();
    }

    // 获取用户授权应用
    @Override
    public Object getUserAppAuth() throws DWBusinessException {
//        String userId = AthenaUtils.getUserId();
//        if (StringUtils.isEmpty(userId)) {
//            throw new DWBusinessException("userId is empty");
//        }
//
//        Map<String,Object> tenantAppInfos = new HashMap<>();
//        tenantAppInfos.put("appCodes",this.cacUtils.getAppAuth(userId));
//        tenantAppInfos.put("tenantVersion",kgInnerService.currentTenantVersion());
//        tenantAppInfos.put("tenantId",AthenaUtils.getTenantId());
//        tenantAppInfos.put("userId",userId);
//        return tenantAppInfos;

        RespObject respTenantEntity = appMetaCaller.call("/tenant/userAppAuth","get",null,RespObject.class);
//        return respTenantEntity.getResponse();
        Object res = respTenantEntity.getResponse();
        if (Objects.nonNull(res) && res instanceof JSONObject) {
            JSONObject resObj = (JSONObject) res;
            JSONArray appCodes = resObj.getJSONArray("appCodes");
            if (CollectionUtils.isNotEmpty(appCodes)) {
                List<Map> applications = mongoTemplate.find(Query.query(Criteria.where("code").in(appCodes)), Map.class, "application");
                resObj.put("applications", applications);
            }
            return resObj;
        }
        return res;
    }

    // 获取用户授权应用 ,传userId,解决集成token对应userId错误的问题
    @Override
    public Object getUserAppAuth(String userId) throws DWBusinessException {
        if (StringUtils.isEmpty(userId)) {
            userId = AthenaUtils.getUserId();
        }

        Map<String,Object> tenantAppInfos = new HashMap<>();
        List<String> appCodes = this.cacUtils.getAppAuth(userId);
        tenantAppInfos.put("appCodes",this.cacUtils.getAppAuth(userId));
        tenantAppInfos.put("tenantVersion",kgInnerService.currentTenantVersion());
        tenantAppInfos.put("tenantId",AthenaUtils.getTenantId());
        tenantAppInfos.put("userId",userId);
//        RespObject respTenantEntity = appMetaCaller.call("/tenant/userAppAuthyUserId","get",AppMetaCaller.of("userId",userId),RespObject.class);
//        return respTenantEntity.getResponse();
//        Object res = respTenantEntity.getResponse();
        /*if (Objects.nonNull(res) && res instanceof JSONObject) {
            JSONObject resObj = (JSONObject) res;
            JSONArray appCodes = resObj.getJSONArray("appCodes");*/
            if (CollectionUtils.isNotEmpty(appCodes)) {
                List<Map> applications = mongoTemplate.find(Query.query(Criteria.where("code").in(appCodes)), Map.class, "application");
                tenantAppInfos.put("applications", applications);
            }
//            return resObj;
//        }
        return tenantAppInfos;
    }
    // 用户粒度查询授权应用
    @Override
    public List<Application> getUserMetricApplication() throws DWBusinessException {
        return getUserMetricApplication("1");
    }

    @Override
    public List<Application> getUserMetricApplication(String type) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        return getUserMetricApplication(type,userId);
    }

    @Override
    public List<Application> getUserMetricApplication(String type,String userId) throws DWBusinessException {
        if (StringUtils.isEmpty(userId)) {
            userId = AthenaUtils.getUserId();
        }

        String tenantVersion = kgInnerService.currentTenantVersion();
        // 查询租户授权应用，类型是1代表查敏捷数据应用
        List<String> appCodes = cacUtils.getAppAuth(userId);
        if (StringUtils.equals(type,"1")) {
            // 查询敏捷数据应用
            return mongoTemplate.find(
                    Query.query(Criteria.where("version").is(tenantVersion)
                            .and("code").in(appCodes).and("appType").in(6,12)),Application.class);
        }

        return mongoTemplate.find(
                Query.query(Criteria.where("version").is(tenantVersion)
                        .and("code").in(appCodes)),Application.class);

        /*Map<String,Object> map=AppMetaCaller.of("userId",userId);
        map.put("type",type);
        RespApplicationList respTenantEntity = appMetaCaller.call("/tenant/userMetricApplicationByTypeAndUserId","get",map,RespApplicationList.class);
        return respTenantEntity.getResponse();*/
    }

    @Override
    public List<Application> getTenantMetricApplication() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.currentTenantVersion();
        // 查询租户授权应用
        List<String> appCodes = cacService.getAuthorizationsApplication(tenantId);
        // 查询敏捷数据应用
        return mongoTemplate.find(
                Query.query(Criteria.where("version").is(tenantVersion)
                        .and("code").in(appCodes).and("appType").in(6,12)),Application.class);
    }

    // 根据租户查询大屏场景
    @Override
    public List<BigScreenViewDTO> getQuerySceneByTenant() throws Exception {
        List<BigScreenViewDTO> reportScenes = new ArrayList<>();
              String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.currentTenantVersion();

        // 查询用户授权敏捷数据应用的鼎捷云授权
         List<String> bigScreenCodes = iScreenService.getUserPermissionScreen(Collections.singletonList("bigScreen"));
        if (CollectionUtils.isEmpty(bigScreenCodes)) {
            return reportScenes;
        }

        // 先查应用数据
        List<ReportSceneDTO> sceneResults = sceneService.querySceneByCodeAndTag(bigScreenCodes, tenantVersion);
        reportScenes = sceneResults.stream()
                .map(scene -> BigScreenViewDTO.builder()
                        .screenCode(scene.getCode())
                        .screenName(scene.getSceneTitle())
                        .flashFrequency(5)
                        .pageTurningFrequency(30)
                        .type("system")
                        .build())
                .collect(Collectors.toList());

        // 查询用户级别大屏配置信息
        Query query = Query.query(Criteria
                .where("userId").is(AthenaUtils.getUserId()));
        query.with(Sort.by(Sort.Direction.DESC, "createDate"));
        List<UserScreenConfig> userScreenList = mongoTemplateUser.find(query, UserScreenConfig.class);
        reportScenes.addAll(0,userScreenList.stream()
                .map(scene -> BigScreenViewDTO.builder()
                        .screenCode(scene.getCode())
                        .screenName(scene.getName())
                        .flashFrequency(5)
                        .pageTurningFrequency(30)
                        .type("user")
                        .build())
                .collect(Collectors.toList()));

        //再查租户数据，设置应用级标题和频率等
        List<BigScreenViewConfig> appBigScreenViewConfigs = mongoTemplateUser.find(Query.query(Criteria.where("bigScreenCode").in(bigScreenCodes)
                .and("tenantId").is(tenantId)), BigScreenViewConfig.class);

        // 设置租户级别的配置信息
        Map<String, BigScreenViewConfig> configMap = appBigScreenViewConfigs.stream()
                .filter(config -> Objects.nonNull(config) && StringUtils.isNotEmpty(config.getBigScreenCode()))
                .collect(Collectors.toMap(BigScreenViewConfig::getBigScreenCode, Function.identity()));

        for (BigScreenViewDTO bigScreenView : reportScenes) {
            BigScreenViewConfig appConfig = configMap.get(bigScreenView.getScreenCode());
            if (appConfig != null) {
                bigScreenView.setScreenName(StringUtils.isNotEmpty(appConfig.getBigScreenTitle()) ?
                        appConfig.getBigScreenTitle() : bigScreenView.getScreenName());
                bigScreenView.setFlashFrequency(Optional.ofNullable(appConfig.getFlashFrequency()).orElse(5));
                bigScreenView.setPageTurningFrequency(Optional.ofNullable(appConfig.getPageTurningFrequency()).orElse(30));
            }
        }

        return reportScenes;
    }
    /**
     * 获取系统级与租户级服务配置
     * @param tenantId      租户ID
     * @param serviceName   服务名称
     * @return  Map
     * @throws DWBusinessException
     */
    @Override
    public Object getSystemTenantServiceConfig(String tenantId, String serviceName) throws DWBusinessException {
        if(StringUtils.isEmpty(tenantId) || StringUtils.isEmpty(serviceName)){
            return Collections.emptyMap();
        }
        // 获取数据库租户配置的产品信息
        TenantServiceConfig tenantServiceConfig = tenantServiceConfigDAO.findTenantServiceConfig(tenantId, serviceName);
        // 获取数据库系统级配置的产品信息
        String[] systemServiceConfig = productNameResolver.getPrioritizedProductList(serviceName);
        // 定义返回MAP
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("tenantServiceConfig", tenantServiceConfig);
        resultMap.put("systemServiceConfig", systemServiceConfig);
        return resultMap;
    }


    @Override
    public Object postQueryPermissionSceneByCode(List<String> codes) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        String tenantVersion = kgInnerService.currentTenantVersion();
        String userId = AthenaUtils.getUserId();
        // 查询用户授权敏捷数据应用的鼎捷云授权
//        List<String> permissionCodes = iScreenService.getUserPermissionScreen(Arrays.asList("scene","metric"));
        List<ReportSceneDTOs> dataSets = mongoTemplate.find(Query.query(Criteria.where("version").is(tenantVersion).and("code").in(codes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");

        List<PermissionSceneDTO> reportScenes = new  ArrayList<>();
        if (CollectionUtils.isNotEmpty(dataSets)) {
            List<String> applicationCodes = dataSets.stream()
                    .map(ReportSceneDTOs::getAppCode)
                    .distinct()
                    .collect(Collectors.toList());
            List<String> permissionCodes = screenService.getUserPermissionScreen(userId, new ArrayList<>(),applicationCodes);
            reportScenes = dataSets.stream()
                    .map(scene -> {
                        boolean isAuthorized = permissionCodes.contains(scene.getCode());
                        PermissionSceneDTO dto = new PermissionSceneDTO();
                        dto.setCode(scene.getCode());
                        dto.setSceneTitle(scene.getName());
                        dto.setIsAuthorized(isAuthorized);
                        return dto;
                    })
                    .collect(Collectors.toList());
            return sceneService.getTranslateContent(reportScenes);
        }
        List<ReportSceneDTO> scenes = sceneService.querySceneMapsData(codes, tenantVersion);

        if (CollectionUtils.isEmpty(scenes)) {
            return sceneService.getTranslateContent(reportScenes);
        }
        List<String> applicationCodes = scenes.stream()
                .map(ReportSceneDTO::getAppCode)
                .distinct()
                .collect(Collectors.toList());
        List<String> permissionCodes = screenService.getUserPermissionScreen(userId, new ArrayList<>(),applicationCodes);

        List<PermissionSceneDTO> reportSceneLists = scenes.stream()
                .map(scene -> {
                    boolean isAuthorized = permissionCodes.contains(scene.getCode());
                    PermissionSceneDTO dto = new PermissionSceneDTO();
                    dto.setCode(scene.getCode());
                    dto.setSceneTitle(scene.getSceneTitle());
                    dto.setIsAuthorized(isAuthorized);
                    return dto;
                })
                .collect(Collectors.toList());
//        reportScenes.addAll(reportSceneLists);
        return sceneService.getTranslateContent(reportSceneLists);
    }



    @Override
    public Object postQueryPermissionSceneByCode(List<String> codes,String userId) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        String tenantVersion = kgInnerService.currentTenantVersion();
        // 查询用户授权敏捷数据应用的鼎捷云授权
//        List<String> permissionCodes = iScreenService.getUserPermissionScreen(Arrays.asList("scene","metric"));
        List<ReportSceneDTOs> dataSets = mongoTemplate.find(Query.query(Criteria.where("version").is(tenantVersion).and("code").in(codes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");

        List<PermissionSceneDTO> reportScenes = new  ArrayList<>();
        if (CollectionUtils.isNotEmpty(dataSets)) {
            List<String> applicationCodes = dataSets.stream()
                    .map(ReportSceneDTOs::getAppCode)
                    .distinct()
                    .collect(Collectors.toList());
            List<String> permissionCodes = screenService.getUserPermissionScreen(userId, new ArrayList<>(),applicationCodes);
            reportScenes = dataSets.stream()
                    .map(scene -> {
                        boolean isAuthorized = permissionCodes.contains(scene.getCode());
                        PermissionSceneDTO dto = new PermissionSceneDTO();
                        dto.setCode(scene.getCode());
                        dto.setSceneTitle(scene.getName());
                        dto.setIsAuthorized(isAuthorized);
                        return dto;
                    })
                    .collect(Collectors.toList());
            return sceneService.getTranslateContent(reportScenes);
        }
        List<ReportSceneDTO> scenes = sceneService.querySceneMapsData(codes, tenantVersion);

        if (CollectionUtils.isEmpty(scenes)) {
            return sceneService.getTranslateContent(reportScenes);
        }
        List<String> applicationCodes = scenes.stream()
                .map(ReportSceneDTO::getAppCode)
                .distinct()
                .collect(Collectors.toList());
        List<String> permissionCodes = screenService.getUserPermissionScreen(userId, new ArrayList<>(),applicationCodes);

        List<PermissionSceneDTO> reportSceneLists = scenes.stream()
                .map(scene -> {
                    boolean isAuthorized = permissionCodes.contains(scene.getCode());
                    PermissionSceneDTO dto = new PermissionSceneDTO();
                    dto.setCode(scene.getCode());
                    dto.setSceneTitle(scene.getSceneTitle());
                    dto.setIsAuthorized(isAuthorized);
                    return dto;
                })
                .collect(Collectors.toList());
//        reportScenes.addAll(reportSceneLists);
        return sceneService.getTranslateContent(reportSceneLists);
    }

    @Override
    public Object postQueryPermissionSceneByCode(String userId,List<String> appCodes,List<String> codes) throws DWBusinessException {
        if (CollectionUtils.isEmpty(appCodes) || CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        List<String> permissionCodes = iScreenService.getUserPermissionScreen(userId,Arrays.asList("scene","metric"),appCodes);

        if (CollectionUtils.isEmpty(permissionCodes)) {
            return Collections.emptyList();
        }

        return codes.stream().filter(permissionCodes::contains)
                .collect(Collectors.toList());
    }

    @Override
    public Object postQueryProductLineByApp(List<String> appCodes) throws DWBusinessException {
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyMap();
        }

        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query(Criteria.where("code").in(appCodes)
                .and("version").is(tenantVersion));
        List<Application> applications = mongoTemplate.find(query,Application.class);
        return appCodes.stream()
                .collect(Collectors.toMap(
                        appCode -> appCode, // 以 appCode 为 key
                        appCode -> applications.stream()
                                .filter(application -> application.getCode().equals(appCode))
                                .findFirst()
                                .map(Application::getProductLines) // 获取对应的产品线
                                .orElse(Collections.emptyList()) // 如果没有找到，返回空列表
                        ,(existing, replacement) -> existing));

        /*RespObject respTenantEntity = appMetaCaller.call("/tenant/queryProductLineByApp","post",AppMetaCaller.of("appCodes",appCodes),RespObject.class);
        return respTenantEntity.getResponse();*/
    }

}