package com.digiwin.athena.knowledgegraph.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.locale.Lang;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import com.digiwin.athena.knowledgegraph.domain.MockData;
import com.digiwin.athena.repository.neo4j.Activity2Repository;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.knowledgegraph.service.ITestService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import lombok.extern.slf4j.Slf4j;
import com.digiwin.athena.knowledgegraph.utils.TranslateUtils;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-05-12 16:45
 **/
@Lang
@Service
@Slf4j
public class TestService implements ITestService {

    private static Logger logger = LoggerFactory.getLogger(TestService.class);

    {
        System.out.println("TestService..........");
    }
    ThreadLocal<String> local = new ThreadLocal<>();

    @Value("${hello1}")
    private String hello1;

    @Autowired(required=false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain1;

    @Autowired(required=false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactoryDomain2;

    @Autowired
    private StringRedisTemplate redisTemplate;

    @Autowired
    TranslateUtils translateUtils;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplate;


    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    Activity2Repository activity2Repository;

    @Autowired
    MonitorRuleRepository monitorRuleRepository;

    @Override
    public String getTest01(String input) {
        System.out.println("test01..............."+hello1);
//        List<Activity> activities = activity2Repository.getActivitiesByPattern("E10ATHENA6003","STATEMENT","1.0");
//        System.out.println(activities.size());

        System.out.println(monitorRuleRepository.findByCodeAndVersion(input,"2.0"));


        return "hello "+hello1;
    }

    @Override
    public String getTest02(String input,String paas) {
        System.out.println("test02..............."+hello1);
        if(!"zhangtuo0813".equals(paas)){return "error";}


        new Thread(){
            public void run (){
                cleanData(input,sessionFactoryDomain1);
            }
        }.start();

        long count = cleanData(input,sessionFactoryDomain2);


        return count+"";
    }


    private long cleanData(String version,SessionFactory sessionFactory){
        Map<String,Object> param = new HashMap<>();
        param.put("version",version);
        String cypher = "match (te:TenantEntity{version:$version})-[r:ACTION]->(action:EspAction{version:$version,nameSpace:'espCommon'}) where te.ifCommon is null and action.inclusionTenant is null and action.notInclusionTenant is null with r limit 100000 delete r return count(r) as count";
        AtomicLong count=new AtomicLong(0);
        AtomicLong total=new AtomicLong(0);
        Session session = sessionFactory.openSession();
        do{
            Result result = session.query(cypher,param);
            result.queryResults().forEach(map->{
              Object c= map.get("count");
              count.set((Long) c);
              total.addAndGet((Long) c);
            });
        System.out.println(Thread.currentThread().getName()+" delete " +count.get());
        }while (count.get()>0);
        System.out.println(Thread.currentThread().getName()+" total " +total.get());

        return total.get();
    }

    @Override
    public String getTest03(String input) throws DWBusinessException {
        System.out.println("test03..............."+input);
        String tenantId = AthenaUtils.getTenantId();
        // 获取租户版本
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        return tenantId+":"+tenantVersion;
    }

    @Override
    public String getTest04(String input) {
        System.out.println("test04..............."+input);
        return input;
    }

    @Override
    public String postTest05(String input) {

        sessionFactoryDomain1.openSession().query(input,new HashMap<>());
        sessionFactoryDomain2.openSession().query(input,new HashMap<>());

        return null;
    }

    @Override
    public Object getMock01(String key) {

        String template ="[]";
        switch (key){
            case "process":
                template = "[{\"proNo\": \"pro01\",\"proName\": \"制程1\"},{\"proNo\": \"pro02\",\"proName\": \"制程2\"},{\"proNo\": \"pro03\",\"proName\": \"制程3\"}]";
                break;

            case "material":
                template="[{\"mateNo\": \"mate01\",\"mateName\": \"物料1\"},{\"mateNo\": \"mate02\",\"mateName\": \"物料2\"},{\"mateNo\": \"mate03\",\"mateName\": \"物料3\"}]";
                break;

        }

        Object obj = JSON.parse(template);

        return obj;
    }

    @Override
    public String getBigRedisKeyValue(String pattern) {
        try {
            Map<String, Object> result = new HashMap<>();
            Set<String> keys = redisTemplate.keys(pattern);
            if (keys == null || keys.isEmpty()) {
                return "km相关key为空";
            }
            result.put("getBigRedisKeyValueScan解析km相关key数量", keys.size());
            logger.info("getBigRedisKeyValueScan解析km相关keys：{}，数量：{}", JsonUtil.toJsonString(keys), keys.size());
            Map<String, Object> stringKeyValueMap = new HashMap<>();
            Map<String, Object> stringKeyValueBigMap = new HashMap<>();
            Set<String> errorKeys = new HashSet<>();
            for (String key : keys) {
                try {
                    String value = redisTemplate.opsForValue().get(key);
                    int valueSize = String.valueOf(value).getBytes().length ;
                    stringKeyValueMap.put(key, valueSize);
                    int valueSizeKB = String.valueOf(value).getBytes().length / 1024;
                    if (valueSizeKB > 10) {
                        stringKeyValueBigMap.put(key, valueSizeKB);
                    }
                } catch (RedisConnectionFailureException e) {
                    // 处理Redis连接失败异常
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan解析Redis连接失败", e);
                } catch (Exception e) {
                    // 处理其他异常情况
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan解析Redis的value发生异常", e);
                }
            }
            result.put("stringKeyValueMap", stringKeyValueMap);
            result.put("stringKeyValueBigMap", stringKeyValueBigMap);
            result.put("errorKeys", errorKeys);
            logger.info("getBigRedisKeyValueScan返回结果：{}", JsonUtil.toJsonString(result));
            return JsonUtil.toJsonString(result);
        } catch (Exception e) {
            // 处理异常情况，可以记录日志或者返回错误信息
            logger.error("getBigRedisKeyValueScan获取Redis Key发生异常", e);
            return "getBigRedisKeyValueScan获取Redis Key发生异常";
        }
    }

    @Override
    public String getBigRedisKeyValueScan(String pattern) {
        try {
            Map<String, Object> result = new HashMap<>();
            ScanOptions options = ScanOptions.scanOptions().match(pattern).build();
            Set<String> keys = new HashSet<>();
            redisTemplate.execute((RedisCallback<Set<String>>) connection -> {
                try (Cursor<byte[]> cursor = connection.scan(options)) {
                    while (cursor.hasNext()) {
                        String key = new String(cursor.next(), StandardCharsets.UTF_8);
                        // 处理key，判断是否是string类型
                        DataType type = connection.type(key.getBytes());
                        if (type == DataType.STRING) {
                            keys.add(key);
                        }
                    }
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                return keys;
            });
            if (keys.isEmpty()) {
                return "km相关key为空";
            }
            result.put("getBigRedisKeyValueScan解析km相关key类型为String的数量", keys.size());
            logger.info("getBigRedisKeyValueScan解析km相关类型为String的keys：{}，数量：{}", JsonUtil.toJsonString(keys), keys.size());
            Map<String, Object> stringKeyValueMap = new HashMap<>();
            Map<String, Object> stringKeyValueBigMap = new HashMap<>();
            Set<String> errorKeys = new HashSet<>();
            for (String key : keys) {
                try {
                    String value = redisTemplate.opsForValue().get(key);
                    int valueSize = String.valueOf(value).getBytes().length ;
                    stringKeyValueMap.put(key, valueSize);
                    int valueSizeKB = String.valueOf(value).getBytes().length / 1024;
                    if (valueSizeKB > 10) {
                        stringKeyValueBigMap.put(key, valueSizeKB);
                    }
                } catch (RedisConnectionFailureException e) {
                    // 处理Redis连接失败异常
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan解析Redis连接失败", e);
                } catch (Exception e) {
                    // 处理其他异常情况
                    errorKeys.add(key);
                    logger.error("getBigRedisKeyValueScan解析Redis的value发生异常", e);
                }
            }
            result.put("stringKeyValueMap", stringKeyValueMap);
            result.put("stringKeyValueBigMap", stringKeyValueBigMap);
            result.put("errorKeys", errorKeys);
            logger.info("getBigRedisKeyValueScan返回结果：{}", JsonUtil.toJsonString(result));
            return JsonUtil.toJsonString(result);
        } catch (Exception e) {
            // 处理异常情况，可以记录日志或者返回错误信息
            logger.error("getBigRedisKeyValueScan获取Redis Key发生异常", e);
            return "getBigRedisKeyValueScan获取Redis Key发生异常";
        }
    }

    @Override
    public String getTest06(String content) throws DWBusinessException {
        return translateUtils.translateContent(content);
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getMockMetaData(String type, String condition) {
        Query query = new Query();
        Criteria criteria = Criteria.where("type").is(type);
        query.addCriteria(criteria);
        MockData mockData = this.mongoTemplate.findOne(query, MockData.class);
        Object metaData = mockData.getMetaData();
        if (condition != null && !condition.isEmpty()
                && metaData instanceof Map
                && ((Map<?, ?>) metaData).get("meta_data_list") != null) {
            List<Map<String, Object>> list = (List<Map<String, Object>>) ((Map<?, ?>) metaData).get("meta_data_list");
            String[] conditions = condition.split(";");
            for (String c : conditions) {
                filter(list, c);
            }
        }
        return metaData;
    }

    private void filter(List<Map<String, Object>> metadataList, String condition) {
        String[] con = condition.split("=");
        if (con.length != 2) {
            return;
        }
        metadataList.removeIf(
                metadata ->
                        metadata.get(con[0]) == null || !metadata.get(con[0]).toString().equals(con[1]));
    }
}
