package com.digiwin.athena.knowledgegraph.service.inner;

import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.kmservice.neo4j.Neo4j1Config;
import com.digiwin.athena.kmservice.neo4j.Neo4j2Config;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.knowledgegraph.service.impl.ProductService;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-08-19 14:17
 **/
@Service
@Slf4j
public class KgHelpService {


    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;

    @Autowired
    SessionFactory neo4jSessionFactory;

    @Autowired(required = false)
    @Qualifier(Neo4j1Config.SESSION_FACTORY)
    SessionFactory sessionFactory1;

    @Autowired(required = false)
    @Qualifier(Neo4j2Config.SESSION_FACTORY)
    SessionFactory sessionFactory2;


    @Autowired
    ActionService actionService;

    @Autowired
    ProductService productService;

    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;


    @Autowired
    ObjectMapper objectMapper;

    public void executeCyhper(String cyhper, Map<String,Object> param){

        if(null!=sessionFactory1){
            Session session = sessionFactory1.openSession();
            session.query(cyhper, param);
        }
        if(null!=sessionFactory2){
            Session session = sessionFactory2.openSession();
            session.query(cyhper,param);
        }


    }

    /**
     * 仅仅用户新增数据，因为每次执行前都会把neo4jId设置为空 rule.setNeo4jId(null);
     * @param rule
     */
    public void executeCyhperSave(MonitorRule rule){

        if(null!=sessionFactory1){
            rule.setNeo4jId(null);
            Session session = sessionFactory1.openSession();
            session.save(rule);
        }
        if(null!=sessionFactory2){
            rule.setNeo4jId(null);  //需设置为null，不然第一次执行后的rule对象里带neo4jId,不会执行新增操作
            Session session = sessionFactory2.openSession();
            session.save(rule);
        }
    }


    //todo 我靠 租户拿个产品都这么困难？还玩个锤子！
    public String getTenantProduct(String ruleId)  {

        try {

            List<String> monitorRuleProducts=null;
            if(null!=ruleId){
                monitorRuleProducts = (List<String>) monitorRuleConfigService.getProductNameByMonitorRule(ruleId);
                if(monitorRuleProducts.size()==1){
                    return monitorRuleProducts.get(0);
                }
            }

            List<String> tenantProducts = actionService.getTenantProductList();
            if(CollectionUtils.isEmpty(tenantProducts)){
                return null;
            }else if(tenantProducts.size()==1){
                return tenantProducts.get(0);
            }
            List<String> allSteadyProduct = (List<String>) productService.getAllSteadyProduct();
            tenantProducts.retainAll(allSteadyProduct);
            if(CollectionUtils.isEmpty(tenantProducts)){
                return null;
            }else if(tenantProducts.size()==1){
                return tenantProducts.get(0);
            }

            if(null!=monitorRuleProducts){
                tenantProducts.retainAll(monitorRuleProducts);
                if(tenantProducts.size()>0){
                    return tenantProducts.get(0);
                }
            }
        }catch (Exception e){
            log.error(e.getMessage(),e);
        }

        return null;

    }

    public <T> T convert(Object obj,Class<T> c){
        T t = objectMapper.convertValue(obj,c);
        return t;
    }


    public Query buildQuery(Map<String,Object> query) throws DWBusinessException {
        Query query1 = new Query();
        query.forEach((k,v)->{
            if(v instanceof Collection){
                List list = new ArrayList();
                Collection collection = (Collection) v;
                collection.forEach(ele->{list.add(ele);});
                query1.addCriteria(Criteria.where(k).in(list));
            }else{
                if("name".equalsIgnoreCase(k) && v instanceof String){
                    String sv = (String) v;
                    query1.addCriteria(
                            new Criteria().orOperator(
                                    Criteria.where("name").regex(sv),
                                    Criteria.where("lang.name.zh_CN").regex(sv),
                                    Criteria.where("lang.name.zh_TW").regex(sv),
                                    Criteria.where("lang.name.en_US").regex(sv)
                            )
                    );
                }else {
                    query1.addCriteria(Criteria.where(k).is(v));
                }
            }
        });
        return query1;
    }


}
