package com.digiwin.athena.knowledgegraph.set;

import com.digiwin.athena.set.Sets;
import com.digiwin.athena.set.part.EmailNotice;
import com.digiwin.athena.set.part.ReturnField;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class SetParseContext {

    private Sets currentSet;

    private DTDRelatedInfo dtdRelatedInfo;

    private List<ReturnField> returnFieldAll = new ArrayList<>();

    private List<String> neo4jSql = new ArrayList<>();

    /**
     * 影响的租户id
     */
    private List<String> effectiveTenantIds;

    /**
     * 是否为已经存在的set
     */
    private boolean exists = false;

    public SetParseContext(Sets sets) {
        this.currentSet = sets;
    }

    private List<EmailNotice> emailNotices;

    private Boolean enableEmailNotice;

}
