package com.digiwin.athena.knowledgegraph.support;

import org.springframework.amqp.core.ExchangeTypes;
import org.springframework.amqp.rabbit.annotation.*;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-07-14 10:46
 **/
@Service
public class RabbitService {

    @Value("${rabbitMQExchangeName}")
    private String rabbitMQExchangeName;
    @Value("${scheduleRuleConfigRoutingKey}")
    private String scheduleRuleConfigRoutingKey;
    @Value("${monitorRuleConfigRoutingKey}")
    private String monitorRuleConfigRoutingKey;

    @Autowired(required = false)
    private RabbitTemplate rabbitTemplate;

    public void sendScheduleRuleConfig(Object message){
        if (rabbitTemplate==null){return;}
        rabbitTemplate.convertAndSend(rabbitMQExchangeName,scheduleRuleConfigRoutingKey,message);
    }

    public void sendMonitorRuleConfig(Object message){
        if (rabbitTemplate==null){return;}
        rabbitTemplate.convertAndSend(rabbitMQExchangeName,monitorRuleConfigRoutingKey,message);
    }

//    @RabbitListener(queues = "myqueue")
//    public void listen(String in) {
//        System.out.println(in);
//    }
//
//    @RabbitListener(bindings = @QueueBinding(
//            value = @Queue(value = "auto.headers", autoDelete = "true",
//                    arguments = @Argument(name = "x-message-ttl", value = "10000",
//                            type = "java.lang.Integer")),
//            exchange = @Exchange(value = "auto.headers", type = ExchangeTypes.HEADERS, autoDelete = "true"),
//            arguments = {
//                    @Argument(name = "x-match", value = "all"),
//                    @Argument(name = "thing1", value = "somevalue"),
//                    @Argument(name = "thing2")
//            })
//    )
//    public String handleWithHeadersExchange(String foo) {
//        System.out.println(foo);
//        return "ok";
//    }

}
