package com.digiwin.athena.knowledgegraph.svcomposition.bpm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @ClassName ForbiddenProcessVariable
 * @Description TODO
 * @Author zhuangli
 * @Date 2020/8/7 10:38
 * @Version 1.0
 **/
public class ForbiddenProcessVariable {
    public static final String PROCESS_SERIAL_NUMBER = "processSerialNumber";
    public static final String PROCESS_ID = "processId";
    public static final String SUBJECT = "subject";
    public static final String TENANT_ID = "tenantId";
    public static final String TOKEN = "token";
    public static final String CALL_ID = "call_id";
    public static final String ACTIVITY_ID = "activityId";

    private static ForbiddenProcessVariable instance = new ForbiddenProcessVariable();

    private List<String> forbiddenList;

    private ForbiddenProcessVariable() {
        forbiddenList = new ArrayList<>(Arrays.asList(
                PROCESS_SERIAL_NUMBER,
                PROCESS_ID,
                SUBJECT,
                TENANT_ID,
                TOKEN,
                CALL_ID,
                ACTIVITY_ID
        ));
    }

    public static ForbiddenProcessVariable getInstance(){
        return instance;
    }

    public boolean isForbidden(String str) {
        return forbiddenList.contains(str);
    }
}
