package com.digiwin.athena.knowledgegraph.synonym.dao;


import com.digiwin.athena.knowledgegraph.synonym.domain.EntityType;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageVo;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author: wangao
 * @CreateTime: 2024-03-26  13:08
 * @Description: TODO
 * @Version: 1.0
 */
@Repository
public class EntityTypeDao {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;

    public void insert(EntityType entityType){
        entityType.setCreateDate(new Date());
        mongoTemplate.insert(entityType);
    }

    public void delete(String id, String tenantId){
        if (StringUtils.isEmpty(id)){
            return;
        }
        if (StringUtils.isEmpty(tenantId)){
            throw new BusinessException("租户id不能为空");
        }
        Query query = new Query(Criteria.where("objectId").is(id).andOperator(Criteria.where("tenantId").is(tenantId)));
        this.mongoTemplate.remove(query, EntityType.class);
    }

    public List<EntityType> findList(String tenantId){
        if (StringUtils.isEmpty(tenantId)){
            throw new BusinessException("租户id不能为空");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("tenantId").is(tenantId));
        query.addCriteria(criteria);
        return this.mongoTemplate.find(query, EntityType.class);
    }

    public PageVo<EntityType> getPage(String tid, int pageNum, int pageSize) {

        if (StringUtils.isEmpty(tid)){
            throw new BusinessException("租户id不能为空");
        }
        if (pageSize==0){
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("tenantId").is(tid));

        query.addCriteria(criteria);
        Pageable pageable = PageRequest.of(pageNum, pageSize);
        long totalCount = mongoTemplate.count(query,EntityType.class);

        List<EntityType> entityTypes = this.mongoTemplate.find(query.with(pageable), EntityType.class);
        int totalPage = (int) (totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1);

        return new PageVo((int) totalCount,entityTypes,pageNum,pageSize,totalPage);
    }

    public PageVo<SystemEntityType> getSystemPage(String entityTypeName, int pageNum, int pageSize) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty(entityTypeName)){
            criteria.andOperator(Criteria.where("entityTypeName").is(entityTypeName));
            query.addCriteria(criteria);
        }

        long totalCount = systemMongoTemplate.count(query,SystemEntityType.class);
        Pageable pageable = PageRequest.of(pageNum, pageSize);
        List<SystemEntityType> entityTypes = new ArrayList<>();
        if (pageSize==0&&pageNum==0){
            entityTypes = getAll();
        }else {
            entityTypes = this.systemMongoTemplate.find(query.with(pageable), SystemEntityType.class);
        }
        if (pageSize == 0) {
            throw new IllegalArgumentException("pageSize不能为0");
        }
        int totalPage = (int) (totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1);

        return new PageVo((int) totalCount,entityTypes,pageNum,pageSize,totalPage);
    }

    public List<SystemEntityType> getAll() {
       return  this.systemMongoTemplate.findAll(SystemEntityType.class);
    }

    public void deleteSysEntity(String id) {
        if (StringUtils.isEmpty(id)){
            return;
        }
        Query query = new Query(Criteria.where("objectId").is(id));
        this.systemMongoTemplate.remove(query, SystemEntityType.class);
    }

    public void saveAll(List<SystemEntityType> systemEntityTypes) {
        this.mongoTemplate.insertAll(systemEntityTypes);
    }

    public List<SystemEntityType> getSystemListByNames(List<String> nameList) {
        if (nameList==null||nameList.size()==0){
            return null;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("entityTypeName").in(nameList));
        query.addCriteria(criteria);
        return this.systemMongoTemplate.find(query, SystemEntityType.class);
    }

    public void deleteList(String tid, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)){
            return;
        }
        if (StringUtils.isEmpty(tid)){
            throw new BusinessException("租户id不能为空");
        }

        Query query = new Query(Criteria.where("objectId").in(ids).andOperator(Criteria.where("tenantId").is(tid)));
        this.mongoTemplate.remove(query, EntityType.class);
    }
    public void dataMigration(){
        long count = systemMongoTemplate.count(new Query(), EntityType.class);
        if (count > 0){
            List<EntityType> appThresholdConfigs = systemMongoTemplate.find(new Query(), EntityType.class);
            mongoTemplate.insertAll(appThresholdConfigs);
        }
    }
}
