package com.digiwin.athena.knowledgegraph.synonym.dao;

import com.digiwin.athena.knowledgegraph.synonym.domain.po.PageVo;
import com.digiwin.athena.knowledgegraph.synonym.domain.po.ResultBean;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.DeleteDto;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.GetSubscriptionByPageRequest;
import com.digiwin.athena.knowledgegraph.synonym.domain.subscription.Subscription;
import com.digiwin.athena.knowledgegraph.synonym.exception.BusinessException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import java.util.List;
import java.util.regex.Pattern;

/**
 * @author gudahua
 * @title:
 * @projectName kg
 * @description:
 * @Date
 */
@Repository
public class SubscriptionDao {
    @Autowired
    @Qualifier("knowledgegraphTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate systemMongoTemplate;
    public void insertOne(Subscription subscription) {
        mongoTemplate.insert(subscription);
    }

    public Subscription fineOne(Query query) {
        return mongoTemplate.findOne(query,Subscription.class);
    }

    public void saveOne(Subscription subscription) {
        mongoTemplate.save(subscription);
    }

    public PageVo<Subscription> getEntryPage(Integer pageNum, Integer pageSize, String question, String tenantId) {
        if (StringUtils.isEmpty(tenantId)){
            throw new BusinessException("租户id不能为空");
        }
        if (pageSize == 0){
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("tenantId").is(tenantId).and("type").is("entry"));
        if (StringUtils.isNotEmpty(question)) {
            Pattern questionPattern = Pattern.compile("^.*" + question + ".*$", Pattern.CASE_INSENSITIVE);
            criteria.and("question.question").regex(questionPattern);
        }
        query.addCriteria(criteria);
        Pageable pageable = PageRequest.of(pageNum, pageSize, Sort.Direction.DESC, "createDate","_id");
        long totalCount = mongoTemplate.count(query, Subscription.class);

        List<Subscription> subscriptionList = this.mongoTemplate.find(query.with(pageable), Subscription.class);
        int totalPage = (int) (totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1);

        return new PageVo((int) totalCount,subscriptionList,pageNum,pageSize,totalPage);
    }

    public PageVo<Subscription> getSubscriptionPage(GetSubscriptionByPageRequest request) {
        String tenantId = request.getTenantId();
        Integer pageSize = request.getPageSize();
        Integer pageNum = request.getPage();
        String question = request.getQuestion();


        if (StringUtils.isEmpty(tenantId)){
            throw new BusinessException("租户id不能为空");
        }
        if (pageSize == 0){
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(Criteria.where("tenantId").is(tenantId).and("type").is("subscription"));
        if (StringUtils.isNotEmpty(question)) {
            Pattern questionPattern = Pattern.compile("^.*" + question + ".*$", Pattern.CASE_INSENSITIVE);
            criteria.and("question.question").regex(questionPattern);
        }

        if (StringUtils.isNotEmpty(request.getCreateDateStart()) && StringUtils.isNotEmpty(request.getCreateDateEnd())) {
            criteria.and("createDate").gte(request.getCreateDateStart()).lte(request.getCreateDateEnd());
        }
        if (StringUtils.isNotEmpty(request.getEditDateStart()) && StringUtils.isNotEmpty(request.getEditDateEnd())) {
            criteria.and("editDate").gte(request.getEditDateStart()).lte(request.getEditDateEnd());
        }
        if (StringUtils.isNotEmpty(request.getCreateBy())) {
            Pattern patternDesc = Pattern.compile("^.*" + request.getCreateBy() + ".*$", Pattern.CASE_INSENSITIVE);
            criteria.and("createBy").regex(patternDesc);
        }
        if (StringUtils.isNotEmpty(request.getEditBy())) {
            Pattern patternDesc = Pattern.compile("^.*" + request.getEditBy() + ".*$", Pattern.CASE_INSENSITIVE);
            criteria.and("editBy").regex(patternDesc);
        }

        query.addCriteria(criteria);
        Pageable pageable = PageRequest.of(pageNum, pageSize, Sort.Direction.DESC, "createDate","_id");
        long totalCount = mongoTemplate.count(query, Subscription.class);

        List<Subscription> subscriptionList = this.mongoTemplate.find(query.with(pageable), Subscription.class);
        int totalPage = (int) (totalCount % pageSize == 0 ? totalCount / pageSize : totalCount / pageSize + 1);

        return new PageVo((int) totalCount,subscriptionList,pageNum,pageSize,totalPage);
    }

    public void deleteSubscription(String tenantId, List<String> ruleIds) {
        mongoTemplate.remove(new Query(Criteria.where("tenantId").is(tenantId).and("code").in(ruleIds)),Subscription.class);
    }

    public void deleteEntry(DeleteDto deleteDto) {
        mongoTemplate.remove(new Query(Criteria.where("tenantId").is(deleteDto.getTenantId()).and("code").is(deleteDto.getCode())),Subscription.class);
    }

    public List<Subscription> findByQuestion(String tenantId, String question) {
        return mongoTemplate.find(new Query((Criteria.where("tenantId").is(tenantId)
                .and("type").is("subscription")
                .and("question.question").is(question))), Subscription.class);
    }
}
