package com.digiwin.athena.knowledgegraph.synonym.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Author: wangao
 * @CreateTime: 2024-08-14  09:41
 * @Description:
 * @Version: 1.0
 */
@Data
@Builder
@Accessors(chain = true)
@Document(collection = "agiledata_bigScreenViewConfig")
@AllArgsConstructor
@NoArgsConstructor
public class BigScreenViewConfig {
    @Id
    private String id;

    private String bigScreenCode;
    //大屏名称 默认
    private String bigScreenName;
    //大屏标题
    private String bigScreenTitle;
    //描述
    private String bigScreenDescription;
    //更新时间
    private String updateTime;
    //更新人
    private String updateUser;
    //大屏刷新周期 分钟
    private Integer flashFrequency;
    //翻页时间 秒
    private Integer pageTurningFrequency;
    //数据流刷新频率
    private Integer dataFlowFrequency;

    private String appCode;

    private String tenantId;
    private String type;//custom system
}
