package com.digiwin.athena.knowledgegraph.synonym.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Date;
import java.util.Map;

/**
 * @Author: wangao
 * @CreateTime: 2024-03-25  16:05
 * @Description: TODO
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@Document(collection = "entityType")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class EntityType {
    @Id
    private String objectId;

    private String tenantId;

    private String entityTypeName;

    private Integer perNum;
    private String lang;
    private Object createBy;

    private Date createDate;
    private Object editBy;

    private Date editDate;
    /**
     * 目标跟维度俩字段是不可删除的，这里为true，其他情况都是false
     */
    private Boolean deleteFlag;
}
