package com.digiwin.athena.knowledgegraph.synonym.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @Author: wangao
 * @CreateTime: 2024-06-06  15:20
 * @Description: TODO
 * @Version: 1.0
 */
@Data
@Accessors(chain = true)
@Document(collection = "agiledata_local_app_info")
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LocalAppInfo {
    @Id
    private String objectId;
    private String appName;
    private String appCode;
    /**
     * 是否有效 true 生效，false失效
     */
    @Builder.Default
    private Boolean effectiveness = true;
    /**
     * 开关，true开 false关
     */
    @Builder.Default
    private Boolean appSwitch = false;

    private String tenantId;

    private String appType;

    private String userEmail;
}
