package com.digiwin.athena.knowledgegraph.synonym.domain.po;

import java.io.Serializable;
import java.util.List;
import java.util.Map;


public class ResultBean<T> implements Serializable {


	private static final long serialVersionUID = 1L;


	private Integer code=0;

	private String msg;
	/**
	 * 兼容被外部调用的接口 值和msg相同
	 */
	private String message;

	private T data;
	
	private List<T> dataList;
	
	private Integer pageIndex; // 当前页数
	
	private Integer pageSize; // 每页显示的记录数
	
	private Long totalCount; // 总记录数
	
	private Map<String, Object> ext;
	private String token;
	
	public ResultBean() {}
	
	public ResultBean(Integer code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	public static <T> ResultBean<T> success(T t){
		ResultBean<T> result = new ResultBean();
		result.setData(t);
		return result;
	}

	public static <T> ResultBean<T> fail(Integer code, String msg){
		ResultBean<T> result = new ResultBean(code,msg);
		return result;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	public List<T> getDataList() {
		return dataList;
	}

	public void setDataList(List<T> dataList) {
		this.dataList = dataList;
	}

	public Integer getPageIndex() {
		return pageIndex;
	}

	public void setPageIndex(Integer pageIndex) {
		this.pageIndex = pageIndex;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Long getTotalCount() {
		return totalCount;
	}

	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}

	public Map<String, Object> getExt() {
		return ext;
	}

	public void setExt(Map<String, Object> ext) {
		this.ext = ext;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getMessage() {
		return message == null ? msg : message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Override
	public String toString() {
		return "ResultBean{" +
				"code=" + code +
				", msg='" + msg + '\'' +
				", message='" + message + '\'' +
				", data=" + data +
				", dataList=" + dataList +
				", pageIndex=" + pageIndex +
				", pageSize=" + pageSize +
				", totalCount=" + totalCount +
				", ext=" + ext +
				", token='" + token + '\'' +
				'}';
	}
}
