package com.digiwin.athena.knowledgegraph.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.resource.DWResourceBundleUtils;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBaseInfoBO;
import com.digiwin.athena.kg.activity.*;
import com.digiwin.athena.knowledgegraph.cache.CacheService;
import com.digiwin.athena.knowledgegraph.domain.common.OperationUnit;
import com.digiwin.athena.knowledgegraph.service.impl.ActionService;
import com.digiwin.athena.kmservice.action.metadata.model.DataEntityMetadataDTO;
import com.digiwin.athena.knowledgegraph.service.impl.AppService;
import com.digiwin.athena.knowledgegraph.component.ComponentManager;
import com.digiwin.athena.domain.core.app.ApplicationRelation;
import com.digiwin.athena.kg.domain.OpenWindowDefinition;
import com.digiwin.athena.domain.definition.FieldDescription;
import com.digiwin.athena.kg.domain.FieldOpenWindowSetting;
import com.digiwin.athena.kg.monitorRule.Conditon;
import com.digiwin.athena.kg.monitorRule.DynamicCondition;
import com.digiwin.athena.knowledgegraph.domain.task.ActivityInputData;
import com.digiwin.athena.knowledgegraph.domain.task.ActivityVisibleConfig;
import com.digiwin.athena.repository.neo4j.ActivityRepository;
import com.digiwin.athena.repository.neo4j.DynamicTaskRepository;
import com.digiwin.athena.knowledgegraph.repoSystem.ActivityCompositionRepository;
import com.digiwin.athena.kg.monitorRule.tenant.ConditionOperatorTypeEnum;
import com.digiwin.athena.kg.monitorRule.tenant.ConditionValueTypeEnum;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionTypeEnum;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IActivityService;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.impl.TaskService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.task.model.ActivityCompositionData;
import com.digiwin.athena.knowledgegraph.task.model.ActivityCompositionItemVO;
import com.digiwin.athena.knowledgegraph.task.model.ActivityCompositionVO;
import com.digiwin.athena.knowledgegraph.task.model.DynamicActivityData;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.LanguageUtil;
import com.digiwin.dap.middleware.lmc.util.JsonUtils;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import static com.digiwin.athena.knowledgegraph.constant.ComponentConstants.REDIS_KNOWLEDGE_GRAPH;

@Service
//@SysLog
@Slf4j
public class ActivityService implements IActivityService {

    @Autowired
    ActivityRepository activityRepository;

    @Autowired
    DynamicTaskRepository dynamicTaskRepository;

    @Autowired
    ActivityCompositionRepository activityCompositionRepository;

    @Autowired
    @Qualifier("knowledgegraphSystem")
    MongoTemplate mongoTemplate;
    @Autowired
    TenantService tenantService;

    @Autowired
    AppService appService;


    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    private AppService applicationService;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    KgInnerService kgInnerService;

    @Autowired
    ActionService actionService;
    @Autowired
    TaskService taskService;
    @Autowired
    ComponentManager componentManager;
    @Autowired
    IMechanismService mechanismService;
    @Autowired
    CacheService cacheService;

    @Autowired
    private DataPickService dataPickService;
    @Override
    public Object getInputData(String activityId) throws DWBusinessException {

//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        if (activityId.contains("-")) {//动态任务获取-前面的动态任务模板code
//            activityId = activityId.substring(0, activityId.indexOf("-"));
//        }
//
//        Optional<ActivityInputData> inputData = activityRepository.getActivityInputData(tenantId, activityId, tenantVersion);//tenantId
//        if (inputData.isPresent()) {
//            ActivityInputData data = inputData.get();
//            data.getInputData().setField(new ArrayList<>(data.getFields()));
//            Map<String, Object> result = new HashMap();
//            result.put("activity", activityId);
//            result.put("inputData", DataEntityMetadataDTO.ConvertFromDataEntity(data.getInputData()));
//            return result;
//        }else{
            Object obj2 = dataMapService.taskInputData(activityId);
            return obj2;
     //   }

    }

    @Override
    public Object getInputData(String taskId, String activityId) throws DWBusinessException {

        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);

        Optional<ActivityInputData> inputData = activityRepository.getActivityInputData(tenantId, taskId, activityId, tenantVersion);
        if (inputData.isPresent()) {
            ActivityInputData data = inputData.get();
            data.getInputData().setField(new ArrayList<>(data.getFields()));
            Map<String, Object> result = new HashMap();
            result.put("activity", activityId);
            result.put("inputData", DataEntityMetadataDTO.ConvertFromDataEntity(data.getInputData()));
            return result;
        }
        return null;
    }

    @Override
    public Object postQueryCompositionBySolvePlan(String planId, String dataName) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        String locale = DWResourceBundleUtils.getCurrentLocale().toString();
        Activities activities = activityRepository.getActivitySetByPlanId(planId, dataName, tenantVersion);
        Assert.notNull(activities, "未找到对应活动定义");
        List<ActivityVO> activityVOS = activities.getActivities();
        Assert.notNull(activityVOS,"未找到对应活动定义");
        Assert.notEmpty(activityVOS,"未找到对应活动定义");
        Assert.notEmpty(activityVOS,"未找到对应活动定义");
        List<String> ids = activityVOS.stream().map(ActivityVO::getActivityId).collect(Collectors.toList());
        List<ActivityVO> activityVOS2 = activityRepository.getActivitySetByIds(ids, locale, tenantVersion, tenantId);
        activityVOS2 = dataPickService.excludeWithSameCode(activityVOS2);
        Assert.notEmpty(activityVOS2, "未找到对应活动定义");
        Map<String, ActivityVO> map = activityVOS.stream().collect(Collectors.toMap(ActivityVO::getActivityId, a -> a, (k1, k2) -> k1));
        activityVOS2.forEach(item -> item.setSequence(map.get(item.getActivityId()).getSequence()));
        activities.setActivities(activityVOS2);

        return activities;
    }

    @Override
    public Object postComposition(String taskId, List<String> sequenceFields, List<String> keyFields, Map<String, String> conditionFields, String dueDateField, List<Map> data) throws Exception {
        //由项目Id获取项目模板定义
        if (taskId == null || taskId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.taskIdEmpty"));
        }
        List<DynamicActivityComposition> compositions = dynamicTaskRepository.getDynamicActivityCompositionByTask(taskId);
        if (compositions == null || compositions.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.compositionsNotFound"));
        }

        //从项目中获取composition对应的条件
        Map<String, Map<String, Object>> conditionDefines = new HashMap<>();
        for (DynamicActivityComposition item : compositions) {
            Map<String, Object> cons = new HashMap<>();
            for (DynamicActivityCompositionConditionVO con : item.getConditions()) {
                cons.put(con.getKey(), con.getValue());
            }
            conditionDefines.put(item.getCode(), cons);
        }

        //从数据中获取条件值
        Map<String, Map<String, Object>> dataConditions = new HashMap<>(); //key为排序字段复合值
        Map<String, Map> sortData = new HashMap<>();
        for (Map d: data) {
            Map<String, Object> cons = new HashMap();
            for (Map.Entry<String, String> item : conditionFields.entrySet()) {
                String conditionKey = item.getKey();
                String conditionField = item.getValue();
                cons.put(conditionKey, d.get(conditionField));
            }
            String seq = "";
            for (String seqField : sequenceFields) {
                seq += d.get(seqField).toString();
            }
            dataConditions.put(seq, cons);
            sortData.put(seq, d);
        }
        if (data.size() != sortData.size()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.sequenceNotUnique"));
        }

        //从匹配的动态项目中获取动态任务
        Map<String, String> dataComposition = new TreeMap<>();//按key值(排序字段复合值) 排序
        for (Map.Entry<String, Map<String, Object>> item : dataConditions.entrySet()) {//遍历数据
            int conditionCount = item.getValue().size();
            for (Map.Entry<String, Map<String, Object>> conDef : conditionDefines.entrySet()) {
                if (conDef.getValue().size() == conditionCount) {//条件数量匹配
                    //进行条件值匹配
                    boolean match = true;
                    for (Map.Entry<String, Object> con : item.getValue().entrySet()) {
                        if (!conDef.getValue().get(con.getKey()).toString().equals(con.getValue().toString())) {//有一个条件不满足即退出循环
                            match = false;
                            break;
                        }
                    }
                    if (match) {
                        dataComposition.put(item.getKey(), conDef.getKey());
                        break;//命中composition则退出循环
                    }
                }
            }
        }

        //根据模板生成动态任务
        //获取模板任务
        List<DynamicActivityData> activities = new ArrayList<>();
        List<String> compositionCodes = new ArrayList<>();
        Map<Integer, Map> compSeqDataKey = new HashMap<>();
        int compSeq = 10;
        for (Map.Entry<String, String> item : dataComposition.entrySet()) {
            String opSeq = item.getKey();//制程数据工序
            String code = item.getValue();
            Map d = sortData.get(opSeq);
            List<DynamicActivity> dynamicActs = dynamicTaskRepository.getDynamicActivityByComposition(taskId, code);
            DynamicActivityComposition composition = dynamicTaskRepository.getDynamicActivityCompositionByCode(taskId, code);
            Map<Integer, DynamicActivity> acts = new TreeMap<>();
            for (DynamicActivity activity : dynamicActs) {
                acts.put(activity.getSequence(), activity);//按composition内的任务sequence排序
            }
            for (Map.Entry<Integer, DynamicActivity> activity : acts.entrySet()) {
                activities.add(new DynamicActivityData(activity.getValue(), d, composition, compSeq));
            }
            if (!compositionCodes.contains(code)) {
                compositionCodes.add(code);
            }
            Map dataKey = new HashMap();
            for (String key : keyFields) {
                dataKey.put(key, d.get(key));
            }
            compSeqDataKey.put(compSeq, dataKey);
            compSeq += 10;
        }

        //生成动态任务
        List<ActivityCompositionItem> items = new ArrayList<>();
        int seq = 10;
        for (DynamicActivityData actData : activities) {
            ActivityCompositionItem item = new ActivityCompositionItem();
            DynamicActivity activity = actData.getActivity();
            String dynActCode = activity.getCode();
            Map d = actData.getData();
            item.setActivityId(String.format("%s-%s",dynActCode, processTemplate(activity.getIdSuffixFormula(), d)));//生成运行时的activityId
            item.setFlowId(activity.getFlowId());
            item.setName(processTemplate(activity.getNameFormula(), d));//生成任务标题
            item.setSequence(seq);
            item.setDynamicActivityCode(dynActCode);
            item.setCompositionCode(actData.getComposition().getCode());
            item.setCompositionFlowId(actData.getComposition().getFlowId());
            item.setCompositionSequence(actData.getCompositionSequence());
            item.setDueDate((String)d.get(dueDateField));
            items.add(item);
            seq += 10;
        }
        ActivityComposition ac = new ActivityComposition();
        String compositionId = UUID.randomUUID().toString();
        ac.setCompositionId(compositionId);//生成运行时的compositionId
        ac.setCompositionCodes(compositionCodes);
        ac.setCompositionSequenceDataKey(compSeqDataKey);
        //todo lingxiang 组合compositioncode会超长 先用guid作为compositionId 需要如何考虑复用composition 以及复用的条件
        ac.setActivities(items);
        //保存动态任务前先判断是否已存在
        //保存动态任务
        activityCompositionRepository.insert(ac);

        Map<String, String> re = new HashMap<>();
        re.put("compositionId", compositionId);

        return re;
    }

    //加工处理 ${field}
    public static String processTemplate(String template, Map<String, Object> params){
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\$\\{\\w+\\}").matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 1));
            m.appendReplacement(sb, value==null ? "" : value.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public Object getComposition(String compositionId) throws Exception {
        ActivityComposition re = activityCompositionRepository.findOneByCompositionId(compositionId);
        ActivityCompositionData data = null;
        if (re != null) {
            data = new ActivityCompositionData();
            data.setCompositionId(re.getCompositionId());
            data.setCompositionCodes(re.getCompositionCodes());
            Map<Integer, Map> compSeqDataKey = re.getCompositionSequenceDataKey();
            Map<Integer, ActivityCompositionVO> comps = new TreeMap<>();
            for (ActivityCompositionItem item : re.getActivities()) {
                int compSeq = item.getCompositionSequence();
                ActivityCompositionVO compVO = comps.get(compSeq);
                if (compVO == null) {
                    String compFlowId = item.getCompositionFlowId();
                    String compCode = item.getCompositionCode();
                    compVO = new ActivityCompositionVO(compCode, compFlowId, compSeq, compSeqDataKey.get(compSeq));
                    comps.put(compSeq, compVO);
                }
                ActivityCompositionItemVO itemVO = new ActivityCompositionItemVO(item.getActivityId(), item.getFlowId(),
                        item.getName(), item.getDynamicActivityCode(), item.getSequence());
                compVO.getActivities().add(itemVO);
            }
            List<ActivityCompositionVO> compositionVOS = new ArrayList<>();
            for (Map.Entry<Integer, ActivityCompositionVO> item : comps.entrySet()) {
                compositionVOS.add(item.getValue());
            }
            data.setCompositions(compositionVOS);
        }

        return data;
    }

    @Override
    public Object postUpdateActivity(Activity data) throws Exception {
//        String col = "activityConfigs";
//        String tenantId = AthenaUtils.getTenantId();
//        String id = data.getId();
//        if(id==null){ throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.idEmpty"));}
        List<DynamicApproveInfo> dynamicApproves = data.getDynamicApproves();
        List<Map<String, String>> res = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dynamicApproves)) {
            for (DynamicApproveInfo dynamicApprove : dynamicApproves) {
                Map<String, String> map = new HashMap<>();
                Object dynamicConditionObj = dynamicApprove.getDynamicCondition();
                String expression = expressionHandle(dynamicConditionObj);
                dynamicApprove.setExpression(expression);
                map.put("name", dynamicApprove.getName());
                map.put("code", dynamicApprove.getCode());
                map.put("seq", dynamicApprove.getSeq());
                map.put("expression", dynamicApprove.getExpression());
                res.add(map);
            }
        }
        dataMapService.updateTask(data);
//        Query dataQuery = Query.query(Criteria.where("code").is(data.getCode()).and("version").is(data.getVersion()).and("tenantId").is(tenantId));
//        Activity indb = mongoTemplateUser.findOne(dataQuery,Activity.class,col);
//        if (indb==null){
//            indb = mongoTemplate.findById(data.getId(),Activity.class,col);
//            if(indb==null){//说明该数据来源于datamap
//                dataMapService.updateTask(data);
//            }else {
//                //因为系统级和租户级不是同一条记录,需要判断用户点击提交修改后没有刷新页面再次修改的情况,这时候id仍然是系统级的但是已经产生了一条租户级记录了
//                Query query = Query.query(Criteria.where("code").is(indb.getCode()).and("version").is(indb.getVersion()).and("tenantId").is(tenantId));
//                Activity indb2 = mongoTemplateUser.findOne(query,Activity.class,col);
//                if(null!=indb2){
//                    data.setId(null); //id不替换，用原来indb2里的id去更新数据
//                    AthenaUtils.mergeObject(data,indb2);
//                    mongoTemplateUser.save(indb2,col);
//                }else {
//                    data.setTenantId(tenantId);
//                    data.setId(null); //找不到时重新设置id
//                    mongoTemplateUser.save(data,col);
//                }
//            }
//        }else{
//            AthenaUtils.mergeObject(data,indb);
//            mongoTemplateUser.save(indb,col);
//        }
//        cacheService.deleteWithPattern(REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + "*");
        return res;
    }


    @Override
    public Object postUpdateActivity(Activity data, OperationUnit operationUnit) throws Exception {
//        String col = "activityConfigs";
//        String tenantId = AthenaUtils.getTenantId();
//        String id = data.getId();
//        if(id==null){ throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.idEmpty"));}
        List<DynamicApproveInfo> dynamicApproves = data.getDynamicApproves();
        List<Map<String, String>> res = new ArrayList<>();
        if (!CollectionUtils.isEmpty(dynamicApproves)) {
            for (DynamicApproveInfo dynamicApprove : dynamicApproves) {
                Map<String, String> map = new HashMap<>();
                Object dynamicConditionObj = dynamicApprove.getDynamicCondition();
                String expression = expressionHandle(dynamicConditionObj);
                dynamicApprove.setExpression(expression);
                map.put("name", dynamicApprove.getName());
                map.put("code", dynamicApprove.getCode());
                map.put("seq", dynamicApprove.getSeq());
                map.put("expression", dynamicApprove.getExpression());
                res.add(map);
            }
        }
        if(null!=operationUnit){
            Map<String, Object> eocInfo = new HashMap<>();
            eocInfo.put("eoc_company_id",operationUnit.getEoc_company_id());
            eocInfo.put("eoc_site_id",operationUnit.getEoc_site_id());
            eocInfo.put("eoc_region_id",operationUnit.getEoc_region_id());
            eocInfo.put("operation_unit_v2",operationUnit.getOperation_unit_v2());
            data.setEocInfo(eocInfo);
        }
        dataMapService.updateTask(data);
//        Query dataQuery = Query.query(Criteria.where("code").is(data.getCode()).and("version").is(data.getVersion()).and("tenantId").is(tenantId));
//        Activity indb = mongoTemplateUser.findOne(dataQuery,Activity.class,col);
//        if (indb==null){
//            indb = mongoTemplate.findById(data.getId(),Activity.class,col);
//            if(indb==null){//说明该数据来源于datamap
//                dataMapService.updateTask(data, operationUnit);
//            }else {
//                //因为系统级和租户级不是同一条记录,需要判断用户点击提交修改后没有刷新页面再次修改的情况,这时候id仍然是系统级的但是已经产生了一条租户级记录了
//                Query query = Query.query(Criteria.where("code").is(indb.getCode()).and("version").is(indb.getVersion()).and("tenantId").is(tenantId));
//                Activity indb2 = mongoTemplateUser.findOne(query,Activity.class,col);
//                if(null!=indb2){
//                    data.setId(null); //id不替换，用原来indb2里的id去更新数据
//                    AthenaUtils.mergeObject(data,indb2);
//                    mongoTemplateUser.save(indb2,col);
//                }else {
//                    data.setTenantId(tenantId);
//                    data.setId(null); //找不到时重新设置id
//                    mongoTemplateUser.save(data,col);
//                }
//            }
//        }else{
//            AthenaUtils.mergeObject(data,indb);
//            mongoTemplateUser.save(indb,col);
//        }
//        cacheService.deleteWithPattern(REDIS_KNOWLEDGE_GRAPH + ComponentConstants.COLON +  ComponentConstants.SYSTEM + ComponentConstants.COLON + tenantId + "*");
        return res;
    }

    private String expressionHandle(Object dynamicConditionObj) throws DWBusinessException {
        String expression = null;
        List<String> list = new ArrayList<>();
        if (dynamicConditionObj instanceof Map) {
            DynamicConditionConfigDO dynamicCondition = JsonUtils.readValue(JSON.toJSONString(dynamicConditionObj),
                    DynamicConditionConfigDO.class);
            expression = typeHandle(dynamicCondition);
        }
        if (dynamicConditionObj instanceof List) {
            List conditionObj = (List) dynamicConditionObj;
            DynamicConditionConfigDO dy = new DynamicConditionConfigDO();
            dy.setType(DynamicConditionTypeEnum.AND_GROUP);
            List<DynamicConditionConfigDO> items = new ArrayList<>();
            for (Object o : conditionObj) {
                DynamicConditionConfigDO dynamicCondition = JsonUtils.readValue(JSON.toJSONString(o),
                        DynamicConditionConfigDO.class);
                items.add(dynamicCondition);
            }
            dy.setItems(items);
            list.add(typeHandle(dy));
            expression = "(" + StringUtils.join(list, "&&") + ")";
        }
        return expression;
    }

    private String typeHandle(DynamicConditionConfigDO dynamicCondition) throws DWBusinessException {
        String expression = null;
        List<String> list = new ArrayList<>();
        //是or  则||区分
        if (dynamicCondition.getType().equals(DynamicConditionTypeEnum.OR_GROUP)) {
            if (!CollectionUtils.isEmpty(dynamicCondition.getItems())) {
                List<DynamicConditionConfigDO> items = dynamicCondition.getItems();
                for (DynamicConditionConfigDO item : items) {
                    list.add(typeHandle(item));
                }
                expression = "(" + StringUtils.join(list, "||") + ")";
            }
        }
        // 是and 则为&&
        if (dynamicCondition.getType().equals(DynamicConditionTypeEnum.AND_GROUP)) {
            if (!CollectionUtils.isEmpty(dynamicCondition.getItems())) {
                List<DynamicConditionConfigDO> items = dynamicCondition.getItems();
                for (DynamicConditionConfigDO item : items) {
                    list.add(typeHandle(item));
                }
                expression = "(" + StringUtils.join(list, "&&") + ")";
            }
        }
        // 单个
        if (dynamicCondition.getType().equals(DynamicConditionTypeEnum.SINGLE)) {
            list.add(conversionExpression(dynamicCondition));
            expression = StringUtils.join(list, "");
        }
        return expression;
    }

    private String conversionExpression(DynamicConditionConfigDO item) throws DWBusinessException {
        StringBuilder stringBuffer = new StringBuilder();
        String leftValue = substituteParameters(item.getLeft(), item.getLeftValueType());
        if (item.getOp().equals(ConditionOperatorTypeEnum.EQUAL)) {
            return String.valueOf(stringBuffer.append(leftValue).append("==").append(substituteParameters(item.getRight().toString(), item.getRightValueType())));

        }
        if (item.getOp().equals(ConditionOperatorTypeEnum.NOT_EQUAL)) {
            return String.valueOf(stringBuffer.append(leftValue).append("!=").append(substituteParameters(item.getRight().toString(), item.getRightValueType())));

        }
        if (item.getOp().equals(ConditionOperatorTypeEnum.IN)) {
            List<Object> right = (List) item.getRight();
            ArrayList<String> rightList = new ArrayList<>();
            for (Object s : right) {
                String rightValue = substituteParameters(s, item.getRightValueType());
                rightList.add(leftValue + "==" + rightValue);
            }
            return "(" + StringUtils.join(rightList, "||") + ")";
        }
        if (item.getOp().equals(ConditionOperatorTypeEnum.NOT_IN)) {
            List<Object> right = (List) item.getRight();
            ArrayList<String> rightList = new ArrayList<>();
            for (Object s : right) {
                String rightValue = substituteParameters(s, item.getRightValueType());
                rightList.add(leftValue + "!=" + rightValue);
            }
            return "(" + StringUtils.join(rightList, "&&") + ")";
        }
        throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.requirementNotExist"));
    }

    private static String substituteParameters(Object str, ConditionValueTypeEnum type) {
        if (type.equals(ConditionValueTypeEnum.COLUMN)) {
            return "'$(" + str + ")'";
        }
        return "'" + str + "'";
    }

    @Override
    public Object getAllApproveActivityByApp(String applicationCode, String locale) throws Exception {

        Object obj = dataMapService.allApproveActivityByApp(applicationCode,locale);
        return obj;

//        String tenantId2 = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId2);
//        List<String> taskIdList = applicationService.getTaskCode(applicationCode);
//        List<ActivityBaseInfoVO> approveActivityListByTaskIds = this.activityRepository.getApproveActivityListByTaskIds(taskIdList, tenantId2, locale, tenantVersion);
//
//
//        List<ApplicationRelation> activity = this.applicationService.getApplicationRelationByTypeAndAppCode("activity", applicationCode);
//        List<String> codeList = activity.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
//        if(!CollectionUtils.isEmpty(codeList)){
//            Map<String,Object> q = new HashMap<>();
//            q.put("code",codeList);
//            q.put("type","approve");
//            List dmlist = dataMapService.approveTaskList(q);
//
//            if(null!=dmlist){
//                approveActivityListByTaskIds.addAll(dmlist);
//            }
//        }
 //       return approveActivityListByTaskIds;
    }


    @Deprecated
    @Override
    public Object getManualActivityByApp(String applicationCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        List<String> taskIdList = applicationService.getTaskCode(applicationCode);
        List<ActivityBaseInfoVO> approveActivityListByTaskIds = this.activityRepository.getManualActivityListByTaskIds(taskIdList, tenantId, tenantVersion);

        return approveActivityListByTaskIds;
    }

    @Override
    public Object getActivityByTask(String taskCode, String locale) throws Exception {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<String> taskIdList = new ArrayList<>();
//        taskIdList.add(taskCode);
//        List<ActivityBaseInfoVO> approveActivityListByTaskIds = this.activityRepository.getActivityListByTaskIds(taskIdList, tenantId, locale, tenantVersion);
//        if(CollectionUtils.isEmpty(approveActivityListByTaskIds)){
            Map<String,Object> param = new HashMap<>();
            param.put("projectCode",taskCode);
            param.put("locale",locale);
            return dataMapService.postTasksByProject(param);
//        }
//        return approveActivityListByTaskIds;
    }

    @Override
    public Object postAuthorityConfigs(List<String> activityIdList) throws Exception{
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query(Criteria.where("code").in(activityIdList).and("version").is(kgInnerService.getTenantVersion(tenantId)));
        query.fields().include("code").include("authorityPrefix");
        List<AuthorityConfigVO> defaultActivity = mongoTemplate.find(query, AuthorityConfigVO.class,"activityConfigs");
        return defaultActivity;
    }

    @Override
    public Object postAllApproveActivityByApp(String applicationCode, String locale, Map<String, Object> paramCodeAndValue) throws Exception {
        String tenantId2 = AthenaUtils.getTenantId();
        String tenantVersion = kgInnerService.getTenantVersion(tenantId2);
        List<String> taskIdList = applicationService.getTaskCode(applicationCode);
        List<ActivityBaseInfoVO> approveActivityListByTaskId = new ArrayList<>();
            //    this.activityRepository.getApproveActivityListByTaskIds(taskIdList, tenantId2, locale, tenantVersion);

        List<ActivityBaseInfoVO> approveActivityListByTaskIds = new ArrayList<>();
        List<ApplicationRelation> activity = this.applicationService.getApplicationRelationByTypeAndAppCode(tenantId2,"activity", applicationCode);
        List<String> codeList = activity.stream().map(ApplicationRelation::getCode).distinct().collect(Collectors.toList());
        if(!CollectionUtils.isEmpty(codeList)){
            Map<String,Object> q = new HashMap<>();
            q.put("code",codeList);
            q.put("type","approve");
            List dmlist = dataMapService.approveTaskList(q);
//            if (!CollectionUtils.isEmpty(approveActivityListByTaskId)) {
//                for (ActivityBaseInfoVO vo : approveActivityListByTaskId) {
//                    Activity betterActivity = taskService.findBetterActivity(AthenaUtils.getTenantId(),
//                            vo.getActivityId(), tenantVersion);
//                    if (null != betterActivity && !CollectionUtils.isEmpty(betterActivity.getDynamicApproves())) {
//                        List list = JSON.parseObject(JSON.toJSONString(betterActivity.getDynamicApproves()),
//                                List.class);
//                        vo.setSubApprove(list);
//                    }
//                }
//            }
            if (null != dmlist) {
                approveActivityListByTaskId.addAll(dmlist);
            }

            //开窗条件组合
            Map<String, Map<String, String>> openWin = new HashMap<>();
            for (Object o : approveActivityListByTaskId) {
                ActivityBaseInfoVO activityBaseInfoVO = JSON.parseObject(JSON.toJSONString(o),
                        ActivityBaseInfoVO.class);
                approveActivityListByTaskIds.add(activityBaseInfoVO);
                FieldDescription dropDown = dataPickService.findOneByCondition(Criteria.where("code").is(activityBaseInfoVO.getActivityId()), FieldDescription.class, "subApproveConditionDropDown");
                if (dropDown == null) {
                    continue;
                }
                if (dropDown.getFieldOpenWindowMap() != null) {
                    activityBaseInfoVO.setFieldOpenWindowMap(dropDown.getFieldOpenWindowMap());
                    Map<String, String> map = new HashMap<>();
                    List<FieldOpenWindowSetting> fieldOpenWindowSettings =
                            JSON.parseArray(JSON.toJSONString(dropDown.getFieldOpenWindowMap()),
                                    FieldOpenWindowSetting.class);
                    for (FieldOpenWindowSetting setting : fieldOpenWindowSettings) {
                        map.put(setting.getColumn(), setting.getOpenWindowKey());
                    }
                    openWin.put(activityBaseInfoVO.getActivityId(), map);
                    // 处理参数对应的开窗信息
                    Map<String, Map<String, OpenWindowDefinition>> openWinInfo =
                            appService.postOpenWinInfo(openWin);
                    Map<String, OpenWindowDefinition> temp = openWinInfo.get(activityBaseInfoVO.getActivityId());
                    activityBaseInfoVO.setFieldOpenWindowDefinitions(temp);
                }
                if (dropDown.getFieldMappings() != null) {
                    LanguageUtil.processLocaleLanguage(dropDown.getFieldMappings(), locale);
                    activityBaseInfoVO.setFieldMappings(dropDown.getFieldMappings());
                }
            }

        }
        // 利用应用参数值、产品、条件筛选获取的任务信息
        List<ActivityBaseInfoVO> filterResult = filterActivityInfo(applicationCode, approveActivityListByTaskIds, paramCodeAndValue);

        //过滤组件清单
        List<ComponentBaseInfoBO> componentBaseInfos = new ArrayList<>();
        for (ActivityBaseInfoVO activityInfo : approveActivityListByTaskIds) {
            ComponentBaseInfoBO componentInfo = new ComponentBaseInfoBO();
            componentInfo.setCode(activityInfo.getActivityId());
            componentInfo.setType(ComponentTypeEnum.Task);
            componentBaseInfos.add(componentInfo);
        }
        List<ComponentBaseInfoBO> filteredBaseInfos = componentManager.FilterByTenantApplicationComponentList(applicationCode, tenantId2,componentBaseInfos);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(filteredBaseInfos)
                && filteredBaseInfos.size() != componentBaseInfos.size()) {
            //有过滤
            Set<String> collect = filteredBaseInfos.stream().map(ComponentBaseInfoBO::getCode).collect(Collectors.toSet());
            Iterator<ActivityBaseInfoVO> iterator = filterResult.iterator();
            while(iterator.hasNext()){
                ActivityBaseInfoVO next = iterator.next();
                if(!collect.contains(next.getActivityId())){
                    iterator.remove();
                }
            }
            return filterResult;
//            Map<String, ActivityBaseInfoVO> approveActivityMapByTaskId = approveActivityListByTaskIds.stream().collect(Collectors.toMap(ActivityBaseInfoVO::getActivityId, t->t, (a, b)-> b));
//            List<ActivityBaseInfoVO> filteredApproveActivityListByTaskIds = new ArrayList<>();
//            for(ComponentBaseInfoBO componentInfo : filteredBaseInfos) {
//                filteredApproveActivityListByTaskIds.add(approveActivityMapByTaskId.get(componentInfo.getCode()));
//            }
//            return filteredApproveActivityListByTaskIds;
        }
        return filterResult;
    }

    @Override
    public Object postActivityByTask(String taskCode, String appCode, String locale, Map<String, Object> paramCodeAndValue) throws Exception {
//        String tenantId = AthenaUtils.getTenantId();
//        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
//        List<String> taskIdList = new ArrayList<>();
//        taskIdList.add(taskCode);
//        List<ActivityBaseInfoVO> approveActivityListByTaskIds = this.activityRepository.getActivityListByTaskIds(taskIdList, tenantId, locale, tenantVersion);
//        if(CollectionUtils.isEmpty(approveActivityListByTaskIds)){
//            Map<String,Object> param = new HashMap<>();
//            param.put("projectCode",taskCode);
//            param.put("locale",locale);
//            List listdatmap= dataMapService.postTasksByProject(param);
//            if(null!=listdatmap){
//                approveActivityListByTaskIds = JSON.parseArray(JSON.toJSONString(listdatmap),ActivityBaseInfoVO.class);
//            }
//        }
//        // 利用应用参数值、产品、条件筛选获取的任务信息
//        List<ActivityBaseInfoVO> filterResult = filterActivityInfo(appCode, approveActivityListByTaskIds, paramCodeAndValue);
//        filterResult = setConfig(taskCode, tenantId, filterResult);
//        return filterResult;

        Map<String,Object> param = new HashMap<>();
        param.put("taskCode",taskCode);
        param.put("appCode",appCode);
        param.put("locale",locale);
        param.put("paramCodeAndValue",paramCodeAndValue);
        return dataMapService.postActivityByTask(param);
    }

    private List<ActivityBaseInfoVO> setConfig(String taskCode, String tenantId, List<ActivityBaseInfoVO> filterResult) {
        if (CollectionUtils.isEmpty(filterResult)) {
            return filterResult;
        }
        filterResult.forEach(item -> {
            Object dm = taskService.getTaskInfoFromDataMap(taskCode, item.getActivityId(), null, tenantId);
            Activity result = JSON.parseObject(JSON.toJSONString(dm), Activity.class);
            item.setConfig(result.getConfig());
        });
        return filterResult;
    }

    /*
     利用应用参数值、产品、条件筛选获取的任务信息
     */
    private List<ActivityBaseInfoVO> filterActivityInfo(String applicationCode, List<ActivityBaseInfoVO> approveActivityList, Map<String, Object> paramCodeAndValue) throws Exception {
        List<ActivityBaseInfoVO> result = new ArrayList<>();
        // 获取当前租户对应的敏/稳态产品名称
        List<String> productList = actionService.getTenantProductList();
        for (ActivityBaseInfoVO activityBaseInfo : approveActivityList) {
            Object activityCode = JSONPath.eval(activityBaseInfo, "activityId");
            ActivityVisibleConfig activityVisibleConfig;
            // 如果有产品限定的条件就用限定条件，如果没有就用productCode为空的通用条件
            Query queryHasProduct = Query.query(Criteria.where("activityCode").is(activityCode).and("appCode").is(applicationCode).and("productCode").in(productList));
            activityVisibleConfig = mongoTemplate.findOne(queryHasProduct, ActivityVisibleConfig.class, "activityVisibleConfig");
            if (activityVisibleConfig == null) {
                Criteria criteria = new Criteria();
                criteria.and("activityCode").is(activityCode).and("appCode").is(applicationCode);
                criteria = new Criteria().andOperator(criteria, new Criteria().orOperator(Criteria.where("productCode").is(""), Criteria.where("productCode").is(null)));
                Query queryHasNoProduct = Query.query(criteria);
                activityVisibleConfig = mongoTemplate.findOne(queryHasNoProduct, ActivityVisibleConfig.class, "activityVisibleConfig");
            }
            if (conditionResult(activityVisibleConfig, paramCodeAndValue)) {
                result.add(activityBaseInfo);
            }
        }
        return result;
    }

    /*
     利用已有参数值对条件进行判断,未设条件默认显示，设定条件后符合条件的显示
     */
    private Boolean conditionResult(ActivityVisibleConfig activityVisibleConfig, Map<String, Object> paramCodeAndValue) throws DWBusinessException{
        if (activityVisibleConfig != null) {
            DynamicCondition dynamicCondition = activityVisibleConfig.getAcitvityVisibleCondition();
            if (DynamicConditionTypeEnum.SINGLE.toString().equals(dynamicCondition.getType())) {
                return judgeExpression(dynamicCondition, paramCodeAndValue);
            }
            if (DynamicConditionTypeEnum.AND_GROUP.toString().equals(dynamicCondition.getType())) {
                List<DynamicCondition> conditons = dynamicCondition.getItems();
                for (Conditon cd : conditons) {
                    if (!judgeExpression(cd, paramCodeAndValue)) {
                        return false;
                    }
                }
                return true;
            }
            if (DynamicConditionTypeEnum.OR_GROUP.toString().equals(dynamicCondition.getType())) {
                List<DynamicCondition> conditons = dynamicCondition.getItems();
                for (Conditon cd : conditons) {
                    if (judgeExpression(cd, paramCodeAndValue)) {
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    // 处理条件中的IN、GREATER_THAN、LESS_THAN三种运算
    private Boolean judgeExpression(Conditon dc, Map<String, Object> paramCodeAndValue) throws DWBusinessException {
        boolean result = false;
        if (paramCodeAndValue == null || paramCodeAndValue.isEmpty()) {
            paramCodeAndValue = (Map<String, Object> )this.mechanismService.getVariable(dc.getLeft(), AthenaUtils.getTenantId());
        }
        if(paramCodeAndValue == null || paramCodeAndValue.isEmpty()){
            return true;
        }

        Object variable = paramCodeAndValue.get(dc.getLeft());
        String op = dc.getOp();
        String[] value = dc.getRight().split(","); // 多个条件以逗号为分隔
        if (ConditionOperatorTypeEnum.IN.toString().equals(op)) {
            if (Arrays.asList(value).contains(String.valueOf(variable))) {
                result = true;
            }
        }
        try {
            if (ConditionOperatorTypeEnum.GREATER_THAN.toString().equals(op)) {
                double douValue = variable != null ? Double.parseDouble(String.valueOf(variable)) : 0;
                if (douValue > Double.parseDouble(value[0])) {
                    result = true;
                }
            }
            if (ConditionOperatorTypeEnum.LESS_THAN.toString().equals(op)) {
                double douValue = variable != null ? Double.parseDouble(String.valueOf(variable)) : 0;
                if (douValue < Double.parseDouble(value[0])) {
                    result = true;
                }
            }
        } catch (Exception e) {
            log.error("条件数值比较出现异常, 请检查配置条件值类型！");
            throw e;
        }
        return result;
    }

    @Override
    public Object postCopyApiStatus(List<String> codeList, String tenantId,String appCode) throws Exception {
        String tenantVersion = kgInnerService.getTenantVersion(tenantId);
        if (CollectionUtils.isEmpty(codeList)) {
            codeList = new ArrayList<>();
        }
        if (StringUtils.isNotEmpty(appCode)) {
            Query query = new Query();
            query.addCriteria(Criteria.where("appCode").is(appCode).and("version").is(tenantVersion));
            List<ApplicationRelation> applicationRelations = mongoTemplate.find(query, ApplicationRelation.class);
            if (!CollectionUtils.isEmpty(applicationRelations)) {
                for (ApplicationRelation applicationRelation : applicationRelations) {
                    codeList.add(applicationRelation.getCode());
                }
            }
        }
        Criteria criteria = Criteria.where("code").in(codeList).and("copyApi").ne(null);
        List<ActivityConfig> activityConfigs = dataPickService.find(criteria, ActivityConfig.class, "activityConfigs");
        if (CollectionUtils.isEmpty(activityConfigs)) {
            return new ArrayList<>();
        }
        LanguageUtil.processLocaleLanguage(activityConfigs,AthenaUtils.getCurrentLocale());
        return activityConfigs;
    }


    @Override
    public Object getAddActionsByPluginId(String code,String variableId, String pluginId) throws DWBusinessException {
        // 太恶心了 机制生效的时候要求给基础定义中增加机制变量 方便他们读取  不是小ai有问题就是设计架构有问题 只能这么写  目前只写了基础资料
        ActivityConfig activityConfigs = dataPickService.findOneByCondition(Criteria.where("code").is(code), ActivityConfig.class, "activityConfigs");
        try {
            //为什么小ai要这么设计 读个机制变量放这么深？ 暂不考虑健壮性  有问题直接抛
            Map pages = activityConfigs.getPages();
            Map basicData = (Map) pages.get("basic-data");
            Object submitActions = basicData.get("submitActions");
            HashMap<String, Object> map = new HashMap<>();
            map.put("name", variableId);
            map.put("value", variableId);
            map.put("type", "TM_VARIABLE");
            map.put("pluginId", pluginId);
            if (ObjectUtils.isEmpty(submitActions)) {
                basicData.put("submitActions", Collections.singletonList(ImmutableMap.of("actionParams",
                        Collections.singletonList(map))));
            } else {
                List submitAction = (List) submitActions;
                submitAction.add(ImmutableMap.of("actionParams",
                        Collections.singletonList(map)));
            }
            Query query1 = new Query();
            query1.addCriteria(Criteria.where("_id").is(activityConfigs.getId()));
            Update update = new Update();
            update.set("pages",pages);
            mongoTemplate.upsert(query1,update,"activityConfigs");
            //清一下缓存  全局的
            cacheService.deleteWithPattern(REDIS_KNOWLEDGE_GRAPH + ":*");
        } catch (Exception e) {
            throw new DWBusinessException("getAddActionsByPluginId  error,{}",e.toString());
        }
        return "ok";
    }

    @Override
    public Object getCleanActionsByPluginId(String code, String pluginId) throws DWBusinessException {
        ActivityConfig activityConfigs = dataPickService.findOneByCondition(Criteria.where("code").is(code), ActivityConfig.class, "activityConfigs");
        try {
            Map basicData = (Map) activityConfigs.getPages().get("basic-data");
            if (!ObjectUtils.isEmpty(basicData.get("submitActions"))) {
                List list = (List) basicData.get("submitActions");
                Iterator iterator = list.iterator();
                while(iterator.hasNext()){
                    Map next = (Map)iterator.next();
                    Object actionParams = next.get("actionParams");
                    if (!ObjectUtils.isEmpty(actionParams)) {
                        List list1 = (List) actionParams;
                        Iterator iterator1 = list1.iterator();
                        while(iterator1.hasNext()){
                            Map next1 = (Map)iterator1.next();
                            if("TM_VARIABLE".equals(next1.get("type"))&&pluginId.equals(next1.get("pluginId"))){
                                iterator.remove();
                            }
                        }
                    }
                }
            }
            Query query1 = new Query();
            query1.addCriteria(Criteria.where("_id").is(activityConfigs.getId()));
            Update update = new Update();
            update.set("pages",activityConfigs.getPages());
            mongoTemplate.upsert(query1,update,"activityConfigs");
        } catch (Exception e) {
            throw new DWBusinessException("getCleanActionsByPluginId  error,{}",e.toString());
        }
        return "ok";
    }
}