package com.digiwin.athena.knowledgegraph.task.model;

import com.digiwin.athena.kg.activity.ActivityApprove;
import com.digiwin.athena.kg.activity.Message;
import com.digiwin.athena.kg.activity.ExpectedDurationDTO;
import lombok.Data;

import java.util.List;
import java.util.Map;

//0901新版json结构
@Data
public class ActivityDefinition2DTO {
    private String activityId;
    private Object activityName;
    private int sequence;
    private int emergency;
    private ExpectedDurationDTO expectedDuration;
    private ActivityExecuteTypeEnum executeType;
    private ActivityPatternEnum pattern;
    private String category;
    private Boolean milestone;
    private Boolean showFlow;

    //新版json结构
    //数据源
    private Object dataSources;
    //数据查询器
    private Object dataFilters;
    //数据加工器
    private Object dataProcessors;
    //页面
    private Object pages;

    //审核相关
    private Integer approveType;
    private Integer groupDispatchType;
    private List<String> startApproveActivity;
    private String startApproveActivityName;
    private List<ActivityApprove> approves;

    //消息
    private List<Message> messages;

    //附件
    private Object attachment;

    private Map<String, Object> activityParameter;
}