package com.digiwin.athena.knowledgegraph.task.model;

import com.digiwin.athena.kg.activity.ExpectedDurationDTO;
import lombok.Data;

@Data
public class ActivityInfoDTO implements Cloneable {
    private String activityId;
    private Object activityName;
    private int sequence;
    private int emergency;
    private ActivityExecuteTypeEnum executeType;
    private ExpectedDurationDTO expectedDuration;
    private Boolean milestone;
    private Boolean showFlow;
    private String category;
    private String pattern;
    private Boolean merge;//是否支持任务卡合并

    @Override
    public Object clone() throws CloneNotSupportedException {
        ActivityInfoDTO activityInfoDTO = (ActivityInfoDTO) super.clone();
        ExpectedDurationDTO durationDTO = activityInfoDTO.getExpectedDuration();
        if (durationDTO != null) {
            activityInfoDTO.setExpectedDuration((ExpectedDurationDTO)durationDTO.clone());
        }
        return activityInfoDTO;
    }
}
