package com.digiwin.athena.knowledgegraph.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.support.MergePolicy;
import com.digiwin.athena.kmservice.utils.ServiceUtils;
import com.digiwin.athena.knowledgegraph.constant.PropertiesConstants;
import com.digiwin.athena.knowledgegraph.filter.KgFilter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-10-29 15:47
 **/
@Slf4j
public class AthenaUtils {

    public static String getHeaderToken()  throws DWBusinessException{
        Map<String, Object> profile = DWServiceContext.getContext().getRequestHeader();
        if(profile != null){
            return (String) profile.getOrDefault("token", null);
        }else{
            throw new DWBusinessException("not found token from requestHeader");
        }

    }


    public static String getUserId()  throws DWBusinessException{
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        if(profile != null){
            return (String) profile.getOrDefault("userId", null);
        }else{
            throw new DWBusinessException("not found userId from token");
        }

    }

    public static String getTenantId() throws DWBusinessException {
        String tenantId=null;
        try {
            Map<String, Object> profile = DWServiceContext.getContext().getProfile();
             tenantId = (String) profile.getOrDefault("tenantId", null);
        }catch (Exception e){}
        if(null==tenantId){
            try {
                tenantId = KgFilter.getLoginInfo().getTenantId();
            }catch (Exception e2){}
        }
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.tokenMissingTeant"));
        }
        if(null!= KgFilter.getLoginInfo()){
            KgFilter.getLoginInfo().setTenantId(tenantId);
        }
        return tenantId;
    }

    public static String getTenantIdSilent() throws DWBusinessException {
        String tenantId=null;
        try {
            Map<String, Object> profile = DWServiceContext.getContext().getProfile();
            tenantId = (String) profile.getOrDefault("tenantId", null);
        }catch (Exception e){}
        if(null==tenantId){
            try {
                tenantId = KgFilter.getLoginInfo().getTenantId();
            }catch (Exception e2){}
        }
        return tenantId;
    }


    public static String getSecretToken() throws DWBusinessException {
        String sectoken = (String) DWServiceContext.getContext().getRequestHeader().get("security-token");
        return sectoken;
    }

    //浅拷贝
    public static void mergeObject(Object source, Object to) {
        List<Field> fieldList = ServiceUtils.getFields(source.getClass());
        for (Field f : fieldList) {
            try {
                f.setAccessible(true);
                Object value = f.get(source);
                if (null != value) {
                    f.set(to, value);
                }
            } catch (Exception e) {
                log.error(e.toString());
            }
        }
    }

    public static void mergeObject(Object source, Object to, MergePolicy policy)   {
        if(null==source || null==to ){return;}
        if(!isMapOrObject(source)){return;}
        if(policy.getParsed().contains(source)){return;}
        policy.getParsed().add(source);
        String parent = policy.getPath();
        if(source instanceof Map){
            Map sourcemap = (Map) source;
            Map tomap = (Map) to;
            sourcemap.forEach((k,v)->{
                String path = parent+"."+k;
                if(null!=v){
                    Object v2 = tomap.get(k);
                    if(isMapOrObject(v) && policy.pathMatch(path) && v2!=null){
                        policy.setPath(path);
                        mergeObject(v,v2,policy);
                    }else {
                        tomap.put(k,v);
                    }
                }
            });
        }else{
            //复合类型
            List<Field> fieldList = ServiceUtils.getFields(source.getClass());
            for(Field f : fieldList){
                try{
                    f.setAccessible(true);
                    Object value = f.get(source);
                    if(null==value){
                        continue;
                    }
                    Object value2 = f.get(to);
                    if(value2==null){
                        f.set(to,value);
                        continue;
                    }
                    String path = parent+"."+f.getName();
                    if(isMapOrObject(value) && policy.pathMatch(path)){
                        policy.setPath(path);
                        mergeObject(value,value2,policy);
                    }else{
                        if(value instanceof Map){
                            Map mv = (Map) value;
                            if(!mv.isEmpty()){
                                Map mv2 = (Map) value2;
                                mv2.putAll(mv);
                                f.set(to,mv2);
                            }
                        }else if(value instanceof Collection){
                            Collection cv = (Collection) value;
                            if(cv.size()>0){
                                f.set(to,value);
                            }
                        } else {
                            f.set(to,value);
                        }
                    }
                }catch(Exception e){
                    log.error(e.toString());
                }
            }
        }


    }

    private static boolean isMapOrObject(Object v){
        if(v==null){return false;}
        if(v instanceof Collection || v.getClass().isArray() || isPrimitive(v.getClass())){return false;}
        return true;
    }

    public static boolean isPrimitive(Class<?> c) {
        if (c != null) {

            if (c.isPrimitive()  || Number.class.isAssignableFrom(c) || Boolean.class.equals(c)
                    || Character.class.isAssignableFrom(c) || CharSequence.class.isAssignableFrom(c)) {
                return true;
            }

        }

        return false;
    }

    public static void mergeList(List source,List to){
        if(CollectionUtils.isEmpty(source) || CollectionUtils.isEmpty(to)){
            return;
        }
      for(Object s:source){
          if(null!=s){
              for(Object t : to){
                  if(s.equals(t)){
                      mergeObject(s,t);
                      break;
                  }
              }
          }
      }
    }


    public static String postEoc(String uri, Header[] headers, String jsonbody, String appToken) {

        if (null == headers) {
            headers = Utils.requiredHeaders();
        }

        String token = DWServiceContext.getContext().getToken();
        if (null != token) {
            Header auth = new BasicHeader("digi-middleware-auth-user", token);
            headers = ArrayUtils.add(headers, auth);
        }
        if (null != appToken) {
            Header auth = new BasicHeader("digi-middleware-auth-app", appToken);
            headers = ArrayUtils.add(headers, auth);
        }
//        String url = DWModuleConfigUtils.getCurrentModuleProperty("eocUrl") + uri;
        String url = PropertiesConstants.getInstance().getEocUrl() + uri;
        String body = Utils.postJson(url, headers, jsonbody);

        return body;

    }

    public static String postEoc(String uri, Header[] headers, String jsonbody, String token, String appToken) {

        if (null == headers) {
            headers = Utils.requiredHeaders();
        }

//        String token = DWServiceContext.getContext().getToken();
        if (null != token) {
            Header auth = new BasicHeader("digi-middleware-auth-user", token);
            headers = ArrayUtils.add(headers, auth);
        }
        if (null != appToken) {
            Header auth = new BasicHeader("digi-middleware-auth-app", appToken);
            headers = ArrayUtils.add(headers, auth);
        }
//        String url = DWModuleConfigUtils.getCurrentModuleProperty("eocUrl") + uri;
        String url = PropertiesConstants.getInstance().getEocUrl() + uri;
        String body = Utils.postJson(url, headers, jsonbody);

        return body;

    }

    public static JSONObject getEoc(String uri, Header[] headers, Map<String, String> jsonbody, String appToken) throws IOException {

        if (null == headers) {
            headers = Utils.requiredHeaders();
        }

        String token = DWServiceContext.getContext().getToken();
        if (null != token) {
            Header auth = new BasicHeader("digi-middleware-auth-user", token);
            headers = ArrayUtils.add(headers, auth);
        }
        if (null != appToken) {
            Header auth = new BasicHeader("digi-middleware-auth-app", appToken);
            headers = ArrayUtils.add(headers, auth);
        }
//        String url = DWModuleConfigUtils.getCurrentModuleProperty("eocUrl") + uri;
        String url = PropertiesConstants.getInstance().getEocUrl() + uri;
        String body = Utils.get(url, headers, jsonbody);

        JSONObject jsonObject = JSON.parseObject(body);

        return jsonObject;

    }

    public static String getCurrentLocale() {
        String localeString = null;
        Map<String, Object> headers = DWServiceContext.getContext().getRequestHeader();
        if (headers != null && headers.containsKey("locale")) {
            localeString = (String)headers.get("locale");
        }
        return localeString;
    }

    public static List<String> indexFiledName(String path) {
        ArrayList<String> filedNameList = new ArrayList<>();
        File directory = new File(path);
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    filedNameList.add(file.getName());
                }
            }
        } else {
            log.error("该路径不存在或者不是一个目录");
        }
        return filedNameList;
    }

    public static String loadStream(String file)  {
        try {
            String text = IOUtils.toString(ServiceUtils.class.getResource(file),"utf-8");
            return text;
        } catch (IOException e) {
            log.error(e.toString());
        }
        return null;
    }

    public static  <T> T loadEntity(String file,Class<T> c){
        String replaced =  loadStream(file);
        T entities = JSON.parseObject(replaced,c);
        return entities;
    }

}
