package com.digiwin.athena.knowledgegraph.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
@Deprecated
public class HttpUtil {
    private static Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);

    @Autowired
    @Qualifier("routeRestTemplate")
    RestTemplate routeRestTemplate;

    static RestTemplate restTemplate;

    @PostConstruct
    public void init() {
        restTemplate = routeRestTemplate;
    }

    /**
     * 发送请求
     *
     * @param content
     * @return
     * @throws Exception
     */
    public static String post(final String url, final String content) {
        String result = "";
        try {
            final HttpHeaders headers = new HttpHeaders();
            Utils.requiredHeaders(headers);
            final MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());

            HttpUtil.LOGGER.info("url:{}", url);
            HttpUtil.LOGGER.info("content:{}", content);
            final HttpEntity<String> formEntity = new HttpEntity<>(content, headers);

            result = restTemplate.postForObject(url, formEntity, String.class);
            HttpUtil.LOGGER.info("result:{}", result);
        } catch (final JSONException e) {
            HttpUtil.LOGGER.error("http post error:", e);
        } catch (final Exception e) {
            HttpUtil.LOGGER.error("http post error2:", e);
        }

        return result;
    }

    /**
     * 发送请求
     *
     * @param content
     * @return
     * @throws Exception
     */
    public static String post(final String url, final String content, Map<String, String> headerParam) {
        String result = "";
        try {
            final HttpHeaders headers = new HttpHeaders();
            Utils.requiredHeaders(headers);
            final MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            for (String k : headerParam.keySet()) {
                headers.add(k,headerParam.get(k));
            }

            HttpUtil.LOGGER.info("url:{}", url);
            HttpUtil.LOGGER.info("content:{}", content);
            final HttpEntity<String> formEntity = new HttpEntity<>(content, headers);

            result = restTemplate.postForObject(url, formEntity, String.class);
            HttpUtil.LOGGER.info("result:{}", result);
        } catch (final JSONException e) {
            HttpUtil.LOGGER.error("http post error:", e);
        } catch (final Exception e) {
            HttpUtil.LOGGER.error("http post error2:", e);
        }

        return result;
    }

    public static String sendGet(String url, String reqJson, Map<String, String> header) {
        String responseContent = "";
        HttpClient httpClient = Utils.getHttpClient();
        // Get请求
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (StringUtils.isNotEmpty(reqJson)) {
                List<NameValuePair> nameValuePairList = json2NameValuePairList(JSON.parseObject(reqJson));
                uriBuilder.setParameters(nameValuePairList);
            }
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            // 设置Header
            httpGet.setHeader("Content-Type", "application/json");
            if (null != header && !header.isEmpty()) {
                for (Map.Entry<String, String> i : header.entrySet()) {
                    httpGet.setHeader(i.getKey(), i.getValue());
                }
            }

            HttpResponse httpResponse = httpClient.execute(httpGet);
            org.apache.http.HttpEntity entity = httpResponse.getEntity();            //获取响应实体
            if (null != entity) {
                responseContent = EntityUtils.toString(entity, "UTF-8");
                EntityUtils.consume(entity); //Consume response content
            }
            return responseContent;
        } catch (URISyntaxException | IOException e) {
            log.error(e.getMessage(), e);
            throw new RuntimeException(I18nUtils.getValue("knowledgegraph.httpRequestError",e.getMessage()));
        }
    }

    private static List<NameValuePair> json2NameValuePairList(JSONObject params) {
        if (params != null && !params.isEmpty()) {
            List<NameValuePair> list = new ArrayList<NameValuePair>();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (entry.getValue() != null) {
                    String value = String.valueOf(entry.getValue());
                    list.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            return list;
        }
        return null;
    }


}
