package com.digiwin.athena.knowledgegraph.utils;

import com.digiwin.athena.mechanism.common.MechanismVariable;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MechanismUtils {

    public static String listStr(List<String> list){
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for(int i=0;i< list.size();i++){
            sb.append("'").append(list.get(i)).append("'");
            if(i< list.size()-1){
                sb.append(",");
            }
        }
        sb.append("]");

        return sb.toString();
    }

    public static ActivityWidget getMechanismVariableActivity(List<String> variables){
        String ids = MechanismUtils.listStr(variables);
        ActivityWidget activityWidget0 = new ActivityWidget();
        activityWidget0.setType("http");
        activityWidget0.setConfig(new HashMap<>());
        activityWidget0.getConfig().put("executionMode","script");
        activityWidget0.getConfig().put("method","post");
        activityWidget0.getConfig().put("domain","thememap");
        activityWidget0.getConfig().put("contentType","json");
        activityWidget0.getConfig().put("url","/restful/service/knowledgegraph/mechanism/variableListSimple");
        Map<String,String> scriptMode0 = new HashMap<>();
        String requestScript0="var request = {map:{variableIds:#ids#}}; return request;";
        requestScript0 = requestScript0.replaceAll("#ids#",ids);
        scriptMode0.put("requestScript",requestScript0);
         String responseScript0="var response = $(response);var variables = response.response; return {\"success\":true,\"processVariable\":{\"mechanismVariables\":variables}}";
        scriptMode0.put("responseScript",responseScript0);
        activityWidget0.getConfig().put("scriptMode",scriptMode0);
        activityWidget0.setName("获取应用参数");

        return activityWidget0;
    }

    public static ActivityWidget scriptActivityWidget(String name,String script){
        ActivityWidget activityWidget1 = new ActivityWidget();
        activityWidget1.setType("script");
        activityWidget1.setConfig(new HashMap<>());
        activityWidget1.getConfig().put("executionMode","script");
        Map<String,String> scriptMode = new HashMap<>();
        scriptMode.put("requestScript","");
        scriptMode.put("responseScript",script);
        activityWidget1.getConfig().put("scriptMode",scriptMode);
        activityWidget1.setName(name);
        return activityWidget1;
    }


    public static String pathKey(MechanismVariable variable){
        if(null==variable){
            return null;
        }
        if(null!=variable.getCode()){
            return variable.getCode();
        }
        if(null!=variable.getPath()){
            String[] paths =variable.getPath().split("\\.");
            return paths[paths.length-1];
        }

        return null;
    }

    public static String pathParentKey(MechanismVariable variable){
        if(null==variable){
            return null;
        }
        if(null!=variable.getCode()){
            return variable.getCode();
        }
        if(null!=variable.getPath()){
            String[] paths =variable.getPath().split("\\.");
            return paths[paths.length-2];
        }

        return null;
    }
}
