package com.digiwin.athena.knowledgegraph.vo;

import com.digiwin.athena.knowledgegraph.domain.task.DataMapTaskVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class FindTaskFromUserVO implements Serializable {
    /**
     * 任务类型名称
     */
    private String taskDefName;
    /**
     * 任务类型code
     */
    private String taskDefCode;
    /**
     * 业务类型
     */
    private String category;
    /**
     * 应用
     */
    private String application;

    /**
     * 根据locale设置taskDefName
     * @param dataMapTaskVO
     *  lang 数据结构 {
     *                  name: {
     *                   "zh_TW": "項目簽核",
     *                   "en_US": "The project for approval",
     *                   "zh_CN": "项目签核"
     *                  }
     *              }
     */
    public void setTaskDefName(DataMapTaskVO dataMapTaskVO, String locale) {
        if (MapUtils.isEmpty(dataMapTaskVO.getLang()) || MapUtils.isEmpty(dataMapTaskVO.getLang().get("name"))) {
            this.taskDefName = dataMapTaskVO.getName();
            return;
        }
        Map<String, String> localeName = dataMapTaskVO.getLang().get("name");
        if (StringUtils.isEmpty(locale)) {
            locale = "zh_CN";
        }
        this.taskDefName = localeName.get(locale);
    }
}
