package com.digiwin.athena.knowledgegraph.vo;

import com.digiwin.athena.knowledgegraph.domain.mechanism.Paradigm;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 取机制范式权限、指定应用下的范式集合、机制组件清单数据帮助tdd处理范式筛选记录Vo
 */
@Data
public class HandleParadigmListVo {

    /**
     * 租户和应用下范式和机制的权限数据
     */
    private List<String> checkedList;

    /**
     * 范式集合数据
      */
    private  List<Paradigm> paradigmList;


    /**
     * 组件清单范式Map 分组逻辑：key机制code，value：范式code
     */
    private Map<String, String> mechanismParadigmMap;

}
