package com.digiwin.athena.knowledgegraph.vo.workbenchSetting;

import com.digiwin.athena.knowledgegraph.enums.WSPageCode;
import com.digiwin.athena.knowledgegraph.enums.WSConfigType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 交付设计器的待办工作台设置
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class WorkbenchSettingVO {
    /**
     * 主键id
     */
    private String id;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 配置类型
     */
    private WSConfigType configType;
    /**
     * 页面类型枚举值
     */
    private WSPageCode pageCode;
    /**
     *条件配置
     */
    private List<WSConditionVO> condition;
    /**
     * 排序下，默认的条件
     */
    private List<WSConditionVO> defaultCondition;
}
