package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.knowledgegraph.domain.inference.InferenceEntity;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface InferenceRepository extends Neo4jRepository<InferenceEntity, Long> {
//MATCH (source:{sourceLabel} {code: $1})-[:$2*{depth}]->(target:{targetLabel} {code: $5}) RETURN target
    @Query("MATCH (source:Part {code: '车轴code'})-[:belong*]->(target:Gas) RETURN target")
    List<InferenceEntity>  queryInference(String sourceLabel, String sourceCode,String relationShip,int depth,
                                          String targetLabel,String targetCode);

    //@Query("MATCH (source:{sourceLabel} {code: $1})-[:$2*]->(target:{targetLabel} {code: $4}) RETURN target ")
    @Query("MATCH (source:Part {code: '车轴code'})-[:belong*]->(target:Gas) RETURN target")
    List<InferenceEntity>  queryInferenceNoDepth(@Param("sourceLabel")String sourceLabel, String sourceCode, String relationShip,
                                                 @Param("targetLabel")String targetLabel, String targetCode);
}
