package com.digiwin.athena.repository.neo4j;

import com.digiwin.athena.knowledgegraph.domain.AppEntity;
import com.digiwin.athena.knowledgegraph.domain.TenantAppInfoDTO;
import com.digiwin.athena.knowledgegraph.domain.TenantAppInfosDTO;
import com.digiwin.athena.knowledgegraph.domain.TenantEntity;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-07-07 14:02
 **/
@Repository
public interface TenantEntityRepository  extends Neo4jRepository<TenantEntity,Long> {

    @Query("match(te:TenantEntity) where te.ifCommon is null or te.ifCommon = false return te")
    List<TenantEntity> allTenantEntity();

    @Query("match(te:TenantEntity{version:$0}) where te.ifCommon is null or te.ifCommon = false return te")
    List<TenantEntity> allTenantEntity(String tenantVersion);


    @Query("match(te:TenantEntity{tenantId:$0}) return te")
    TenantEntity tenantEntity(String tenantId);

    @Query("match(te:TenantEntity{tenantId:$0}) optional match (te)-[:USE]->(app:AppEntity{code:$1}) return te.tenantId as tenantId, te.tenantName as tenantName, app.code as appCode, app.namespace as namespace")
    TenantAppInfoDTO tenantEntity(String tenantId, String appCode);

    @Query("match(te:TenantEntity{tenantId:$0}) optional match (te)-[:USE]->(app:AppEntity) return app.code as appCode")
    List<TenantAppInfoDTO> tenantAppEntity(String tenantId);

    @Query("match(te:AppEntity{code:$0}) return te LIMIT 1")
    AppEntity appEntity(String code);

    @Query("match(te:AppEntity) return te")
    List<AppEntity> queryAllAppEntity();

    @Query("match(te:TenantEntity{tenantId:$0})-[:USE]->(app:AppEntity{code:$1}) return te.tenantId as tenantId, te.tenantName as tenantName, app.code as appCode, app.namespace as namespace")
    TenantAppInfoDTO tenantWithAppEntity(String tenantId, String appCode);


    @Query("match (te:TenantEntity)-[:USE]->(app:AppEntity) where app.code in $0 return te.tenantId as tenantId, te.tenantName as tenantName, te.customerServiceCode as customerServiceCode, app.code as appCode")
    List<TenantAppInfoDTO> queryTenant(List<String> appCodeList);

    @Query("match(te:TenantEntity{tenantId:$0}) optional match (te)-[:USE]->(app:AppEntity) return app.code as appCode, app.name as appName,te.tenantId as tenantId")
    List<TenantAppInfosDTO> tenantAppsEntity(String tenantId);

    @Query("match (te:TenantEntity{tenantId:$0})-[:USE]->(app:AppEntity) return app.code as code ")
    List<String> appCodes(String tenantId);
}
