package com.digiwin.athena.knowledgegraph.action.metadata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.action.dao.ActionMetadataDAO;
import com.digiwin.athena.dto.ApiDataFieldMetadataDTO;
import com.digiwin.athena.kmservice.action.model.*;
import com.digiwin.athena.kmservice.action.metadata.model.*;
import com.digiwin.athena.knowledgegraph.data.Neo4jManager;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@Service
public class ApiSynchronizer {
    @Autowired
    private ActionMetadataDAO actionMetadataDAO;

//    private final String MDC_URL = "http://esp.digiwincloud.com.cn/ESP/MetadataCache";该类已过时 不使用
    private final String MDC_URL = "https://mdc.apps.digiwincloud.com.cn/restful/standard/mdc";

    public void SynchronizeOne(String apiName, String productName, String productVersion) throws Exception {
        String apiMetadataUrl = MDC_URL + "/ApiMetadata/Get";

        URL restURL = new URL(apiMetadataUrl);

        HttpURLConnection conn = (HttpURLConnection) restURL.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);

        ApiMetadataRequestDTO metadataReuest = new ApiMetadataRequestDTO();
        metadataReuest.setApi_name(apiName);
        metadataReuest.setProduct_name(productName);
        metadataReuest.setProduct_version(productVersion);
        PrintStream ps = new PrintStream(conn.getOutputStream());
        ps.print(JSON.toJSON(metadataReuest));
        ps.close();

        ApiMetadataResponseDTO metadataResponse = JSON.parseObject(conn.getInputStream(), ApiMetadataResponseDTO.class);

        String apiVersion = metadataResponse.getData().getApi_version();
        String category = metadataResponse.getData().getCategory();
        String remark_cn = metadataResponse.getData().getRemark().getZh_CN();
        String remark_tw = metadataResponse.getData().getRemark().getZh_TW();
        String desc_cn = metadataResponse.getData().getDescription().getZh_CN();
        String desc_tw = metadataResponse.getData().getDescription().getZh_TW();

        ApiDataMetadataDTO dataMetadata = metadataResponse.getData().getData_metadata();

        List<ApiDataFieldMetadataDTO> fieldsOfParameter = dataMetadata.getRequest().getBody().getField().get(0).getField();
        List<ApiDataFieldMetadataDTO> fieldRequestObjects = new ArrayList<ApiDataFieldMetadataDTO>();
        for (ApiDataFieldMetadataDTO fieldOfParameter : fieldsOfParameter) {
            if (!fieldOfParameter.getData_name().equals("enterprise_no")
                    && !fieldOfParameter.getData_name().equals("site_no")
                    && !fieldOfParameter.getData_name().equals("call_id")) {
                fieldRequestObjects.add(fieldOfParameter);
                break;
            }
        }
        String request_str = JSON.toJSONString(fieldRequestObjects);

        List<ApiDataFieldMetadataDTO> fieldsOfResponse = dataMetadata.getResponse_success().getBody().getField();
        ApiDataFieldMetadataDTO fieldReponseObject = null;
        for (ApiDataFieldMetadataDTO fieldOfResponse : fieldsOfResponse) {
            if (fieldOfResponse.getData_name().equals("parameter")) {
                fieldReponseObject = fieldOfResponse;
                break;
            }
        }
        String response_str = "";
        if (fieldReponseObject != null) {
            response_str = JSON.toJSONString(fieldReponseObject.getField().get(0));
        }

        String actionId = "esp_" + apiName;

        StringBuffer stringBuffer = new StringBuffer();

        stringBuffer.append("Create (action:Action {");
        stringBuffer.append("actionId:'");
        stringBuffer.append(actionId);
        stringBuffer.append("', serviceName:'");
        stringBuffer.append(apiName);
        stringBuffer.append("', serviceVersion:'");
        stringBuffer.append(apiVersion);
        stringBuffer.append("', actionName:'");
        stringBuffer.append(desc_cn);
        stringBuffer.append("', actionName_tw:'");
        stringBuffer.append(desc_tw);
        stringBuffer.append("', desc:'");
        stringBuffer.append(remark_cn);
        stringBuffer.append("', desc_tw:'");
        stringBuffer.append(remark_tw);
        stringBuffer.append("', request_parameters:'");
        stringBuffer.append(request_str);
        stringBuffer.append("', response_object:'");
        stringBuffer.append(response_str);
        stringBuffer.append("'})");

        Neo4jManager.getNeo4jManager().ExecuteQuery(stringBuffer.toString());

        //保存元数据到mongo
        actionMetadataDAO.upsertActionMetadata(actionId,apiVersion, JSONObject.parseArray(request_str),JSONObject.parseObject(response_str),apiName);
    }

    public List<String> SynchronizeAll(String tenantId) throws Exception {
        String apiListUrl = MDC_URL + "/ApiList/Get";

        URL restURL = new URL(apiListUrl);

        HttpURLConnection conn = (HttpURLConnection) restURL.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        ApiListRequestDTO apiListRequest = new ApiListRequestDTO();
        apiListRequest.setLanguage("zh_CN");
        PrintStream ps = new PrintStream(conn.getOutputStream());
        ps.print(JSON.toJSON(apiListRequest));
        ps.close();

        if(conn.getResponseCode() != 200) {
            throw new DWBusinessException(Integer.toString(conn.getResponseCode()), I18nUtils.getValue("knowledgegraph.apiError") + conn.getResponseMessage());
        }

        ApiListResponseDTO apiListResponse = JSON.parseObject(conn.getInputStream(), ApiListResponseDTO.class);

        List<ApiInfoDTO> apiInfos = apiListResponse.getData().getApi_info();

        List<String> succeeded = new ArrayList<String>();
        for (ApiInfoDTO apiInfo : apiInfos) {
            //TO DO 先写死
            try {
                SynchronizeOne(apiInfo.getName(), "E10", "6.0.0.1"); //NOSONAR
                succeeded.add(apiInfo.getName());
                //System.out.println("api synchronized: " + apiInfo.getName());
            }
            catch (Exception ex) {
                System.out.println("api failed to synchronize: " + apiInfo.getName());
                //return DWServiceResultBuilder.build(false, "failed to get api metadata: " + apiInfo.getName(), null);
            }
        }
        return succeeded;
    }
}
