package com.digiwin.athena.knowledgegraph.action.model.report;

import lombok.Data;

import java.io.IOException;
import java.util.List;

/**
 * @title: PlaygroundFilterDTO
 * @author: linc
 * @date 2023/11/22 18:23
 * @version: 1.0
 */
@Data
public class PlaygroundFilterDTO {
    private List<PlaygroundFilterDTO> children;
    /**
     * 左边的值
     */
    private String leftValue;
    /**
     * 逻辑连接符，"and"，"or"
     */
    private String logical;
    /**
     *
     * 操作符，"eq","not_eq","lt","le","gt","ge","in","not_in","like","not_like","null","not_null","empty","not_empty","between","not_between","start_like","not_start_like","end_like","not_end_like"
     */
    private String operator;
    /**
     * 右边的类型，"field","const","param"
     */
    private RightType rightType;
    /**
     * 右边的值，[ xxx]：字段，xxx：常量，@xxx@：传参
     */
    private String rightValue;
}

enum RightType {
    CONST, FIELD, PARAM;

    public String toValue() {
        switch (this) {
            case CONST: return "const";
            case FIELD: return "field";
            case PARAM: return "param";
        }
        return null;
    }

    public static RightType forValue(String value) throws IOException {
        if (value.equals("const")) return CONST;
        if (value.equals("field")) return FIELD;
        if (value.equals("param")) return PARAM;
        throw new IOException("Cannot deserialize RightType");
    }
}
