package com.digiwin.athena.knowledgegraph.app;

import cn.hutool.core.util.StrUtil;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.knowledgegraph.service.impl.IamService;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.mongodb.client.MongoCollection;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

import static com.mongodb.client.model.Filters.eq;

/**
 * 请使用核心服务中的LicenseKeyManager
 */

@Deprecated
@Service
@Slf4j
public class LicenseKeyManager {

    private static final String APP_LICENSE_KEY_COLLECTION_NAME = "appLicenseKey";
    private static final String TENANT_ID_KEY_NAME = "tenantId";
    private static final String LICENSE_KEY_FIELD_NAME = "licenseKey";
    private static final String AES_KEY_HEX = "C40605DBA4C2D6D3FA353C7CA35752B9";

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplate;//改为使用公用mongodb

    @Autowired
    private IamService iamService;

    public void setLicenseKey(String tenantId, String licenseKey){
        Query query = new Query();
        query.addCriteria(Criteria.where(TENANT_ID_KEY_NAME).is(tenantId));
        Update update = new Update();
        update.set(LICENSE_KEY_FIELD_NAME, licenseKey);
        this.mongoTemplate.upsert(query, update,APP_LICENSE_KEY_COLLECTION_NAME);
    }

    public String getDirectLicenseKey(String tenantId) throws DWBusinessException{
        MongoCollection<Document> col = this.mongoTemplate.getCollection(APP_LICENSE_KEY_COLLECTION_NAME);//改为使用公用mongodb
        Document doc = col.find(eq(TENANT_ID_KEY_NAME, tenantId)).first();
        if (doc != null) {
            return doc.getString(LICENSE_KEY_FIELD_NAME);
        }else{
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.licenseKeyNotFound",tenantId));
        }

    }

    public String getDirectLicenseKeyCanNull(String tenantId) throws DWBusinessException{
        MongoCollection<Document> col = this.mongoTemplate.getCollection(APP_LICENSE_KEY_COLLECTION_NAME);//改为使用公用mongodb
        Document doc = col.find(eq(TENANT_ID_KEY_NAME, tenantId)).first();
        if (doc != null) {
            return doc.getString(LICENSE_KEY_FIELD_NAME);
        }else{
            return null;
        }

    }

    public String getLicenseKey(String tenantId) throws Exception {

        MongoCollection<Document> col = this.mongoTemplate.getCollection(APP_LICENSE_KEY_COLLECTION_NAME);//改为使用公用mongodb
        //获取的配置必须是启用状态
        Document doc = col.find(eq(TENANT_ID_KEY_NAME, tenantId)).first();
        String licenseKey = null;
        if (doc != null) {
            licenseKey = doc.getString(LICENSE_KEY_FIELD_NAME);
            if(StringUtils.isEmpty(licenseKey)){
                log.info("===getAthenaLicenceKeyFromIam===");
                licenseKey = this.iamService.getAthenaLicenceKey(tenantId);
                if(StringUtils.isEmpty(licenseKey)){
                    throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.licenseKeyNotFound",tenantId));
                }
                this.setLicenseKey(tenantId, licenseKey);
            }
        } else{
            log.info("===getAthenaLicenceKeyFromIam===");
            licenseKey = this.iamService.getAthenaLicenceKey(tenantId);
            if(StringUtils.isEmpty(licenseKey)){
                throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.licenseKeyNotFound",tenantId));
            }
            this.setLicenseKey(tenantId, licenseKey);
        }

        byte[] byteKey = DatatypeConverter.parseHexBinary(AES_KEY_HEX);
        Key key = new SecretKeySpec(byteKey,"AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding"); //NOSONAR 暂不清楚修改加密算法后的影响
        cipher.init(Cipher.ENCRYPT_MODE, key);
        byte[] result = cipher.doFinal(licenseKey.getBytes());
        return DatatypeConverter.printHexBinary(result);
    }

    public String getLicenseKey(String tenantId, String requestFrom, String md5Str, long timestamp) throws Exception {
        this.checkIsLegal(tenantId,requestFrom,md5Str,timestamp);
        return this.getLicenseKey(tenantId);
//        MongoCollection<Document> col = this.mongoTemplate.getCollection(APP_LICENSE_KEY_COLLECTION_NAME);//改为使用公用mongodb
//        //获取的配置必须是启用状态
//        Document doc = col.find(eq(TENANT_ID_KEY_NAME, tenantId)).first();
//        String licenseKey = null;
//        if (doc != null) {
//            licenseKey = doc.getString(LICENSE_KEY_FIELD_NAME);
//            if(StringUtils.isEmpty(licenseKey)){
//                log.info("===getAthenaLicenceKeyFromIam===");
//                licenseKey = this.iamService.getAthenaLicenceKey(tenantId);
//                if(StringUtils.isEmpty(licenseKey)){
//                    throw new DWBusinessException(String.format("License Key not found for tenant %s", tenantId));
//                }
//                this.setLicenseKey(tenantId, licenseKey);
//            }
//
//        } else{
//            log.info("===getAthenaLicenceKeyFromIam===");
//            licenseKey = this.iamService.getAthenaLicenceKey(tenantId);
//            if(StringUtils.isEmpty(licenseKey)){
//                throw new DWBusinessException(String.format("License Key not found for tenant %s", tenantId));
//            }
//            this.setLicenseKey(tenantId, licenseKey);
//        }
//        byte[] byteKey = DatatypeConverter.parseHexBinary(AES_KEY_HEX);
//        Key key = new SecretKeySpec(byteKey,"AES");
//
//        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
//        cipher.init(Cipher.ENCRYPT_MODE, key);
//        byte[] result = cipher.doFinal(licenseKey.getBytes());
//        return DatatypeConverter.printHexBinary(result);
    }

    public Boolean checkIsLegal(String tenantId, String requestFrom, String md5Str, long timestamp) throws DWBusinessException{

        if (!AppCons.SysEnum.sysExists(requestFrom)) {
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.requestFromError",requestFrom));
        }

        long now = new Date().getTime();
        if(now > timestamp && now - timestamp > AppCons.EXPIRE_TIME){
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.timeExpire",now,timestamp));
        }

        String key = DigestUtils.md5Hex(tenantId+requestFrom+timestamp+AppCons.SysEnum.getKey(requestFrom));
        if(!StringUtils.equals(md5Str, key)){
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.keyIncorrect",md5Str));
        }

        return true;
    }
}
