package com.digiwin.athena.knowledgegraph.component.applies;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.athena.domain.component.ComponentTypeEnum;
import com.digiwin.athena.domain.component.bo.ComponentBO;
import com.digiwin.athena.dto.TaskSchedule;
import com.digiwin.athena.kg.monitorRule.DynamicParam;
import com.digiwin.athena.kg.monitorRule.StandardPollingRule;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyContext;
import com.digiwin.athena.knowledgegraph.component.ComponentApplyService;
import com.digiwin.athena.knowledgegraph.constant.ComponentConstants;
import com.digiwin.athena.knowledgegraph.domain.MechanismTenantVariable;
import com.digiwin.athena.knowledgegraph.domain.MonitorRule;
import com.digiwin.athena.knowledgegraph.domain.VariableDefinition;
import com.digiwin.athena.kg.activity.ActivityConfig;
import com.digiwin.athena.knowledgegraph.enums.MechanismParameterTypeEnum;
import com.digiwin.athena.repository.neo4j.MonitorRuleRepository;
import com.digiwin.athena.knowledgegraph.rule.AbstractMonitorRuleMechanismParameterService;
import com.digiwin.athena.knowledgegraph.rule.MonitorRuleConfigService;
import com.digiwin.athena.kg.monitorRule.MonitorRuleProductConfig;
import com.digiwin.athena.knowledgegraph.rule.model.parameter.MechanismParameterReqDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.StaticParamsDO;
import com.digiwin.athena.knowledgegraph.service.DataMapService;
import com.digiwin.athena.knowledgegraph.service.IMechanismService;
import com.digiwin.athena.knowledgegraph.service.impl.TenantService;
import com.digiwin.athena.knowledgegraph.service.inner.DataPickService;
import com.digiwin.athena.knowledgegraph.service.inner.KgHelpService;
import com.digiwin.athena.knowledgegraph.service.model.MonitorRuleConfigDTO;
import com.digiwin.athena.kg.monitorRule.TriggerDTO;
import com.digiwin.athena.knowledgegraph.utils.AthenaUtils;
import com.digiwin.athena.knowledgegraph.utils.I18nUtils;
import com.digiwin.athena.knowledgegraph.utils.JsonUtil;
import com.digiwin.athena.knowledgegraph.vo.VariableBean;
import com.digiwin.athena.domain.MechanismApplyRecord;
import com.digiwin.athena.mechanism.bo.ControlAbilityBO;
import com.digiwin.athena.mechanism.bo.DriveAbilityBo;
import com.digiwin.athena.mechanism.bo.LimitAbilityBo;
import com.digiwin.athena.mechanism.bo.MechanismLogic;
import com.digiwin.athena.mechanism.common.MechanismEnum;
import com.digiwin.athena.mechanism.mechanismEnum.VariableTypeEnum;
import com.digiwin.athena.mechanism.pre.MechanismPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskByQuantityPart;
import com.digiwin.athena.mechanism.pre.parts.CheckTaskOnTimeOverPart;
import com.digiwin.athena.mechanism.pre.parts.SourceSchedulePart;
import com.digiwin.athena.mechanism.widgets.ActivityWidget;
import com.digiwin.athena.mechanism.widgets.PlanWidget;
import com.digiwin.athena.mechanism.widgets.activity.IMActivityWidget;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.PersonnelCondition;
import com.digiwin.athena.mechanism.widgets.plan.ActivityPlanWidget;
import com.digiwin.athena.mechanism.widgets.source.ScheduleApiSourceWidget;
import com.digiwin.athena.mechanism.widgets.source.ScheduleSourceWidget;
import com.google.common.collect.Lists;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-27 17:46
 **/
@Service
@Order(1)
@Slf4j
public class AbilityComponentApplyService implements ComponentApplyService {


    @Autowired
    @Qualifier("knowledgegraphSystem")
    private MongoTemplate mongoTemplateSystem;

    @Autowired
    @Qualifier("knowledgegraphTenant")
    MongoTemplate mongoTemplateUser;

    @Autowired
    DataMapService dataMapService;

    @Autowired
    KgHelpService kgHelpService;

    @Autowired
    MonitorRuleConfigService monitorRuleConfigService;

    @Autowired
    MonitorRuleRepository monitorRuleRepository;

    @Autowired
    TenantService tenantService;
    @Autowired
    IMechanismService iMechanismService;

    @Autowired
    private List<AbstractMonitorRuleMechanismParameterService>  monitorRuleMechanismParameterServices;

    @Autowired
    private IMechanismService mechanismService;

    private static final List<String> ALLOW_REPLACE_VARIABLE_TYPES = Arrays.asList("NUMBER","STRING","DATE","DATETIME");
    @Autowired
    private DataPickService dataPickService;



    @Override
    public boolean accept(ComponentBO componentBO) {

        return ComponentTypeEnum.MechanismControl.equals(componentBO.getType())
                || ComponentTypeEnum.MechanismDecision.equals(componentBO.getType())
                || ComponentTypeEnum.MechanismAssign.equals(componentBO.getType())
                || ComponentTypeEnum.MechanismDrive.equals(componentBO.getType())
                || ComponentTypeEnum.MechanismLimit.equals(componentBO.getType())
                ;
    }

   // @Async
    @Override
    public void apply(ComponentBO componentBO, ComponentApplyContext context) throws Exception {

        log.info("开始应用机制能力startApplyMechanismCapacity: "+JSON.toJSONString(componentBO));
        String tenantId = AthenaUtils.getTenantId();
        String logicCode = componentBO.getLogicCode();
        if(null==logicCode){
            logicCode = componentBO.getCode();
        }
        if(null==logicCode){
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.componentCodeError"));
        }
        Query query = Query.query(Criteria.where("code").is(logicCode).and("tenantId").is(tenantId));
        MechanismLogic logic = mongoTemplateUser.findOne(query,MechanismLogic.class);
        if(null==logic || logic.getLogic()==null){
            logic = getSystemLogic(logicCode);
        }
        if(null==logic || logic.getLogic()==null){
            log.error("没有找到对应的MechanismLogic："+logicCode);
            return;
        }

        Map<String,Object> param = new HashMap<>();
        param.put("type",componentBO.getType().name());
        param.put("pluginId",componentBO.getCode());
        param.put("mechanismCode",context.getMechanismCode());
        param.put("mechanismVersion",componentBO.getMechanismCapacity().getMechanismVersion());
        param.put("ability",logic.getLogic());
        param.put("mechanismVariables",context.getMechanismVariables());

        if(null!=logic.getType()){
            param.put("type",logic.getType());
        }
        // 如果IM通知人选择机制参数时，在此时替换掉
        replaceImNoticeReceiverFromMechanismVariable(logic,tenantId);

        //机制时机类型为基础资料时拿到pageUIElement表的code发送到dataMap，用作欧博士弹窗
        setDataViewCode(logic, param);

        // 为限制能力转换机制参数
        replaceVariableCodeToTenantValueForLimit(logic);
        dataMapService.bindMechanismComponent(param);

        mongoTemplateUser.remove(Query.query(Criteria.where("tenantId").is(tenantId).and("mechanismAbilityCode").is(componentBO.getCode())),MechanismApplyRecord.class);
        MechanismApplyRecord applyRecord = new MechanismApplyRecord();
        applyRecord.setMechanismCode(context.getMechanismCode());
        applyRecord.setMechanismAbilityCode(componentBO.getCode());
        applyRecord.setTenantId(tenantId);
        applyRecord.setUpdateTime(new Date());
        mongoTemplateUser.save(applyRecord);

        String version = tenantService.getTenantVersion(tenantId);
        String pluginId = componentBO.getCode() + tenantId;

        // 控制能力
        if(ComponentTypeEnum.MechanismDrive.name().equals(logic.getType())) {
            DriveAbilityBo bo = kgHelpService.convert(logic.getLogic(), DriveAbilityBo.class);
            // 判断是否需要生成轻量级侦测，如果需要则生成轻量级侦测，而后直接退出
            if (bo.getNeedLightDetection() != null && bo.getNeedLightDetection()) {
                if (bo.getCheckSource() instanceof ScheduleSourceWidget) {
                    MechanismPart part = componentBO.getMechanismCapacity().getCheck();
                    ScheduleSourceWidget checkSource = (ScheduleSourceWidget) bo.getCheckSource();
                    com.digiwin.athena.kg.monitorRule.MonitorRule monitorRule = checkSource.getMonitorRule();
                    TaskSchedule taskSchedule = kgHelpService.convert(monitorRule, TaskSchedule.class);
                    taskSchedule.setTenantId(AthenaUtils.getTenantId());
                    taskSchedule.setMechanismLogicCode(logicCode);
                    taskSchedule.setType("taskDetail");
                    taskSchedule.setActionType("task");
                    taskSchedule.setActionCommonId(bo.getProjectCode());
                    if(part instanceof CheckTaskByQuantityPart){
                        CheckTaskByQuantityPart checkPart = (CheckTaskByQuantityPart) part;
                        String jobCode = checkPart.getCheckByQuantity().getJobCode();
                        taskSchedule.setTaskCode(jobCode);
                        taskSchedule.setDataStates(Lists.newArrayList(
                                StringUtils.isEmpty(checkPart.getCheckByQuantity().getDataStateCode())
                                        ? "waitting" : checkPart.getCheckByQuantity().getDataStateCode()));
                    }
                    if (part instanceof CheckTaskOnTimeOverPart && componentBO.getMechanismCapacity().getSource() instanceof SourceSchedulePart) {
                        String taskCode = ((SourceSchedulePart) componentBO.getMechanismCapacity().getSource()).getTargetSource().getTarget();
                        taskSchedule.setTaskCode(taskCode);
                        taskSchedule.setDataStates(Lists.newArrayList(
                                StringUtils.isEmpty(((CheckTaskOnTimeOverPart) part).getCheckComplete().getDataStateCode())
                                        ? "waitting" : ((CheckTaskOnTimeOverPart) part).getCheckComplete().getDataStateCode()));
                    }
                    //侦测时间支持机制参数处理
                    MonitorMechanismParameterProcess(componentBO, taskSchedule, tenantId, bo);
                    dataMapService.postTaskSchedule(taskSchedule);
                }
                return;
            }
            //控制能力-侦测时间支持机制参数
            MonitorSupportMechanismParameter(bo, tenantId);
            String monitorRuleId = pluginId;
            String actionId = bo.getActionId();
            Map<String, Object> param2 = new HashMap<>();
            param2.put("pluginId", pluginId);
            param2.put("tenantId", tenantId);
            param2.put("monitorRuleId", monitorRuleId);
            param2.put("actionId", actionId);
            String product = kgHelpService.getTenantProduct(monitorRuleId);

            String deleteCyhper1 = "match(m:MonitorRule{pluginId:$pluginId}) detach delete m";
            Query query1 = Query.query(Criteria.where("pluginId").is(pluginId));
            kgHelpService.executeCyhper(deleteCyhper1,param2);
            mongoTemplateSystem.remove(query1,MonitorRuleProductConfig.class);
            TriggerDTO triggerDTO = null;
            ScheduleApiSourceWidget scheduleSource=null;
            if(!Objects.isNull(componentBO.getMechanismCapacity())){
                MechanismPart part = componentBO.getMechanismCapacity().getSource();
                SourceSchedulePart sourceSchedulePart = (SourceSchedulePart) part;
                scheduleSource = sourceSchedulePart.getScheduleSource();
            }
            if(null!=scheduleSource&&MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue()
                    .equals(scheduleSource.getCheckFrequencyType())) {
                triggerDTO = getTriggerDTO(tenantId, bo, scheduleSource);
            }
            List<MonitorRule> rules = dataPickService.excludeWithSameCodeAndFilterTenant(monitorRuleRepository.findByCodeAndVersion(monitorRuleId,version));
            if(rules.size()==0){
                Object ruleObj = JSONPath.eval(logic.getLogic(),"$.checkSource.monitorRule");
                String projectCode = (String) JSONPath.eval(logic.getLogic(),"$.projectCode");
                if(null!=ruleObj){
                    MonitorRule rule = JSON.parseObject(JSON.toJSONString(ruleObj),MonitorRule.class);
                    rule.setCode(monitorRuleId);
                    rule.setVersion(version);
                    rule.setActionType("task");
                    rule.setActionCommonId(projectCode);
                    rule.setPluginId(pluginId);
                    rule.setDynamicParams(rule.getDynamicParamsDto());
                    //设置规则I
                    if(!Objects.isNull(triggerDTO)){
                       rule.setStandardPollingRule(JSON.toJSONString(triggerDTO));
                    }
//                    monitorRuleRepository.save(rule);
                    kgHelpService.executeCyhperSave(rule);

                    if(null!=rule.getMonitorActionId()){
                        param2.put("monitorRuleActionId",rule.getMonitorActionId());
                    }

                    MonitorRuleProductConfig monitorRuleProductConfig = new MonitorRuleProductConfig();
                    monitorRuleProductConfig.setMonitorRuleId(monitorRuleId);
                    monitorRuleProductConfig.setProductName(product==null?"Athena":product);
                    monitorRuleProductConfig.setVersion(version);
                    monitorRuleProductConfig.setPluginId(pluginId);
                    if(null!=rule.getStaticParams()){
                        List<StaticParamsDO> staticParams = new ArrayList<>();
                        for(DynamicParam p: rule.getStaticParams()){
                            StaticParamsDO sp = new StaticParamsDO();
                            sp.setParam_name(p.getParam_name());
                            //php api 调用，参数替换
                            replaceValue(tenantId, rule, p, sp,staticParams);
                        }
                        monitorRuleProductConfig.setStaticParams(staticParams);
                    }
                    if(null!=rule.getDynamicParamsDto()){
                        List<DynamicParamsDO> dynamicParams = JSON.parseArray(rule.getDynamicParamsDto(),DynamicParamsDO.class);
                        monitorRuleProductConfig.setDynamicParams(dynamicParams);
                    }
                    mongoTemplateSystem.save(monitorRuleProductConfig);
                }
            }

            String createMonitorRelation="match(t:TenantEntity{tenantId:$tenantId}),(m:MonitorRule{code:$monitorRuleId}) merge (t)-[:USE]->(m)";
            String createActionRelation="match(t:TenantEntity{tenantId:$tenantId}),(m:StartDataEventAction{actionId:$actionId}) merge (t)-[:ACTION]->(m)";
            String createApiActionRelation="match(t:TenantEntity{tenantId:$tenantId}),(m:Action{actionId:$monitorRuleActionId}) merge (t)-[:ACTION]->(m)";

            kgHelpService.executeCyhper(createMonitorRelation,param2);
            kgHelpService.executeCyhper(createActionRelation,param2);
            if(null!=param2.get("monitorRuleActionId")){
                kgHelpService.executeCyhper(createApiActionRelation,param2);
            }

            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setConfigId(logicCode);
            config.setTenantId(tenantId);
            config.setMonitorRuleId(monitorRuleId);
            config.setProductName(product);
            config.setStatus(1);
            config.setHasMechanismOrCustomParam(hasMechanismOrCustomParam(logic));
            try{
                Object standardPollingRule = JSONPath.eval(bo,"$.checkSource.monitorRule.standardPollingRule");
                // 每次生效的时候都应该去取参数值生成的triggerDTO，如果没有才拿standardPollingRule
                if (triggerDTO == null && null != standardPollingRule) {
                    triggerDTO = JSON.parseObject(JSON.toJSONString(standardPollingRule), TriggerDTO.class);
                }
            } catch (Exception e) {
            }
            if (Objects.nonNull(triggerDTO)) {
                config.setStandardPollingRule(triggerDTO);
            }
            monitorRuleConfigService.post(config);
        }
    }

    /**
     * 轻量级侦测时间支持机制参数处理
     */
    private void MonitorMechanismParameterProcess(ComponentBO componentBO, TaskSchedule taskSchedule, String tenantId, DriveAbilityBo bo) {
        if(taskSchedule.getStandardPollingRule() == null){
            ScheduleApiSourceWidget scheduleSource=null;
            if(!Objects.isNull(componentBO.getMechanismCapacity())){
                MechanismPart sourcePart = componentBO.getMechanismCapacity().getSource();
                SourceSchedulePart sourceSchedulePart = (SourceSchedulePart) sourcePart;
                scheduleSource = sourceSchedulePart.getScheduleSource();
            }
            if(null!=scheduleSource&&MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue()
                    .equals(scheduleSource.getCheckFrequencyType())) {
                TriggerDTO triggerDTO  = getTriggerDTO(tenantId, bo, scheduleSource);
                StandardPollingRule pollingRule=JSON.parseObject(JSON.toJSONString(triggerDTO), StandardPollingRule.class);
                //1自定义，2关联机制参数
                pollingRule.setStartTimeType(1);
                taskSchedule.setStandardPollingRule(pollingRule);
            }
        }
    }

    /**
     * 机制时机类型为基础资料时拿到pageUIElement表的code发送到dataMap，用作欧博士弹窗
     * @param logic
     * @param param
     */
    private void setDataViewCode(MechanismLogic logic, Map<String, Object> param) {
        try {
            //转换实体类
            LimitAbilityBo limitAbilityBo = kgHelpService.convert(logic.getLogic(), LimitAbilityBo.class);

            //判断如果类型是基础资料才发送dataViewCode
            if(Objects.nonNull(limitAbilityBo) && limitAbilityBo.getCheckSource().getType().equalsIgnoreCase("dataEntrySource")){
                //拿到浏览页的dataViewCode
                List<ActivityConfig> activityConfigs = dataPickService.find(Criteria.where("code").in(limitAbilityBo.getCheckSource().getTarget()), ActivityConfig.class, "activityConfigs");
                if(!CollectionUtils.isEmpty(activityConfigs)){
                    ActivityConfig activityConfig = activityConfigs.get(0);

                    Map<String, Object> pages = activityConfig.getPages();

                    Optional.ofNullable(pages)
                            .map(p -> (Map) p.get("browse-page"))
                            .map(browsePage -> browsePage.get("dataSourceName"))
                            .map(Object::toString)
                            .flatMap(dataSourceName -> Optional.ofNullable(activityConfig.getDataSources())
                                    .map(dataSources -> (Map) dataSources.get(dataSourceName)))
                            .map(dataSource -> (Map) dataSource.get("dataViewQuery"))
                            .map(dataViewQuery -> (String) dataViewQuery.get("code"))
                            .ifPresent(dataViewCode -> param.put("dataViewCode", dataViewCode));

                }
            }
        } catch (Exception e) {
            log.error("Route==>AbilityComponentApplyService method=setDataViewCode error:",e);
        }
    }

    private Map getRealDataSource(Map<String, Object> dataSources) {
        //简单起见,先实现为取第一个
        if (dataSources == null || dataSources.isEmpty()) {
            return null;
        }
        return JSON.parseObject(JSON.toJSONString(dataSources.entrySet().iterator().next().getValue()), Map.class);
    }

    private boolean hasMechanismOrCustomParam(MechanismLogic logic) {
        try {
            Object ruleObj = JSONPath.eval(logic.getLogic(), "$.checkSource.monitorRule");
            if (null != ruleObj) {
                MonitorRule rule = JSON.parseObject(JSON.toJSONString(ruleObj), MonitorRule.class);
                if (!CollectionUtils.isEmpty(rule.getStaticParams())) {
                    return true;
                }
            }
        } catch (Exception ex) {
            log.error("判断是否存在机制参数或者自定义参数异常", ex);
        }
        return false;
    }

    /**
     * 如果IM通知人选择机制参数时，在此时替换掉
     * 控制标准的天数选择机制参数也替换掉
     * @param logic logic
     * @param tenantId 租户id
     * @throws DWBusinessException 异常
     */
    private void replaceImNoticeReceiverFromMechanismVariable(MechanismLogic logic, String tenantId) throws DWBusinessException {
        if (ComponentTypeEnum.MechanismDrive.name().equals(logic.getType()) || ComponentTypeEnum.MechanismControl.name().equals(logic.getType())) {
            PlanWidget positiveTarget = null;
            // 控制标准的天数选择机制参数也替换掉
            List<ActivityWidget> preActivities = null;
            if (ComponentTypeEnum.MechanismDrive.name().equals(logic.getType())) {
                DriveAbilityBo bo = kgHelpService.convert(logic.getLogic(), DriveAbilityBo.class);
                positiveTarget = bo.getChoose().getPositiveTarget();
                preActivities = bo.getPreActivities();
            } else if (ComponentTypeEnum.MechanismControl.name().equals(logic.getType())) {
                ControlAbilityBO bo = kgHelpService.convert(logic.getLogic(), ControlAbilityBO.class);
                positiveTarget = bo.getChoose().getPositiveTarget();
                preActivities = bo.getPreActivities();
            }
            if (positiveTarget != null && "activityPlan".equals(positiveTarget.getType())) {
                ActivityPlanWidget activityPlanWidget = (ActivityPlanWidget) positiveTarget;
                List<ActivityWidget> activityWidget = activityPlanWidget.getActivityWidget();
                if (!CollectionUtils.isEmpty(activityWidget)) {
                    for (ActivityWidget activityWidgetItem : activityWidget) {
                        if ("im".equals(activityWidgetItem.getType())) {
                            IMActivityWidget imActivityWidgetItem = (IMActivityWidget) activityWidgetItem;
                            // 如果IM通知人选择机制参数时，在此时替换掉
                            if (MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue().equals(imActivityWidgetItem.getPerformerType())) {
                                String mechanismVariableCode = imActivityWidgetItem.getPerformerValue();
                                Object value = iMechanismService.postSelectVariable(mechanismVariableCode, tenantId);
                                if (Objects.isNull(value)) {
                                    throw new DWBusinessException("IM通知人机制参数未配置");
                                }
                                if (value instanceof String) {
                                    imActivityWidgetItem.setUserId("['" + value + "']");
                                } else if (value instanceof List) {
                                    // 将list转成['user']格式
                                    List<String> list = (List<String>) value;
                                    List<String> collect = list.stream().map(s -> "'" + s + "'").collect(Collectors.toList());
                                    imActivityWidgetItem.setUserId("[" + String.join(",", collect) + "]");
                                } else {
                                    throw new DWBusinessException("IM通知人机制参数类型错误");
                                }
                            }
                            if (StringUtils.isNotBlank(imActivityWidgetItem.getMessage())) {
                                imActivityWidgetItem.setMessage(replaceMessageVariables(imActivityWidgetItem.getMessage()));
                                if (imActivityWidgetItem.getLang() != null
                                        && imActivityWidgetItem.getLang().containsKey("message")
                                        && imActivityWidgetItem.getLang().get("message") != null) {
                                    for (Map.Entry<String, String> entry : imActivityWidgetItem.getLang().get("message").entrySet()) {
                                        entry.setValue(replaceMessageVariables(entry.getValue()));
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (!CollectionUtils.isEmpty(preActivities)) {
                String patternString = "#(.*?)#"; // 正则表达式，匹配#和#之间的任何内容
                Pattern pattern = Pattern.compile(patternString);
                for (ActivityWidget activityWidgetItem : preActivities) {
                    if ("script".equals(activityWidgetItem.getType())) {
                        Object resObj = JSONPath.eval(activityWidgetItem, "$.config.scriptMode.responseScript");
                        if (null != resObj) {
                            String responseScript = String.valueOf(resObj);
                            Matcher matcher = pattern.matcher(responseScript);
                            // 查找并提取匹配的内容
                            if (matcher.find()) {
                                String placeholderText = matcher.group(0);
                                String matchedText = matcher.group(1);
                                Object value = iMechanismService.postSelectVariable(matchedText, tenantId);
                                if (!Objects.isNull(value)) {
                                    responseScript = responseScript.replaceAll(placeholderText, String.valueOf(value));
                                    JSONPath.set(activityWidgetItem, "$.config.scriptMode.responseScript", responseScript);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 替换掉IM消息中的参数
     *
     * @param msg 消息
     * @return 替换后的消息
     * @throws DWBusinessException 异常
     */
    private String replaceMessageVariables(String msg) throws DWBusinessException {
        Pattern pattern = Pattern.compile("#\\{(.+?)}");
        Matcher matcher = pattern.matcher(msg);
        StringBuffer result = new StringBuffer();
        String tenantId = AthenaUtils.getTenantId();
        String version = tenantService.getTenantVersion(tenantId);
        while (matcher.find()) {
            String key = matcher.group(1);
            Criteria criteria = Criteria.where("code").is(key).and("version").is(version).and("displayType").in(ALLOW_REPLACE_VARIABLE_TYPES);
            VariableDefinition variable = dataPickService.findOneByCondition(criteria, VariableDefinition.class, "variableDefinition");
            Object value = null;
            // 存在满足条件的参数定义
            if (variable != null) {
                // 查找租户级数据
                Query tenantQuery = new Query();
                tenantQuery.addCriteria(Criteria.where("variableId").is(key).and("tenantId").is(tenantId));
                MechanismTenantVariable tenantVariable = mongoTemplateUser.findOne(tenantQuery, MechanismTenantVariable.class);
                // 没有就用默认值
                value = Optional.ofNullable(tenantVariable).map(MechanismTenantVariable::getValue).orElse(variable.getDefaultValue());
            }
            // 找不到就是空串
            matcher.appendReplacement(result, Optional.ofNullable(value).map(String::valueOf).orElse(""));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    /**
     * 将机制参数 code 替换为租户的设置的值
     *
     * @param logic 机制逻辑
     */
    private void replaceVariableCodeToTenantValueForLimit(MechanismLogic logic) throws Exception {
        if (!ComponentTypeEnum.MechanismLimit.name().equals(logic.getType())) {
            return;
        }
        LimitAbilityBo bo = kgHelpService.convert(logic.getLogic(), LimitAbilityBo.class);
        PersonnelCondition personnelCondition = bo.getPersonnelCondition();
        doReplaceVariableCodeToTenantValue(personnelCondition);
        // TODO delete 一次编译不应该保存两份 personnelCondition, 否则会造成修改不完全
        if (null != bo.getStrategies()) {
            for (SingleStrategyWidget strategy : bo.getStrategies()) {
                if (null != strategy.getPersonnelCondition()) {
                    doReplaceVariableCodeToTenantValue(strategy.getPersonnelCondition());
                }
            }
        }

    }

    private void doReplaceVariableCodeToTenantValue(PersonnelCondition personnelCondition) throws Exception {
        if (null == personnelCondition) {
            return;
        }
        if (MechanismEnum.RightCondType.MECHANISM_VARIABLE.getCode().equalsIgnoreCase(personnelCondition.getRightCondType())) {
            VariableBean bean = new VariableBean();
            bean.setVariableIds(Lists.newArrayList(personnelCondition.getToValue().toString()));
            if(!ObjectUtils.isEmpty(personnelCondition.getFromValue())){
                bean.getVariableIds().add(personnelCondition.getFromValue().toString());
            }
            Object variableObj = mechanismService.postVariableListSimple(bean);
            JSONObject variableJsonObj = JSONObject.parseObject(JSON.toJSONString(variableObj));
            if(!ObjectUtils.isEmpty(personnelCondition.getFromValue())){
                personnelCondition.setFromValue(variableJsonObj.getString(personnelCondition.getFromValue().toString()));
            }
            personnelCondition.setToValue(variableJsonObj.getString(personnelCondition.getToValue().toString()));
        }
    }

    private TriggerDTO getTriggerDTO(String tenantId, DriveAbilityBo bo, ScheduleApiSourceWidget scheduleSource) {
        TriggerDTO triggerDTO;
        //生成一个侦测
        ScheduleSourceWidget checkSource = (ScheduleSourceWidget) bo.getCheckSource();
        com.digiwin.athena.kg.monitorRule.MonitorRule rule = checkSource.getMonitorRule();
        //获取机制参数为侦测类型的code值。后续可以考虑页面直接封装好mechanismParameterReqDO对象，这样，下面通过抽象类
        //定义的泛型才更有意义，可以根据各自的解析器定义各自的入参和出参
        MechanismParameterReqDO mechanismParameterReqDO = new MechanismParameterReqDO();
        mechanismParameterReqDO.setActionId(rule.getMonitorActionId());
        mechanismParameterReqDO.setType(scheduleSource.getCheckFrequencyType());
        mechanismParameterReqDO.setTenantId(tenantId);
        String checkFrequencyVariableCode= scheduleSource.getCheckFrequencyVariableCode();
        mechanismParameterReqDO.setVariableCode(checkFrequencyVariableCode);
        //定义接口，通过责任链模式，定义具体的实现，完成对应侦测的生成
        triggerDTO =(TriggerDTO) monitorRuleMechanismParameterServices.stream()
                .filter(res -> res.accept(String.valueOf(checkFrequencyVariableCode)))
                .findFirst().get().parse(mechanismParameterReqDO);
        return triggerDTO;
    }


    private void replaceValue(String tenantId, MonitorRule rule, DynamicParam p, StaticParamsDO sp,List<StaticParamsDO> staticParams ) {
        if(ComponentConstants.PHP_API.equals(p.getConfigType())
                &&ComponentConstants.PHP_TASK_INFO.equals(p.getParam_name())){
            List<DynamicParam> taskInfos = JsonUtil.toList(p.getParam_value(), DynamicParam.class);
            taskInfos.forEach(task->{
                StaticParamsDO newDynamicParam=new StaticParamsDO();
                //增加機制參數的處理
                if(MechanismParameterTypeEnum.MECHANISM_PARAMETER.getValue().equals(task.getConfigType())){
                    Map<String, Object> map = null;
                    try {
                        map = (Map<String, Object>) this.mechanismService.getVariable(task.getParam_value(), tenantId);
                    } catch (DWBusinessException e) {
                        throw new RuntimeException(e);
                    }
                    String value=map.get(task.getParam_value())==null?null:String.valueOf(map.get(task.getParam_value()));
                    List<AbstractMonitorRuleMechanismParameterService> services=
                            monitorRuleMechanismParameterServices.stream()
                                    .filter(res -> res.accept(rule.getMonitorActionId() + "." + task.getParam_value())).collect(Collectors.toList());
                    if(!CollectionUtils.isEmpty(services)){
                        Object changeValue = services.stream().findFirst().get().parse(value);
                        task.setParam_value(String.valueOf(changeValue));
                    }else{
                        task.setParam_value(value);
                    }
                }
                newDynamicParam.setParam_name(task.getParam_name());
                newDynamicParam.setParam_value(task.getParam_value());
                staticParams.add(newDynamicParam);
            });
        }else{
            sp.setParam_value(p.getParam_value());
            staticParams.add(sp);
        }
    }


    //侦测时间支持机制参数
    @SneakyThrows
    public void MonitorSupportMechanismParameter(DriveAbilityBo bo, String tenantId) {
        StandardPollingRule pollingRule = (StandardPollingRule) JSONPath.eval(
            bo, "$.checkSource.monitorRule.standardPollingRule");
        if (pollingRule != null && null!=pollingRule.getStartTimeType()
                &&pollingRule.getStartTimeType()
            .equals(VariableTypeEnum.VARIABLE_VALUE.getKey())) {
            String startVariableCode = pollingRule.getStartVariableCode();
            String variableTimeValue = iMechanismService.postSelectVariable(startVariableCode,
                tenantId).toString();
            String startTime = pollingRule.getStart_time();
            if (startTime.contains("null")) {
                int startIndex = startTime.indexOf(' ') + 1;
                String timePart = startTime.substring(startIndex);
                // 定义日期时间格式
              /*  String formatTime = DateUtils.formatTime(
                    DateUtils.parseDateTime(startTime, "yyyy-MM-dd HH:mm:ss"));*/
                pollingRule.setStart_time(variableTimeValue + " " + timePart);
            }


        }
    }


   // @Async
    @Override
    public void unApply(ComponentBO componentBO, ComponentApplyContext context) throws Exception {
        log.info("开始删除机制能力startDeleteMechanismCapacity: "+ JSON.toJSONString(componentBO));
        String logicCode = componentBO.getLogicCode();
        String tenantId = AthenaUtils.getTenantId();
        if(null==logicCode){
            logicCode = componentBO.getCode();
        }
        if(null==logicCode){
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.componentCodeError"));
        }

        Query query = Query.query(Criteria.where("code").is(logicCode).and("tenantId").is(tenantId));
        MechanismLogic logic = mongoTemplateUser.findOne(query,MechanismLogic.class);
        if(null==logic || logic.getLogic()==null){
            logic = getSystemLogic(logicCode);
        }

//        Query query = Query.query(Criteria.where("code").is(logicCode));
//        MechanismLogic logic = mongoTemplateSystem.findOne(query,MechanismLogic.class);
        if(null==logic || logic.getLogic()==null){
            throw new DWBusinessException(I18nUtils.getValue("knowledgegraph.componentCodeNotFound",logicCode));
        }

        Map<String,Object> param = new HashMap<>();
        param.put("type",componentBO.getType().name());
        param.put("pluginId",componentBO.getCode());
        param.put("mechanismCode",context.getMechanismCode());
        param.put("ability",logic.getLogic());
        dataMapService.unBindMechanismComponent(param);

        mongoTemplateUser.remove(Query.query(Criteria.where("tenantId").is(tenantId).and("mechanismAbilityCode").is(componentBO.getCode())),MechanismApplyRecord.class);

        if(ComponentTypeEnum.MechanismDrive.name().equals(logic.getType())){
            DriveAbilityBo bo = kgHelpService.convert(logic.getLogic(),DriveAbilityBo.class);
            // 租户级侦测规则id = logicCode + tenantId，logic中的monitorRuleId后拼接的tenantId为SYSTEM,是有问题的，导致侦测删不掉
            String monitorRuleId = logicCode + tenantId;
            String actionId  = bo.getActionId();
            Map<String,Object> param2 = new HashMap<>();
            param2.put("tenantId",tenantId);
            param2.put("monitorRuleId",monitorRuleId);
            param2.put("actionId",actionId);

            String createMonitorRelation="match(t:TenantEntity{tenantId:$tenantId})-[r:USE]->(m:MonitorRule{code:$monitorRuleId}) delete r";
            String createActionRelation="match(t:TenantEntity{tenantId:$tenantId})-[r:ACTION]->(m:StartServiceComposerAction{actionId:$actionId}) delete r";

            kgHelpService.executeCyhper(createMonitorRelation,param2);
            kgHelpService.executeCyhper(createActionRelation,param2);


            String product = kgHelpService.getTenantProduct(monitorRuleId);

            MonitorRuleConfigDTO config = new MonitorRuleConfigDTO();
            config.setConfigId(logicCode);
            config.setTenantId(tenantId);
            config.setMonitorRuleId(monitorRuleId);
            config.setProductName(product);
            config.setStatus(0);
           // config.setType();

           // monitorRuleConfigService.post(config);
            monitorRuleConfigService.delete(tenantId,monitorRuleId);

            //判断如果是轻量级侦测，删除对应的侦测定义
            if (bo.getNeedLightDetection() != null && bo.getNeedLightDetection()) {
                if (bo.getCheckSource() instanceof ScheduleSourceWidget) {
                    MechanismPart part = componentBO.getMechanismCapacity().getCheck();
                    ScheduleSourceWidget checkSource = (ScheduleSourceWidget) bo.getCheckSource();
                    com.digiwin.athena.kg.monitorRule.MonitorRule monitorRule = checkSource.getMonitorRule();
                    TaskSchedule taskSchedule = kgHelpService.convert(monitorRule, TaskSchedule.class);
                    taskSchedule.setTenantId(AthenaUtils.getTenantId());
                    taskSchedule.setMechanismLogicCode(logicCode);
                    if(part instanceof CheckTaskByQuantityPart){
                        CheckTaskByQuantityPart checkPart = (CheckTaskByQuantityPart) part;
                        String jobCode = checkPart.getCheckByQuantity().getJobCode();
                        taskSchedule.setTaskCode(jobCode);
                    }
                    if (part instanceof CheckTaskOnTimeOverPart && componentBO.getMechanismCapacity().getSource() instanceof SourceSchedulePart) {
                        String taskCode = ((SourceSchedulePart) componentBO.getMechanismCapacity().getSource()).getTargetSource().getTarget();
                        taskSchedule.setTaskCode(taskCode);
                    }
                    dataMapService.postDeleteTaskSchedule(taskSchedule);
                }
            }
        }

    }

    /**
     * 查询系统级的MechanismLogic
     * @param logicCode code
     * @return MechanismLogic
     * @throws DWBusinessException 异常
     */
    private MechanismLogic getSystemLogic(String logicCode) throws DWBusinessException {
        Criteria criteria = Criteria.where("code").is(logicCode);
        Query query = Query.query(criteria);
        List<MechanismLogic> mechanismLogics = mongoTemplateSystem.find(query, MechanismLogic.class);
        mechanismLogics = dataPickService.excludeWithSameCode(mechanismLogics, MechanismLogic::getCode, MechanismLogic::getSourceLevel);
        return CollectionUtils.isEmpty(mechanismLogics) ? null : mechanismLogics.get(0);
    }
}
