package com.digiwin.athena.knowledgegraph.configuration;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.kmservice.cache.old.Cache;
import com.digiwin.athena.knowledgegraph.service.KgInnerService;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Map;

/**
 *
 */
@Aspect
@Slf4j
@Component
@Order(0)
public class KgCacheAspect {
    @Resource
    KgInnerService kgInnerService;

    @Around("@annotation(com.digiwin.athena.kmservice.cache.old.Cache)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        Signature sig = point.getSignature();
        MethodSignature msig = (MethodSignature)sig;
        Method method = msig.getMethod();
        Cache annotation = method.getAnnotation(Cache.class);
        if (annotation.tenant()) {
            ServletRequestAttributes requestAttributes =
                    (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                String tenantId;
                HttpServletRequest request = requestAttributes.getRequest();
                tenantId = (String) profile.getOrDefault("tenantId", "");
                request.setAttribute("tenantId", tenantId);
            }
            //String tenantIdVersion = kgInnerService.getTenantVersion(tenantId);
            //request.setAttribute("tenantVersion", tenantIdVersion);
        }
        Object exResult;
        try {
            exResult = point.proceed();
            return exResult;
        } catch (Exception e) {
            throw e;
        }
    }

}
