package com.digiwin.athena.knowledgegraph.domain;

import com.digiwin.athena.kg.monitorRule.DynamicParam;
import com.digiwin.athena.kg.domain.CodedEntity;
import com.digiwin.athena.kg.action.Action;
import lombok.Data;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2020-06-29 10:24
 **/
@Data
@NodeEntity
public class MonitorRule extends CodedEntity {
    private List<String> inclusionTenant;

    private String pluginId;

    private String name;

    // category是SCAN时才有，与monitorRuleProductConfig里的entityMapping有映射关系
    private String entity;

    @Relationship(type="Triggers")
    private List<Action> actions;
    // category是SCAN时才有，侦测时需要返回的列
    private String returnFields;
    // 发起侦测的时间和频率
    private String standardPollingRule;
    // MODIFIED 修改，CREATED 新增，APPROVED 审核， CUSTOM 自定义、REPORT外部系统调用侦测、CREATED_OR_MODIFIED新增或修改、SCHEDULE
    private String type;
    // SCAN、API、SCHEDULE、REPORT外部系统调用侦测
    private String category;
    private String dynamicConditionFields;
    // datapulling  task serviceComposer
    private String actionType;
    //actionType=task 为projectCode   actionType=serviceComposer为serviceComposerId 这两种场景下没有Aciton
    private String actionCommonId;

    private String pollingInterval;
    //json
//    private String apiSetting;
//    private String timeSetting;
    // 未侦测到数据是否发起Action
    private Boolean isContinue = false;
    private String monitorActionId;
    private String dynamicParams;

    private String description;

    //是否允许(立即)执行
    private Integer executable;
    //周期开关 分号分隔 M;W;D;H;F M每x月 W每x周 D每x天 H每x小时 F每x分钟
    private String periodEnable;

    // 回溯时间
    private String backtrackDate;
    // 是否创建侦测时立即执行一次
    private Boolean executeOnStartup;
    // 是否自动创建侦测
    private Boolean autoRun;
    //“侦测开始时间”=“回溯时间 标记
    private Boolean backtrackDateEqualsStartTime;
    // 是否数据比对
    private boolean dataCheck;
    //给sd的防抖冷却时间
    private Integer chillInterval;

    private List<DynamicParam> staticParams;

    //用于多个MonitorRule传参，很尴尬
    private String dynamicParamsDto;

    private String productName;

    private String nameSpace;

    // 敏捷报表定义 场景
    private String scene;
    // 敏捷报表定义 执行引擎需要定义入参
    private String actionParamDefine;

    /*****************************MQTT start类型的侦测参数************************/
    //业务主题
    private String mqttTopic;
    //主题来源
    private String mqttSource;

    /**
     * 开发平台配置的是否在交付设计器启用
     */
    private Boolean isDesignerSet = true;
}
